/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.InstanceVariable;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainInstanceVariable<T>
extends InstanceVariable {
    private static Logger logger = LoggerFactory.getLogger(PlainInstanceVariable.class);
    private T qV;
    private DateTime qW;
    private UnsignedShort qX = UnsignedShort.ZERO;
    private DateTime qR = INITIALIZATION_TIME;
    private StatusCode fC = new StatusCode(StatusCodes.Bad_WaitingForInitialData);

    public PlainInstanceVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, NodeId nodeId2) throws StatusException {
        super(nodeManagerUaNode, nodeId, nodeId2);
    }

    public PlainInstanceVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, UaVariable uaVariable) {
        super(nodeManagerUaNode, nodeId, uaVariable);
    }

    public final T getCurrentValue() {
        return this.qV;
    }

    public DateTime getServerTimestamp() {
        return this.qW;
    }

    public DateTime getSourceTimestamp() {
        return this.qR;
    }

    @Override
    public StatusCode getStatus() {
        return this.fC;
    }

    @Override
    public DataValue getValue() {
        DataValue dataValue = this.qV == null ? new DataValue(this.fC) : new DataValue(new Variant(this.qV), this.fC);
        dataValue.setServerTimestamp(this.qW);
        dataValue.setSourceTimestamp(this.qR);
        dataValue.setSourcePicoseconds(this.qX);
        return dataValue;
    }

    public Class<?> getValueClass() {
        if (this.qV == null) {
            return null;
        }
        return this.qV.getClass();
    }

    public boolean setCurrentValue(T t) {
        return this.setCurrentValue(t, DateTime.currentTime());
    }

    public boolean setCurrentValue(T t, DateTime dateTime) {
        return this.setCurrentValue(t, StatusCode.GOOD, dateTime, null);
    }

    public boolean setCurrentValue(T t, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) {
        boolean bl;
        boolean bl2 = bl = !Objects.equals(t, this.getCurrentValue());
        if (bl) {
            if (dateTime == null) {
                dateTime = DateTime.currentTime();
            }
            try {
                this.setValue(new DataValue(new Variant(t), statusCode, dateTime, unsignedShort, null, null));
            }
            catch (StatusException statusException) {
                throw new IllegalArgumentException(statusException);
            }
            if (NodeId.isNull(this.getDataTypeId())) {
                try {
                    Structure[] structureArray;
                    Class<Structure[]> clazz;
                    DataValue dataValue;
                    if (t instanceof Structure) {
                        this.setDataTypeId(this.nodeManager.getNamespaceTable().toNodeId(((Structure)t).getTypeId()));
                    } else if (t.getClass().isArray() && !(dataValue = this.getValue()).isNull() && (clazz = dataValue.getValue().getCompositeClass()).isAssignableFrom(Structure[].class) && (structureArray = (Structure[])dataValue.getValue().getValue()).length > 0) {
                        this.setDataTypeId(this.nodeManager.getNamespaceTable().toNodeId(structureArray[0].getTypeId()));
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            if (this.getValueRank() == -2) {
                if (t.getClass().isArray()) {
                    this.setArrayDimensions(new UnsignedInteger[]{UnsignedInteger.ZERO});
                    this.setValueRank(0);
                } else {
                    this.setValueRank(-1);
                }
            }
        }
        return bl;
    }

    @Override
    public void setStatus(StatusCode statusCode) {
        this.fC = statusCode;
    }

    @Override
    protected void doSetValue(DataValue dataValue) throws StatusException {
        if (dataValue == null) {
            this.qV = null;
            this.qR = DateTime.currentTime();
            this.qW = DateTime.currentTime();
            this.fC = StatusCode.BAD;
        } else {
            this.qV = dataValue.isNull() ? null : dataValue.getValue().getValue();
            this.fC = dataValue.getStatusCode();
            this.qR = dataValue.getSourceTimestamp();
            this.qX = dataValue.getSourcePicoseconds();
            this.qW = dataValue.getServerTimestamp();
            if (this.qW == null) {
                this.qW = DateTime.currentTime();
            }
        }
    }
}

