/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.AccessLevels;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.ServerNode;
import com.prosysopc.ua.server.nodes.UaServerReference;
import com.prosysopc.ua.server.nodes.a;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.VariableAttributes;
import com.prosysopc.ua.stack.core.VariableTypeAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstanceVariable
extends ServerNode
implements UaVariable {
    private static final Logger logger = LoggerFactory.getLogger(InstanceVariable.class);
    private static UaNode qS;
    private AccessLevelType hz = AccessLevels.READ_ONLY;
    private final UaVariable qT;
    private UaReference qU;

    public InstanceVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, NodeId nodeId2) throws StatusException {
        this(nodeManagerUaNode, nodeId, (UaVariable)nodeManagerUaNode.getNode(nodeId2));
    }

    public InstanceVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, UaVariable uaVariable) {
        super(nodeManagerUaNode, nodeId);
        this.qT = uaVariable;
    }

    @Override
    public UaReference addReference(UaNode uaNode, NodeId nodeId, boolean bl) {
        return super.addReference(uaNode, nodeId, bl);
    }

    @Override
    public UaReference deleteReference(ExpandedNodeId expandedNodeId, NodeId nodeId, boolean bl) {
        return super.deleteReference(expandedNodeId, nodeId, bl);
    }

    @Override
    public AccessLevelType getAccessLevel() {
        return this.hz;
    }

    @Override
    public UnsignedInteger[] getArrayDimensions() {
        return this.qT.getArrayDimensions();
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.qT.getAttributes();
    }

    @Override
    public Map<UnsignedInteger, Object> getAttributesMap() {
        HashMap<UnsignedInteger, Object> hashMap = new HashMap<UnsignedInteger, Object>();
        hashMap.putAll(this.qT.getAttributesMap());
        hashMap.put(Attributes.NodeId, this.getNodeId());
        return Collections.unmodifiableMap(hashMap);
    }

    @Override
    public QualifiedName getBrowseName() {
        return this.qT.getBrowseName();
    }

    @Override
    public UaNode getComponent(QualifiedName qualifiedName) {
        return this.qT.getComponent(qualifiedName);
    }

    @Override
    public UaNode[] getComponents() {
        return this.qT.getComponents();
    }

    @Override
    public UaDataType getDataType() {
        return this.qT.getDataType();
    }

    @Override
    public NodeId getDataTypeId() {
        return this.qT.getDataTypeId();
    }

    @Override
    public LocalizedText getDescription() {
        return this.qT.getDescription();
    }

    @Override
    public LocalizedText getDisplayName() {
        return this.qT.getDisplayName();
    }

    @Override
    public Boolean getHistorizing() {
        return false;
    }

    @Override
    public UaMethod getMethod(QualifiedName qualifiedName) throws ClassCastException {
        return null;
    }

    @Override
    public Double getMinimumSamplingInterval() {
        return null;
    }

    @Override
    public NodeClass getNodeClass() {
        return NodeClass.Variable;
    }

    @Override
    public UaProperty getNodeVersionNode() {
        return null;
    }

    @Override
    public UaProperty[] getProperties() {
        return this.qT.getProperties();
    }

    @Override
    public UaProperty getProperty(QualifiedName qualifiedName) {
        return this.qT.getProperty(qualifiedName);
    }

    @Override
    public UaReference getReference(NodeId nodeId, boolean bl) {
        if (!bl && nodeId.equals(Identifiers.HasTypeDefinition)) {
            return this.getTypeDefinitionReference();
        }
        if (bl && this.qU != null && this.qU.getReferenceTypeId().equals(nodeId)) {
            return this.qU;
        }
        return super.getReference(nodeId, bl);
    }

    public StatusCode getStatus() {
        return this.getValue().getStatusCode();
    }

    @Override
    public UaType getTypeDefinition() {
        if (this instanceof UaProperty) {
            return this.getPropertyTypeNode();
        }
        return this.qT.getTypeDefinition();
    }

    @Override
    public ExpandedNodeId getTypeDefinitionId() {
        if (this instanceof UaProperty) {
            return new ExpandedNodeId(Identifiers.PropertyType);
        }
        return this.qT.getTypeDefinitionId();
    }

    @Override
    public AccessLevelType getUserAccessLevel() {
        return this.qT.getUserAccessLevel();
    }

    @Override
    public AttributeWriteMask getUserWriteMask() {
        return this.qT.getUserWriteMask();
    }

    @Override
    public Integer getValueRank() {
        return this.qT.getValueRank();
    }

    @Override
    public AttributeWriteMask getWriteMask() {
        return AttributeWriteMask.of();
    }

    @Override
    public boolean hasUserWriteAccess(UnsignedInteger unsignedInteger) {
        return false;
    }

    @Override
    public boolean hasWriteAccess(UnsignedInteger unsignedInteger) {
        return false;
    }

    @Override
    public DataValue readAttribute(UnsignedInteger unsignedInteger) {
        DataValue dataValue = new DataValue();
        this.readAttribute(unsignedInteger, dataValue, null);
        return dataValue;
    }

    @Override
    public void readAttribute(UnsignedInteger unsignedInteger, DataValue dataValue, Locale locale) {
        if (unsignedInteger.equals(Attributes.NodeId)) {
            dataValue.setValue(new Variant(this.getNodeId()));
        } else if (unsignedInteger.equals(Attributes.NodeClass)) {
            Integer n2 = this.getNodeClass().getValue();
            dataValue.setValue(new Variant(n2));
        } else if (unsignedInteger.equals(Attributes.AccessLevel)) {
            dataValue.setValue(new Variant(this.getAccessLevel()));
        } else if (unsignedInteger.equals(Attributes.Value)) {
            DataValue dataValue2 = this.getValue();
            dataValue.setValue(dataValue2.getValue());
            dataValue.setSourceTimestamp(this.getValue().getSourceTimestamp());
            dataValue.setSourcePicoseconds(this.getValue().getSourcePicoseconds());
            dataValue.setServerTimestamp(this.getValue().getServerTimestamp());
            dataValue.setServerPicoseconds(this.getValue().getServerPicoseconds());
            dataValue.setStatusCode(this.getValue().getStatusCode());
        } else {
            this.qT.readAttribute(unsignedInteger, dataValue, locale);
        }
    }

    @Override
    public UaNode removeComponent(UaNode uaNode) {
        return null;
    }

    @Override
    public UaProperty removeProperty(QualifiedName qualifiedName) {
        return null;
    }

    @Override
    public void setAccessLevel(AccessLevelType accessLevelType) {
        this.hz = accessLevelType;
    }

    @Override
    public void setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
        throw new IllegalArgumentException("Cannot set ArrayDimensions");
    }

    @Override
    public void setAttribute(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (!unsignedInteger.equals(Attributes.Value)) {
            throw new StatusException(StatusCodes.Bad_NotWritable);
        }
        this.setValue(dataValue);
    }

    @Override
    public void setAttributes(NodeAttributes nodeAttributes) {
        if (nodeAttributes instanceof VariableTypeAttributes) {
            try {
                this.setValue(new DataValue(new Variant(((VariableTypeAttributes)nodeAttributes).getValue()), StatusCode.GOOD, DateTime.currentTime(), DateTime.currentTime()));
            }
            catch (StatusException statusException) {
                logger.warn("Could not set Value Attribute from NodeAttributes");
            }
        } else if (nodeAttributes instanceof VariableAttributes) {
            try {
                this.setValue(new DataValue(new Variant(((VariableAttributes)nodeAttributes).getValue()), StatusCode.GOOD, DateTime.currentTime(), DateTime.currentTime()));
            }
            catch (StatusException statusException) {
                logger.warn("Could not set Value Attribute from NodeAttributes");
            }
        } else {
            logger.error("Given NodeAttributes are not instanceof Variable(Type)Attributes");
        }
    }

    @Override
    public void setBrowseName(QualifiedName qualifiedName) {
        throw new IllegalArgumentException("Cannot set BrowseName");
    }

    @Override
    public void setDataType(UaDataType uaDataType) {
    }

    @Override
    public void setDataTypeId(NodeId nodeId) {
    }

    @Override
    public void setDescription(LocalizedText localizedText) {
        throw new IllegalArgumentException("Cannot set Description");
    }

    @Override
    public void setDisplayName(LocalizedText localizedText) {
        throw new IllegalArgumentException("Cannot set DisplayName");
    }

    @Override
    public void setHistorizing(Boolean bl) {
        throw new IllegalArgumentException("Cannot set Historizing");
    }

    @Override
    public void setMinimumSamplingInterval(Double d2) {
    }

    @Override
    public void setReferences(UaReference[] uaReferenceArray) {
        logger.error("Cannot set References");
    }

    public void setStatus(StatusCode statusCode) {
        DataValue dataValue = this.getValue();
        if (dataValue != null && dataValue.getStatusCode().equals(statusCode)) {
            return;
        }
        DataValue dataValue2 = new DataValue(statusCode);
        if (dataValue != null) {
            if (!statusCode.isBad()) {
                dataValue2.setValue(dataValue.getValue());
            }
            dataValue2.setServerTimestamp(DateTime.currentTime());
            dataValue2.setSourcePicoseconds(dataValue.getSourcePicoseconds());
            dataValue2.setSourceTimestamp(dataValue.getSourceTimestamp());
        }
        try {
            this.setValue(dataValue2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    @Override
    public void setTypeDefinition(UaType uaType) {
        this.addReference((UaNode)uaType, Identifiers.HasTypeDefinition, false);
    }

    @Override
    public void setTypeDefinitionId(ExpandedNodeId expandedNodeId) {
        try {
            this.setTypeDefinitionId(this.nodeManager.getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (ServiceResultException serviceResultException) {
            throw new IllegalArgumentException(serviceResultException);
        }
    }

    @Override
    public void setTypeDefinitionId(NodeId nodeId) {
        try {
            this.setTypeDefinition((UaType)this.nodeManager.getNodeOrExternal(nodeId));
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException);
        }
    }

    @Override
    public void setUserAccessLevel(AccessLevelType accessLevelType) {
        throw new IllegalArgumentException("Cannot set UserAccessLevel");
    }

    @Override
    public void setUserWriteMask(AttributeWriteMask attributeWriteMask) {
        throw new IllegalArgumentException("Cannot set UserWriteMask");
    }

    @Override
    public void setValue(DataValue dataValue) throws StatusException {
        DataValue dataValue2 = this.getValue();
        if (!Objects.equals(dataValue, dataValue2)) {
            this.doSetValue(dataValue);
        }
        this.dataChange(Attributes.Value, dataValue2, dataValue);
    }

    @Override
    public void setValue(Object object) throws StatusException {
        Variant variant;
        StatusCode statusCode;
        StatusCode statusCode2 = statusCode = object == null ? StatusCode.BAD : StatusCode.GOOD;
        if (object instanceof Variant && (variant = (Variant)object).getValue() == null) {
            statusCode = StatusCode.BAD;
        }
        this.updateValue(object, statusCode, null, null);
    }

    @Override
    public void setValueRank(int n2) {
        throw new IllegalArgumentException("Cannot set ValueRank");
    }

    @Override
    public void setWriteMask(AttributeWriteMask attributeWriteMask) {
        throw new IllegalArgumentException("Cannot set WriteMask");
    }

    @Override
    public boolean writeAttribute(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        logger.error("Cannot write attribute {}", (Object)unsignedInteger);
        return false;
    }

    private void updateValue(Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        Variant variant;
        DataValue dataValue;
        logger.debug("updateValue: {}", object);
        DateTime dateTime2 = new DateTime();
        UnsignedShort unsignedShort2 = UnsignedShort.valueOf(0);
        if (object instanceof DataValue) {
            dataValue = (DataValue)object;
            variant = dataValue.getValue();
            statusCode = dataValue.getStatusCode();
            dateTime = dataValue.getSourceTimestamp();
            unsignedShort = dataValue.getSourcePicoseconds();
        } else {
            variant = object instanceof Variant ? (Variant)object : new Variant(object);
        }
        dataValue = this.getValue();
        if (dataValue == null || dataValue.isNull() || !dataValue.getStatusCode().equals(statusCode) || !dataValue.getValue().equals(variant) || dateTime != null && !dateTime.equals(this.getValue().getSourceTimestamp())) {
            if (dateTime == null) {
                dateTime = dateTime2;
                unsignedShort = unsignedShort2;
            }
            this.setValue(new DataValue(variant, statusCode, dateTime, unsignedShort, dateTime2, unsignedShort2));
        } else {
            dataValue.setServerTimestamp(dateTime2);
        }
    }

    @Override
    protected boolean beforeAddReference(UaReference uaReference) {
        if (uaReference.getReferenceTypeId().equals(Identifiers.HasTypeDefinition) && uaReference.getSourceNode() == this) {
            return false;
        }
        if (this.qU == null && uaReference.getReferenceType().inheritsFrom(Identifiers.Aggregates) && uaReference.getTargetNode() == this) {
            this.qU = uaReference;
            return false;
        }
        return super.beforeAddReference(uaReference);
    }

    protected abstract void doSetValue(DataValue var1) throws StatusException;

    protected UaType getPropertyTypeNode() {
        if (qS == null) {
            try {
                qS = this.getNodeManager().getNode(Identifiers.PropertyType);
            }
            catch (StatusException statusException) {
                throw new RuntimeException(statusException);
            }
        }
        return (UaType)qS;
    }

    @Override
    protected List<UaReference> getReferencesAsList(Boolean bl, NodeId ... nodeIdArray) {
        List<UaReference> list = super.getReferencesAsList(bl, nodeIdArray);
        if (nodeIdArray == null || nodeIdArray.length == 0) {
            if (this.isFalseOrNull(bl)) {
                list.add(this.getTypeDefinitionReference());
            }
            if (this.isTrueOrNull(bl) && this.qU != null) {
                list.add(this.qU);
            }
        } else if (this.isFalseOrNull(bl) && this.referenceTypeInherits(Identifiers.HasTypeDefinition, nodeIdArray)) {
            list.add(this.getTypeDefinitionReference());
        }
        if (this.isTrueOrNull(bl) && this.qU != null && this.referenceTypeInherits(this.qU.getReferenceTypeId(), nodeIdArray)) {
            list.add(this.qU);
        }
        return list;
    }

    protected UaServerReference getTypeDefinitionReference() {
        return new a(Identifiers.HasTypeDefinition, (UaNode)this, (UaNode)this.getTypeDefinition());
    }
}

