/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.instantiation;

import com.prosysopc.ua.UaBrowseNamePath;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.ModellingRule;
import com.prosysopc.ua.server.instantiation.DefaultInstantiationStrategy;
import com.prosysopc.ua.server.instantiation.InstanceDeclaration;
import com.prosysopc.ua.server.instantiation.InstantiationStrategy;
import com.prosysopc.ua.server.instantiation.UaNodeBuilderConfiguration;
import com.prosysopc.ua.stack.common.NamespaceTable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDefinitionBasedNodeBuilderConfiguration
implements UaNodeBuilderConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TypeDefinitionBasedNodeBuilderConfiguration.class);
    private final InstantiationStrategy qA;
    private final Map<UaBrowseNamePath, InstantiationStrategy> qB;
    private final Map<UaQualifiedName, InstantiationStrategy> qC;
    private final boolean qD;

    public static Builder builder() {
        return new Builder(new DefaultInstantiationStrategy(DefaultInstantiationStrategy.MethodInstantiationLogic.SHARED));
    }

    public static Builder builder(InstantiationStrategy instantiationStrategy) {
        return new Builder(instantiationStrategy);
    }

    public static Builder builder(DefaultInstantiationStrategy.MethodInstantiationLogic methodInstantiationLogic) {
        return new Builder(new DefaultInstantiationStrategy(methodInstantiationLogic));
    }

    private TypeDefinitionBasedNodeBuilderConfiguration(InstantiationStrategy instantiationStrategy, Map<UaBrowseNamePath, InstantiationStrategy> map, Map<UaQualifiedName, InstantiationStrategy> map2, boolean bl) {
        this.qA = instantiationStrategy;
        this.qB = map;
        this.qC = map2;
        this.qD = bl;
    }

    @Override
    public InstantiationStrategy getInstantiationStrategy(UaNodeBuilderConfiguration.InstantiationStrategySearchParameters instantiationStrategySearchParameters) {
        try {
            if (instantiationStrategySearchParameters.getHierarchy().length == 0) {
                return this.qA;
            }
            InstanceDeclaration[] instanceDeclarationArray = instantiationStrategySearchParameters.getHierarchy();
            UaNode uaNode = instanceDeclarationArray[instanceDeclarationArray.length - 1].getNode();
            logger.debug("Searching using TypeDefinition of node with id: {}, name:{}", (Object)uaNode.getNodeId(), (Object)uaNode.getBrowseName());
            if (uaNode instanceof UaInstance || uaNode instanceof UaType) {
                Comparable<UaNodeId> comparable;
                UaType uaType;
                InstantiationStrategy instantiationStrategy = null;
                NamespaceTable namespaceTable = uaType.getAddressSpace().getNamespaceTable();
                UaQualifiedName uaQualifiedName = UaQualifiedName.from(instantiationStrategySearchParameters.getInstanceDeclaration().getNode().getBrowseName(), namespaceTable);
                for (uaType = uaNode instanceof UaType ? (UaType)uaNode : ((UaInstance)uaNode).getTypeDefinition(); uaType != null && instantiationStrategy == null; uaType = uaType.getSuperType()) {
                    comparable = UaNodeId.fromLocal(uaType.getNodeId(), namespaceTable);
                    UaBrowseNamePath uaBrowseNamePath = UaBrowseNamePath.from(comparable, new UaQualifiedName[]{uaQualifiedName});
                    instantiationStrategy = this.qB.get(uaBrowseNamePath);
                    if (instantiationStrategy != null) {
                        logger.debug("Found td/id: {}/{}, found: {}", uaType.getBrowseName(), uaQualifiedName.toQualifiedName(namespaceTable), instantiationStrategy);
                        continue;
                    }
                    logger.debug("Not found in/td/id: {}/({})/{}, searching again using super type of the typedefinition", uaNode.getBrowseName(), uaType.getBrowseName(), uaQualifiedName.toQualifiedName(namespaceTable));
                }
                if (instantiationStrategy == null) {
                    comparable = UaQualifiedName.from(instantiationStrategySearchParameters.getInstanceDeclaration().getNode().getBrowseName(), namespaceTable);
                    instantiationStrategy = this.qC.get(comparable);
                }
                if (instantiationStrategy == null && ModellingRule.Mandatory == instantiationStrategySearchParameters.getInstanceDeclaration().getModellingRule()) {
                    instantiationStrategy = this.qA;
                }
                logger.debug("Returning strategy:{}", (Object)instantiationStrategy);
                if (instantiationStrategy != null) {
                    return instantiationStrategy;
                }
            }
            if (ModellingRule.Mandatory == instantiationStrategySearchParameters.getInstanceDeclaration().getModellingRule()) {
                return this.qA;
            }
            if (this.qD && !ModellingRule.MandatoryPlaceholder.equals(instantiationStrategySearchParameters.getInstanceDeclaration().getModellingRule()) && !ModellingRule.OptionalPlaceholder.equals(instantiationStrategySearchParameters.getInstanceDeclaration().getModellingRule())) {
                return this.qA;
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            logger.error("Error while searching InstantiationStrategy", runtimeException);
            throw runtimeException;
        }
    }

    public static class Builder {
        private final InstantiationStrategy qE;
        private final Map<UaBrowseNamePath, InstantiationStrategy> qF;
        private final Map<UaQualifiedName, InstantiationStrategy> qG;
        private boolean qD;

        private Builder(InstantiationStrategy instantiationStrategy) {
            this.qE = instantiationStrategy;
            this.qF = new HashMap<UaBrowseNamePath, InstantiationStrategy>();
            this.qG = new HashMap<UaQualifiedName, InstantiationStrategy>();
            this.qD = false;
        }

        public Builder addOptional(Collection<UaBrowseNamePath> collection) {
            this.addOptional(collection.toArray(new UaBrowseNamePath[collection.size()]));
            return this;
        }

        public Builder addOptional(UaBrowseNamePath ... uaBrowseNamePathArray) {
            if (uaBrowseNamePathArray != null) {
                for (UaBrowseNamePath uaBrowseNamePath : uaBrowseNamePathArray) {
                    this.qF.put(uaBrowseNamePath, this.qE);
                }
            }
            return this;
        }

        public Builder addOptional(UaQualifiedName uaQualifiedName) {
            this.qG.put(uaQualifiedName, this.qE);
            return this;
        }

        public TypeDefinitionBasedNodeBuilderConfiguration build() {
            HashMap<UaBrowseNamePath, InstantiationStrategy> hashMap = new HashMap<UaBrowseNamePath, InstantiationStrategy>();
            hashMap.putAll(this.qF);
            HashMap<UaQualifiedName, InstantiationStrategy> hashMap2 = new HashMap<UaQualifiedName, InstantiationStrategy>();
            hashMap2.putAll(this.qG);
            return new TypeDefinitionBasedNodeBuilderConfiguration(this.qE, hashMap, hashMap2, this.qD);
        }

        public Builder setInstantiateAllOptionals(boolean bl) {
            this.qD = bl;
            return this;
        }

        public Builder setInstantiationStrategy(UaBrowseNamePath uaBrowseNamePath, InstantiationStrategy instantiationStrategy) {
            this.qF.put(uaBrowseNamePath, instantiationStrategy);
            return this;
        }
    }
}

