/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.instantiation;

import com.prosysopc.ua.RelativeNamePath;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.instantiation.b;
import com.prosysopc.ua.server.instantiation.h;
import com.prosysopc.ua.server.instantiation.k;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class TemporaryInstanceDeclaration {
    private final Set<RelativeNamePath> qa;
    private final Set<b> qb;
    private final Set<h> qt;
    private final UaNode node;
    private final List<UaNode> nodes;
    private final NodeId nodeId;

    public static Builder builder(TemporaryInstanceDeclaration temporaryInstanceDeclaration) {
        return new Builder(temporaryInstanceDeclaration);
    }

    public static Builder builder(TemporaryInstanceDeclaration temporaryInstanceDeclaration, RelativeNamePath relativeNamePath) {
        return new Builder(temporaryInstanceDeclaration, relativeNamePath);
    }

    public static Builder builder(UaNode uaNode, RelativeNamePath relativeNamePath) {
        return new Builder(uaNode, relativeNamePath);
    }

    public static Builder builder(UaType uaType) {
        return TemporaryInstanceDeclaration.builder(uaType, RelativeNamePath.EMPTY);
    }

    private TemporaryInstanceDeclaration(UaNode uaNode, List<UaNode> list, LinkedHashSet<RelativeNamePath> linkedHashSet, LinkedHashSet<b> linkedHashSet2, LinkedHashSet<h> linkedHashSet3) {
        this.node = uaNode;
        this.nodeId = uaNode.getNodeId();
        this.nodes = Collections.unmodifiableList(new ArrayList<UaNode>(list));
        this.qa = Collections.unmodifiableSet(linkedHashSet);
        this.qb = Collections.unmodifiableSet(linkedHashSet2);
        this.qt = Collections.unmodifiableSet(linkedHashSet3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TemporaryInstanceDeclaration temporaryInstanceDeclaration = (TemporaryInstanceDeclaration)object;
        if (this.qa == null ? temporaryInstanceDeclaration.qa != null : !this.qa.equals(temporaryInstanceDeclaration.qa)) {
            return false;
        }
        if (this.qb == null ? temporaryInstanceDeclaration.qb != null : !this.qb.equals(temporaryInstanceDeclaration.qb)) {
            return false;
        }
        if (this.qt == null ? temporaryInstanceDeclaration.qt != null : !this.qt.equals(temporaryInstanceDeclaration.qt)) {
            return false;
        }
        return !(this.nodeId == null ? temporaryInstanceDeclaration.nodeId != null : !this.nodeId.equals(temporaryInstanceDeclaration.nodeId));
    }

    public Set<RelativeNamePath> getBrowsePaths() {
        return this.qa;
    }

    public Set<b> getExternalReferences() {
        return this.qb;
    }

    public Set<h> getInternalReferences() {
        return this.qt;
    }

    public UaNode getNode() {
        return this.node;
    }

    public List<UaNode> getNodes() {
        return this.nodes;
    }

    public RelativeNamePath getPrimaryPath() {
        return this.qa.iterator().next();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.qa == null ? 0 : this.qa.hashCode());
        n3 = 31 * n3 + (this.qb == null ? 0 : this.qb.hashCode());
        n3 = 31 * n3 + (this.qt == null ? 0 : this.qt.hashCode());
        n3 = 31 * n3 + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return n3;
    }

    public boolean hasPath(RelativeNamePath relativeNamePath) {
        return this.qa.contains(relativeNamePath);
    }

    public boolean isRoot() {
        return this.qa.size() == 1 && this.getPrimaryPath().isEmpty();
    }

    public String toString() {
        return "Paths=" + this.qa;
    }

    TemporaryInstanceDeclaration b(TemporaryInstanceDeclaration temporaryInstanceDeclaration) {
        Builder builder = TemporaryInstanceDeclaration.builder(this);
        builder.nodes.addAll(temporaryInstanceDeclaration.nodes);
        builder.addBrowsePath(temporaryInstanceDeclaration.qa);
        builder.addExternalReference(temporaryInstanceDeclaration.qb);
        builder.addInternalReference(temporaryInstanceDeclaration.qt);
        return builder.build();
    }

    public static class Builder {
        private final LinkedHashSet<RelativeNamePath> qu = new LinkedHashSet();
        private final LinkedHashSet<b> qv = new LinkedHashSet();
        private final LinkedHashSet<h> qw = new LinkedHashSet();
        private final UaNode node;
        private final List<UaNode> nodes = new ArrayList<UaNode>();

        private Builder(TemporaryInstanceDeclaration temporaryInstanceDeclaration) {
            this.node = temporaryInstanceDeclaration.node;
            this.nodes.add(this.node);
            this.qu.addAll(temporaryInstanceDeclaration.qa);
            this.qv.addAll(temporaryInstanceDeclaration.qb);
            this.qw.addAll(temporaryInstanceDeclaration.qt);
        }

        private Builder(TemporaryInstanceDeclaration temporaryInstanceDeclaration, RelativeNamePath relativeNamePath) {
            this.node = temporaryInstanceDeclaration.node;
            this.nodes.add(this.node);
            for (Comparable<RelativeNamePath> comparable : temporaryInstanceDeclaration.qa) {
                this.qu.add(relativeNamePath.append((RelativeNamePath)comparable));
            }
            this.qv.addAll(temporaryInstanceDeclaration.qb);
            for (Comparable<RelativeNamePath> comparable : temporaryInstanceDeclaration.qt) {
                this.qw.add(new h(((k)comparable).getReferenceType(), relativeNamePath.append(((h)comparable).cnv())));
            }
        }

        private Builder(UaNode uaNode, RelativeNamePath relativeNamePath) {
            this.node = uaNode;
            this.nodes.add(uaNode);
            this.qu.add(relativeNamePath);
        }

        public void addBrowsePath(Collection<? extends RelativeNamePath> collection) {
            this.qu.addAll(collection);
        }

        public void addBrowsePath(RelativeNamePath relativeNamePath) {
            this.qu.add(relativeNamePath);
        }

        public void addExternalReference(Collection<? extends b> collection) {
            this.qv.addAll(collection);
        }

        public void addExternalReference(b b2) {
            this.qv.add(b2);
        }

        public void addInternalReference(Collection<? extends h> collection) {
            this.qw.addAll(collection);
        }

        public void addInternalReference(h h2) {
            this.qw.add(h2);
        }

        public TemporaryInstanceDeclaration build() {
            return new TemporaryInstanceDeclaration(this.node, this.nodes, this.qu, this.qv, this.qw);
        }

        public UaNode getNode() {
            return this.node;
        }

        public RelativeNamePath getPrimaryPath() {
            return (RelativeNamePath)this.qu.iterator().next();
        }
    }
}

