/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.instantiation;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.GeneratedNode;
import com.prosysopc.ua.server.InvalidTypeNodeException;
import com.prosysopc.ua.server.ModellingRule;
import com.prosysopc.ua.server.NodeBuilderException;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.instantiation.InstanceDeclaration;
import com.prosysopc.ua.server.instantiation.InstanceDeclarationHierarchy;
import com.prosysopc.ua.server.instantiation.InstanceDeclarationHierarchyException;
import com.prosysopc.ua.server.instantiation.InstantiationParameters;
import com.prosysopc.ua.server.instantiation.InstantiationStrategy;
import com.prosysopc.ua.server.instantiation.UaNodeBuilderConfiguration;
import com.prosysopc.ua.server.instantiation.b;
import com.prosysopc.ua.server.instantiation.f;
import com.prosysopc.ua.server.instantiation.g;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.VariableAttributes;
import com.prosysopc.ua.stack.core.VariableTypeAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeBuilder<T extends UaInstance> {
    private static final InstantiationStrategy DEFAULT_INSTANTIATION_STRATEGY = UaNodeBuilderConfiguration.DEFAULT_INSTANTIATION_STRATEGY;
    private static final Logger logger = LoggerFactory.getLogger(NodeBuilder.class);
    private static Set<NodeId> qo = new HashSet<NodeId>();
    private QualifiedName hl;
    private final UaNodeBuilderConfiguration qp;
    private int qq = -1;
    private LocalizedText hm;
    private String name;
    private NodeId nodeId;
    private final NodeManagerUaNode nodeManager;
    private final UaType qr;

    protected static boolean isTypeOnlyReference(b b2) {
        return qo.contains(b2.getReferenceType().getNodeId());
    }

    public NodeBuilder(NodeManagerUaNode nodeManagerUaNode, UaNodeBuilderConfiguration uaNodeBuilderConfiguration, UaType uaType) throws InvalidTypeNodeException {
        if (nodeManagerUaNode == null) {
            throw new NullPointerException("NodeBuilder: nodeManager");
        }
        if (uaNodeBuilderConfiguration == null) {
            throw new NullPointerException("NodeBuilder: configuration");
        }
        if (uaType == null) {
            throw new NullPointerException("NodeBuilder: type");
        }
        this.nodeManager = nodeManagerUaNode;
        this.qr = uaType;
        this.qp = uaNodeBuilderConfiguration;
        switch (uaType.getNodeClass()) {
            case ObjectType: {
                break;
            }
            case VariableType: {
                break;
            }
            default: {
                throw new InvalidTypeNodeException("NodeBuilder: Invalid NodeClass of type node.");
            }
        }
    }

    public T build() throws NodeBuilderException {
        Object object;
        UaNode uaNode;
        InstanceDeclarationHierarchy instanceDeclarationHierarchy;
        this.cnw();
        logger.debug("build: browseName={} type={}", (Object)this.hl, (Object)this.qr);
        try {
            instanceDeclarationHierarchy = this.nodeManager.getNodeManagerTable().getInstanceDeclarationHierarchyCache().getForType(this.qr);
        }
        catch (InstanceDeclarationHierarchyException instanceDeclarationHierarchyException) {
            throw new NodeBuilderException("Could not get InstanceDeclarationHierarchy", instanceDeclarationHierarchyException);
        }
        g g2 = instanceDeclarationHierarchy.cnm();
        InstantiationStrategy instantiationStrategy = this.qp.getInstantiationStrategy(new UaNodeBuilderConfiguration.InstantiationStrategySearchParameters(g2, this.nodeManager.getNamespaceTable(), new InstanceDeclaration[0]));
        if (instantiationStrategy == null) {
            instantiationStrategy = DEFAULT_INSTANTIATION_STRATEGY;
        }
        logger.debug("build: rootStrategy={}", (Object)instantiationStrategy);
        InstantiationParameters instantiationParameters = new InstantiationParameters(g2, this.nodeManager, this.nodeId, null, this.hl, this.hm);
        UaInstance uaInstance = (UaInstance)instantiationStrategy.createInstance(instantiationParameters);
        this.a(uaInstance, this.qr);
        uaInstance.setTypeDefinition(this.qr);
        if (logger.isDebugEnabled()) {
            logger.debug("build: rootStrategy.createsCompleteHierarchy()={}", (Object)instantiationStrategy.createsCompleteHierarchy());
        }
        if (instantiationStrategy.createsCompleteHierarchy()) {
            return (T)uaInstance;
        }
        HashMap<g, InstantiationParameters> hashMap = new HashMap<g, InstantiationParameters>();
        HashMap<g, UaNode> hashMap2 = new HashMap<g, UaNode>();
        hashMap2.put(g2, uaInstance);
        this.a(g2, new g[]{g2}, hashMap2, uaInstance, hashMap);
        for (g object2 : hashMap2.keySet()) {
            uaNode = (UaNode)hashMap2.get(object2);
            if (uaNode == object2.getNode()) continue;
            logger.trace("build: references for node={}", (Object)uaNode);
            object = new ArrayList<b>(object2.getExternalReferences());
            ArrayList<f> arrayList = new ArrayList<f>(object2.cno());
            Collections.reverse(object);
            Collections.reverse(arrayList);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                b b2 = (b)iterator.next();
                if (NodeBuilder.isTypeOnlyReference(b2)) continue;
                logger.trace("build: externalReference={}", (Object)b2);
                uaNode.addReference(b2.cnk(), b2.getReferenceType().getNodeId(), false);
            }
            for (f f2 : arrayList) {
                if (!hashMap2.containsKey(f2.cnu())) continue;
                logger.trace("build: instanceReference={}", (Object)f2);
                uaNode.addReference((UaNode)hashMap2.get(f2.cnu()), f2.getReferenceType().getNodeId(), false);
            }
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            uaNode = (UaNode)entry.getValue();
            if (uaNode == uaInstance || uaNode == ((g)entry.getKey()).getNode()) continue;
            logger.trace("build: attributes for node={}", (Object)uaNode);
            object = (InstantiationParameters)hashMap.get(entry.getKey());
            uaNode.setAttributes(((InstantiationParameters)object).getNodeAttributes());
        }
        if (uaInstance instanceof GeneratedNode) {
            ((GeneratedNode)((Object)uaInstance)).afterCreate();
        }
        this.clear();
        return (T)uaInstance;
    }

    public void clear() {
        this.hl = null;
        this.qq = -1;
        this.hm = null;
        this.name = null;
        this.nodeId = null;
    }

    public NodeBuilder<T> setBrowseName(QualifiedName qualifiedName) {
        this.hl = qualifiedName;
        return this;
    }

    public NodeBuilder<T> setDefaultNameSpaceIndex(int n2) {
        this.qq = n2;
        return this;
    }

    public NodeBuilder<T> setDisplayName(LocalizedText localizedText) {
        this.hm = localizedText;
        return this;
    }

    public NodeBuilder<T> setName(String string) {
        this.name = string;
        return this;
    }

    public NodeBuilder<T> setNodeId(NodeId nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    private void addNode(UaNode uaNode) throws NodeBuilderException {
        if (uaNode == null) {
            throw new NodeBuilderException("Nodebuilder.addNode, node cannot be null");
        }
        try {
            this.nodeManager.addNode(uaNode);
        }
        catch (StatusException statusException) {
            throw new NodeBuilderException("Could not add node " + uaNode + " to NodeManager", statusException);
        }
    }

    private void a(g g2, g[] gArray, Map<g, UaNode> map, UaNode uaNode, Map<g, InstantiationParameters> map2) throws NodeBuilderException {
        Set<? extends g> set = g2.getNextDeclarations();
        for (g g3 : set) {
            if (map.get(g3) != null) continue;
            InstantiationStrategy instantiationStrategy = this.qp.getInstantiationStrategy(new UaNodeBuilderConfiguration.InstantiationStrategySearchParameters(g3, this.nodeManager.getNamespaceTable(), gArray));
            logger.debug("createNodes: instanceDeclaration={} instantiationStrategy={}", (Object)g3, (Object)instantiationStrategy);
            if (instantiationStrategy == null && !ModellingRule.Mandatory.equals(g3.getModellingRule())) {
                logger.debug("createNodes: skipped");
                continue;
            }
            if (instantiationStrategy == null) {
                instantiationStrategy = DEFAULT_INSTANTIATION_STRATEGY;
            }
            NodeId nodeId = this.nodeManager.createNodeId(uaNode, g3.getNode().getBrowseName());
            InstantiationParameters instantiationParameters = new InstantiationParameters(g3, nodeId, this.nodeManager, uaNode);
            UaNode uaNode2 = instantiationStrategy.createInstance(instantiationParameters);
            map.put(g3, uaNode2);
            map2.put(g3, instantiationParameters);
            if (uaNode2 == g3.getNode()) continue;
            this.addNode(uaNode2);
            if (instantiationStrategy.createsCompleteHierarchy()) continue;
            ArrayList<g> arrayList = new ArrayList<g>();
            for (g g4 : gArray) {
                arrayList.add(g4);
            }
            arrayList.add(g3);
            this.a(g3, arrayList.toArray(new g[0]), map, uaNode2, map2);
        }
    }

    private void a(UaNode uaNode, UaType uaType) {
        NodeAttributes nodeAttributes = uaNode.getAttributes();
        NodeAttributes nodeAttributes2 = uaType.getAttributes().clone();
        nodeAttributes.setDescription(nodeAttributes2.getDescription());
        nodeAttributes.setUserWriteMask(nodeAttributes2.getUserWriteMask());
        nodeAttributes.setWriteMask(nodeAttributes2.getWriteMask());
        if (nodeAttributes instanceof VariableAttributes && nodeAttributes2 instanceof VariableTypeAttributes) {
            this.a((VariableAttributes)nodeAttributes, (VariableTypeAttributes)nodeAttributes2);
        }
        uaNode.setAttributes(nodeAttributes);
    }

    private void a(VariableAttributes variableAttributes, VariableTypeAttributes variableTypeAttributes) {
        variableAttributes.setArrayDimensions(variableTypeAttributes.getArrayDimensions());
        variableAttributes.setValueRank(variableTypeAttributes.getValueRank());
        variableAttributes.setDataType(variableTypeAttributes.getDataType());
        variableAttributes.setValue(variableTypeAttributes.getValue());
    }

    private void cnw() throws NodeBuilderException {
        if (this.hl == null && this.name != null && this.qq >= 0) {
            this.setBrowseName(new QualifiedName(this.qq, this.name));
        }
        if (this.hm == null && this.name != null) {
            this.hm = new LocalizedText(this.name, "");
            this.setDisplayName(this.hm);
        }
        if (this.nodeId == null && this.name != null && this.qq >= 0) {
            this.setNodeId(new NodeId(this.qq, this.name));
        }
        if (this.hl == null) {
            throw new NodeBuilderException("Browse name is not set.");
        }
        if (this.hm == null) {
            throw new NodeBuilderException("Display name is not set.");
        }
        if (this.nodeId == null) {
            throw new NodeBuilderException("Node id is not set.");
        }
    }

    static {
        qo.add(Identifiers.HasModellingRule);
        qo.add(Identifiers.GeneratesEvent);
    }
}

