/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.instantiation;

import com.prosysopc.ua.RelativeNamePath;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.instantiation.InstanceDeclaration;
import com.prosysopc.ua.server.instantiation.InstanceDeclarationHierarchyCache;
import com.prosysopc.ua.server.instantiation.InstanceDeclarationHierarchyException;
import com.prosysopc.ua.server.instantiation.TemporaryInstanceDeclaration;
import com.prosysopc.ua.server.instantiation.d;
import com.prosysopc.ua.server.instantiation.g;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstanceDeclarationHierarchy {
    private static final Logger logger = LoggerFactory.getLogger(InstanceDeclarationHierarchy.class);
    public static boolean addInstanceDeclarationsTypeDefinitionOptionals = false;
    private final d pX;
    private final g pY;

    InstanceDeclarationHierarchy(UaType uaType, InstanceDeclarationHierarchyCache instanceDeclarationHierarchyCache) {
        d d2 = this.a(uaType);
        logger.debug("type:{} id:{}, IDset before merging ID typedefs, {}", uaType.getBrowseName(), uaType.getNodeId(), d2);
        d d3 = this.a(d2, instanceDeclarationHierarchyCache);
        this.pY = d3.cnr();
        this.pX = d3;
    }

    public Optional<UaNode> findFirstMatch(RelativeNamePath relativeNamePath, boolean bl, Predicate<UaNode> predicate) {
        Optional<UaNode> optional = this.a(this.pY, relativeNamePath, predicate);
        if (optional.isPresent()) {
            return optional;
        }
        if (!bl) {
            return Optional.empty();
        }
        RelativeNamePath relativeNamePath2 = relativeNamePath.removeFirst();
        if (relativeNamePath2.isEmpty()) {
            return Optional.empty();
        }
        g g2 = this.pY.cnn().get(relativeNamePath.getFirst());
        if (g2 == null || !(g2.getNode() instanceof UaInstance)) {
            return Optional.empty();
        }
        UaInstance uaInstance = (UaInstance)g2.getNode();
        NodeManagerTable nodeManagerTable = (NodeManagerTable)uaInstance.getAddressSpace();
        try {
            InstanceDeclarationHierarchy instanceDeclarationHierarchy = nodeManagerTable.getInstanceDeclarationHierarchyCache().getForType(uaInstance.getTypeDefinition());
            Optional<UaNode> optional2 = instanceDeclarationHierarchy.findFirstMatch(relativeNamePath2, true, predicate);
            if (optional2.isPresent()) {
                return optional2;
            }
        }
        catch (Exception exception) {
            logger.warn("Failure during searching InstanceDeclarationHierarchy", exception);
            return Optional.empty();
        }
        return Optional.empty();
    }

    public InstanceDeclaration getRoot() {
        return this.pY;
    }

    private d a(d d2, InstanceDeclarationHierarchyCache instanceDeclarationHierarchyCache) {
        d d3 = d2;
        if (addInstanceDeclarationsTypeDefinitionOptionals) {
            for (TemporaryInstanceDeclaration temporaryInstanceDeclaration : d2) {
                d3 = this.a(temporaryInstanceDeclaration, d3, instanceDeclarationHierarchyCache);
            }
        }
        return d3;
    }

    private d a(TemporaryInstanceDeclaration temporaryInstanceDeclaration, d d2, InstanceDeclarationHierarchyCache instanceDeclarationHierarchyCache) {
        UaNode uaNode = temporaryInstanceDeclaration.getNode();
        d d3 = d2;
        if (uaNode instanceof UaInstance) {
            UaType uaType = ((UaInstance)uaNode).getTypeDefinition();
            InstanceDeclarationHierarchy instanceDeclarationHierarchy = null;
            try {
                instanceDeclarationHierarchy = instanceDeclarationHierarchyCache.getForType(uaType);
            }
            catch (InstanceDeclarationHierarchyException instanceDeclarationHierarchyException) {
                logger.debug("Could not get InstanceDeclarationHierarchy. This situation can happen if a TypeDefinition has an InstanceDeclration that has the TypeDefintion in question, i.e. a type node has an InstanceDeclaration of itself", instanceDeclarationHierarchyException);
                return d3;
            }
            for (RelativeNamePath relativeNamePath : temporaryInstanceDeclaration.getBrowsePaths()) {
                d d4 = instanceDeclarationHierarchy.a(relativeNamePath);
                d3 = d3.a(d4);
            }
        }
        return d3;
    }

    private Optional<UaNode> a(g g2, RelativeNamePath relativeNamePath, Predicate<UaNode> predicate) {
        if (g2 == null) {
            return Optional.empty();
        }
        if (relativeNamePath.isEmpty()) {
            for (UaNode uaNode : g2.getNodes()) {
                if (!predicate.test(uaNode)) continue;
                return Optional.of(uaNode);
            }
            return Optional.empty();
        }
        return this.a(g2.cnn().get(relativeNamePath.getFirst()), relativeNamePath.removeFirst(), predicate);
    }

    private d a(UaType uaType) {
        d d2 = d.c(uaType);
        if (uaType.hasSuperType()) {
            d2 = d2.a(this.a(uaType.getSuperType()));
        }
        logger.debug("getFullyInherited: type={} set={}", (Object)uaType.getBrowseName(), (Object)d2);
        return d2;
    }

    d a(RelativeNamePath relativeNamePath) {
        return this.pX.c(relativeNamePath);
    }

    g cnm() {
        return this.pY;
    }
}

