/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.InternalUaNodeSetNodeManagerUaNodeParser;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaException;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaNodeSet;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.UaReferenceTypeIds;
import com.prosysopc.ua.internal.InternalDefinitionFieldXMLDataContainer;
import com.prosysopc.ua.internal.InternalDefinitionXMLDataContainer;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.server.GeneratedNode;
import com.prosysopc.ua.server.ModelParser;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.AddNodesItem;
import com.prosysopc.ua.stack.core.AddReferencesItem;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.OptionSet;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.DynamicOptionSetStructure;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.OptionSetStructure;
import com.prosysopc.ua.typedictionary.OptionSetStructureSpecification;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class a {
    private static final Logger logger = LoggerFactory.getLogger(a.class);
    private static final UaQualifiedName iF = UaQualifiedName.standard("Default Binary");
    private static final UaQualifiedName iG = UaQualifiedName.standard("Default XML");
    private static final UaQualifiedName iH = UaQualifiedName.standard("Default JSON");
    private final EncoderContext iI;
    private final List<UaNodeSet> iJ;
    private final Set<UaNodeId> iK = new HashSet<UaNodeId>();
    private final Set<UaNodeId> iL = new HashSet<UaNodeId>();
    private final Set<UaNodeId> iM = new HashSet<UaNodeId>();
    private final Set<UaNodeId> iN = new HashSet<UaNodeId>();
    private final Map<UaNodeId, UaNodeId> iO = new HashMap<UaNodeId, UaNodeId>();
    private final Map<UaNodeId, UaNodeId> iP = new HashMap<UaNodeId, UaNodeId>();
    private final Map<UaNodeId, UaNodeId> iQ = new HashMap<UaNodeId, UaNodeId>();
    private final Map<UaNodeId, UaNodeId> iR = new HashMap<UaNodeId, UaNodeId>();
    private final Map<UaNodeId, UaNodeId> iS = new HashMap<UaNodeId, UaNodeId>();
    private final Set<UaNodeSet.NodeData> iT = new CopyOnWriteArraySet<UaNodeSet.NodeData>();
    private final Set<UaNodeSet.NodeData> iU = new CopyOnWriteArraySet<UaNodeSet.NodeData>();
    private final Set<UaNodeSet.NodeData> iV = new CopyOnWriteArraySet<UaNodeSet.NodeData>();
    private final Set<UaNodeSet.NodeData> iW = new CopyOnWriteArraySet<UaNodeSet.NodeData>();
    private final Set<UaNodeSet.NodeData> iX = new CopyOnWriteArraySet<UaNodeSet.NodeData>();
    private final Set<AddNodesItem> iY = new HashSet<AddNodesItem>();
    private final Set<AddReferencesItem> iZ = new HashSet<AddReferencesItem>();

    protected static a a(EncoderContext encoderContext, Iterable<UaNodeSet> iterable) {
        EncoderContext encoderContext2 = encoderContext;
        ArrayList<UaNodeSet> arrayList = new ArrayList<UaNodeSet>();
        iterable.forEach(uaNodeSet -> arrayList.add((UaNodeSet)uaNodeSet));
        a a2 = new a(encoderContext2, arrayList);
        a2.resolve();
        return a2;
    }

    protected static a a(EncoderContext encoderContext, UaNodeSet ... uaNodeSetArray) {
        return a.a(encoderContext, Arrays.asList(uaNodeSetArray));
    }

    private a(EncoderContext encoderContext, List<UaNodeSet> list) {
        this.iI = encoderContext;
        this.iJ = list;
    }

    private void cjT() {
        this.iJ.forEach(uaNodeSet -> uaNodeSet.getNamespaces().forEach(uaNamespace -> this.iI.getNamespaceTable().add(uaNamespace.getURI())));
    }

    private Optional<UaDataTypeSpecification> c(UaNodeId uaNodeId) {
        UaNodeId uaNodeId2 = uaNodeId;
        UaDataTypeSpecification uaDataTypeSpecification = null;
        while ((uaNodeId2 = this.iR.get(uaNodeId2)) != null && (uaDataTypeSpecification = this.iI.getDataTypeSpecifications().get(uaNodeId2)) == null) {
        }
        return Optional.ofNullable(uaDataTypeSpecification);
    }

    private void cjU() {
        this.iJ.stream().flatMap(uaNodeSet -> uaNodeSet.getNodes().stream()).filter(nodeData -> nodeData.getNodeClass() == NodeClass.DataType).forEach(nodeData -> {
            if (this.iI.getDataTypeSpecifications().containsKey(nodeData.getNodeId())) {
                return;
            }
            if (this.e(nodeData.getNodeId())) {
                this.iV.add((UaNodeSet.NodeData)nodeData);
                return;
            }
            if (this.f(nodeData.getNodeId())) {
                if (UaIds.Structure.equals(nodeData.getNodeId())) {
                    return;
                }
                this.iU.add((UaNodeSet.NodeData)nodeData);
                return;
            }
            if (this.d(nodeData.getNodeId())) {
                this.iT.add((UaNodeSet.NodeData)nodeData);
                return;
            }
            InternalDefinitionXMLDataContainer internalDefinitionXMLDataContainer = (InternalDefinitionXMLDataContainer)nodeData.get(InternalUaNodeSetNodeManagerUaNodeParser.internal());
            if (internalDefinitionXMLDataContainer == null) {
                this.iX.add((UaNodeSet.NodeData)nodeData);
                return;
            }
            if (internalDefinitionXMLDataContainer.isOptionSet) {
                this.iW.add((UaNodeSet.NodeData)nodeData);
                return;
            }
            logger.warn("Encountered DataType whose kind cannot be resolved, name: {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
        });
        logger.debug("Unknown DataTypes to resolve counts, enumerations: {}, simpletypes: {}, optionsets: {}, structures: {}, optionsetstructures: {}", this.iT.size(), this.iX.size(), this.iW.size(), this.iU.size(), this.iV.size());
    }

    private boolean d(UaNodeId uaNodeId) {
        if (uaNodeId == null) {
            return false;
        }
        if (UaIds.Enumeration.equals(uaNodeId)) {
            return true;
        }
        if (this.iI.getDataTypeSpecifications().get(uaNodeId) instanceof EnumerationSpecification) {
            return true;
        }
        return this.d(this.iR.get(uaNodeId));
    }

    private boolean e(UaNodeId uaNodeId) {
        if (uaNodeId == null) {
            return false;
        }
        if (UaIds.OptionSet.equals(uaNodeId)) {
            return true;
        }
        if (this.iI.getDataTypeSpecifications().get(uaNodeId) instanceof OptionSetStructureSpecification) {
            return true;
        }
        return this.e(this.iR.get(uaNodeId));
    }

    private boolean f(UaNodeId uaNodeId) {
        if (uaNodeId == null) {
            return false;
        }
        if (UaIds.Structure.equals(uaNodeId)) {
            return true;
        }
        if (this.iI.getDataTypeSpecifications().get(uaNodeId) instanceof StructureSpecification) {
            return true;
        }
        return this.f(this.iR.get(uaNodeId));
    }

    private void resolve() {
        this.cjV();
        this.cjW();
        this.cjX();
        this.cjU();
        this.cjY();
        this.cjT();
        this.iJ.forEach(uaNodeSet -> uaNodeSet.nodesToAddNodesItem(this.iI).forEach(addNodesItem -> this.iY.add((AddNodesItem)addNodesItem)));
        this.iJ.forEach(uaNodeSet -> uaNodeSet.referencesToAddReferencesItem(this.iI).forEach(addReferencesItem -> this.iZ.add((AddReferencesItem)addReferencesItem)));
        logger.debug("Resolved {} AddNodesItems and {} AddReferencesItems", (Object)this.iY.size(), (Object)this.iZ.size());
    }

    private void cjV() {
        this.iK.addAll(this.iI.getDataTypeSpecifications().keySet());
        this.iK.add(UaIds.Structure);
        this.iK.add(UaIds.Enumeration);
        this.iJ.stream().flatMap(uaNodeSet -> uaNodeSet.getNodes().stream()).filter(nodeData -> nodeData.getNodeClass() == NodeClass.DataType).forEach(nodeData -> this.iK.add(nodeData.getNodeId()));
    }

    private void f(UaNodeSet.NodeData nodeData) {
        if (UaIds.Enumeration.equals(nodeData.getNodeId())) {
            return;
        }
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setTypeId(nodeData.getNodeId());
        builder.setName(nodeData.getBrowseName().getName());
        InternalDefinitionXMLDataContainer internalDefinitionXMLDataContainer = (InternalDefinitionXMLDataContainer)nodeData.get(InternalUaNodeSetNodeManagerUaNodeParser.internal());
        if (internalDefinitionXMLDataContainer != null) {
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            internalDefinitionXMLDataContainer.fields.forEach(internalDefinitionFieldXMLDataContainer -> hashMap.put(internalDefinitionFieldXMLDataContainer.value, internalDefinitionFieldXMLDataContainer.name));
            builder.setMappings(hashMap);
        }
        logger.debug("Resolved Enumeration: {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
        this.iI.addDataTypeSpecification(builder.build());
    }

    private void g(UaNodeSet.NodeData nodeData) {
        Optional<UaDataTypeSpecification> optional = this.c(nodeData.getNodeId());
        if (!optional.isPresent()) {
            logger.warn("Cannot resolve parent specification for node, name: {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
            return;
        }
        InternalDefinitionXMLDataContainer internalDefinitionXMLDataContainer = (InternalDefinitionXMLDataContainer)nodeData.get(InternalUaNodeSetNodeManagerUaNodeParser.internal());
        if (internalDefinitionXMLDataContainer == null) {
            logger.warn("UInteger-OptionSets without <Definition> not yet supported, {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
            return;
        }
        OptionSetSpecification.Builder<UaOptionSet.Builder> builder = OptionSetSpecification.builder();
        builder.setTypeId(nodeData.getNodeId());
        builder.setName(nodeData.getBrowseName().getName());
        UaDataTypeSpecification uaDataTypeSpecification = optional.get();
        if (uaDataTypeSpecification instanceof SimpleTypeSpecification) {
            SimpleTypeSpecification simpleTypeSpecification = (SimpleTypeSpecification)uaDataTypeSpecification;
            builder.setBaseTypeId(simpleTypeSpecification.getBaseTypeId());
            for (InternalDefinitionFieldXMLDataContainer internalDefinitionFieldXMLDataContainer : internalDefinitionXMLDataContainer.fields) {
                OptionSpecification.Builder builder2 = OptionSpecification.builder();
                builder2.setName(internalDefinitionFieldXMLDataContainer.name);
                builder2.setBitPosition(internalDefinitionFieldXMLDataContainer.value);
                builder.addOptions(builder2.build());
            }
            this.iI.addDataTypeSpecification(builder.build());
            return;
        }
        if (uaDataTypeSpecification instanceof OptionSetSpecification) {
            OptionSetSpecification optionSetSpecification = (OptionSetSpecification)uaDataTypeSpecification;
            builder.setBaseTypeId(optionSetSpecification.getBaseTypeId());
            for (InternalDefinitionFieldXMLDataContainer internalDefinitionFieldXMLDataContainer : internalDefinitionXMLDataContainer.fields) {
                OptionSpecification.Builder builder3 = OptionSpecification.builder();
                builder3.setName(internalDefinitionFieldXMLDataContainer.name);
                builder3.setBitPosition(internalDefinitionFieldXMLDataContainer.value);
                builder.addOptions(builder3.build());
            }
            this.iI.addDataTypeSpecification(builder.build());
            return;
        }
        logger.warn("Unknown parent spec type: {}, for node, name: {}, id: {}", uaDataTypeSpecification, nodeData.getBrowseName(), nodeData.getNodeId());
    }

    private void h(UaNodeSet.NodeData nodeData) {
        InternalDefinitionXMLDataContainer internalDefinitionXMLDataContainer = (InternalDefinitionXMLDataContainer)nodeData.get(InternalUaNodeSetNodeManagerUaNodeParser.internal());
        if (internalDefinitionXMLDataContainer == null) {
            logger.error("OptionSets Structures without <Definition> not yet supported, {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
            return;
        }
        OptionSetStructureSpecification.Builder<OptionSetStructure.Builder> builder = OptionSetStructureSpecification.builder();
        builder.setTypeId(nodeData.getNodeId());
        builder.setName(nodeData.getBrowseName().getName());
        builder.setBaseTypeId(UaIds.OptionSet);
        builder.setJavaClass((Class)DynamicOptionSetStructure.class);
        builder.setBinaryEncodeId(this.iO.get(nodeData.getNodeId()));
        builder.setXmlEncodeId(this.iP.get(nodeData.getNodeId()));
        builder.setJsonEncodeId(this.iQ.get(nodeData.getNodeId()));
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.addField(OptionSet.Fields.Value.getSpecification());
        builder.addField(OptionSet.Fields.ValidBits.getSpecification());
        for (InternalDefinitionFieldXMLDataContainer internalDefinitionFieldXMLDataContainer : internalDefinitionXMLDataContainer.fields) {
            OptionSpecification.Builder builder2 = OptionSpecification.builder();
            builder2.setName(internalDefinitionFieldXMLDataContainer.name);
            builder2.setBitPosition(internalDefinitionFieldXMLDataContainer.value);
            builder.addOptions(builder2.build());
        }
        logger.debug("Resolved OptionSetStructure: {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
        this.iI.addDataTypeSpecification(builder.build());
    }

    private void i(UaNodeSet.NodeData nodeData) {
        Optional<SimpleTypeSpecification> optional = this.c(nodeData.getNodeId()).filter(uaDataTypeSpecification -> uaDataTypeSpecification instanceof SimpleTypeSpecification).map(uaDataTypeSpecification -> (SimpleTypeSpecification)SimpleTypeSpecification.class.cast(uaDataTypeSpecification));
        if (!optional.isPresent()) {
            logger.error("Cannot resolve parent SimpleTypeSpecification for node, name: {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
            return;
        }
        SimpleTypeSpecification.Builder builder = SimpleTypeSpecification.builder();
        builder.setTypeId(nodeData.getNodeId());
        builder.setName(nodeData.getBrowseName().getName());
        builder.setBaseTypeId(optional.get().getBaseTypeId());
        builder.setJavaClass(optional.get().getJavaClass());
        logger.debug("Resolved SimpleType: {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
        this.iI.addDataTypeSpecification(builder.build());
    }

    private void cjW() {
        this.iJ.stream().flatMap(uaNodeSet -> uaNodeSet.getNodes().stream()).filter(nodeData -> nodeData.getNodeClass() == NodeClass.Object).forEach(nodeData -> {
            if (iF.equals(nodeData.getBrowseName())) {
                this.iL.add(nodeData.getNodeId());
            } else if (iG.equals(nodeData.getBrowseName())) {
                this.iM.add(nodeData.getNodeId());
            } else if (iH.equals(nodeData.getBrowseName())) {
                this.iN.add(nodeData.getNodeId());
            }
        });
        this.iJ.stream().flatMap(uaNodeSet -> uaNodeSet.getReferences().stream()).filter(referenceData -> UaReferenceTypeIds.HasEncoding.equals(referenceData.getReferenceType())).forEach(referenceData -> {
            UaNodeId uaNodeId;
            UaNodeId uaNodeId2 = referenceData.isForward() ? referenceData.getReferenceSource() : referenceData.getReferenceTarget();
            UaNodeId uaNodeId3 = uaNodeId = referenceData.isForward() ? referenceData.getReferenceTarget() : referenceData.getReferenceSource();
            if (this.iL.contains(uaNodeId)) {
                this.iO.put(uaNodeId2, uaNodeId);
            } else if (this.iM.contains(uaNodeId)) {
                this.iP.put(uaNodeId2, uaNodeId);
            } else if (this.iN.contains(uaNodeId)) {
                this.iQ.put(uaNodeId2, uaNodeId);
            }
        });
    }

    private void cjX() {
        this.iJ.stream().flatMap(uaNodeSet -> uaNodeSet.getReferences().stream()).filter(referenceData -> UaReferenceTypeIds.HasSubtype.equals(referenceData.getReferenceType())).forEach(referenceData -> {
            if (this.iK.contains(referenceData.getReferenceSource())) {
                if (referenceData.isForward()) {
                    this.iS.put(referenceData.getReferenceSource(), referenceData.getReferenceTarget());
                    this.iR.put(referenceData.getReferenceTarget(), referenceData.getReferenceSource());
                } else {
                    this.iS.put(referenceData.getReferenceTarget(), referenceData.getReferenceSource());
                    this.iR.put(referenceData.getReferenceSource(), referenceData.getReferenceTarget());
                }
            }
        });
    }

    private void cjY() {
        this.iT.forEach(nodeData -> this.f((UaNodeSet.NodeData)nodeData));
        this.iX.forEach(nodeData -> this.i((UaNodeSet.NodeData)nodeData));
        this.iW.forEach(nodeData -> this.g((UaNodeSet.NodeData)nodeData));
        this.iV.forEach(nodeData -> this.h((UaNodeSet.NodeData)nodeData));
        logger.debug("Trying to resolve {} unknown Structure DataTypes: {}", (Object)this.iU.size(), (Object)this.iU.stream().map(nodeData -> nodeData.getNodeId()).toArray());
        int n2 = 0;
        while (n2 != this.iU.size()) {
            n2 = this.iU.size();
            this.iU.forEach(nodeData -> {
                if (this.j((UaNodeSet.NodeData)nodeData)) {
                    this.iU.remove(nodeData);
                }
            });
        }
        logger.debug("number of unresolved datatypes: {}, datatypes: {}", (Object)this.iU.size(), (Object)this.iU.stream().map(nodeData -> nodeData.getNodeId()).toArray());
    }

    private boolean j(UaNodeSet.NodeData nodeData2) {
        Optional<InternalDefinitionXMLDataContainer> optional = Optional.ofNullable((InternalDefinitionXMLDataContainer)nodeData2.get(InternalUaNodeSetNodeManagerUaNodeParser.internal()));
        UaNodeId uaNodeId3 = this.iR.get(nodeData2.getNodeId());
        if (uaNodeId3 == null) {
            logger.trace("Encountered a Structure type that doesn't have a parent via references, id: {}, name: {}", (Object)nodeData2.getNodeId(), (Object)nodeData2.getBrowseName());
            return false;
        }
        if (!UaIds.Structure.equals(uaNodeId3) && !this.iI.getDataTypeSpecifications().containsKey(uaNodeId3)) {
            logger.trace("Skipping {} as it's parent type {} is not yet resolved", (Object)nodeData2.getNodeId(), (Object)uaNodeId3);
            if (!this.iU.stream().map(nodeData -> nodeData.getNodeId()).anyMatch(uaNodeId2 -> uaNodeId3.equals(uaNodeId2))) {
                logger.trace("^ The yet-not-processed structure types do not contain the parent");
            }
            return false;
        }
        StructureSpecification structureSpecification = this.iI.getStructureSpecification(uaNodeId3);
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.setTypeId(nodeData2.getNodeId());
        builder.setName(nodeData2.getBrowseName().getName());
        builder.setBinaryEncodeId(this.iO.get(nodeData2.getNodeId()));
        builder.setXmlEncodeId(this.iP.get(nodeData2.getNodeId()));
        builder.setJsonEncodeId(this.iQ.get(nodeData2.getNodeId()));
        if (structureSpecification != null) {
            structureSpecification.getFields().forEach(fieldSpecification -> builder.addField((FieldSpecification)fieldSpecification));
        }
        if (optional.isPresent()) {
            for (InternalDefinitionFieldXMLDataContainer object2 : optional.get().fields) {
                FieldSpecification.Builder bl = FieldSpecification.builder();
                bl.setDataTypeId(object2.dataType);
                bl.setIsOptional(object2.isOptional);
                bl.setAllowSubTypes(object2.allowSubTypes);
                bl.setValueRank(object2.valueRank);
                bl.setName(object2.name);
                bl.setArrayDimensions(object2.arrayDimensions);
                Class bl2 = null;
                if (UaIds.Structure.equals(object2.dataType)) {
                    bl2 = ExtensionObject.class;
                } else {
                    bl2 = Optional.ofNullable(this.iI.getDataTypeSpecification(object2.dataType)).map(uaDataTypeSpecification -> uaDataTypeSpecification.getJavaClass()).orElse(null);
                    if (bl2 == null) {
                        if (this.iU.stream().map(nodeData -> nodeData.getNodeId()).anyMatch(uaNodeId -> internalDefinitionFieldXMLDataContainer.dataType.equals(uaNodeId))) {
                            bl2 = DynamicStructure.class;
                        } else {
                            logger.debug("Cannot resolve the Java Class for type: {}", (Object)object2.dataType);
                            return false;
                        }
                    }
                    if (object2.allowSubTypes) {
                        bl2 = Structure.class.isAssignableFrom(bl2) ? ExtensionObject.class : Object.class;
                    }
                }
                if (object2.valueRank > 0) {
                    bl2 = MultiDimensionArrayUtils.arrayClassOf(bl2, object2.valueRank);
                }
                bl.setJavaClass(bl2);
                builder.addField(bl.build());
            }
        }
        if (structureSpecification != null) {
            builder.setStructureType(structureSpecification.getStructureType());
        } else {
            builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        }
        StructureSpecification structureSpecification2 = builder.build();
        StructureSpecification.Builder builder2 = structureSpecification2.toBuilder();
        boolean bl = false;
        boolean bl2 = false;
        for (FieldSpecification fieldSpecification2 : structureSpecification2.getFields()) {
            if (fieldSpecification2.isOptional()) {
                bl = true;
                break;
            }
            if (!fieldSpecification2.isAllowSubTypes()) continue;
            bl2 = true;
            break;
        }
        if (optional.isPresent() && optional.get().isUnion) {
            if (bl2) {
                builder2.setStructureType(StructureSpecification.StructureType.UNION_SUBTYPES);
            } else {
                builder2.setStructureType(StructureSpecification.StructureType.UNION);
            }
        } else if (bl) {
            builder2.setStructureType(StructureSpecification.StructureType.OPTIONAL);
        } else if (bl2) {
            builder2.setStructureType(StructureSpecification.StructureType.SUBTYPES);
        } else {
            builder2.setStructureType(StructureSpecification.StructureType.NORMAL);
        }
        logger.debug("Resolved Structure: {}, id: {}", (Object)nodeData2.getBrowseName(), (Object)nodeData2.getNodeId());
        this.iI.addDataTypeSpecification(builder2.build());
        return true;
    }

    void a(AddNodesItem addNodesItem, NodeManagerTable nodeManagerTable) {
        try {
            NodeId nodeId = this.c(addNodesItem, nodeManagerTable);
            if (!nodeId.getValue().equals(addNodesItem.getRequestedNewNodeId().getValue())) {
                logger.warn("addNode: {} requested NodeId={} actual NodeId={}", addNodesItem.getBrowseName(), addNodesItem.getRequestedNewNodeId(), nodeId);
            } else {
                logger.debug("addNode:{} requested NodeId={}", (Object)addNodesItem.getBrowseName(), (Object)addNodesItem.getRequestedNewNodeId());
            }
        }
        catch (Exception exception) {
            logger.error("Failed to add node: {}", (Object)addNodesItem, (Object)exception);
        }
    }

    void a(List<AddNodesItem> list, String string, NodeManagerTable nodeManagerTable) throws ServiceException {
        logger.debug("addNodes: {}", (Object)string);
        for (AddNodesItem addNodesItem : list) {
            this.a(addNodesItem, nodeManagerTable);
        }
    }

    void a(AddReferencesItem addReferencesItem, NodeManagerTable nodeManagerTable) {
        try {
            this.b(addReferencesItem, nodeManagerTable);
            if (logger.isDebugEnabled()) {
                logger.debug("createModel: Adding refitem: " + addReferencesItem.getSourceNodeId() + " --> " + addReferencesItem.getTargetNodeId() + " forward:" + addReferencesItem.getIsForward() + " type: " + addReferencesItem.getReferenceTypeId());
            }
        }
        catch (Exception exception) {
            logger.error("Failed to add reference: {}", (Object)addReferencesItem, (Object)exception);
        }
    }

    void a(List<AddReferencesItem> list, NodeManagerTable nodeManagerTable) {
        for (AddReferencesItem addReferencesItem : list) {
            this.a(addReferencesItem, nodeManagerTable);
        }
    }

    void b(AddNodesItem addNodesItem, NodeManagerTable nodeManagerTable) {
        if (!ModelParser.callAfterCreateForTopLevelNodes) {
            return;
        }
        try {
            UaReference[] uaReferenceArray;
            UaNode uaNode = nodeManagerTable.getNode(nodeManagerTable.getNamespaceTable().toNodeId(addNodesItem.getRequestedNewNodeId()));
            if (uaNode.getReference(Identifiers.HasModellingRule, false) != null) {
                return;
            }
            if (uaNode instanceof GeneratedNode && ((uaReferenceArray = uaNode.getInverseReferences(Identifiers.Aggregates)) == null || uaReferenceArray.length == 0)) {
                ((GeneratedNode)uaNode).afterCreate();
            }
        }
        catch (Exception exception) {
            logger.error("Could not call afterCreate for item {}", (Object)addNodesItem, (Object)exception);
        }
    }

    NodeId c(AddNodesItem addNodesItem, NodeManagerTable nodeManagerTable) throws StatusException {
        logger.debug("doAddNode: {}", (Object)addNodesItem);
        return nodeManagerTable.addNode(ServiceContext.INTERNAL_OPERATION_CONTEXT, addNodesItem);
    }

    void b(AddReferencesItem addReferencesItem, NodeManagerTable nodeManagerTable) throws StatusException {
        nodeManagerTable.addReference(ServiceContext.INTERNAL_OPERATION_CONTEXT, addReferencesItem);
    }

    Set<AddNodesItem> cjZ() {
        return Collections.unmodifiableSet(this.iY);
    }

    Set<AddReferencesItem> cka() {
        return Collections.unmodifiableSet(this.iZ);
    }

    void a(NodeManagerTable nodeManagerTable) throws UaException {
        Set<AddNodesItem> set = this.iY;
        Set<AddReferencesItem> set2 = this.iZ;
        ArrayList<AddNodesItem> arrayList = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList2 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList3 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList4 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList5 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList6 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList7 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList8 = new ArrayList<AddNodesItem>();
        block10: for (AddNodesItem addNodesItem : set) {
            if (addNodesItem.getNodeClass() == null) {
                arrayList5.add(addNodesItem);
                continue;
            }
            switch (addNodesItem.getNodeClass()) {
                case ReferenceType: {
                    arrayList.add(addNodesItem);
                    continue block10;
                }
                case DataType: {
                    arrayList2.add(addNodesItem);
                    continue block10;
                }
                case Method: {
                    arrayList8.add(addNodesItem);
                    continue block10;
                }
                case Object: {
                    arrayList3.add(addNodesItem);
                    continue block10;
                }
                case ObjectType: {
                    arrayList6.add(addNodesItem);
                    continue block10;
                }
                case Variable: {
                    arrayList4.add(addNodesItem);
                    continue block10;
                }
                case VariableType: {
                    arrayList7.add(addNodesItem);
                    continue block10;
                }
                case View: {
                    arrayList5.add(addNodesItem);
                    continue block10;
                }
            }
            logger.warn("Encountered unkown NodeClass: {}, ignoring node: {}", (Object)addNodesItem.getNodeClass(), (Object)addNodesItem.getRequestedNewNodeId());
        }
        this.a(arrayList, "ReferenceTypes", nodeManagerTable);
        this.a(arrayList2, "DataTypes", nodeManagerTable);
        this.a(arrayList6, "ObjectTypeNodes", nodeManagerTable);
        this.a(arrayList7, "VariableTypeNodes", nodeManagerTable);
        this.a(arrayList3, "ObjectNodes", nodeManagerTable);
        this.a(arrayList4, "VariableNodes", nodeManagerTable);
        this.a(arrayList5, "OtherNodes", nodeManagerTable);
        this.a(arrayList8, "MethodNodes", nodeManagerTable);
        this.a(new ArrayList<AddReferencesItem>(set2), nodeManagerTable);
        for (AddNodesItem addNodesItem : arrayList3) {
            this.b(addNodesItem, nodeManagerTable);
        }
    }
}

