/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.AccessLevels;
import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.ModelException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaAddress;
import com.prosysopc.ua.UaApplication;
import com.prosysopc.ua.client.ServerConnectionException;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.AttributeServiceHandler;
import com.prosysopc.ua.server.DiagnosticsManager;
import com.prosysopc.ua.server.NodeManagementServiceHandler;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.NodeManagerRoot;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.PubSubConfigurator;
import com.prosysopc.ua.server.ReverseConnectionParameters;
import com.prosysopc.ua.server.ServerCodegenModel;
import com.prosysopc.ua.server.ServerCodegenModelProvider;
import com.prosysopc.ua.server.ServerUserIdentity;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceHandler;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManager;
import com.prosysopc.ua.server.SessionManagerAdapter;
import com.prosysopc.ua.server.SessionManagerListener;
import com.prosysopc.ua.server.SessionServiceHandler;
import com.prosysopc.ua.server.SubscriptionManager;
import com.prosysopc.ua.server.SubscriptionServiceHandler;
import com.prosysopc.ua.server.UaServerException;
import com.prosysopc.ua.server.UaServerListener;
import com.prosysopc.ua.server.UserValidator;
import com.prosysopc.ua.server.io.IoManagerListener;
import com.prosysopc.ua.stack.application.Application;
import com.prosysopc.ua.stack.application.Server;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.FindServersRequest;
import com.prosysopc.ua.stack.core.FindServersResponse;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.MdnsDiscoveryConfiguration;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.RegisterServer2Request;
import com.prosysopc.ua.stack.core.RegisterServerRequest;
import com.prosysopc.ua.stack.core.RegisteredServer;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.ServerCapability;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.stack.core.SignedSoftwareCertificate;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.EndpointServer;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.endpoint.EndpointServiceRequest;
import com.prosysopc.ua.stack.transport.https.HttpsServer;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.HttpsSecurityPolicy;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.nio.OpcTcpServer;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.types.gds.server.GdsServerInformationModel;
import com.prosysopc.ua.types.opcua.SessionDiagnosticsObjectType;
import com.prosysopc.ua.types.opcua.SessionSecurityDiagnosticsType;
import com.prosysopc.ua.types.opcua.server.BuildInfoTypeNode;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerCapabilitiesTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerInformationModel;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class UaServer
extends UaApplication {
    private static final int oL = 3600;
    static Logger logger = LoggerFactory.getLogger(UaServer.class);
    private SecurityMode oM = SecurityMode.BASIC128RSA15_SIGN_ENCRYPT;
    private Set<InetAddress> oN = null;
    private final Map<UaApplication.Protocol, Set<InetAddress>> oO = new HashMap<UaApplication.Protocol, Set<InetAddress>>();
    private boolean oP = true;
    private final AtomicReference<DiscoveryServer> oQ = new AtomicReference<Object>(null);
    private UaAddress oR = null;
    private long oS = 10L;
    private boolean oT = true;
    private EndpointConfiguration fZ = Endpoint.createDefaultEndpointConfiguration();
    private List<EndpointDescription> oU;
    private boolean oV = true;
    private volatile boolean oW = true;
    private final Set<String> oX = new HashSet<String>();
    private HttpsSettings gb = new HttpsSettings();
    private int oY = 10;
    private boolean initialized = false;
    private final Map<UaApplication.Protocol, Integer> oZ = new TreeMap<UaApplication.Protocol, Integer>();
    private final Map<ReverseConnectionParameters, EndpointServer.ReverseEndpointHandle> pa = new HashMap<ReverseConnectionParameters, EndpointServer.ReverseEndpointHandle>();
    private volatile boolean mZ;
    private final Server server = Server.createServerApplication();
    private Integer pb = null;
    private Integer pc = null;
    private String serverName = "";
    private final Map<UaApplication.Protocol, String> pd = new TreeMap<UaApplication.Protocol, String>();
    private boolean pe;
    private boolean pf = true;
    private boolean pg = true;
    private boolean ph = false;
    private final List<UserTokenPolicy> userTokenPolicies = new ArrayList<UserTokenPolicy>();
    private UserValidator pi;
    protected ApplicationIdentity applicationIdentity;
    protected ServiceHandler attributeServiceHandler;
    protected Set<String> discoveryUris;
    protected Set<String> httpsUris;
    protected UaServerListener listener;
    protected NodeManagerRoot nodeManagerRoot;
    protected NodeManagerTable nodeManagerTable;
    protected NodeManagerUaServer nodeManagerUaServer;
    protected NodeManagementServiceHandler nodeServiceHandler;
    protected Set<SecurityMode> httpsSecurityModes = new CopyOnWriteArraySet<SecurityMode>();
    protected Set<SecurityMode> securityModes = new CopyOnWriteArraySet<SecurityMode>();
    protected Set<String> serverUris;
    protected SessionManager sessionManager;
    protected ScheduledExecutorService executor;
    protected final SessionManagerListener sessionManagerListener = new SessionManagerAdapter(){

        @Override
        public boolean onActivateSession(Session session, ServerUserIdentity serverUserIdentity) throws StatusException {
            logger.debug("onActivateSession: userIdentity={}", (Object)serverUserIdentity);
            return UaServer.this.validateUserIdentity(session, serverUserIdentity);
        }

        @Override
        public void onActivateSessionError(Session session, UserIdentityToken userIdentityToken, Exception exception) {
            UaServer.this.validateUserError(session, userIdentityToken, exception);
        }

        @Override
        public void onAfterActivateSession(Session session) {
            logger.debug("onAfterActivateSession: session={} (doing nothing)", (Object)session);
        }

        @Override
        public void onCancelSession(Session session) {
            if (logger.isDebugEnabled()) {
                logger.debug("onCancelSession: session={} (doing nothing)", (Object)session);
            }
        }

        @Override
        public void onCloseSession(Session session, boolean bl) {
            logger.debug("onCloseSession: session={} deleteSubscriptions={} (doing nothing)", (Object)session, (Object)bl);
        }

        @Override
        public void onCreateSession(Session session) throws StatusException {
            StatusCode statusCode;
            logger.debug("onCreateSession: session={}", (Object)session);
            if (!session.getSecurityMode().getMessageSecurityMode().equals(MessageSecurityMode.None) && !(statusCode = UaServer.this.validateApplicationCertificate(session.getClientIdentity())).isGood()) {
                throw new StatusException(statusCode);
            }
        }
    };
    protected SessionServiceHandler sessionServiceHandler;
    protected SubscriptionManager subscriptionManager;
    protected SubscriptionServiceHandler subscriptionServiceHandler;
    a pj;
    Timer pk = null;
    protected DiagnosticsManager diagnosticsManager;
    private PubSubConfigurator pl;

    public static UnsignedByte getEndpointSecurityLevel(SecurityMode securityMode) {
        int n2 = (securityMode.getMessageSecurityMode().getValue() - 1) * 10;
        String string = securityMode.getSecurityPolicy().getPolicyUri();
        int n3 = 0;
        if (string.equals("http://opcfoundation.org/UA/SecurityPolicy#None") || string.equals("http://opcfoundation.org/UA-Profile/Securitypolicy/None")) {
            n3 = 0;
        } else if (string.equals("http://opcfoundation.org/UA/SecurityPolicy#Basic128Rsa15") || string.equals("http://opcfoundation.org/UA-Profile/Securitypolicy/Basic128Rsa15")) {
            n3 = 1;
        } else if (string.equals("http://opcfoundation.org/UA/SecurityPolicy#Basic256") || string.equals("http://opcfoundation.org/UA-Profile/Securitypolicy/Basic256")) {
            n3 = 2;
        } else if (string.equals("http://opcfoundation.org/UA/SecurityPolicy#Basic256Sha256")) {
            n3 = 4;
        } else if (string.equals("http://opcfoundation.org/UA/SecurityPolicy#Aes128_Sha256_RsaOaep")) {
            n3 = 3;
        } else if (string.equals("http://opcfoundation.org/UA/SecurityPolicy#Aes256_Sha256_RsaPss")) {
            n3 = 5;
        }
        if (n3 == 0) {
            return UnsignedByte.ZERO;
        }
        return UnsignedByte.valueOf(n2 + n3);
    }

    protected static RegisteredServer toRegisteredServer(String string, boolean bl, UaServer uaServer) {
        ApplicationDescription applicationDescription = uaServer.getApplicationIdentity().getApplicationDescription();
        logger.debug("toRegisteredServer: d={}", (Object)applicationDescription);
        RegisteredServer registeredServer = new RegisteredServer(applicationDescription.getApplicationUri(), applicationDescription.getProductUri(), new LocalizedText[]{applicationDescription.getApplicationName()}, applicationDescription.getApplicationType(), applicationDescription.getGatewayServerUri(), applicationDescription.getDiscoveryUrls(), string, bl);
        return registeredServer;
    }

    static int h(int n2) {
        int n3;
        if (n2 <= 0) {
            return 0;
        }
        double d2 = n2;
        if ((n3 = (int)Math.ceil(d2 += d2 * 0.1)) == n2) {
            ++n3;
        }
        return n3;
    }

    public UaServer() {
        this.registerModel(ServerInformationModel.MODEL);
    }

    public void addEndpoint(String string, SecurityMode securityMode, UserTokenPolicy ... userTokenPolicyArray) throws UaServerException {
        if (this.isRunning()) {
            throw new UaServerException("Cannot define endpoints when running");
        }
        UserTokenPolicy[] userTokenPolicyArray2 = userTokenPolicyArray.length > 0 ? userTokenPolicyArray : this.getUserTokenPolicies();
        this.oU.add(new EndpointDescription(string, this.getApplicationIdentity().getApplicationDescription(), ByteString.valueOf(this.getApplicationIdentity().getCertificate().getEncoded()), securityMode.getMessageSecurityMode(), securityMode.getSecurityPolicy().getPolicyUri(), userTokenPolicyArray2, null, UaServer.getEndpointSecurityLevel(securityMode)));
        if (logger.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder(" [");
            for (UserTokenPolicy userTokenPolicy : userTokenPolicyArray2) {
                stringBuilder.append(userTokenPolicy.getTokenType());
                stringBuilder.append(",");
            }
            stringBuilder.setCharAt(stringBuilder.length() - 1, ']');
            logger.debug("Endpoint added: {} {} {}", string, securityMode, stringBuilder);
        }
    }

    public String[] addEndpointHost(String string) throws UaServerException {
        int n2;
        int n3;
        String string2;
        if (this.serverUris == null) {
            throw new RuntimeException("Cannot call addEndpointHost() before UaServer.init() is called");
        }
        int n4 = this.getPort();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n4 > 0 || n4 == -1) {
            string2 = n4 == -1 ? UaAddress.formatUri(UaApplication.Protocol.OpcTcp, string, 0, this.getServerName(UaApplication.Protocol.OpcTcp)) : UaAddress.formatUri(UaApplication.Protocol.OpcTcp, string, n4, this.getServerName(UaApplication.Protocol.OpcTcp));
            this.serverUris.add(string2);
            arrayList.add(string2);
            if (this.initialized) {
                for (SecurityMode securityMode : this.securityModes) {
                    this.addEndpoint(string2, securityMode, this.getUserTokenPolicies());
                }
            }
            if (this.getServerName(UaApplication.Protocol.OpcTcp) != null) {
                this.discoveryUris.add(UaAddress.formatUri(UaApplication.Protocol.OpcTcp, string, n4, null));
            }
        }
        if ((n3 = this.getPort(UaApplication.Protocol.OpcHttps)) > 0 || n3 == -1) {
            string2 = n3 == -1 ? UaAddress.formatUri(UaApplication.Protocol.OpcHttps, string, 0, this.getServerName(UaApplication.Protocol.OpcHttps)) : UaAddress.formatUri(UaApplication.Protocol.OpcHttps, string, n3, this.getServerName(UaApplication.Protocol.OpcHttps));
            this.httpsUris.add(string2);
            arrayList.add(string2);
            if (this.initialized) {
                this.addEndpoint(string2, SecurityMode.NONE, this.getUserTokenPolicies());
            }
            if (this.getServerName(UaApplication.Protocol.OpcHttps) != null) {
                this.discoveryUris.add(UaAddress.formatUri(UaApplication.Protocol.OpcHttps, string, n3, null));
            }
        }
        if ((n2 = this.getPort(UaApplication.Protocol.Http)) > 0 || n2 == -1) {
            string2 = n2 == -1 ? UaAddress.formatUri(UaApplication.Protocol.Http, string, 0, this.getServerName(UaApplication.Protocol.Http)) : UaAddress.formatUri(UaApplication.Protocol.Http, string, n2, this.getServerName(UaApplication.Protocol.Http));
            this.httpsUris.add(string2);
            arrayList.add(string2);
            if (this.initialized) {
                this.addEndpoint(string2, SecurityMode.NONE, this.getUserTokenPolicies());
            }
            if (this.getServerName(UaApplication.Protocol.Http) != null) {
                this.discoveryUris.add(UaAddress.formatUri(UaApplication.Protocol.Http, string, n2, null));
            }
        }
        this.oX.add(string);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void addLocale(Locale locale) throws UaServerException {
        this.v("Locales");
        this.server.getApplication().addLocale(locale);
    }

    public synchronized void addReverseConnection(ReverseConnectionParameters reverseConnectionParameters) {
        boolean bl;
        boolean bl2 = bl = !this.pa.containsKey(reverseConnectionParameters);
        if (bl) {
            this.pa.put(reverseConnectionParameters, null);
        }
        if (bl && this.isRunning()) {
            try {
                this.a(reverseConnectionParameters);
            }
            catch (UaServerException uaServerException) {
                throw new IllegalArgumentException("Could not add reverse connection", uaServerException);
            }
        }
    }

    public synchronized void addReverseConnection(String string) {
        this.addReverseConnection(ReverseConnectionParameters.from(string, null));
    }

    public synchronized void addReverseConnection(String string, String string2) {
        this.addReverseConnection(ReverseConnectionParameters.from(string, string2));
    }

    public void addServiceHandler(Object object) {
        logger.debug("addServiceHandler {}: {}", (Object)this.server, object);
        this.server.addServiceHandler(object);
    }

    public void addToServerArray(String string) throws StatusException {
        this.getAddressSpace().getServerTable().add(-1, string);
        this.updateServerArray();
    }

    public void addUserTokenPolicy(UserTokenPolicy userTokenPolicy) throws UaServerException {
        this.v("UserTokenPolicies");
        if (!this.userTokenPolicies.contains(userTokenPolicy)) {
            this.userTokenPolicies.add(userTokenPolicy);
        }
    }

    public synchronized void close() {
        if (this.initialized) {
            try {
                ScheduledExecutorService scheduledExecutorService;
                if (this.mZ) {
                    this.shutdown(0, "");
                }
                if ((scheduledExecutorService = this.executor) != null) {
                    scheduledExecutorService.shutdownNow();
                    this.executor = null;
                }
                this.cmW();
                this.cmX();
                this.nodeManagerTable.close();
                this.server.close();
                logger.info("UaServer closed.");
            }
            finally {
                this.initialized = false;
            }
        }
    }

    @Override
    public NodeManagerTable getAddressSpace() {
        return this.nodeManagerTable;
    }

    @Override
    public ApplicationIdentity getApplicationIdentity() {
        return this.applicationIdentity;
    }

    public ServiceHandler getAttributeServiceHandler() {
        return this.attributeServiceHandler;
    }

    public synchronized Set<InetAddress> getBindAddresses() {
        if (this.oN == null) {
            try {
                HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
                InetAddress inetAddress = this.isEnableIPv6() ? InetAddress.getByName("[::]") : InetAddress.getByName("0.0.0.0");
                logger.debug("getBindAddresses, IPv6: {}, using address: {}", (Object)this.isEnableIPv6(), (Object)inetAddress);
                hashSet.add(inetAddress);
                this.oN = Collections.unmodifiableSet(hashSet);
                return this.oN;
            }
            catch (UnknownHostException unknownHostException) {
                throw new RuntimeException("Could not resolve wildcard IP address, please set BindAddresses manually.", unknownHostException);
            }
        }
        return this.oN;
    }

    public Set<InetAddress> getBindAddresses(UaApplication.Protocol protocol) {
        Set<InetAddress> set = this.oO.get((Object)protocol);
        if (set != null) {
            return set;
        }
        return this.getBindAddresses();
    }

    public DiagnosticsManager getDiagnosticsManager() {
        return this.diagnosticsManager;
    }

    public UaAddress getDiscoveryServerAddress() {
        return this.oR;
    }

    public long getDiscoveryServerRegistrationPeriod() {
        return this.oS;
    }

    public SecurityMode getDiscoveryServerRegistrationSecurityMode() {
        return this.oM;
    }

    public String getDiscoveryServerUrl() {
        if (this.oR == null) {
            return "";
        }
        if (this.oR.getAddress() == null) {
            return "";
        }
        return this.oR.getAddress();
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.server.getEncoderContext();
    }

    public EndpointDescription getEndpoint(String string, SecurityMode securityMode) {
        for (EndpointDescription endpointDescription : this.oU) {
            if (!endpointDescription.getEndpointUrl().equals(string) || !endpointDescription.getSecurityMode().equals(securityMode.getMessageSecurityMode()) || !endpointDescription.getSecurityPolicyUri().equals(securityMode.getSecurityPolicy().getPolicyUri())) continue;
            return endpointDescription;
        }
        return null;
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.fZ;
    }

    public EndpointDescription[] getEndpoints() {
        return this.server.getEndpointDescriptions();
    }

    public EndpointDescription[] getEndpoints(String string) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : this.getEndpoints()) {
            if (!endpointDescription.getEndpointUrl().equals(string)) continue;
            arrayList.add(endpointDescription);
        }
        return arrayList.toArray(new EndpointDescription[arrayList.size()]);
    }

    public String[] getHostNames() {
        if (this.oX.isEmpty()) {
            try {
                this.getServerUris();
            }
            catch (UaServerException uaServerException) {
                // empty catch block
            }
        }
        return this.oX.toArray(new String[this.oX.size()]);
    }

    public Set<SecurityMode> getHttpsSecurityModes() {
        return this.httpsSecurityModes;
    }

    public HttpsSettings getHttpsSettings() {
        return this.gb;
    }

    public int getHttpsWorkerThreadCount() {
        return this.oY;
    }

    public UaServerListener getListener() {
        return this.listener;
    }

    public Locale[] getLocales() {
        return this.server.getApplication().getLocales();
    }

    public Integer getMaxOpcHttpsConnections() {
        return this.pc;
    }

    public Integer getMaxOpcTcpConnections() {
        return this.pb;
    }

    public NodeManagementServiceHandler getNodeManagementServiceHandler() {
        return this.nodeServiceHandler;
    }

    public NodeManagerRoot getNodeManagerRoot() {
        return this.nodeManagerRoot;
    }

    @Deprecated
    public NodeManagerTable getNodeManagerTable() {
        return this.nodeManagerTable;
    }

    public NodeManagerUaServer getNodeManagerUaServer() {
        return this.nodeManagerUaServer;
    }

    public int getPort() {
        return this.getPort(UaApplication.Protocol.OpcTcp);
    }

    public int getPort(UaApplication.Protocol protocol) {
        if (this.oZ.containsKey((Object)protocol)) {
            return this.oZ.get((Object)protocol);
        }
        return 0;
    }

    public PubSubConfigurator getPubSubConfigurator() throws StatusException {
        PubSubConfigurator pubSubConfigurator = this.pl;
        if (pubSubConfigurator == null) {
            throw new StatusException(StatusCodes.Bad_NotSupported);
        }
        return pubSubConfigurator;
    }

    public Set<SecurityMode> getSecurityModes() {
        return this.securityModes;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerName(UaApplication.Protocol protocol) {
        if (this.pd.containsKey((Object)protocol)) {
            return this.pd.get((Object)protocol);
        }
        return this.getServerName();
    }

    @Override
    public ServerTable getServerTable() {
        return this.getAddressSpace().getServerTable();
    }

    public String[] getServerUris() throws UaServerException {
        if (this.serverUris == null) {
            this.serverUris = new HashSet<String>();
            this.discoveryUris = new HashSet<String>();
            this.httpsUris = new HashSet<String>();
            String string = ApplicationIdentity.getActualHostName();
            this.addEndpointHost(string);
            this.serverUris.addAll(this.httpsUris);
        }
        return this.serverUris.toArray(new String[this.serverUris.size()]);
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public SessionServiceHandler getSessionServiceHandler() {
        return this.sessionServiceHandler;
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public SubscriptionServiceHandler getSubscriptionServiceHandler() {
        return this.subscriptionServiceHandler;
    }

    public UserTokenPolicy[] getUserTokenPolicies() {
        return this.userTokenPolicies.toArray(new UserTokenPolicy[this.userTokenPolicies.size()]);
    }

    public synchronized void init() throws UaServerException {
        if (!this.initialized) {
            if (this.applicationIdentity == null) {
                throw new NullPointerException("ApplicationIdentity must be defined before calling init or start");
            }
            this.cmZ();
            this.cnd();
            this.cnc();
            this.cje();
            this.initServiceHandlers();
            this.cna();
            this.initServerArray();
            this.initAggregateFunctions();
            this.cni();
            this.updateServerCapabilities();
            this.registerServer(false, false);
            this.initialized = true;
            this.oW = false;
        }
        if (this.executor == null) {
            this.executor = this.createExecutor();
        }
    }

    public boolean isDiscoveryEndpointEnabled() {
        return this.oP;
    }

    public boolean isEnableIPv6() {
        return this.oT;
    }

    public boolean isFailOnBindError() {
        return this.oV;
    }

    public boolean isRunning() {
        return this.mZ;
    }

    @Deprecated
    public boolean isUseAllIpAddresses() {
        return this.pe;
    }

    @Deprecated
    public boolean isUseCanonicalHostName() {
        return this.pf;
    }

    @Deprecated
    public boolean isUseHostName() {
        return this.pg;
    }

    @Deprecated
    public boolean isUseLocalhost() {
        return this.ph;
    }

    public void registerAndLoadModel(ServerCodegenModel serverCodegenModel, URI uRI) throws SAXException, IOException, ModelException, ServiceException {
        this.registerModelInternal(serverCodegenModel);
        this.getAddressSpace().loadModel(uRI);
    }

    public void registerModel(ServerCodegenModel serverCodegenModel) {
        this.registerModelInternal(serverCodegenModel);
    }

    public boolean registerServer(boolean bl) {
        return this.registerServer(bl, true);
    }

    public void registerServer(String string, boolean bl) throws UaServerException {
        UaClient uaClient;
        if (!bl) {
            this.cnh();
        }
        if (this.applicationIdentity.getCertificate().getCertificate() == null) {
            throw new UaServerException("Application Certificate not defined when calling registerServer");
        }
        RegisteredServer registeredServer = UaServer.toRegisteredServer(null, bl, this);
        try {
            uaClient = new UaClient(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UaServerException("Invalid URI", illegalArgumentException);
        }
        ApplicationIdentity applicationIdentity = this.getApplicationIdentity();
        uaClient.setApplicationIdentity(applicationIdentity);
        uaClient.setSecurityMode(this.getDiscoveryServerRegistrationSecurityMode());
        uaClient.setTimeout(10000L);
        String string2 = bl ? "online" : "offline";
        boolean bl2 = true;
        try {
            MdnsDiscoveryConfiguration mdnsDiscoveryConfiguration = new MdnsDiscoveryConfiguration(this.getApplicationIdentity().getApplicationDescription().getApplicationName().getText(), ServerCapability.getIdentifiers(ServerCapability.DA));
            ExtensionObject[] extensionObjectArray = new ExtensionObject[]{ExtensionObject.binaryEncode(mdnsDiscoveryConfiguration, this.getEncoderContext())};
            uaClient.sessionlessRequest(new RegisterServer2Request(null, registeredServer, extensionObjectArray));
            if (logger.isDebugEnabled()) {
                logger.debug("Registered server ({}) to Discovery Server at {} with RegisterServer2", (Object)string2, (Object)uaClient.getEndpoint().getEndpointUrl());
            }
            bl2 = false;
        }
        catch (ServerConnectionException serverConnectionException) {
            throw new UaServerException("Could not register server (" + string2 + ") to Discovery Server at " + this.getDiscoveryServerUrl(), serverConnectionException);
        }
        catch (ServiceException serviceException) {
            logger.debug("Failed to register server with RegisterServer2", serviceException);
        }
        catch (EncodingException encodingException) {
            logger.warn("Failed to encode DiscoveryConfiguration", encodingException);
        }
        if (bl2) {
            try {
                uaClient.sessionlessRequest(new RegisterServerRequest(null, registeredServer));
                if (logger.isDebugEnabled()) {
                    logger.debug("Registered server ({}) to Discovery Server at {} with RegisterServer", (Object)string2, (Object)uaClient.getEndpoint().getEndpointUrl());
                }
            }
            catch (ServerConnectionException serverConnectionException) {
                throw new UaServerException("Could not register server (" + string2 + ") to Discovery Server at " + this.getDiscoveryServerUrl(), serverConnectionException);
            }
            catch (ServiceException serviceException) {
                throw new UaServerException("Could not register server (" + string2 + ") to Discovery Server at " + this.getDiscoveryServerUrl(), serviceException);
            }
        }
    }

    public void removeEndpoint(String string, SecurityMode securityMode) {
        for (int i2 = this.oU.size() - 1; i2 >= 0; --i2) {
            EndpointDescription endpointDescription = this.oU.get(i2);
            if (!endpointDescription.getEndpointUrl().equals(string) || !endpointDescription.getSecurityMode().equals(securityMode.getMessageSecurityMode()) || !endpointDescription.getSecurityPolicyUri().equals(securityMode.getSecurityPolicy().getPolicyUri())) continue;
            this.oU.remove(i2);
        }
    }

    public void removeEndpointHost(String string) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : this.oU) {
            arrayList.add(endpointDescription);
        }
        for (EndpointDescription endpointDescription : arrayList) {
            if (!string.equals(endpointDescription.getEndpointUrl())) continue;
            this.oU.remove(endpointDescription);
        }
    }

    public void removeLocale(Locale locale) throws UaServerException {
        this.v("Locales");
        this.server.getApplication().removeLocale(locale);
    }

    public synchronized void removeReverseConnection(ReverseConnectionParameters reverseConnectionParameters) {
        EndpointServer.ReverseEndpointHandle reverseEndpointHandle = this.pa.remove(reverseConnectionParameters);
        if (reverseEndpointHandle != null) {
            reverseEndpointHandle.close();
        }
    }

    public synchronized void removeReverseConnection(String string) {
        this.removeReverseConnection(ReverseConnectionParameters.from(string, null));
    }

    @Deprecated
    public synchronized void removeReverseConnection(String string, String string2) {
        this.removeReverseConnection(ReverseConnectionParameters.from(string, string2));
    }

    public void removeUserTokenPolicy(UserTokenPolicy userTokenPolicy) throws UaServerException {
        this.v("UserTokenPolicies");
        this.userTokenPolicies.remove(userTokenPolicy);
    }

    public boolean requestServerStateChange(ServiceContext serviceContext, ServerState serverState, DateTime dateTime, UnsignedInteger unsignedInteger, LocalizedText localizedText, final Boolean bl) throws StatusException {
        final UaServerListener uaServerListener = this.getListener();
        if (uaServerListener == null) {
            return false;
        }
        if (bl.booleanValue() || serverState == ServerState.Shutdown) {
            int n2;
            int n3 = n2 = unsignedInteger.intValue() > 3600 ? 3600 : unsignedInteger.intValue();
            if (!uaServerListener.onShutdownRequest(serviceContext, n2, localizedText, bl)) {
                return false;
            }
            this.shutdownBegin(n2, localizedText);
            if (n2 > 0) {
                final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
                scheduledExecutorService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            uaServerListener.onShutdown(UaServer.this, bl);
                            UaServer.this.shutdownEnd(true);
                        }
                        finally {
                            scheduledExecutorService.shutdown();
                        }
                    }
                }, (long)n2, TimeUnit.SECONDS);
            } else {
                uaServerListener.onShutdown(this, bl);
                this.shutdownEnd(true);
            }
            return true;
        }
        return false;
    }

    public void setApplicationIdentity(ApplicationIdentity applicationIdentity) {
        if (applicationIdentity == null) {
            throw new NullPointerException("identity must be defined");
        }
        if (applicationIdentity.getApplicationDescription() == null) {
            throw new IllegalArgumentException("identity's ApplicationDescription must be defined");
        }
        this.applicationIdentity = applicationIdentity;
    }

    public void setBindAddresses(UaApplication.Protocol protocol, Set<InetAddress> set) {
        this.oO.put(protocol, set);
        this.cne();
    }

    public synchronized void setBindAddresses(Set<InetAddress> set) {
        this.oN = set;
    }

    public void setDiscoveryEndpointEnabled(boolean bl) {
        this.oP = bl;
    }

    public void setDiscoveryServerAddress(UaAddress uaAddress) {
        this.oR = uaAddress;
    }

    public void setDiscoveryServerRegistrationPeriod(long l2) {
        this.oS = l2;
    }

    public void setDiscoveryServerRegistrationSecurityMode(SecurityMode securityMode) {
        this.oM = securityMode;
    }

    public void setDiscoveryServerUrl(String string) throws URISyntaxException {
        this.oR = string == null || string.isEmpty() ? null : new UaAddress(string);
    }

    public void setEnableIPv6(boolean bl) {
        this.oT = bl;
    }

    public void setEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.fZ = endpointConfiguration != null ? endpointConfiguration : Endpoint.createDefaultEndpointConfiguration();
    }

    public void setFailOnBindError(boolean bl) {
        this.oV = bl;
    }

    public void setHttpsSecurityPolicies(HttpsSecurityPolicy ... httpsSecurityPolicyArray) throws UaServerException {
        this.w("HttpsSecurityPolicies");
        this.getHttpsSettings().setHttpsSecurityPolicies(httpsSecurityPolicyArray);
    }

    public void setHttpsSettings(HttpsSettings httpsSettings) {
        this.gb = httpsSettings;
    }

    public void setHttpsWorkerThreadCount(int n2) {
        this.oY = n2;
    }

    public void setListener(UaServerListener uaServerListener) {
        this.listener = uaServerListener;
    }

    public void setMaxOpcHttpsConnections(Integer n2) {
        this.pc = n2;
    }

    public void setMaxOpcTcpConnections(Integer n2) {
        if (n2 != null && n2 <= 0) {
            throw new IllegalArgumentException("Maximum value for maxOpcTcpConnections must be larger than 0 (or null), given: " + n2);
        }
        this.pb = n2;
    }

    public void setPort(int n2) throws UaServerException {
        this.setPort(UaApplication.Protocol.OpcTcp, n2);
    }

    public void setPort(UaApplication.Protocol protocol, int n2) throws UaServerException {
        this.w("Port");
        this.oZ.put(protocol, n2);
        this.cne();
    }

    public void setPubSubConfigurator(PubSubConfigurator pubSubConfigurator) {
        this.pl = pubSubConfigurator;
    }

    @Deprecated
    public void setSecurityModes(SecurityMode[] securityModeArray) throws UaServerException {
        this.w("SecurityModes");
        this.securityModes.clear();
        this.securityModes.addAll(Arrays.asList(securityModeArray));
    }

    public void setServerName(UaApplication.Protocol protocol, String string) throws UaServerException {
        this.w("ServerName");
        if (string == null) {
            this.pd.remove((Object)protocol);
        } else {
            this.pd.put(protocol, string);
        }
        this.cne();
    }

    public void setServerName(String string) throws UaServerException {
        this.w("ServerName");
        this.serverName = string == null ? "" : string;
    }

    @Deprecated
    public void setUseAllIpAddresses(boolean bl) {
        this.pe = bl;
    }

    @Deprecated
    public void setUseCanonicalHostName(boolean bl) {
        this.pf = bl;
    }

    @Deprecated
    public void setUseHostName(boolean bl) {
        this.pg = bl;
    }

    @Deprecated
    public void setUseLocalhost(boolean bl) throws UaServerException {
        this.w("UseLocalhost");
        this.ph = bl;
    }

    public void setUserTokenPolicies(UserTokenPolicy ... userTokenPolicyArray) throws UaServerException {
        this.w("UserTokenPolicies");
        this.userTokenPolicies.clear();
        this.userTokenPolicies.addAll(Arrays.asList(userTokenPolicyArray));
    }

    public void setUserValidator(UserValidator userValidator) {
        this.pi = userValidator;
    }

    public void shutdown(int n2, LocalizedText localizedText) {
        this.shutdown(n2, localizedText, true);
    }

    public synchronized void shutdown(int n2, LocalizedText localizedText, boolean bl) {
        if (this.initialized) {
            this.shutdownBegin(n2, localizedText);
            this.shutdownSleep(n2);
            this.shutdownEnd(bl);
        }
    }

    public void shutdown(int n2, String string) {
        this.shutdown(n2, new LocalizedText(string, LocalizedText.NO_LOCALE));
    }

    public void shutdown(int n2, String string, boolean bl) {
        this.shutdown(n2, new LocalizedText(string, LocalizedText.NO_LOCALE), bl);
    }

    public synchronized void start() throws UaServerException {
        if (!this.isRunning()) {
            this.init();
            this.cnb();
            this.mZ = true;
            try {
                this.cng();
                this.updateServerCapabilities();
                this.cmU();
                this.cni();
                this.registerServer(true, false);
                this.cnf();
                this.cmV();
            }
            catch (UaServerException uaServerException) {
                this.close();
                this.mZ = false;
                throw uaServerException;
            }
        }
    }

    private void c(String string, String string2) throws ServiceResultException {
        Endpoint endpoint;
        String string3 = this.getDiscoveryUriOf(string2);
        if (logger.isDebugEnabled()) {
            logger.debug("bindDiscoveryEndpoint: discoveryUriString={}", (Object)string3);
            logger.debug("bindDiscoveryEndpoint: discovery bindings={}", (Object)Arrays.toString(this.getDiscoveryServer().getBindings()));
            logger.debug("bindDiscoveryEndpoint: server bindings={}", (Object)Arrays.toString(this.server.getBindings()));
        }
        if ((endpoint = !this.getDiscoveryServer().hasEndpoint(string3) && !this.server.hasEndpoint(string3) ? new Endpoint(string3, SecurityMode.NONE) : this.getDiscoveryServer().getEndpointByUri(string3)) != null) {
            this.getDiscoveryServer().bind(string, endpoint);
            logger.debug("Discovery endpoint bound to {}", (Object)string);
        }
    }

    private void u(String string) throws UaServerException {
        if (!this.server.hasEndpoint(string)) {
            String string2 = string;
            TreeSet<HttpsSecurityPolicy> treeSet = new TreeSet<HttpsSecurityPolicy>();
            try {
                Object object2;
                if (string.startsWith("opc.https")) {
                    object2 = this.server.getOrCreateHttpsServer();
                    ((HttpsServer)object2).getHttpsSettings().readFrom(this.gb);
                    if (((HttpsServer)object2).getWorkerThreadCount() != this.getHttpsWorkerThreadCount()) {
                        ((HttpsServer)object2).setWorkerThreadCount(this.getHttpsWorkerThreadCount());
                    }
                    for (HttpsSecurityPolicy object3 : ((HttpsServer)object2).getSupportedSecurityPolicies()) {
                        treeSet.add(object3);
                    }
                }
                object2 = new Endpoint(string, string.startsWith("opc.https") ? this.httpsSecurityModes.toArray(SecurityMode.EMPTY_ARRAY) : this.securityModes.toArray(SecurityMode.EMPTY_ARRAY));
                ((Endpoint)object2).setEndpointConfiguration(this.fZ);
                UaAddress uaAddress = UaAddress.parse(string);
                ArrayList<String> arrayList = new ArrayList<String>();
                Set<InetAddress> set = this.getBindAddresses(uaAddress.getProtocol());
                if (set == null) {
                    throw new UaServerException("BindAddresses not available.");
                }
                for (InetAddress inetAddress : set) {
                    Object object;
                    Object object3;
                    if (!this.oT && inetAddress instanceof Inet6Address) continue;
                    String string3 = inetAddress instanceof Inet6Address ? "%s://[%s]:%d" : "%s://%s:%d";
                    int n2 = uaAddress.getPort();
                    if (n2 == -1) {
                        logger.debug("Cannot parse host using URI. Diverting to custom parser");
                        object3 = string.split("/+");
                        if (((String[])object3).length < 2) {
                            throw new UaServerException("Invalid URI: " + string);
                        }
                        object = object3[0];
                        String[] stringArray = object3[1].split(":");
                        try {
                            n2 = Integer.parseInt(stringArray[1]);
                        }
                        catch (NumberFormatException arrayIndexOutOfBoundsException) {
                            n2 = UriUtil.defaultPort((String)object);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n2 = UriUtil.defaultPort((String)object);
                        }
                    }
                    object3 = String.format(Locale.ROOT, string3, uaAddress.getProtocol().toString(), inetAddress.getHostAddress(), n2);
                    object = this.server.bind((String)object3, (Endpoint)object2);
                    int stringArray = n2;
                    Iterator numberFormatException = object.iterator();
                    while (numberFormatException.hasNext()) {
                        EndpointServer.EndpointHandle endpointHandle = (EndpointServer.EndpointHandle)numberFormatException.next();
                        if (!string.equals(endpointHandle.endpointBinding().getOriginalAddress()) && !string2.equals(endpointHandle.endpointBinding().getOriginalAddress())) continue;
                        string2 = endpointHandle.endpointBinding().endpointAddress.getEndpointUrl();
                        stringArray = UaAddress.parse(string2).getPort();
                        if (!this.serverUris.contains(string) || this.serverUris.contains(string2)) continue;
                        this.serverUris.remove(string);
                        this.serverUris.add(string2);
                    }
                    arrayList.add(inetAddress.getHostAddress() + ":" + stringArray);
                    if (this.isDiscoveryEndpointEnabled()) {
                        this.c((String)object3, string2);
                        continue;
                    }
                    logger.debug("Skipping binding DiscoveryEndpoint because isDiscoveryEndpointEnabled is false");
                }
                this.a(treeSet, (Endpoint)object2, arrayList);
            }
            catch (ServiceResultException serviceResultException) {
                if (this.oV) {
                    this.server.close();
                    throw new UaServerException("Failed to initialize server endpoint: " + string2, serviceResultException);
                }
                logger.error("Failed to initialize server endpoint: " + string2, serviceResultException);
            }
        }
    }

    private void cmU() throws UaServerException {
        for (EndpointDescription endpointDescription : this.oU) {
            String string = endpointDescription.getEndpointUrl();
            this.u(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void a(ReverseConnectionParameters reverseConnectionParameters) throws UaServerException {
        if (this.pa.get(reverseConnectionParameters) != null) {
            return;
        }
        try {
            if (reverseConnectionParameters.getEndpointUrlForClientConnection() == null) {
                void var3_8;
                HashSet<String> hashSet = new HashSet<String>();
                for (EndpointDescription endpointDescription : this.getEndpoints()) {
                    if (!endpointDescription.getEndpointUrl().startsWith("opc.tcp")) continue;
                    hashSet.add(endpointDescription.getEndpointUrl());
                }
                if (hashSet.isEmpty()) {
                    throw new UaServerException("No opc.tcp bound endpoints found, ReverseConnections only work on opc.tcp");
                }
                if (hashSet.size() == 1) {
                    String string = (String)hashSet.iterator().next();
                } else {
                    String string = reverseConnectionParameters.getEndpointUrlForClientConnectionSelector().apply(new ArrayList(hashSet));
                }
                ReverseConnectionParameters.Builder builder = reverseConnectionParameters.toBuilder();
                builder.setEndpointUrlForClientConnection((String)var3_8);
                EndpointServer.ReverseEndpointHandle reverseEndpointHandle = this.server.bindReverse(builder.build(), this.getExecutor());
                this.pa.put(reverseConnectionParameters, reverseEndpointHandle);
            } else {
                EndpointServer.ReverseEndpointHandle reverseEndpointHandle = this.server.bindReverse(reverseConnectionParameters, this.getExecutor());
                this.pa.put(reverseConnectionParameters, reverseEndpointHandle);
            }
        }
        catch (Exception exception) {
            throw new UaServerException("Could not add a reverse connection binding", exception);
        }
    }

    private void cmV() throws UaServerException {
        for (ReverseConnectionParameters reverseConnectionParameters : this.pa.keySet()) {
            this.a(reverseConnectionParameters);
        }
    }

    private void v(String string) throws UaServerException {
        if (this.initialized) {
            throw new UaServerException(String.format(Locale.ROOT, "Cannot configure %s after the server is initialized.", string));
        }
    }

    private void cmW() {
        for (UserTokenPolicy userTokenPolicy : this.server.getUserTokenPolicies()) {
            this.server.removeUserTokenPolicy(userTokenPolicy);
        }
    }

    private synchronized void cmX() {
        logger.debug("Closing reverse connections");
        this.pa.forEach((reverseConnectionParameters, reverseEndpointHandle) -> {
            if (reverseEndpointHandle != null) {
                reverseEndpointHandle.close();
            }
        });
        this.pa.replaceAll((reverseConnectionParameters, reverseEndpointHandle) -> null);
    }

    private String[] cmY() {
        return this.serverUris.toArray(new String[0]);
    }

    private void cmZ() {
        if (!this.oW) {
            return;
        }
        Application application = this.server.getApplication();
        application.setApplicationName(this.applicationIdentity.getApplicationDescription().getApplicationName());
        application.setApplicationUri(this.applicationIdentity.getApplicationDescription().getApplicationUri());
        application.setProductUri(this.applicationIdentity.getApplicationDescription().getProductUri());
        KeyPair[] keyPairArray = this.applicationIdentity.getCertificates();
        if (keyPairArray != null) {
            for (KeyPair object : keyPairArray) {
                application.addApplicationInstanceCertificate(object);
                logger.debug("certificateThumbPrint: {}", (Object)Arrays.toString(object.getCertificate().getEncodedThumbprint()));
            }
        } else {
            application.addApplicationInstanceCertificate(this.applicationIdentity.getKeys());
            logger.debug("certificateThumbPrint: {}", (Object)Arrays.toString(this.applicationIdentity.getKeys().getCertificate().getEncodedThumbprint()));
        }
        application.getHttpsSettings().setKeyPair(this.applicationIdentity.getHttpsCertificate(), new Cert[0]);
        application.getOpctcpSettings().setCertificateValidator(this.getCertificateValidator());
        for (SignedSoftwareCertificate signedSoftwareCertificate : this.applicationIdentity.getSoftwareCertificates()) {
            application.addSoftwareCertificate(signedSoftwareCertificate);
        }
    }

    private void cna() throws UaServerException {
        try {
            BuildInfoTypeNode buildInfoTypeNode = this.getNodeManagerRoot().getServerData().getServerStatusNode().getBuildInfoNode();
            if (buildInfoTypeNode.getProductUri() == null) {
                buildInfoTypeNode.setProductUri(this.getApplicationIdentity().getApplicationDescription().getProductUri());
            }
            if (buildInfoTypeNode.getProductName() == null) {
                buildInfoTypeNode.setProductName(this.getApplicationIdentity().getApplicationDescription().getApplicationName().getText());
            }
        }
        catch (StatusException statusException) {
            throw new UaServerException("Failed to initialize BuildInfo", statusException);
        }
    }

    private void cnb() {
        Application application = this.server.getApplication();
        Integer n2 = this.pb;
        if (n2 == null) {
            n2 = UaServer.h(this.getSessionManager().getMaxSessionCount());
        } else if (n2 < this.getSessionManager().getMaxSessionCount()) {
            logger.warn("The UaServer maxOpcTcpConnections ({}) has been configured to be a value lower than the configured MaxSessionCount ({}).", (Object)n2, (Object)this.getSessionManager().getMaxSessionCount());
        }
        application.getOpctcpSettings().setMaxConnections(n2);
        Integer n3 = this.pc;
        if (n3 == null) {
            n3 = UaServer.h(this.getSessionManager().getMaxSessionCount());
        } else if (n3 < this.getSessionManager().getMaxSessionCount()) {
            logger.warn("The UaServer maxOpcHttpsConnections ({}) has been configured to be a value lower than the configured MaxSessionCount ({}).", (Object)n3, (Object)this.getSessionManager().getMaxSessionCount());
        }
        application.getHttpsSettings().setMaxConnections(n3);
        this.gb.setMaxConnections(n3);
    }

    private void cnc() throws UaServerException {
        this.oU = new ArrayList<EndpointDescription>();
        logger.debug("initEndpoints: SecurityModes={} httpsSecurityPolicies={}", (Object)this.securityModes, (Object)Arrays.toString((Object[])this.getHttpsSecurityPolicies()));
        for (String string : this.getServerUris()) {
            logger.debug("uri: {}", (Object)string);
            Set<SecurityMode> set = string.startsWith("opc.https") ? this.httpsSecurityModes : this.securityModes;
            try {
                for (SecurityMode securityMode : set) {
                    this.addEndpoint(string, securityMode, this.getUserTokenPolicies());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.server.close();
                throw new UaServerException("Failed to initialize server endpoint: " + string, illegalArgumentException);
            }
        }
    }

    private void cje() {
        this.registerModel(GdsServerInformationModel.MODEL);
        if (this.isAutoDiscoverCodegenModels()) {
            this.registerAutoDiscoveredModels(ServerCodegenModelProvider.class);
        }
    }

    private void cnd() throws UaServerException {
        if (this.userTokenPolicies.isEmpty()) {
            throw new UaServerException("No UserTokenPolicies defined");
        }
        for (UserTokenPolicy userTokenPolicy : this.userTokenPolicies) {
            if (userTokenPolicy == null) {
                throw new UaServerException("Defined UserTokenPolicies includes a null policy");
            }
            if (userTokenPolicy.getTokenType() != null) continue;
            throw new UaServerException("Defined UserTokenPolicies includes a null UserTokenType (instead of one of the enum values) in policy: " + userTokenPolicy);
        }
        this.cmW();
        for (UserTokenPolicy userTokenPolicy : this.userTokenPolicies) {
            this.server.addUserTokenPolicy(userTokenPolicy);
        }
    }

    private void listenerError(String string, Object object, RuntimeException runtimeException) {
        logger.error("Exception while calling " + string + " on object " + object, runtimeException);
        throw runtimeException;
    }

    private void a(Set<HttpsSecurityPolicy> set, Endpoint endpoint, List<String> list) {
        boolean bl;
        logger.info("Server endpoint: {}", (Object)endpoint.getEndpointUrl());
        logger.info("* Endpoint bound to: {}", (Object)list);
        TreeSet<MessageSecurityMode> treeSet = new TreeSet<MessageSecurityMode>();
        TreeSet<SecurityPolicy> treeSet2 = new TreeSet<SecurityPolicy>();
        TreeSet<SecurityPolicy> treeSet3 = new TreeSet<SecurityPolicy>();
        for (SecurityMode object : endpoint.getSecurityModes()) {
            treeSet.add(object.getMessageSecurityMode());
            if (MessageSecurityMode.Sign.equals(object.getMessageSecurityMode())) {
                treeSet2.add(object.getSecurityPolicy());
            }
            if (!MessageSecurityMode.SignAndEncrypt.equals(object.getMessageSecurityMode())) continue;
            treeSet3.add(object.getSecurityPolicy());
        }
        ArrayList arrayList = new ArrayList();
        for (SecurityPolicy securityPolicy : treeSet2) {
            arrayList.add(securityPolicy.getDisplayName());
        }
        ArrayList arrayList2 = new ArrayList();
        for (SecurityPolicy securityPolicy : treeSet3) {
            arrayList2.add(securityPolicy.getDisplayName());
        }
        logger.info("* Endpoint MessageSecurityModes: " + treeSet);
        boolean bl2 = arrayList.equals(arrayList2);
        if (!treeSet.containsAll(Arrays.asList(MessageSecurityMode.Sign, MessageSecurityMode.SignAndEncrypt))) {
            bl2 = true;
        }
        boolean bl3 = treeSet.size() == 1 && treeSet.contains(MessageSecurityMode.None);
        boolean bl4 = bl = !set.isEmpty();
        if (!bl3) {
            if (bl2) {
                logger.info("* Endpoint SecurityPolicies: " + arrayList);
            } else {
                if (treeSet.contains(MessageSecurityMode.Sign)) {
                    logger.info("* Endpoint SecurityPolicies (Sign): " + arrayList);
                }
                if (treeSet.contains(MessageSecurityMode.SignAndEncrypt)) {
                    logger.info("* Endpoint SecurityPolicies (SignAndEncrypt): " + arrayList2);
                }
            }
            if (bl) {
                ArrayList<String> arrayList3 = new ArrayList<String>();
                for (HttpsSecurityPolicy httpsSecurityPolicy : set) {
                    arrayList3.add(httpsSecurityPolicy.name());
                }
                logger.info("* Endpoint HTTPS SecurityPolicies: " + arrayList3);
            }
        }
    }

    private void cne() {
        this.serverUris = null;
        this.oX.clear();
    }

    private void cnf() {
        long l2 = TimeUnit.MINUTES.toMillis(this.getDiscoveryServerRegistrationPeriod());
        if (this.pk == null && this.isDiscoveryEndpointEnabled() && !this.getDiscoveryServerUrl().isEmpty() && l2 > 0L) {
            this.pk = new Timer("DiscoveryRegistrationTimer");
            this.pj = new a(this.getDiscoveryServerUrl());
            this.pk.schedule((TimerTask)this.pj, l2, l2);
            logger.debug("discoveryRegistrationTimer scheduled: period={}", (Object)l2);
        }
    }

    private void cng() throws UaServerException {
        try {
            this.diagnosticsManager.start();
            this.sessionManager.start();
            this.subscriptionManager.start();
            this.nodeServiceHandler.start();
        }
        catch (StatusException statusException) {
            throw new UaServerException("Failed to start all managers", statusException);
        }
        catch (UaNodeFactoryException uaNodeFactoryException) {
            throw new UaServerException("Failed to start all managers", uaNodeFactoryException);
        }
    }

    private void cnh() {
        if (this.pk != null) {
            this.pk.cancel();
            this.pk = null;
            logger.debug("discoveryRegistrationTimer canceled");
        }
    }

    private void cni() {
        String[] stringArray = this.cmY();
        this.getApplicationIdentity().getApplicationDescription().setDiscoveryUrls(stringArray);
        this.getServer().getApplication().getApplicationDescription().setDiscoveryUrls(stringArray);
        if (logger.isDebugEnabled()) {
            logger.debug("updateApplicationDescription: applicationDescription={}", (Object)this.getApplicationIdentity().getApplicationDescription());
        }
    }

    protected AttributeServiceHandler createAttributeServiceHandler() {
        return new AttributeServiceHandler(this.sessionManager, this.nodeManagerTable);
    }

    protected DiagnosticsManager createDiagnosticsManager() {
        DiagnosticsManager diagnosticsManager = new DiagnosticsManager(this);
        return diagnosticsManager;
    }

    protected ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    protected NodeManager createNewNodeManager(ServiceContext serviceContext, String string) throws StatusException {
        NodeManager nodeManager = null;
        if (this.getListener() != null) {
            nodeManager = this.getListener().onCreateNewNodeManager(serviceContext, string);
        }
        if (nodeManager == null) {
            nodeManager = new NodeManagerUaNode(this, string);
        }
        return nodeManager;
    }

    protected NodeManagementServiceHandler createNodeManagementServiceHandler() {
        return new NodeManagementServiceHandler(this.sessionManager, this.nodeManagerTable);
    }

    protected NodeManagerRoot createNodeManagerRoot() {
        return new NodeManagerRoot(this);
    }

    protected NodeManagerTable createNodeManagerTable() {
        return new NodeManagerTable(this);
    }

    protected NodeManagerUaServer createNodeManagerUaServer(String string) {
        return new NodeManagerUaServer(this, string);
    }

    protected SessionManager createSessionManager() {
        SessionManager sessionManager = new SessionManager(this);
        return sessionManager;
    }

    protected SessionServiceHandler createSessionServiceHandler() {
        return new SessionServiceHandler(this.sessionManager);
    }

    protected SubscriptionManager createSubscriptionManager() {
        return new SubscriptionManager(this.sessionManager, this.nodeManagerTable);
    }

    protected SubscriptionServiceHandler createSubscriptionServiceHandler() {
        return new SubscriptionServiceHandler(this.subscriptionManager);
    }

    protected DiscoveryServer getDiscoveryServer() {
        DiscoveryServer discoveryServer = this.oQ.get();
        if (discoveryServer != null) {
            return discoveryServer;
        }
        discoveryServer = new DiscoveryServer(this.server);
        try {
            this.server.getOrCreateOpcTcpServer().discoveryServer = discoveryServer;
        }
        catch (ServiceResultException serviceResultException) {
            logger.debug("Cannot assign discoveryServer");
        }
        this.oQ.compareAndSet(null, discoveryServer);
        return this.oQ.get();
    }

    protected String getDiscoveryUriOf(String string) {
        UaAddress uaAddress = UaAddress.parse(string);
        return UaAddress.fromComponents(uaAddress.getProtocol(), uaAddress.getHost(), uaAddress.getPort()).getAddress();
    }

    protected ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    protected int getHttpsPort() {
        return this.getPort(UaApplication.Protocol.OpcHttps);
    }

    protected HttpsSecurityPolicy[] getHttpsSecurityPolicies() {
        return this.getHttpsSettings().getHttpsSecurityPolicies();
    }

    protected Server getServer() {
        return this.server;
    }

    protected void initAggregateFunctions() {
        try {
            FolderTypeNode folderTypeNode = this.getNodeManagerRoot().getServerData().getServerCapabilitiesNode().getAggregateFunctionsNode();
            FolderTypeNode folderTypeNode2 = this.getAddressSpace().getNode(Identifiers.HistoryServerCapabilities_AggregateFunctions, FolderTypeNode.class);
            for (NodeId nodeId : this.getAggregateCalculator().getSupportedFunctions()) {
                folderTypeNode.addReference(nodeId, Identifiers.Organizes, false);
                folderTypeNode2.addReference(nodeId, Identifiers.Organizes, false);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not init AggregateFunctions", exception);
        }
    }

    protected void initServerArray() throws UaServerException {
        if (this.oW) {
            try {
                this.addToServerArray(this.applicationIdentity.getApplicationDescription().getApplicationUri());
            }
            catch (StatusException statusException) {
                throw new UaServerException("Failed to add server to server array.", statusException);
            }
        }
        try {
            this.updateServerArray();
        }
        catch (StatusException statusException) {
            throw new UaServerException("Failed to initialize UaServer", statusException);
        }
    }

    protected void initServiceHandlers() throws UaServerException {
        if (!this.oW) {
            try {
                this.nodeServiceHandler.init();
            }
            catch (UaNodeFactoryException uaNodeFactoryException) {
                throw new UaServerException("Failed to initialize UaServer", uaNodeFactoryException);
            }
            catch (StatusException statusException) {
                throw new UaServerException("Failed to initialize UaServer", statusException);
            }
            return;
        }
        if (this.isDiscoveryEndpointEnabled()) {
            this.addServiceHandler(this.getDiscoveryServer());
        }
        this.diagnosticsManager = this.createDiagnosticsManager();
        this.sessionManager = this.createSessionManager();
        this.sessionManager.addListener(this.sessionManagerListener);
        this.sessionServiceHandler = this.createSessionServiceHandler();
        this.addServiceHandler(this.sessionServiceHandler);
        this.nodeManagerTable = this.createNodeManagerTable();
        this.nodeManagerRoot = this.createNodeManagerRoot();
        this.nodeManagerTable.addNodeManager(0, this.nodeManagerRoot);
        this.nodeServiceHandler = this.createNodeManagementServiceHandler();
        this.addServiceHandler(this.nodeServiceHandler);
        this.attributeServiceHandler = this.createAttributeServiceHandler();
        this.addServiceHandler(this.attributeServiceHandler);
        this.subscriptionManager = this.createSubscriptionManager();
        this.subscriptionServiceHandler = this.createSubscriptionServiceHandler();
        this.addServiceHandler(this.subscriptionServiceHandler);
        this.nodeManagerUaServer = this.createNodeManagerUaServer(this.applicationIdentity.getApplicationDescription().getApplicationUri());
        try {
            this.nodeServiceHandler.init();
        }
        catch (StatusException statusException) {
            throw new UaServerException("Failed to initialize UaServer", statusException);
        }
        catch (UaNodeFactoryException uaNodeFactoryException) {
            throw new UaServerException("Failed to initialize UaServer", uaNodeFactoryException);
        }
    }

    protected void logRegisterServerError(String string, boolean bl, UaServerException uaServerException) {
        String string2 = uaServerException.getCause() == null ? "" : " Cause: " + uaServerException.getCause().getMessage();
        boolean bl2 = false;
        if (this.listener != null) {
            bl2 = this.listener.onRegisterServerError(string, bl, uaServerException);
        }
        if (!bl2) {
            logger.warn(uaServerException.getMessage() + string2);
        }
    }

    protected boolean registerServer(boolean bl, boolean bl2) {
        if (this.isDiscoveryEndpointEnabled()) {
            this.getDiscoveryServer().registerServer(this, null, bl);
            if (!this.getDiscoveryServerUrl().isEmpty() && bl2) {
                try {
                    String string = bl ? "online" : "offline";
                    this.registerServer(this.getDiscoveryServerUrl(), bl);
                    logger.info("Registered server {} to DiscoveryServerUrl={}", (Object)string, (Object)this.getDiscoveryServerUrl());
                    if (this.listener != null) {
                        this.listener.onRegisterServer(this.getDiscoveryServerUrl(), bl);
                    }
                    return true;
                }
                catch (UaServerException uaServerException) {
                    this.logRegisterServerError(this.getDiscoveryServerUrl(), bl, uaServerException);
                }
            }
        }
        return false;
    }

    protected void setHttpsPort(int n2) throws UaServerException {
        this.setPort(UaApplication.Protocol.OpcHttps, n2);
    }

    protected void shutdownBegin(int n2, LocalizedText localizedText) {
        logger.info("Shutdown: Delay (s)={}; Reason={}", (Object)n2, (Object)localizedText);
        this.registerServer(false, true);
        this.getNodeManagerRoot().shutdown(n2, localizedText);
    }

    protected void shutdownEnd(boolean bl) {
        try {
            if (this.subscriptionManager != null) {
                this.subscriptionManager.close();
            }
            this.sessionManager.close();
            this.diagnosticsManager.close();
        }
        finally {
            this.mZ = false;
        }
        if (bl) {
            this.close();
        }
    }

    protected void shutdownSleep(int n2) {
        logger.debug("Sleeping {} seconds", (Object)n2);
        try {
            Thread.sleep(n2 * 1000);
        }
        catch (InterruptedException interruptedException) {
            logger.debug("Shutdown interrupted", interruptedException);
        }
    }

    protected void updateNamespaceArray() {
        this.getNodeManagerRoot().getServerData().updateNamespaceArray();
    }

    protected void updateServerArray() throws StatusException {
        this.getNodeManagerRoot().getServerData().updateServerArray();
    }

    protected void updateServerCapabilities() {
        ServerCapabilitiesTypeNode serverCapabilitiesTypeNode = this.getNodeManagerRoot().getServerData().getServerCapabilitiesNode();
        serverCapabilitiesTypeNode.setFieldsFromEndpointConfiguration(this.fZ);
        serverCapabilitiesTypeNode.setMinSupportedSampleRate(this.getSubscriptionManager().getMinSamplingInterval());
        serverCapabilitiesTypeNode.setMaxSessions(this.getSessionManager().getMaxSessionCount());
        serverCapabilitiesTypeNode.setMaxSubscriptionsPerSession(this.getSubscriptionManager().getMaxSubscriptionCount());
        serverCapabilitiesTypeNode.setMaxMonitoredItemsPerSubscription(this.subscriptionManager.getMaxMonitoredItemsPerSubscription());
        long l2 = (long)this.getSubscriptionManager().getMaxSubscriptionCount() * (long)this.getSessionManager().getMaxSessionCount();
        if (l2 > 0xFFFFFFFFL) {
            serverCapabilitiesTypeNode.setMaxSubscriptions(UnsignedInteger.MAX_VALUE);
        } else {
            serverCapabilitiesTypeNode.setMaxSubscriptions(l2);
        }
        long l3 = l2 * (long)this.getSubscriptionManager().getMaxMonitoredItemsPerSubscription();
        if (l3 > 0xFFFFFFFFL) {
            serverCapabilitiesTypeNode.setMaxMonitoredItems(UnsignedInteger.MAX_VALUE);
        } else {
            serverCapabilitiesTypeNode.setMaxMonitoredItems(l3);
        }
    }

    protected void validateUserError(Session session, UserIdentityToken userIdentityToken, Exception exception) {
        logger.debug("validateUserIdentity: userValidator={}", (Object)this.pi);
        if (this.pi != null) {
            try {
                this.pi.onValidationError(session, userIdentityToken, exception);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("userValidationError", this.pi, runtimeException);
            }
        }
    }

    protected boolean validateUserIdentity(Session session, ServerUserIdentity serverUserIdentity) throws StatusException {
        logger.debug("validateUserIdentity: userValidator={}", (Object)this.pi);
        if (this.pi != null) {
            try {
                return this.pi.onValidate(session, serverUserIdentity);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("validateUserIdentity", this.pi, runtimeException);
            }
        }
        return true;
    }

    void w(String string) throws UaServerException {
        if (this.isRunning()) {
            throw new UaServerException(String.format(Locale.ROOT, "Cannot change %s when running", string));
        }
    }

    private class a
    extends TimerTask {
        private final String pq;

        public a(String string) {
            this.pq = string;
        }

        @Override
        public void run() {
            long l2 = 5L;
            while (l2 > 0L && System.currentTimeMillis() - this.scheduledExecutionTime() < TimeUnit.MINUTES.toMillis(UaServer.this.getDiscoveryServerRegistrationPeriod())) {
                try {
                    UaServer.this.registerServer(this.pq, true);
                    l2 = 0L;
                }
                catch (UaServerException uaServerException) {
                    try {
                        UaServer.this.logRegisterServerError(this.pq, true, uaServerException);
                        logger.debug("Retrying to register server in {} seconds", (Object)l2);
                        long l3 = System.currentTimeMillis();
                        do {
                            TimeUnit.SECONDS.sleep(1L);
                        } while (UaServer.this.isRunning() && System.currentTimeMillis() - l3 < l2 * 1000L);
                        l2 = UaServer.this.isRunning() ? Math.min(2L * l2, TimeUnit.MINUTES.toSeconds(UaServer.this.getDiscoveryServerRegistrationPeriod())) : 0L;
                    }
                    catch (InterruptedException interruptedException) {
                        logger.debug("DiscoveryRegistrationTask interrupted");
                        l2 = 0L;
                    }
                }
            }
            logger.debug("DiscoveryRegistrationTask end");
        }
    }

    public static class NodeManagerUaServer
    extends NodeManagerUaNode {
        private final IoManagerListener pt = new IoManagerListener(){

            @Override
            public AccessLevelType onGetUserAccessLevel(ServiceContext serviceContext, NodeId nodeId, UaVariable uaVariable) {
                if (uaVariable == null) {
                    return AccessLevels.READ_ONLY;
                }
                if (uaVariable instanceof SessionSecurityDiagnosticsType) {
                    UaReference[] uaReferenceArray;
                    for (UaReference uaReference : uaReferenceArray = uaVariable.getReferences(Identifiers.HasComponent, true)) {
                        if (!(uaReference.getSourceNode() instanceof SessionDiagnosticsObjectType) || !uaReference.getSourceNode().getNodeId().equals(serviceContext.getSession().getSessionId())) continue;
                        return AccessLevels.READ_ONLY;
                    }
                    return this.getAccessLevelForSecurityDiagnostics(serviceContext);
                }
                UaReference uaReference = uaVariable.getReference(Identifiers.HasComponent, true);
                if (uaReference == null) {
                    uaReference = uaVariable.getReference(Identifiers.HasProperty, true);
                }
                if (uaReference != null && uaReference.getSourceNode() instanceof SessionSecurityDiagnosticsType) {
                    UaReference[] uaReferenceArray;
                    for (UaReference uaReference2 : uaReferenceArray = uaReference.getSourceNode().getReferences(Identifiers.HasComponent, true)) {
                        if (!(uaReference2.getSourceNode() instanceof SessionDiagnosticsObjectType) || !uaReference2.getSourceNode().getNodeId().equals(serviceContext.getSession().getSessionId())) continue;
                        return AccessLevels.READ_ONLY;
                    }
                    return this.getAccessLevelForSecurityDiagnostics(serviceContext);
                }
                return AccessLevels.READ_ONLY;
            }

            @Override
            public Boolean onGetUserExecutable(ServiceContext serviceContext, NodeId nodeId, UaMethod uaMethod) {
                return false;
            }

            @Override
            public AttributeWriteMask onGetUserWriteMask(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode) {
                return AttributeWriteMask.of();
            }

            @Override
            public boolean onReadNonValue(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
                return false;
            }

            @Override
            public boolean onReadValue(ServiceContext serviceContext, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
                return false;
            }

            @Override
            public boolean onWriteNonValue(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
                return false;
            }

            @Override
            public boolean onWriteValue(ServiceContext serviceContext, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, DataValue dataValue) throws StatusException {
                return false;
            }
        };

        public NodeManagerUaServer(UaServer uaServer, String string) {
            super(uaServer, string);
            this.getIoManager().addListeners(this.pt);
        }

        @Override
        protected NodeId addNode(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, QualifiedName qualifiedName, NodeClass nodeClass, ExpandedNodeId expandedNodeId, NodeAttributes nodeAttributes, NodeId nodeId3) throws StatusException {
            if (!serviceContext.isInternal()) {
                throw new StatusException(StatusCodes.Bad_UserAccessDenied);
            }
            return super.addNode(serviceContext, nodeId, nodeId2, qualifiedName, nodeClass, expandedNodeId, nodeAttributes, nodeId3);
        }

        @Override
        protected void addReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, boolean bl, NodeClass nodeClass, String string) throws StatusException {
            super.addReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, nodeClass, string);
        }

        @Override
        protected void deleteNode(ServiceContext serviceContext, NodeId nodeId, Boolean bl) throws StatusException {
            if (!serviceContext.isInternal()) {
                throw new StatusException(StatusCodes.Bad_UserAccessDenied);
            }
            super.deleteNode(serviceContext, nodeId, bl);
        }

        @Override
        protected void deleteReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, Boolean bl, Boolean bl2) throws StatusException {
            super.deleteReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, bl2);
        }

        protected AccessLevelType getAccessLevelForSecurityDiagnostics(ServiceContext serviceContext) {
            if (serviceContext != null && serviceContext.isInternal()) {
                return AccessLevels.READ_ONLY;
            }
            if (this.getServer().getListener() != null && this.getServer().getListener().onAllowReadSecurityDiagnostics(serviceContext)) {
                return AccessLevels.READ_ONLY;
            }
            return AccessLevelType.of();
        }
    }

    public class DiscoveryServer
    extends Server {
        private final Logger logger;
        private final Map<String, RegisteredServer> pr;
        private final Server ps;

        public DiscoveryServer(Server server) {
            super(server.getApplication());
            this.logger = LoggerFactory.getLogger(DiscoveryServer.class);
            this.pr = new ConcurrentHashMap<String, RegisteredServer>(2, 1.0f, 2);
            this.ps = server;
            super.addServiceHandler(this);
        }

        @Override
        public synchronized HttpsServer getOrCreateHttpsServer() throws ServiceResultException {
            return this.ps.getOrCreateHttpsServer();
        }

        @Override
        public synchronized OpcTcpServer getOrCreateOpcTcpServer() throws ServiceResultException {
            return this.ps.getOrCreateOpcTcpServer();
        }

        public RegisteredServer[] getRegisteredServers() {
            return this.pr.values().toArray(new RegisteredServer[this.pr.size()]);
        }

        public final void onFindServers(EndpointServiceRequest<FindServersRequest, FindServersResponse> endpointServiceRequest) throws ServiceFaultException {
            this.logger.debug("onFindServers");
            FindServersResponse findServersResponse = new FindServersResponse();
            ArrayList<ApplicationDescription> arrayList = new ArrayList<ApplicationDescription>();
            FindServersRequest findServersRequest = endpointServiceRequest.getRequest();
            String string = findServersRequest.getEndpointUrl();
            this.logger.debug("endpointUrl={}", (Object)string);
            List<Object> list = findServersRequest.getServerUris() != null && findServersRequest.getServerUris().length != 0 ? Arrays.asList(findServersRequest.getServerUris()) : Collections.emptyList();
            List<Object> list2 = findServersRequest.getLocaleIds() != null && findServersRequest.getLocaleIds().length != 0 ? Arrays.asList(findServersRequest.getLocaleIds()) : Collections.emptyList();
            this.logger.debug("serverUris={}", (Object)list);
            this.logger.debug("registeredServers={}", (Object)this.pr.values());
            for (RegisteredServer registeredServer : this.pr.values()) {
                if (!registeredServer.getIsOnline().booleanValue() || !list.isEmpty() && !list.contains(registeredServer.getServerUri())) continue;
                List<LocalizedText> list3 = Arrays.asList(registeredServer.getServerNames());
                LocalizedText localizedText = list3.get(0);
                block1: for (String string2 : list2) {
                    for (LocalizedText localizedText2 : list3) {
                        if (!string2.equals(localizedText2.getLocale().getLanguage())) continue;
                        localizedText = localizedText2;
                        continue block1;
                    }
                }
                ArrayList arrayList2 = new ArrayList();
                if (string != null) {
                    for (String string3 : registeredServer.getDiscoveryUrls()) {
                        if (!string3.contains(string)) continue;
                        arrayList2.add(string3);
                    }
                }
                if (arrayList2.isEmpty()) {
                    for (String string3 : registeredServer.getDiscoveryUrls()) {
                        if (string3.contains("localhost")) continue;
                        arrayList2.add(string3);
                    }
                }
                arrayList.add(new ApplicationDescription(registeredServer.getServerUri(), registeredServer.getProductUri(), localizedText, registeredServer.getServerType(), registeredServer.getGatewayServerUri(), null, arrayList2.toArray(new String[arrayList2.size()])));
            }
            this.logger.debug("servers={}", (Object)arrayList);
            findServersResponse.setServers(arrayList.toArray(new ApplicationDescription[arrayList.size()]));
            ResponseHeader responseHeader = new ResponseHeader(DateTime.currentTime(), findServersRequest.getRequestHeader().getRequestHandle(), null, null, this.getApplication().getLocaleIds(), null);
            findServersResponse.setResponseHeader(responseHeader);
            endpointServiceRequest.sendResponse(findServersResponse, null);
        }

        public void registerServer(UaServer uaServer, String string, boolean bl) {
            boolean bl2 = this.cnj();
            RegisteredServer registeredServer = UaServer.toRegisteredServer(string, bl, uaServer);
            this.pr.put(registeredServer.getServerUri(), registeredServer);
            this.logger.debug("registerServer: server={} isOnline={}", (Object)registeredServer, (Object)bl);
            if (bl2 && !this.cnj()) {
                this.logger.debug("No Online Servers: closing the internal Discovery Server");
                super.close();
                UaServer.this.oQ.set(null);
            }
        }

        private boolean cnj() {
            for (RegisteredServer registeredServer : this.pr.values()) {
                if (!registeredServer.getIsOnline().booleanValue()) continue;
                return true;
            }
            return false;
        }
    }
}

