/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.SubscriptionBase;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManagerAdapter;
import com.prosysopc.ua.server.SessionManagerListener;
import com.prosysopc.ua.server.SubscriptionDiagnostics;
import com.prosysopc.ua.server.SubscriptionManager;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.DataChangeNotification;
import com.prosysopc.ua.stack.core.EventFieldList;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.EventFilterResult;
import com.prosysopc.ua.stack.core.EventNotificationList;
import com.prosysopc.ua.stack.core.MonitoredItemNotification;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.core.NotificationData;
import com.prosysopc.ua.stack.core.NotificationMessage;
import com.prosysopc.ua.stack.core.StatusChangeNotification;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.stack.utils.StackUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subscription
extends SubscriptionBase {
    private static int nm = 15;
    private volatile boolean closed;
    private final AtomicBoolean nn = new AtomicBoolean(true);
    private final AtomicBoolean no = new AtomicBoolean(true);
    private final AtomicInteger np = new AtomicInteger(0);
    private final AtomicInteger nq = new AtomicInteger(0);
    private final AtomicReference<DateTime> nr = new AtomicReference<DateTime>(DateTime.currentTime());
    private final AtomicLong ns = new AtomicLong(0L);
    private final AtomicReference<DateTime> nt = new AtomicReference<DateTime>(DateTime.currentTime());
    private final AtomicLong nu = new AtomicLong(0L);
    private volatile MonitoredItemBase nv;
    private final Logger logger = LoggerFactory.getLogger(Subscription.class);
    private final AtomicLong nw = new AtomicLong(1L);
    private ScheduledExecutorService nx;
    private final AtomicReference<BlockingQueue<SubscriptionBase>> ny = new AtomicReference();
    private ScheduledFuture<?> nz;
    private final Map<UnsignedInteger, NotificationMessage> nA = new ConcurrentHashMap<UnsignedInteger, NotificationMessage>();
    private volatile Session lI;
    private final SessionManagerListener sessionManagerListener = new SessionManagerAdapter(){

        @Override
        public void onActivateSessionError(Session session, UserIdentityToken userIdentityToken, Exception exception) {
            this.cmj();
        }

        @Override
        public void onAfterActivateSession(Session session) {
            this.cmj();
        }

        public void cmj() {
            for (MonitoredItemBase monitoredItemBase : Subscription.this.getItems()) {
                if (!(monitoredItemBase instanceof MonitoredDataItem)) continue;
                ((MonitoredDataItem)monitoredItemBase).updateAccessible(Subscription.this.lI);
            }
        }
    };
    private final SubscriptionManager subscriptionManager;
    private final Map<UnsignedInteger, MonitoredItem> nB = new ConcurrentHashMap<UnsignedInteger, MonitoredItem>();
    private final SubscriptionDiagnostics nC;
    private volatile boolean nD;

    protected static void setPublishTimeCheckAllowedThresholdMS(int n2) {
        nm = n2;
    }

    public Subscription(SubscriptionManager subscriptionManager, UnsignedInteger unsignedInteger, Boolean bl, Double d2, UnsignedInteger unsignedInteger2, UnsignedInteger unsignedInteger3, UnsignedInteger unsignedInteger4, UnsignedByte unsignedByte) {
        super(unsignedInteger, bl, d2, unsignedInteger2, unsignedInteger3, unsignedInteger4, unsignedByte);
        if (subscriptionManager == null) {
            throw new NullPointerException("subscriptionManager required");
        }
        this.subscriptionManager = subscriptionManager;
        this.nC = new SubscriptionDiagnostics(null, unsignedInteger, unsignedByte, d2, unsignedInteger3, unsignedInteger2, unsignedInteger4, bl);
        subscriptionManager.getSessionManager().addListener(this.sessionManagerListener);
    }

    public MonitoredDataItem addDataItem(ServiceContext serviceContext, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, QualifiedName qualifiedName, MonitoringMode monitoringMode) {
        this.logger.trace("addDataItem: SubscriptionID={}", (Object)this.getSubscriptionId());
        if (monitoringMode == null) {
            throw new NullPointerException("monitoringMode");
        }
        if (unsignedInteger.equals(Attributes.EventNotifier)) {
            throw new IllegalArgumentException("addItem called with EventNotifier, use addEventItme instead");
        }
        MonitoredDataItem monitoredDataItem = new MonitoredDataItem(serviceContext, this, this.cmg(), nodeId, unsignedInteger, numericRange, monitoringMode);
        this.addItem(monitoredDataItem, monitoredDataItem.getMonitoredItemId());
        return monitoredDataItem;
    }

    public MonitoredDataItem addDataItem(ServiceContext serviceContext, UaNode uaNode, UnsignedInteger unsignedInteger, NumericRange numericRange, QualifiedName qualifiedName, MonitoringMode monitoringMode) {
        MonitoredDataItem monitoredDataItem = this.addDataItem(serviceContext, uaNode.getNodeId(), unsignedInteger, numericRange, qualifiedName, monitoringMode);
        monitoredDataItem.setNode(uaNode);
        return monitoredDataItem;
    }

    public MonitoredEventItem addEventItem(ServiceContext serviceContext, NodeId nodeId, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.logger.debug("addEventItem: SubscriptionID={}", (Object)this.getSubscriptionId());
        MonitoredEventItem monitoredEventItem = new MonitoredEventItem(serviceContext, this, this.cmg(), nodeId, eventFilter, eventFilterResult);
        this.addItem(monitoredEventItem, monitoredEventItem.getMonitoredItemId());
        return monitoredEventItem;
    }

    public void beginNotify() {
        this.np.incrementAndGet();
    }

    public void close() throws ServiceException {
        this.logger.debug("close");
        if (!this.closed) {
            this.subscriptionManager.getSessionManager().removeListener(this.sessionManagerListener);
            this.subscriptionManager.removeSubscription(ServiceContext.INTERNAL_OPERATION_CONTEXT, this, false);
        }
    }

    @Override
    public int compareTo(SubscriptionBase subscriptionBase) {
        Subscription subscription = (Subscription)subscriptionBase;
        BlockingQueue<SubscriptionBase> blockingQueue = this.getPublishQueue();
        BlockingQueue<SubscriptionBase> blockingQueue2 = subscription.getPublishQueue();
        if (blockingQueue == null && blockingQueue2 != null) {
            return 1;
        }
        if (blockingQueue != null && blockingQueue2 == null) {
            return -1;
        }
        if (this.cmf() && !subscription.cmf()) {
            return 1;
        }
        if (!this.cmf() && subscription.cmf()) {
            return -1;
        }
        int n2 = super.compareTo(subscriptionBase);
        if (n2 == 0 && subscriptionBase instanceof Subscription) {
            return subscription.cme().compareTo(this.cme());
        }
        return n2;
    }

    public void endNotify() {
        int n2 = this.np.decrementAndGet();
        if (n2 == 0) {
            this.b(false);
        } else if (n2 < 0) {
            throw new RuntimeException("endNotify() called more times than beginNotify()");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SubscriptionBase subscriptionBase = (SubscriptionBase)object;
        UnsignedInteger unsignedInteger = this.getSubscriptionId();
        UnsignedInteger unsignedInteger2 = subscriptionBase.getSubscriptionId();
        return !(unsignedInteger == null ? unsignedInteger2 != null : !unsignedInteger.equals(unsignedInteger2));
    }

    public UnsignedInteger[] getAvailableSequenceNumbers() {
        Object[] objectArray = this.nA.keySet().toArray(new UnsignedInteger[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public SubscriptionDiagnostics getDiagnostics() {
        return this.nC;
    }

    @Override
    public MonitoredItem getItem(NodeId nodeId, UnsignedInteger unsignedInteger) {
        return (MonitoredItem)super.getItem(nodeId, unsignedInteger);
    }

    @Override
    public int getMaxNotificationsPerPublish() {
        int n2 = super.getMaxNotificationsPerPublish();
        try {
            if (n2 == 0 || n2 > this.subscriptionManager.getMaxNotificationsPerPublish()) {
                n2 = this.subscriptionManager.getMaxNotificationsPerPublish();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return n2;
    }

    public Session getSession() {
        return this.lI;
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public boolean hasExpired() {
        long l2 = DateTime.currentTime().getTimeInMillis() - this.cmd().getTimeInMillis();
        boolean bl = (double)l2 > (double)this.lifetimeCount * this.publishingInterval;
        this.logger.trace("hasExpired: result={} lifetimeCount={} publishingInterval={} elapsed={}", bl, this.lifetimeCount, this.publishingInterval, l2);
        return bl;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        UnsignedInteger unsignedInteger = this.getSubscriptionId();
        n3 = 31 * n3 + (unsignedInteger == null ? 0 : unsignedInteger.hashCode());
        return n3;
    }

    public Boolean hasMoreNotifications() {
        boolean bl;
        BlockingQueue<SubscriptionBase> blockingQueue = this.getPublishQueue();
        boolean bl2 = bl = blockingQueue != null && blockingQueue.contains(this);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("hasMoreNotifications: lastSentItem={}", (Object)this.nv);
            this.logger.trace("hasMoreNotifications: hasMoreDataChangeNotifications={}", (Object)this.nn.get());
            this.logger.trace("hasMoreNotifications: hasMoreEventNotifications={}", (Object)this.no.get());
            this.logger.trace("hasMoreNotifications: isInQueue={}", (Object)bl);
        }
        return this.nv != null || this.nn.get() || this.no.get() || bl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public MonitoredItemBase removeItem(MonitoredItemBase monitoredItemBase) throws ServiceException, StatusException {
        return this.removeItem(monitoredItemBase.getMonitoredItemId());
    }

    @Override
    public MonitoredItemBase removeItem(UnsignedInteger unsignedInteger) throws ServiceException, StatusException {
        return this.subscriptionManager.deleteMonitoredItem(ServiceContext.INTERNAL_OPERATION_CONTEXT, this, unsignedInteger);
    }

    public void start() {
        this.logger.debug("start");
        this.startPublishing();
    }

    private List<ExtensionObject> a(List<ExtensionObject> list, NotificationData notificationData, Session session) {
        if (list == null) {
            list = new ArrayList<ExtensionObject>();
        }
        try {
            List<Locale> list2 = Collections.emptyList();
            if (session != null) {
                list2 = session.getLocales();
            }
            list.add(ExtensionObject.binaryEncode(notificationData, this.getSubscriptionManager().getNodeManagerTable().getServer().getEncoderContext(), list2));
        }
        catch (EncodingException encodingException) {
            this.logger.error("EncodingException: ", encodingException);
        }
        catch (NullPointerException nullPointerException) {
            this.logger.error("Invalid session: {}", (Object)session);
        }
        return list;
    }

    private void a(NotificationMessage notificationMessage) {
        if (!this.isClosed()) {
            this.nA.put(notificationMessage.getSequenceNumber(), notificationMessage);
            int n2 = this.subscriptionManager.getMaxRetransmissionQueueSize();
            while (this.nA.size() > n2) {
                this.nA.remove(Collections.min(this.nA.keySet()));
                this.nC.cmq().incrementAndGet();
            }
            this.nC.cmP().set(this.nA.size());
            this.updateDiagnostics();
        }
    }

    private void clZ() {
        this.b(true);
    }

    private void b(boolean bl) {
        long l2 = this.cmc();
        if (this.nu.get() != 0L && this.isTimeToPublish(l2)) {
            this.addToPublishQueue(l2, false, bl);
        }
    }

    private DataChangeNotification cma() {
        this.logger.trace("getDataChangeNotification");
        DataChangeNotification dataChangeNotification = new DataChangeNotification();
        ArrayList<MonitoredItemNotification> arrayList = new ArrayList<MonitoredItemNotification>();
        boolean bl = false;
        this.nD = false;
        int n2 = this.getMaxNotificationsPerPublish();
        MonitoredItemBase monitoredItemBase = null;
        while (!this.items.isEmpty()) {
            this.nn.set(false);
            for (MonitoredItemBase monitoredItemBase2 : this.items.values()) {
                if (this.nv != null) {
                    if (monitoredItemBase2 != this.nv) continue;
                    this.nv = null;
                    continue;
                }
                this.nv = null;
                if (!(monitoredItemBase2 instanceof MonitoredDataItem)) continue;
                MonitoredDataItem monitoredDataItem = (MonitoredDataItem)monitoredItemBase2;
                if (bl) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("getDataChangeNotification: monitoredItemId={} hasMoreSamples={}", (Object)monitoredItemBase2.getMonitoredItemId(), (Object)monitoredDataItem.hasMoreSamples());
                    }
                    if (!monitoredDataItem.hasMoreSamples()) continue;
                    this.nv = monitoredItemBase;
                    break;
                }
                DataValue dataValue = monitoredDataItem.getNextSample(this.nB.containsKey(monitoredDataItem.getMonitoredItemId()));
                this.logger.debug("getDataChangeNotification: dataItem.MonitoredItemId={} nodeId={} value={}", monitoredDataItem.getMonitoredItemId(), monitoredDataItem.getNodeId(), dataValue);
                this.logger.debug("getDataChangeNotification: hasMoreSamples={}", (Object)monitoredDataItem.hasMoreSamples());
                if (!monitoredDataItem.hasMoreSamples()) {
                    this.nB.remove(monitoredDataItem.getMonitoredItemId());
                }
                if (dataValue == MonitoredDataItem.DELAY_SAMPLE) {
                    this.nD = true;
                    continue;
                }
                if (dataValue == null) continue;
                arrayList.add(new MonitoredItemNotification(monitoredItemBase2.getClientHandle(), dataValue));
                if (monitoredDataItem.hasMoreSamples()) {
                    this.nn.set(true);
                }
                if (n2 <= 0 || arrayList.size() < n2) continue;
                bl = true;
                monitoredItemBase = monitoredItemBase2;
                this.logger.debug("isFull");
            }
            if (this.nn.get() && !bl) continue;
        }
        this.logger.debug("getDataChangeNotification: notifications.size()={}", (Object)arrayList.size());
        dataChangeNotification.setMonitoredItems(arrayList.toArray(new MonitoredItemNotification[arrayList.size()]));
        return dataChangeNotification;
    }

    private EventNotificationList cmb() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getEventNotifications");
        }
        ArrayList<EventFieldList> arrayList = new ArrayList<EventFieldList>();
        for (MonitoredItemBase monitoredItemBase : this.items.values()) {
            if (!(monitoredItemBase instanceof MonitoredEventItem)) continue;
            ((MonitoredEventItem)monitoredItemBase).getEvents(arrayList);
        }
        return new EventNotificationList(arrayList.toArray(new EventFieldList[0]));
    }

    private long cmc() {
        return System.currentTimeMillis();
    }

    private DateTime cmd() {
        return this.nr.get();
    }

    private DateTime cme() {
        return this.nt.get();
    }

    private boolean cmf() {
        return (double)DateTime.currentTime().getTimeInMillis() > (double)this.cme().getTimeInMillis() + (double)this.getMaxKeepAliveCount() * this.publishingInterval;
    }

    private UnsignedInteger cmg() {
        return UnsignedInteger.valueOf(this.ns.incrementAndGet());
    }

    private void removeAllItems() {
        for (Map.Entry entry : this.items.entrySet()) {
            MonitoredItemBase monitoredItemBase = (MonitoredItemBase)entry.getValue();
            try {
                this.removeItem(monitoredItemBase);
            }
            catch (Exception exception) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Exception while removing all items: item=" + monitoredItemBase.getMonitoredItemId() + " of subscription " + this.getSubscriptionId() + " of session " + this.getSession() + ". Exception=" + exception.getMessage());
            }
        }
    }

    private void cmh() {
        for (MonitoredItemBase monitoredItemBase : this.getItems()) {
            MonitoredDataItem monitoredDataItem;
            if (!(monitoredItemBase instanceof MonitoredDataItem) || (monitoredDataItem = (MonitoredDataItem)monitoredItemBase).hasMoreSamples()) continue;
            monitoredDataItem.addNewSample(monitoredDataItem.getLastValue(), false);
        }
    }

    private void cmi() {
        for (MonitoredItemBase monitoredItemBase : this.getItems()) {
            if (monitoredItemBase instanceof MonitoredDataItem) {
                ((MonitoredDataItem)monitoredItemBase).updateQueue();
                continue;
            }
            if (!(monitoredItemBase instanceof MonitoredEventItem)) continue;
            ((MonitoredEventItem)monitoredItemBase).updateQueue();
        }
    }

    protected void acknowledge(UnsignedInteger unsignedInteger) throws ServiceException {
        if (this.nA.remove(unsignedInteger) == null) {
            this.logger.info("Acknowledge on Subscription " + this.getSubscriptionId() + ": " + unsignedInteger + " - Bad_SequenceNumberUnknown");
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo();
            diagnosticInfo.setAdditionalInfo(unsignedInteger.toString());
            throw new ServiceException("Cannot acknowledge", StatusCodes.Bad_SequenceNumberUnknown, diagnosticInfo, null);
        }
        this.nC.cmP().set(this.nA.size());
        this.updateDiagnostics();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Acknowledged on Subscription " + this.getSubscriptionId() + ": " + unsignedInteger);
            this.logger.debug("Available sequence numbers on Subscription " + this.getSubscriptionId() + ": " + Arrays.toString(this.nA.keySet().toArray()));
        }
    }

    protected void addToPublishQueue(long l2, boolean bl, boolean bl2) {
        int n2;
        if (bl2 && !bl && (n2 = this.np.get()) != 0) {
            return;
        }
        BlockingQueue<SubscriptionBase> blockingQueue = this.getPublishQueue();
        this.logger.debug("addToPublishQueue: subscriptionId={} queue={}", (Object)this.getSubscriptionId(), (Object)blockingQueue);
        if (blockingQueue != null) {
            this.nn.set(false);
            this.no.set(false);
            if (bl) {
                blockingQueue.remove(this);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Needs keepalive = true");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Needs keepalive = false");
            }
            if (!blockingQueue.contains(this)) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("addToPublishQueue: q.offer()");
                }
                blockingQueue.offer(this);
            }
            if (l2 > 0L) {
                this.nu.set(l2);
            }
            this.resetKeepAliveCounter();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("addToPublishQueue done. queue=" + blockingQueue);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("addToPublishQueue: queue=null");
        }
    }

    @Override
    protected void enabledChanged() throws ServiceException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("enabledChanged:" + Boolean.toString(this.isPublishingEnabled()));
        }
        if (this.isPublishingEnabled() && this.lI != null) {
            this.cmi();
            this.cmh();
            this.clZ();
            this.startPublishing();
        }
        this.nC.cmE().set(this.isPublishingEnabled());
        this.updateDiagnostics();
    }

    protected NotificationMessage getNextNotificationMessage(Session session) {
        AbstractStructure abstractStructure;
        Object object;
        Session session2 = this.getSession();
        this.logger.debug("getNextNotificationMessage: session={}", (Object)session);
        this.logger.debug("getNextNotificationMessage: getSession()={}", (Object)session2);
        boolean bl = true;
        List<ExtensionObject> list = null;
        if (session2 != null && !session2.equals(session)) {
            object = new StatusChangeNotification();
            ((StatusChangeNotification)object).setStatus(StatusCode.valueOf(StatusCodes.Good_SubscriptionTransferred));
            this.logger.debug("getNextNotificationMessage: transferNotification={}", object);
            list = this.a(list, (NotificationData)object, session2);
        } else {
            if (this.hasExpired()) {
                object = new StatusChangeNotification();
                ((StatusChangeNotification)object).setStatus(StatusCode.valueOf(StatusCodes.Bad_Timeout));
                this.logger.debug("getNextNotificationMessage: timeoutNotification={}", object);
                list = this.a(list, (NotificationData)object, session);
                try {
                    this.close();
                }
                catch (ServiceException serviceException) {
                    this.logger.error("ServiceException: ", serviceException);
                }
            }
            if (this.isPublishingEnabled()) {
                object = this.cma();
                this.logger.debug("DataChangeNotification: ", object);
                abstractStructure = this.cmb();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("getNextNotificationMessage: dataChangeNotification.getMonitoredItems().length=" + ((DataChangeNotification)object).getMonitoredItems().length + " " + (this.nv == null ? "null" : this.nv.getMonitoredItemId()));
                }
                if (((DataChangeNotification)object).getMonitoredItems().length > 0) {
                    list = this.a(list, (NotificationData)object, session);
                    bl = false;
                    this.nC.cmn().addAndGet(((DataChangeNotification)object).getMonitoredItems().length);
                    this.updateDiagnostics();
                }
                this.logger.debug("getNextNotificationMessage: eventNotification.getEvents().length={}", (Object)((EventNotificationList)abstractStructure).getEvents().length);
                if (((EventNotificationList)abstractStructure).getEvents().length > 0) {
                    list = this.a(list, (NotificationData)abstractStructure, session);
                    bl = false;
                }
            }
        }
        object = DateTime.currentTime();
        if (list != null) {
            this.nC.cmC().addAndGet(list.size());
        }
        abstractStructure = new NotificationMessage(this.getNextSequenceNumber(bl), (DateTime)object, list == null ? null : list.toArray(new ExtensionObject[list.size()]));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getNextNotificationMessage: isKeepaliveMessage=" + bl);
        }
        if (!bl) {
            this.a((NotificationMessage)abstractStructure);
        }
        this.nt.set((DateTime)object);
        this.nr.set((DateTime)object);
        if (this.hasMoreNotifications().booleanValue()) {
            this.addToPublishQueue(0L, false, false);
        }
        this.logger.debug("getNextNotificationMessage: notificationMessage={}", (Object)abstractStructure);
        this.nC.cmG().incrementAndGet();
        this.updateDiagnostics();
        return abstractStructure;
    }

    protected UnsignedInteger getNextSequenceNumber(boolean bl) {
        long l2 = bl ? this.nw.get() : this.nw.getAndIncrement();
        try {
            return UnsignedInteger.valueOf(l2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.nw.set(bl ? 1L : 2L);
            return UnsignedInteger.valueOf(1L);
        }
    }

    protected NotificationMessage getNotificationMessage(UnsignedInteger unsignedInteger) throws ServiceException {
        NotificationMessage notificationMessage = this.nA.get(unsignedInteger);
        if (notificationMessage == null) {
            throw new ServiceException(StatusCodes.Bad_MessageNotAvailable);
        }
        return notificationMessage;
    }

    protected BlockingQueue<SubscriptionBase> getPublishQueue() {
        return this.lI != null && this.lI.isActive() ? this.ny.get() : null;
    }

    protected void incrementOverflowCount() {
        this.getDiagnostics().cmA().incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalClose(boolean bl) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("internalClose: SubscriptionId=" + this.getSubscriptionId() + " removeFromQueue=" + bl);
        }
        this.publishingEnabled = false;
        BlockingQueue<SubscriptionBase> blockingQueue = this.ny.get();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("internalClose: PublishQueue: " + blockingQueue);
        }
        if (blockingQueue != null) {
            if (bl) {
                blockingQueue.remove(this);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("PublishQueue after remove: " + blockingQueue);
            }
            this.setPublishQueue(null, true);
        }
        this.stopPublishing();
        this.removeAllItems();
        if (this.lI != null) {
            this.lI.removeSubscription(this);
        }
        this.subscriptionManager.getSessionManager().removeListener(this.sessionManagerListener);
        Subscription subscription = this;
        synchronized (subscription) {
            this.nA.clear();
            this.lI = null;
            this.closed = true;
        }
    }

    protected void internalRemoveItem(MonitoredItem monitoredItem) throws ServiceException, StatusException {
        super.removeItem(monitoredItem.getMonitoredItemId());
        monitoredItem.close();
    }

    protected boolean isTimeToPublish(long l2) {
        int n2 = nm;
        long l3 = l2 - this.nu.get();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("isTimeToPublish: now-lastPublishCheckTime=" + l3 + " publishingInterval=" + this.publishingInterval);
        }
        return (double)l3 >= this.publishingInterval - (double)n2;
    }

    protected void monitoringModeChanged(MonitoredItem monitoredItem) {
        long l2 = 0L;
        for (MonitoredItemBase monitoredItemBase : this.items.values()) {
            if (MonitoringMode.Disabled != monitoredItemBase.getMonitoringMode()) continue;
            ++l2;
        }
        this.nC.cmp().set(l2);
        this.updateDiagnostics();
    }

    protected void needTrigger(MonitoredItem monitoredItem, boolean bl, boolean bl2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("needTrigger: triggering item monitoredItemId=" + monitoredItem.getMonitoredItemId() + " needDataChange=" + bl + " needEventChange=" + bl2);
        }
        for (MonitoredItem monitoredItem2 : monitoredItem.links) {
            this.nB.put(monitoredItem2.getMonitoredItemId(), monitoredItem2);
        }
        if (bl) {
            this.nn.set(true);
        }
        if (bl2) {
            this.no.set(true);
        }
        this.clZ();
    }

    protected void newEventAvailable(MonitoredEventItem monitoredEventItem) {
        this.logger.debug("newEventAvailable");
        this.no.set(true);
        this.clZ();
    }

    protected void newSampleAvailable(MonitoredItem monitoredItem) {
        this.logger.debug("newSampleAvailable: monitoredItemId={}", (Object)monitoredItem.getMonitoredItemId());
        this.nn.set(true);
        this.clZ();
    }

    @Override
    protected void paramChanged() throws ServiceException {
        this.logger.debug("paramChanged");
        if (this.isPublishingEnabled() && this.lI != null) {
            this.clZ();
            this.startPublishing();
            BlockingQueue<SubscriptionBase> blockingQueue = this.getPublishQueue();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("paramChanged: queue before=" + blockingQueue);
            }
            if (blockingQueue.contains(this)) {
                blockingQueue.remove(this);
                blockingQueue.offer(this);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("paramChanged: queue after=" + blockingQueue);
            }
        }
        this.nC.cmw().set(UnsignedInteger.valueOf(this.getLifetimeCount()));
        this.nC.cmv().set(UnsignedInteger.valueOf(this.getMaxKeepAliveCount()));
        this.nC.cmx().set(UnsignedInteger.valueOf(this.getMaxNotificationsPerPublish()));
        this.nC.cmD().set(UnsignedByte.valueOf(this.getPriority()));
        this.nC.cmF().set(this.getPublishingInterval());
        this.updateDiagnostics();
    }

    protected void resetKeepAliveCounter() {
        this.nq.set(0);
    }

    protected void resetLastAliveTime() {
        this.nr.set(DateTime.currentTime());
    }

    protected void setPublishQueue(BlockingQueue<SubscriptionBase> blockingQueue, boolean bl) {
        BlockingQueue<SubscriptionBase> blockingQueue2 = this.getPublishQueue();
        if (blockingQueue != blockingQueue2) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("setPublishQueue: " + blockingQueue);
            }
            if (blockingQueue != null && blockingQueue2 != null) {
                blockingQueue2.remove(this);
            }
            this.ny.set(blockingQueue);
            if (blockingQueue != null) {
                for (MonitoredItemBase monitoredItemBase : this.getItems()) {
                    if (!(monitoredItemBase instanceof MonitoredDataItem)) continue;
                    ((MonitoredDataItem)monitoredItemBase).startSampling(bl);
                }
            }
        }
    }

    protected void setSession(Session session) {
        if (session != this.lI) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("setSession: " + session);
            }
            if (this.lI != null) {
                this.lI.removeSubscription(this);
            }
            this.lI = session;
            if (session != null) {
                session.addSubscription(this);
            }
            this.start();
        }
    }

    protected synchronized void startPublishing() {
        long l2;
        if (this.nx == null) {
            this.nx = Executors.newScheduledThreadPool(1, StackUtils.newNamedThreadFactory("PublishExecutor-" + this.getSession().getSessionName() + "-Subscription" + this.getSubscriptionId()));
        }
        if (this.nz != null) {
            this.nz.cancel(false);
            this.logger.debug("startPublishing: canceled existing scheduled publish task");
        }
        if ((l2 = (long)this.getPublishingInterval()) <= 0L) {
            l2 = 10L;
        }
        this.nz = this.nx.scheduleAtFixedRate(new PublishTask(), l2, l2, TimeUnit.MILLISECONDS);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("startPublishing: publishExecutor scheduled, interval=" + this.getPublishingInterval());
        }
    }

    protected synchronized void stopPublishing() {
        if (this.nx != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("stopPublishing: publishExecutor.shutdown()");
            }
            this.nx.shutdown();
            this.nx = null;
        }
    }

    protected void updateDiagnostics() {
        SubscriptionManager subscriptionManager = this.getSubscriptionManager();
        if (subscriptionManager != null) {
            subscriptionManager.getSessionManager().getServer().getDiagnosticsManager().updateSubscription(this);
        }
    }

    public class PublishTask
    implements Runnable {
        @Override
        public void run() {
            this.cmk();
        }

        private void cmk() {
            Subscription.this.logger.debug("publishCheck: SubscriptionID={}", (Object)Subscription.this.getSubscriptionId());
            long l2 = Subscription.this.cmc();
            Subscription.this.logger.debug("now={}", (Object)l2);
            if (Subscription.this.isTimeToPublish(l2)) {
                Subscription.this.logger.debug("lastPublishCheckTime(was)={}", (Object)Subscription.this.nu);
                if (Subscription.this.hasMoreNotifications().booleanValue()) {
                    Subscription.this.addToPublishQueue(l2, false, true);
                } else {
                    this.incKeepAliveCounter(l2);
                    if (Subscription.this.nD) {
                        Subscription.this.addToPublishQueue(l2, false, true);
                    }
                }
                if (Subscription.this.hasExpired()) {
                    try {
                        Subscription.this.logger.info("Subscription timeout: SubscriptionId=" + Subscription.this.getSubscriptionId() + " Session=" + Subscription.this.getSession());
                        Subscription.this.addToPublishQueue(l2, true, false);
                        Subscription.this.close();
                    }
                    catch (ServiceException serviceException) {
                        Subscription.this.logger.warn("While removing expired subscription " + Subscription.this.getSubscriptionId() + " of session " + Subscription.this.getSession(), serviceException);
                    }
                }
            }
            Subscription.this.updateDiagnostics();
        }

        protected void incKeepAliveCounter(long l2) {
            Subscription.this.logger.debug("incKeepAliveCounter: SubscriptionId={} Count={} Max=", Subscription.this.getSubscriptionId(), Subscription.this.nq.get(), Subscription.this.getMaxKeepAliveCount());
            if ((long)Subscription.this.nq.incrementAndGet() >= Subscription.this.getMaxKeepAliveCount()) {
                Subscription.this.nq.set(0);
                Subscription.this.nC.cml().set(0L);
                Subscription.this.addToPublishQueue(l2, true, false);
            } else {
                Subscription.this.nC.cml().incrementAndGet();
            }
        }
    }
}

