/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceHandler;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManager;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ActivateSessionRequest;
import com.prosysopc.ua.stack.core.ActivateSessionResponse;
import com.prosysopc.ua.stack.core.CancelRequest;
import com.prosysopc.ua.stack.core.CancelResponse;
import com.prosysopc.ua.stack.core.CloseSessionRequest;
import com.prosysopc.ua.stack.core.CloseSessionResponse;
import com.prosysopc.ua.stack.core.CreateSessionRequest;
import com.prosysopc.ua.stack.core.CreateSessionResponse;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.SignatureData;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.transport.endpoint.EndpointServiceRequest;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionServiceHandler
extends ServiceHandler {
    private static Logger logger = LoggerFactory.getLogger(SessionServiceHandler.class);
    int nl = 32;

    public SessionServiceHandler(SessionManager sessionManager) {
        super(sessionManager);
    }

    public int getMinServerNonceLength() {
        return this.nl;
    }

    public final void onActivateSession(EndpointServiceRequest<ActivateSessionRequest, ActivateSessionResponse> endpointServiceRequest) throws ServiceFaultException {
        ActivateSessionRequest activateSessionRequest = endpointServiceRequest.getRequest();
        ActivateSessionResponse activateSessionResponse = new ActivateSessionResponse();
        try {
            this.validateRequest(activateSessionRequest, endpointServiceRequest.getChannel());
            ExtensionObject extensionObject = activateSessionRequest.getUserIdentityToken();
            UserIdentityToken userIdentityToken = null;
            if (extensionObject != null) {
                try {
                    userIdentityToken = (UserIdentityToken)extensionObject.decode(this.getEncoderContext());
                }
                catch (DecodingException decodingException) {
                    throw new ServiceException(StatusCodes.Bad_IdentityTokenInvalid);
                }
            }
            if (userIdentityToken != null && (userIdentityToken.getPolicyId() == null || userIdentityToken.getPolicyId().isEmpty())) {
                userIdentityToken = null;
            }
            Session session = this.getSessionManager().activateSession(endpointServiceRequest.getChannel(), activateSessionRequest.getRequestHeader().getAuthenticationToken(), userIdentityToken, activateSessionRequest.getClientSignature(), activateSessionRequest.getClientSoftwareCertificates(), activateSessionRequest.getUserTokenSignature(), activateSessionRequest.getLocaleIds());
            activateSessionResponse.setServerNonce(session.getNewServerNonce(this.nl));
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(activateSessionResponse, serviceException);
        }
        this.validateResponse(activateSessionRequest, activateSessionResponse, null);
        endpointServiceRequest.sendResponse(activateSessionResponse, null);
    }

    public final void onCancel(EndpointServiceRequest<CancelRequest, CancelResponse> endpointServiceRequest) throws ServiceFaultException {
        CancelRequest cancelRequest = endpointServiceRequest.getRequest();
        CancelResponse cancelResponse = new CancelResponse();
        try {
            this.validateRequest(cancelRequest, endpointServiceRequest.getChannel());
            this.getSessionManager().cancelSession(cancelRequest.getRequestHeader().getAuthenticationToken());
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(cancelResponse, serviceException);
        }
        this.validateResponse(cancelRequest, cancelResponse, null);
        endpointServiceRequest.sendResponse(cancelResponse, null);
    }

    public final void onCloseSession(EndpointServiceRequest<CloseSessionRequest, CloseSessionResponse> endpointServiceRequest) throws ServiceFaultException {
        CloseSessionRequest closeSessionRequest = endpointServiceRequest.getRequest();
        CloseSessionResponse closeSessionResponse = new CloseSessionResponse();
        try {
            this.validateRequest(closeSessionRequest, endpointServiceRequest.getChannel());
            this.getSessionManager().closeSession(closeSessionRequest.getRequestHeader().getAuthenticationToken(), (boolean)closeSessionRequest.getDeleteSubscriptions());
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(closeSessionResponse, serviceException);
        }
        this.validateResponse(closeSessionRequest, closeSessionResponse, null);
        endpointServiceRequest.sendResponse(closeSessionResponse, null);
    }

    public final void onCreateSession(EndpointServiceRequest<CreateSessionRequest, CreateSessionResponse> endpointServiceRequest) throws ServiceFaultException {
        CreateSessionRequest createSessionRequest = endpointServiceRequest.getRequest();
        CreateSessionResponse createSessionResponse = new CreateSessionResponse();
        try {
            this.validateRequest(createSessionRequest, endpointServiceRequest.getChannel());
            Session session = this.getSessionManager().createSession(endpointServiceRequest.getChannel(), ByteString.asByteArray(createSessionRequest.getClientCertificate()), createSessionRequest.getClientDescription(), createSessionRequest.getMaxResponseMessageSize(), createSessionRequest.getRequestedSessionTimeout(), createSessionRequest.getSessionName(), endpointServiceRequest.getSecurityMode());
            createSessionResponse.setRevisedSessionTimeout(session.getSessionTimeout());
            createSessionResponse.setSessionId(session.getSessionId());
            createSessionResponse.setAuthenticationToken(session.getAuthenticationToken());
            createSessionResponse.setMaxRequestMessageSize(this.getSessionManager().getMaxRequestMessageSize());
            ApplicationIdentity applicationIdentity = this.getSessionManager().getServerIdentity();
            KeyPair keyPair = endpointServiceRequest.getChannel().getLocalCertificate();
            if (keyPair == null) {
                keyPair = applicationIdentity.getKeys();
            }
            createSessionResponse.setServerSignature(this.a(ByteString.asByteArray(createSessionRequest.getClientCertificate()), ByteString.asByteArray(createSessionRequest.getClientNonce()), endpointServiceRequest.getSecurityMode().getSecurityPolicy(), keyPair.getPrivateKey()));
            createSessionResponse.setServerCertificate(ByteString.valueOf(keyPair.getCertificate().getEncoded()));
            createSessionResponse.setServerSoftwareCertificates(applicationIdentity.getSoftwareCertificates());
            if (logger.isDebugEnabled()) {
                logger.debug("getEndpoints(): " + this.getSessionManager().getEndpoints());
            }
            createSessionResponse.setServerEndpoints(this.getSessionManager().getEndpoints());
            createSessionResponse.setServerNonce(session.getNewServerNonce(this.nl));
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(createSessionResponse, serviceException);
        }
        this.validateResponse(createSessionRequest, createSessionResponse, null);
        endpointServiceRequest.sendResponse(createSessionResponse, null);
    }

    public void setMinServerNonceLength(int n2) {
        this.nl = n2;
    }

    private SignatureData a(byte[] byArray, byte[] byArray2, SecurityPolicy securityPolicy, PrivKey privKey) throws ServiceException {
        if (byArray2 == null || byArray2.length == 0 ? securityPolicy != SecurityPolicy.NONE : byArray2.length < 32) {
            throw new ServiceException(StatusCodes.Bad_NonceInvalid);
        }
        if (byArray != null && byArray.length != 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new ServiceException(StatusCodes.Bad_SecurityChecksFailed);
            }
            catch (Exception exception) {
                throw new ServiceException(StatusCodes.Bad_NonceInvalid);
            }
            if (byArray2 != null && byArray2.length != 0) {
                try {
                    byteArrayOutputStream.write(byArray2);
                }
                catch (IOException iOException) {
                    throw new ServiceException(StatusCodes.Bad_NonceInvalid);
                }
                catch (Exception exception) {
                    throw new ServiceException(StatusCodes.Bad_NonceInvalid);
                }
            }
            try {
                return CryptoUtil.signAsymm(privKey.getPrivateKey(), securityPolicy.getAsymmetricSignatureAlgorithm(), byteArrayOutputStream.toByteArray());
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException.getStatusCode());
            }
        }
        return null;
    }

    @Override
    protected ServiceContext createServiceContext(RequestHeader requestHeader) throws ServiceException {
        return new ServiceContext(null, requestHeader);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

