/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.server.AbstractContinuationPoint;
import com.prosysopc.ua.server.BrowseContinuationPoint;
import com.prosysopc.ua.server.DiagnosticsManager;
import com.prosysopc.ua.server.HistoryContinuationPoint;
import com.prosysopc.ua.server.ServerUserIdentity;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.SessionDiagnostics;
import com.prosysopc.ua.server.SessionListener;
import com.prosysopc.ua.server.SessionManager;
import com.prosysopc.ua.server.SessionSecurityDiagnostics;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.IdType;
import com.prosysopc.ua.stack.core.PublishRequest;
import com.prosysopc.ua.stack.core.PublishResponse;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.ServerSecureChannel;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.tcp.nio.OpcTcpServerSecureChannel;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    public static final Session INTERNAL_SESSION = new Session();
    private static long lM = 10000L;
    static final Logger logger = LoggerFactory.getLogger(Session.class);
    private volatile boolean active = false;
    private volatile boolean closed = false;
    private final NodeId lN;
    private final Map<Long, BrowseContinuationPoint> lO = new ConcurrentSkipListMap<Long, BrowseContinuationPoint>();
    private volatile ServerSecureChannel lP;
    private final ApplicationIdentity lQ;
    private final SessionDiagnostics lR;
    private final SessionSecurityDiagnostics lS;
    private final Map<Long, HistoryContinuationPoint> lT = new ConcurrentSkipListMap<Long, HistoryContinuationPoint>();
    private volatile long lU = 0L;
    private volatile long lV;
    private final List<Locale> lW = new CopyOnWriteArrayList<Locale>();
    private volatile ByteString lX;
    private volatile SessionManager sessionManager;
    private volatile double lY;
    private final List<Subscription> gK = new CopyOnWriteArrayList<Subscription>();
    private final Queue<Subscription> lZ = new ConcurrentLinkedQueue<Subscription>();
    private ServerUserIdentity ma = null;
    protected List<SessionListener> listeners = new CopyOnWriteArrayList<SessionListener>();
    private final SecurityMode gs;

    public static long getActivationTimeout() {
        return lM;
    }

    public static void setActivationTimeout(long l2) {
        lM = l2;
    }

    private static NodeId ckO() {
        byte[] byArray = new byte[32];
        CryptoUtil.getRandom().nextBytes(byArray);
        return NodeId.get(IdType.Opaque, 0, ByteString.valueOf(byArray));
    }

    private Session() {
        this.sessionManager = null;
        this.lR = null;
        this.lS = null;
        this.lQ = null;
        this.lN = null;
        this.gs = SecurityMode.NONE;
        this.active = true;
    }

    protected Session(SessionManager sessionManager, ApplicationIdentity applicationIdentity, String string, SecurityMode securityMode) {
        this.gs = securityMode;
        this.sessionManager = sessionManager;
        UaServer.NodeManagerUaServer nodeManagerUaServer = sessionManager.getServer().getNodeManagerUaServer();
        NodeId nodeId = NodeId.randomGUID(nodeManagerUaServer.getNamespaceIndex());
        if (string == null) {
            string = "ServerAssigned " + nodeId;
        }
        String string2 = null;
        DateTime dateTime = DateTime.currentTime();
        String string3 = null;
        String[] stringArray = null;
        DateTime dateTime2 = dateTime;
        Double d2 = null;
        UnsignedInteger unsignedInteger = null;
        this.lR = new SessionDiagnostics(nodeId, string, applicationIdentity.getApplicationDescription(), string2, string3, stringArray, d2, unsignedInteger, dateTime, dateTime2);
        Cert cert = applicationIdentity.getCertificate();
        ByteString byteString = cert != null ? ByteString.valueOf(cert.getEncoded()) : null;
        String string4 = null;
        String[] stringArray2 = new String[]{};
        String string5 = null;
        String string6 = null;
        String string7 = null;
        this.lS = new SessionSecurityDiagnostics(nodeId, string4, stringArray2, string5, string6, string7, securityMode.getMessageSecurityMode(), securityMode.getSecurityPolicy().getPolicyUri(), byteString);
        this.lQ = applicationIdentity;
        this.lN = Session.ckO();
        this.lV = System.currentTimeMillis();
    }

    public void addSessionListener(SessionListener sessionListener) {
        if (!this.listeners.contains(sessionListener)) {
            this.listeners.add(sessionListener);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Session session = (Session)object;
        if (this.lN == null ? session.lN != null : !this.lN.equals(session.lN)) {
            return false;
        }
        return !(this.getSessionId() == null ? session.getSessionId() != null : !this.getSessionId().equals(session.getSessionId()));
    }

    public NodeId getAuthenticationToken() {
        return this.lN;
    }

    public ServerSecureChannel getChannel() {
        return this.lP;
    }

    public ApplicationIdentity getClientIdentity() {
        return this.lQ;
    }

    public DateTime getClientLastContactTime() {
        return this.lR.clc().get();
    }

    public Locale getDefaultLocale() {
        if (this.lW == null || this.lW.isEmpty()) {
            return Locale.ENGLISH;
        }
        return this.lW.get(0);
    }

    public List<Locale> getLocales() {
        return Collections.unmodifiableList(this.lW);
    }

    public UnsignedInteger getMaxResponseMessageSize() {
        return this.lR.clq().get();
    }

    public SecurityMode getSecurityMode() {
        return this.gs;
    }

    public SessionDiagnostics getSessionDiagnostics() {
        return this.lR;
    }

    public NodeId getSessionId() {
        return this.lR == null ? null : this.lR.getSessionId();
    }

    public String getSessionName() {
        return this.lR == null ? "INTERNAL_SESSION" : this.lR.clA().get();
    }

    public SessionSecurityDiagnostics getSessionSecurityDiagnostics() {
        return this.lS;
    }

    public double getSessionTimeout() {
        return this.lY;
    }

    public int getSubscriptionCount() {
        return this.gK.size();
    }

    public ServerUserIdentity getUserIdentity() {
        return this.ma;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.lN == null ? 0 : this.lN.hashCode());
        n3 = 31 * n3;
        if (this.lR != null) {
            n3 += this.getSessionId().hashCode();
        }
        return n3;
    }

    public boolean hasLocale(Locale locale) {
        return this.lW.contains(locale);
    }

    public boolean hasSessionListener(SessionListener sessionListener) {
        return this.listeners.contains(sessionListener);
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isTimeout() {
        long l2 = System.currentTimeMillis() - this.lV;
        double d2 = this.isActive() ? this.lY : (double)lM;
        logger.trace("isTimeout: timeout={} delay={}", (Object)d2, (Object)l2);
        return (double)l2 > d2;
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.listeners.remove(sessionListener);
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s (ID=%s Token=%s Channel=(%s))", this.getSessionName(), this.getSessionId(), this.getAuthenticationToken(), this.getChannel());
    }

    private Long c(ByteString byteString) throws StatusException {
        Long l2;
        if (byteString == null) {
            throw new StatusException("null", StatusCodes.Bad_ContinuationPointInvalid);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteString.getValue());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            l2 = dataInputStream.readLong();
        }
        catch (IOException iOException) {
            throw new StatusException("Too short array: " + byteString, StatusCodes.Bad_ContinuationPointInvalid);
        }
        return l2;
    }

    private void ckP() {
        for (SessionListener sessionListener : this.listeners) {
            try {
                sessionListener.onSessionActivated(this);
            }
            catch (Exception exception) {
                logger.warn("Exception in SessionListener, onSessionActivated:", exception);
            }
        }
    }

    private void ckQ() {
        for (SessionListener sessionListener : this.listeners) {
            try {
                sessionListener.onSessionChanged(this);
            }
            catch (Exception exception) {
                logger.warn("Exception in SessionListener, onSessionChanged:", exception);
            }
        }
    }

    private void ckR() {
        for (SessionListener sessionListener : this.listeners) {
            try {
                sessionListener.onSessionClosed(this);
            }
            catch (Exception exception) {
                logger.warn("Exception in SessionListener, onSessionClosed:", exception);
            }
        }
    }

    private AbstractContinuationPoint a(ByteString byteString, Map<Long, ? extends AbstractContinuationPoint> map) throws StatusException {
        Long l2 = this.c(byteString);
        AbstractContinuationPoint abstractContinuationPoint = map.remove(l2);
        logger.debug("getContinuationPoint: i={} result={}", (Object)l2, (Object)abstractContinuationPoint);
        if (abstractContinuationPoint == null) {
            throw new StatusException("Not found: " + byteString, StatusCodes.Bad_ContinuationPointInvalid);
        }
        return abstractContinuationPoint;
    }

    private DiagnosticsManager getDiagnosticsManager() {
        SessionManager sessionManager = this.getSessionManager();
        return sessionManager == null ? null : sessionManager.getServer().getDiagnosticsManager();
    }

    private boolean isDiagnosticsEnabled() {
        DiagnosticsManager diagnosticsManager = this.getDiagnosticsManager();
        return diagnosticsManager == null ? false : diagnosticsManager.isEnabled();
    }

    private ByteString a(Long l2) throws StatusException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(l2);
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new StatusException("Cannot create long");
        }
        return ByteString.valueOf(byteArrayOutputStream.toByteArray());
    }

    private synchronized long ckS() {
        return ++this.lU;
    }

    private void a(ServiceContext serviceContext, Map<Long, ? extends AbstractContinuationPoint> map, int n2) throws StatusException {
        if (n2 == 0) {
            return;
        }
        Iterator<? extends AbstractContinuationPoint> iterator = map.values().iterator();
        try {
            while (map.size() >= n2) {
                AbstractContinuationPoint abstractContinuationPoint = iterator.next();
                if (abstractContinuationPoint.getServiceContext().equals(serviceContext)) continue;
                iterator.remove();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new StatusException(StatusCodes.Bad_NoContinuationPoints);
        }
    }

    protected void activate(ServerUserIdentity serverUserIdentity) {
        this.ma = serverUserIdentity;
        this.active = true;
        logger.debug("ServerUserIdentity: {}", (Object)serverUserIdentity);
        if (serverUserIdentity != null) {
            this.lS.clS().set(serverUserIdentity.getType().name());
            if (serverUserIdentity.getName() != null && serverUserIdentity.getName().length() > 0) {
                this.lS.clT().add(serverUserIdentity.getName());
            }
            this.lS.clU().set(serverUserIdentity.getName());
        }
        this.ckP();
    }

    protected ByteString addBrowseContinuationPoint(BrowseContinuationPoint browseContinuationPoint) throws StatusException {
        SessionManager sessionManager = this.getSessionManager();
        if (sessionManager == null) {
            throw new StatusException(StatusCodes.Bad_SessionClosed);
        }
        this.a(browseContinuationPoint.getServiceContext(), this.lO, sessionManager.getMaxBrowseContinuationPoints());
        Long l2 = this.ckS();
        logger.debug("addContinuationPoint: i={}", (Object)l2);
        this.lO.put(l2, browseContinuationPoint);
        this.ckQ();
        return this.a(l2);
    }

    protected ByteString addHistoryContinuationPoint(HistoryContinuationPoint historyContinuationPoint) throws StatusException {
        SessionManager sessionManager = this.getSessionManager();
        if (sessionManager == null) {
            throw new StatusException(StatusCodes.Bad_SessionClosed);
        }
        this.a(historyContinuationPoint.getServiceContext(), this.lT, sessionManager.getMaxHistoryContinuationPoints());
        long l2 = this.ckS();
        this.lT.put(l2, historyContinuationPoint);
        this.ckQ();
        return this.a(l2);
    }

    protected void addSubscription(Subscription subscription) {
        this.gK.add(subscription);
        this.ckQ();
    }

    protected void cancel() {
    }

    protected void close(boolean bl) {
        logger.debug("close");
        this.ckR();
        this.listeners.clear();
        this.active = false;
        this.sessionManager = null;
        this.closed = true;
        this.lO.clear();
        this.lT.clear();
        ServerSecureChannel serverSecureChannel = this.getChannel();
        if (serverSecureChannel instanceof OpcTcpServerSecureChannel) {
            OpcTcpServerSecureChannel opcTcpServerSecureChannel = (OpcTcpServerSecureChannel)serverSecureChannel;
            opcTcpServerSecureChannel.getConnection().setActiveSession(false);
        }
    }

    protected void deactivate() {
        this.active = false;
        this.ckQ();
    }

    protected BrowseContinuationPoint getBrowseContinuationPoint(ByteString byteString) throws StatusException {
        return (BrowseContinuationPoint)this.a(byteString, this.lO);
    }

    protected QualifiedName getDefaultEncoding() {
        return QualifiedName.DEFAULT_BINARY_ENCODING;
    }

    protected HistoryContinuationPoint getHistoryContinuationPoint(ByteString byteString) throws StatusException {
        return (HistoryContinuationPoint)this.a(byteString, this.lT);
    }

    protected ByteString getNewServerNonce(int n2) {
        this.lX = CryptoUtil.createNonce(n2);
        this.ckQ();
        return this.lX;
    }

    protected ByteString getServerNonce() {
        return this.lX;
    }

    protected SessionManager getSessionManager() {
        return this.sessionManager;
    }

    protected Queue<Subscription> getTransferredSubscriptions() {
        return this.lZ;
    }

    protected void removeSubscription(Subscription subscription) {
        this.gK.remove(subscription);
    }

    protected void resetDiagnostics() {
        this.lR.clK();
        this.ckQ();
    }

    protected void setChannel(ServerSecureChannel serverSecureChannel) {
        Object object;
        ServerSecureChannel serverSecureChannel2 = this.lP;
        if (serverSecureChannel2 != null && serverSecureChannel2 instanceof OpcTcpServerSecureChannel) {
            object = (OpcTcpServerSecureChannel)serverSecureChannel2;
            ((OpcTcpServerSecureChannel)object).getConnection().setActiveSession(false);
        }
        this.lP = serverSecureChannel;
        logger.trace("setChannel: serverSecureChannel=" + (serverSecureChannel == null ? "null" : serverSecureChannel));
        if (serverSecureChannel != null) {
            object = serverSecureChannel.getEndpoint().getEndpointUrl();
            this.lR.clm().set((String)object);
            this.lS.clV().set("UA Binary");
            this.lS.clY().set(UriUtil.getTransportProtocol((String)object).toLowerCase(Locale.ROOT));
            this.lS.clW().set(serverSecureChannel.getMessageSecurityMode());
            this.lS.clX().set(serverSecureChannel.getSecurityPolicy().getPolicyUri());
        }
        this.ckQ();
    }

    protected void setLocaleIds(String[] stringArray) {
        if (stringArray != null) {
            this.lW.clear();
            for (String string : stringArray) {
                this.lW.add(LocalizedText.toLocale(string));
            }
        }
        this.lR.clp().set(stringArray);
        this.ckQ();
    }

    protected void setMaxResponseMessageSize(UnsignedInteger unsignedInteger) {
        this.lR.clq().set(unsignedInteger);
        this.ckQ();
    }

    protected void setSessionName(String string) {
        this.lR.clA().set(string);
        this.ckQ();
    }

    protected void setSessionTimeout(double d2) {
        logger.debug("setSessionTimeout: {}", (Object)d2);
        this.lY = d2;
        this.lR.ckU().set(this.lY);
        this.ckQ();
    }

    protected void updateDiagnostics() {
        SessionManager sessionManager = this.getSessionManager();
        if (sessionManager != null) {
            sessionManager.getServer().getDiagnosticsManager().updateSession(this);
        }
    }

    List<Subscription> ckT() {
        return this.gK;
    }

    void a(ServiceRequest serviceRequest) {
        this.lV = System.currentTimeMillis();
        if (this.isDiagnosticsEnabled()) {
            this.lR.clc().set(DateTime.currentTime());
            String string = serviceRequest.getClass().getName().replace("Request", "").replaceAll(".*[.]", "");
            SessionDiagnostics.ServiceCounter serviceCounter = this.lR.t(string);
            if (serviceCounter != null) {
                serviceCounter.clO();
            }
            this.lR.clE().clO();
            if (serviceRequest instanceof PublishRequest) {
                this.lR.clg().incrementAndGet();
            }
            this.updateDiagnostics();
        }
        this.ckQ();
    }

    void a(ServiceResponse serviceResponse) {
        if (this.isDiagnosticsEnabled()) {
            StatusCode statusCode = serviceResponse.getResponseHeader().getServiceResult();
            if (statusCode.isBad()) {
                String string = serviceResponse.getClass().getName().replace("Response", "").replaceAll(".*[.]", "");
                SessionDiagnostics.ServiceCounter serviceCounter = this.lR.t(string);
                if (serviceCounter != null) {
                    serviceCounter.clN();
                }
                this.lR.clE().clN();
                if (statusCode.getValue().equals(StatusCodes.Bad_UserAccessDenied)) {
                    this.lR.clH().incrementAndGet();
                }
            }
            if (serviceResponse instanceof PublishResponse) {
                this.lR.clg().decrementAndGet();
            }
            this.updateDiagnostics();
            this.ckQ();
        }
    }
}

