/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.RequestHeader;

public class ServiceContext {
    public static final ServiceContext INTERNAL_OPERATION_CONTEXT = new ServiceContext(Session.INTERNAL_SESSION, null);
    final RequestHeader lH;
    final Session lI;

    public ServiceContext(Session session, RequestHeader requestHeader) {
        this.lI = session;
        this.lH = requestHeader;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ServiceContext)) {
            return false;
        }
        ServiceContext serviceContext = (ServiceContext)object;
        if (this.lH == null) {
            return serviceContext.lH == null;
        }
        if (serviceContext.lH == null) {
            return false;
        }
        if (this.lH.getRequestHandle() != null && this.lH.getRequestHandle().getValue() != 0L) {
            return this.lH.getRequestHandle().equals(serviceContext.lH.getRequestHandle());
        }
        if (this.lH.getRequestHandle() != null && this.lH.getTimestamp() != null) {
            return this.lH.getTimestamp().equals(serviceContext.lH.getTimestamp());
        }
        return false;
    }

    public String getAuditEntryId() {
        return this.lH.getAuditEntryId();
    }

    public UnsignedInteger getReturnDiagnostics() {
        return this.lH.getReturnDiagnostics();
    }

    public Session getSession() {
        return this.lI;
    }

    public UnsignedInteger getTimeoutHint() {
        return this.lH.getTimeoutHint();
    }

    public DateTime getTimestamp() {
        return this.lH.getTimestamp();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.lH == null ? 0 : this.lH.hashCode());
        n3 = 31 * n3 + (this.lI == null ? 0 : this.lI.hashCode());
        return n3;
    }

    public boolean isInternal() {
        return this.equals(INTERNAL_OPERATION_CONTEXT);
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() > this.getTimestamp().getTimeInMillis() + this.getTimeoutHint().getValue();
    }
}

