/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.server.ReverseConnectionParameters;
import com.prosysopc.ua.stack.common.ServiceResultException;
import java.util.Objects;

public final class ReverseConnectionStatus {
    private final boolean lo;
    private final ServiceResultException lp;
    private final int lq;
    private final ReverseConnectionParameters lr;

    public static Builder builder() {
        return new Builder();
    }

    private ReverseConnectionStatus(boolean bl, int n2, ReverseConnectionParameters reverseConnectionParameters, ServiceResultException serviceResultException) {
        this.lo = bl;
        this.lq = n2;
        this.lr = reverseConnectionParameters;
        this.lp = serviceResultException;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReverseConnectionStatus)) {
            return false;
        }
        ReverseConnectionStatus reverseConnectionStatus = (ReverseConnectionStatus)object;
        return Objects.equals(this.lp, reverseConnectionStatus.lp) && this.lq == reverseConnectionStatus.lq && this.lo == reverseConnectionStatus.lo && Objects.equals(this.lr, reverseConnectionStatus.lr);
    }

    public ServiceResultException getCloseError() {
        return this.lp;
    }

    public int getCurrentRetryCount() {
        return this.lq;
    }

    public ReverseConnectionParameters getParameters() {
        return this.lr;
    }

    public int hashCode() {
        return Objects.hash(this.lp, this.lq, this.lo, this.lr);
    }

    public boolean isConnected() {
        return this.lo;
    }

    public Builder toBuilder() {
        Builder builder = ReverseConnectionStatus.builder();
        builder.setParameters(this.lr);
        builder.setConnected(this.lo);
        builder.setCurrentRetryCount(this.lq);
        return builder;
    }

    public String toString() {
        return "ReverseConnectionStatus [isConnected=" + this.lo + ", currentRetryCount=" + this.lq + ", parameters=" + this.lr + ", closeError=" + this.lp + "]";
    }

    public static class Builder {
        private boolean lo;
        private int lq;
        private ReverseConnectionParameters lr;
        private ServiceResultException lp;

        private Builder() {
        }

        public ReverseConnectionStatus build() {
            return new ReverseConnectionStatus(this.lo, this.lq, this.lr, this.lp);
        }

        public ServiceResultException getCloseError() {
            return this.lp;
        }

        public int getCurrentRetryCount() {
            return this.lq;
        }

        public ReverseConnectionParameters getParameters() {
            return this.lr;
        }

        public boolean isConnected() {
            return this.lo;
        }

        public void setCloseError(ServiceResultException serviceResultException) {
            this.lp = serviceResultException;
        }

        public Builder setConnected(boolean bl) {
            this.lo = bl;
            return this;
        }

        public Builder setCurrentRetryCount(int n2) {
            this.lq = n2;
            return this;
        }

        public Builder setParameters(ReverseConnectionParameters reverseConnectionParameters) {
            this.lr = reverseConnectionParameters;
            return this;
        }
    }
}

