/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.server.ReverseConnectionStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ReverseConnectionParameters {
    private final String li;
    private final String lj;
    private final Function<List<String>, String> lk;
    private final List<Integer> ll;
    private final Executor lm;
    private final Consumer<ReverseConnectionStatus> ln;

    public static Builder builder() {
        return new Builder();
    }

    public static ReverseConnectionParameters from(String string, String string2) {
        Builder builder = ReverseConnectionParameters.builder();
        builder.setClientServerEndpointUrl(string);
        builder.setEndpointUrlForClientConnection(string2);
        return builder.build();
    }

    private ReverseConnectionParameters(String string, String string2, List<Integer> list, Executor executor, Consumer<ReverseConnectionStatus> consumer, Function<List<String>, String> function) {
        this.li = string;
        this.lj = string2;
        this.ll = Collections.unmodifiableList(new ArrayList<Integer>(list));
        this.lm = executor;
        this.ln = consumer;
        this.lk = function;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReverseConnectionParameters)) {
            return false;
        }
        ReverseConnectionParameters reverseConnectionParameters = (ReverseConnectionParameters)object;
        return Objects.equals(this.li, reverseConnectionParameters.li);
    }

    public String getClientServerEndpointUrl() {
        return this.li;
    }

    public String getEndpointUrlForClientConnection() {
        return this.lj;
    }

    public Function<List<String>, String> getEndpointUrlForClientConnectionSelector() {
        return this.lk;
    }

    public List<Integer> getRetryWaitIntervals() {
        return this.ll;
    }

    public int hashCode() {
        return Objects.hash(this.li);
    }

    public void internalFireStatusNotification(ReverseConnectionStatus reverseConnectionStatus) {
        if (this.lm == null || this.ln == null) {
            return;
        }
        try {
            this.lm.execute(() -> this.ln.accept(reverseConnectionStatus));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public Builder toBuilder() {
        Builder builder = ReverseConnectionParameters.builder();
        builder.setClientServerEndpointUrl(this.li);
        builder.setEndpointUrlForClientConnection(this.lj);
        builder.setStatusListener(this.lm, this.ln);
        builder.setEndpointUrlForClientConnectionSelector(this.lk);
        return builder;
    }

    public String toString() {
        return "ReverseConnectionParameters [clientServerEndpointUrl=" + this.li + ", endpointUrlForClientConnection=" + this.lj + ", retryWaitIntervals=" + this.ll + "]";
    }

    public static class Builder {
        private String li;
        private String lj;
        private final List<Integer> ll;
        private Executor lm;
        private Consumer<ReverseConnectionStatus> ln;
        private Function<List<String>, String> lk = list -> (String)list.get(0);

        private Builder() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(100);
            arrayList.add(500);
            arrayList.add(1000);
            this.ll = arrayList;
        }

        public ReverseConnectionParameters build() {
            return new ReverseConnectionParameters(this.li, this.lj, this.ll, this.lm, this.ln, this.lk);
        }

        public String getClientServerEndpointUrl() {
            return this.li;
        }

        public String getEndpointUrlForClientConnection() {
            return this.lj;
        }

        public Function<List<String>, String> getEndpointUrlForClientConnectionSelector() {
            return this.lk;
        }

        public List<Integer> getRetryWaitIntervals() {
            return this.ll;
        }

        public Builder setClientServerEndpointUrl(String string) {
            this.li = string;
            return this;
        }

        public Builder setEndpointUrlForClientConnection(String string) {
            this.lj = string;
            return this;
        }

        public void setEndpointUrlForClientConnectionSelector(Function<List<String>, String> function) {
            InternalArguments.checkNotNull(function, "endpointUrlForClientConnectionSelector");
            this.lk = function;
        }

        public Builder setStatusListener(Executor executor, Consumer<ReverseConnectionStatus> consumer) {
            this.lm = executor;
            this.ln = consumer;
            return this;
        }
    }
}

