/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.AccessLevels;
import com.prosysopc.ua.DataTypeConverter;
import com.prosysopc.ua.ModelException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaObjectType;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.nodes.UaVariableType;
import com.prosysopc.ua.server.EventManagerRoot;
import com.prosysopc.ua.server.GeneralModelChangeEvent;
import com.prosysopc.ua.server.ModelChangeType;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.SemanticChangeEvent;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.io.IoManagerListener;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.types.opcua.FolderType;
import com.prosysopc.ua.types.opcua.server.GeneralModelChangeEventTypeNode;
import com.prosysopc.ua.types.opcua.server.SemanticChangeEventTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerInformationModel;
import com.prosysopc.ua.types.opcua.server.ServerTypeNode;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class NodeManagerRoot
extends NodeManagerUaNode {
    private static Logger logger = LoggerFactory.getLogger(NodeManagerRoot.class);
    private final IoManagerListener jJ = new IoManagerListener(){

        @Override
        public AccessLevelType onGetUserAccessLevel(ServiceContext serviceContext, NodeId nodeId, UaVariable uaVariable) {
            if (Identifiers.Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray.equals(uaVariable.getNodeId())) {
                return NodeManagerRoot.this.getAccessLevelForSecurityDiagnostics(serviceContext);
            }
            return null;
        }

        @Override
        public Boolean onGetUserExecutable(ServiceContext serviceContext, NodeId nodeId, UaMethod uaMethod) {
            return null;
        }

        @Override
        public AttributeWriteMask onGetUserWriteMask(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode) {
            return null;
        }

        @Override
        public boolean onReadNonValue(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
            return false;
        }

        @Override
        public boolean onReadValue(ServiceContext serviceContext, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
            if (uaValueNode == null) {
                return false;
            }
            UaReference uaReference = uaValueNode.getReference(Identifiers.HasComponent, true);
            if (uaReference == null) {
                return false;
            }
            UaNode uaNode = uaValueNode.getReference(Identifiers.HasComponent, true).getSourceNode();
            if (!NodeManagerRoot.this.getServer().getDiagnosticsManager().isEnabled() && (NodeManagerRoot.this.jO.contains(uaValueNode.getNodeId()) || NodeManagerRoot.this.jO.contains(uaNode.getNodeId()))) {
                throw new StatusException(StatusCodes.Bad_NotReadable);
            }
            return false;
        }

        @Override
        public boolean onWriteNonValue(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
            return false;
        }

        @Override
        public boolean onWriteValue(ServiceContext serviceContext, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, DataValue dataValue) throws StatusException {
            return false;
        }
    };
    private final AtomicInteger jK = new AtomicInteger(0);
    private final AtomicReference<GeneralModelChangeEvent> jL = new AtomicReference<Object>(null);
    private final AtomicInteger jM = new AtomicInteger(0);
    private final AtomicReference<SemanticChangeEvent> jN = new AtomicReference<Object>(null);
    private final Set<NodeId> jO = new HashSet<NodeId>();
    private ScheduledFuture<?> jP;

    public NodeManagerRoot(UaServer uaServer) {
        super(uaServer, "http://opcfoundation.org/UA/");
        this.jO.add(Identifiers.Server_ServerDiagnostics_SubscriptionDiagnosticsArray);
        this.jO.add(Identifiers.Server_ServerDiagnostics_ServerDiagnosticsSummary);
        this.jO.add(Identifiers.Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray);
        this.jO.add(Identifiers.Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray);
        this.getIoManager().addListeners(this.jJ);
        this.setEventManager(new EventManagerRoot(this));
    }

    public void addModelChange(NodeId nodeId, NodeId nodeId2, ModelChangeType ... modelChangeTypeArray) {
        GeneralModelChangeEvent generalModelChangeEvent = this.jL.get();
        if (generalModelChangeEvent != null) {
            generalModelChangeEvent.addChange(nodeId, nodeId2, modelChangeTypeArray);
        }
    }

    public void addModelChange(UaNode uaNode, ModelChangeType ... modelChangeTypeArray) {
        GeneralModelChangeEvent generalModelChangeEvent = this.jL.get();
        if (generalModelChangeEvent != null && uaNode.getNodeVersionNode() != null) {
            generalModelChangeEvent.addChange(uaNode, modelChangeTypeArray);
        }
    }

    public void addSemanticChange(UaNode uaNode) {
        SemanticChangeEvent semanticChangeEvent = this.jN.get();
        if (semanticChangeEvent != null) {
            semanticChangeEvent.addChange(uaNode);
        }
    }

    public void beginModelChange() {
        this.jK.incrementAndGet();
        GeneralModelChangeEvent generalModelChangeEvent = this.jL.get();
        if (generalModelChangeEvent == null) {
            GeneralModelChangeEvent generalModelChangeEvent2 = new GeneralModelChangeEvent(this.getNamespaceTable());
            this.jL.compareAndSet(null, generalModelChangeEvent2);
        }
    }

    public void beginSemanticChange() {
        this.jM.incrementAndGet();
        SemanticChangeEvent semanticChangeEvent = this.jN.get();
        if (semanticChangeEvent == null) {
            SemanticChangeEvent semanticChangeEvent2 = new SemanticChangeEvent(this.getNamespaceTable());
            this.jN.compareAndSet(null, semanticChangeEvent2);
        }
    }

    public void endModelChange() {
        int n2 = this.jK.decrementAndGet();
        if (n2 == 0) {
            this.a(null);
        } else if (n2 < 0) {
            throw new RuntimeException("endModelChange() called more times than beginModelChange()");
        }
    }

    public ByteString endSemanticChange() {
        int n2 = this.jM.decrementAndGet();
        if (n2 == 0) {
            return this.b(null);
        }
        if (n2 < 0) {
            throw new RuntimeException("endSemanticChange() called more times than beginModelChange()");
        }
        return null;
    }

    public DataTypeConverter getDataTypeConverter() {
        return this.getNodeManagerTable().getDataTypeConverter();
    }

    public FolderType getDataTypesFolder() {
        return this.i(Identifiers.DataTypesFolder);
    }

    public FolderType getEventTypesFolder() {
        return this.i(Identifiers.EventTypesFolder);
    }

    public GeneralModelChangeEvent getModelChangeEvent() {
        return this.jL.get();
    }

    @Override
    public int getNamespaceIndex() {
        return 0;
    }

    public FolderType getObjectsFolder() {
        return this.i(Identifiers.ObjectsFolder);
    }

    public FolderType getObjectTypesFolder() {
        return this.i(Identifiers.ObjectTypesFolder);
    }

    public FolderType getReferenceTypesFolder() {
        return this.i(Identifiers.ReferenceTypesFolder);
    }

    public FolderType getRoot() {
        return this.i(Identifiers.RootFolder);
    }

    public SemanticChangeEvent getSemanticChangeEvent() {
        return this.jN.get();
    }

    public ServerTypeNode getServerData() {
        try {
            return (ServerTypeNode)this.getNode(Identifiers.Server);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    public FolderType getTypesFolder() {
        return this.i(Identifiers.TypesFolder);
    }

    public FolderType getVariableTypesFolder() {
        return this.i(Identifiers.VariableTypesFolder);
    }

    public FolderType getViewsFolder() {
        return this.i(Identifiers.ViewsFolder);
    }

    private FolderType i(NodeId nodeId) {
        try {
            return (FolderType)this.getNode(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    private void ckg() throws SAXException, IOException, ModelException {
        try {
            URL uRL = ServerInformationModel.class.getResource("Opc.Ua.NodeSet2.xml");
            if (uRL == null) {
                throw new RuntimeException("Cannot find Opc.Ua.NodeSet2.xml, cannot continue");
            }
            this.getNodeManagerTable().loadModel(uRL.toURI(), null, true);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    private void a(NodeId nodeId, int n2, int n3) {
        try {
            Object object;
            UaNode uaNode = this.getNode(nodeId);
            if (uaNode instanceof UaVariable) {
                object = ((UaVariable)uaNode).getValueRank();
                if (object == null || n2 == (Integer)object) {
                    ((UaVariable)uaNode).setValueRank(n3);
                }
            } else if (uaNode instanceof UaVariableType && ((object = ((UaVariableType)uaNode).getValueRank()) == null || n2 == (Integer)object)) {
                ((UaVariableType)uaNode).setValueRank(n3);
            }
            for (UaNode uaNode2 : uaNode.getComponents()) {
                this.a(uaNode2.getNodeId(), n2, n3);
            }
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    private void ckh() {
        this.a(Identifiers.ServerStatusType, -2, -1);
        this.a(Identifiers.Server_ServerStatus, -2, -1);
        this.a(Identifiers.SessionSecurityDiagnosticsType, -2, -1);
        this.a(Identifiers.SessionDiagnosticsVariableType, -2, -1);
        this.a(Identifiers.SubscriptionDiagnosticsType, -2, -1);
        this.a(Identifiers.SessionDiagnosticsObjectType, -2, -1);
        this.a(Identifiers.Server_ServerDiagnostics_ServerDiagnosticsSummary, -2, -1);
        this.a(Identifiers.ServerDiagnosticsSummaryType, -2, -1);
        this.getServerData().afterCreate();
    }

    private synchronized void cki() {
        if (this.jP == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        NodeManagerRoot.this.getServerData().getServerStatusNode().setCurrentTime(new DateTime());
                    }
                    catch (Exception exception) {
                        logger.error("Could not update CurrentTime node", exception);
                    }
                }
            };
            this.jP = this.getServer().getExecutor().scheduleWithFixedDelay(runnable, 0L, 1L, TimeUnit.SECONDS);
        }
    }

    private synchronized void ckj() {
        if (this.jP != null) {
            this.jP.cancel(false);
            this.jP = null;
        }
    }

    private ByteString a(ByteString byteString) {
        GeneralModelChangeEvent generalModelChangeEvent = this.jL.get();
        if (!generalModelChangeEvent.hasChanges()) {
            return null;
        }
        generalModelChangeEvent = this.jL.getAndSet(null);
        generalModelChangeEvent.updateNodeVersions();
        GeneralModelChangeEventTypeNode generalModelChangeEventTypeNode = this.createEvent(GeneralModelChangeEventTypeNode.class);
        generalModelChangeEventTypeNode.setChanges(generalModelChangeEvent.getChanges());
        return generalModelChangeEventTypeNode.triggerEvent(DateTime.currentTime(), null, byteString);
    }

    private ByteString b(ByteString byteString) {
        SemanticChangeEvent semanticChangeEvent = this.jN.getAndSet(null);
        if (semanticChangeEvent.getChanges().length == 0) {
            return null;
        }
        SemanticChangeEventTypeNode semanticChangeEventTypeNode = this.createEvent(SemanticChangeEventTypeNode.class);
        semanticChangeEventTypeNode.setChanges(semanticChangeEvent.getChanges());
        return semanticChangeEventTypeNode.triggerEvent(DateTime.currentTime(), null, byteString);
    }

    @Override
    protected NodeId addNode(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, QualifiedName qualifiedName, NodeClass nodeClass, ExpandedNodeId expandedNodeId, NodeAttributes nodeAttributes, NodeId nodeId3) throws StatusException {
        if (!serviceContext.isInternal()) {
            throw new StatusException(StatusCodes.Bad_UserAccessDenied);
        }
        return super.addNode(serviceContext, nodeId, nodeId2, qualifiedName, nodeClass, expandedNodeId, nodeAttributes, nodeId3);
    }

    @Override
    protected void addReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, boolean bl, NodeClass nodeClass, String string) throws StatusException {
        super.addReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, nodeClass, string);
    }

    @Override
    protected void deleteNode(ServiceContext serviceContext, NodeId nodeId, Boolean bl) throws StatusException {
        if (!serviceContext.isInternal()) {
            throw new StatusException(StatusCodes.Bad_UserAccessDenied);
        }
        super.deleteNode(serviceContext, nodeId, bl);
    }

    @Override
    protected void deleteReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, Boolean bl, Boolean bl2) throws StatusException {
        super.deleteReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, bl2);
    }

    protected AccessLevelType getAccessLevelForSecurityDiagnostics(ServiceContext serviceContext) {
        if (serviceContext != null && serviceContext.isInternal()) {
            return AccessLevels.READ_ONLY;
        }
        if (this.getServer().getListener() != null && this.getServer().getListener().onAllowReadSecurityDiagnostics(serviceContext)) {
            return AccessLevels.READ_ONLY;
        }
        return AccessLevelType.of();
    }

    protected UaDataType getBaseDataType() {
        try {
            return (UaDataType)this.getType(Identifiers.BaseDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    protected UaVariableType getBaseDataVariableType() {
        try {
            return (UaVariableType)this.getType(Identifiers.BaseDataVariableType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    protected UaObjectType getBaseObjectType() {
        try {
            return (UaObjectType)this.getType(Identifiers.BaseObjectType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    protected UaReferenceType getBaseReferenceType() {
        try {
            return (UaReferenceType)this.getType(Identifiers.References);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    protected UaVariableType getBaseVariableType() {
        try {
            return (UaVariableType)this.getType(Identifiers.BaseVariableType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    @Override
    protected void init() throws RuntimeException {
        logger.debug("init");
        if (!this.isInitialized()) {
            try {
                this.ckg();
                this.ckh();
                super.init();
            }
            catch (Exception exception) {
                logger.error("init: exception", exception);
                throw new RuntimeException("NodeManagerRoot", exception);
            }
        }
    }

    protected void shutdown(int n2, LocalizedText localizedText) {
        logger.debug("shutdown");
        this.getServerData().shutdown(n2, localizedText);
        this.ckj();
    }

    @Override
    protected void start() throws StatusException, UaNodeFactoryException {
        logger.debug("start");
        super.start();
        this.getServerData().start();
        this.cki();
    }

    Set<NodeId> ckk() {
        return this.jO;
    }
}

