/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.EventData;
import com.prosysopc.ua.EventListener;
import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.ContentFilterDefinition;
import com.prosysopc.ua.server.EventManager;
import com.prosysopc.ua.server.EventManagerRoot;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.NodeManagerRoot;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.nodes.ServerNode;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.EventFieldList;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.EventFilterResult;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.types.opcua.server.EventQueueOverflowEventTypeNode;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoredEventItem
extends MonitoredItem {
    private static final Logger logger = LoggerFactory.getLogger(MonitoredEventItem.class);
    private final List<List<QualifiedName>> jy = new CopyOnWriteArrayList<List<QualifiedName>>();
    private volatile boolean jz;
    private BlockingDeque<EventFieldList> jn;
    private final ContentFilterDefinition jA = new ContentFilterDefinition();
    protected EventListener eventListener = new EventListener(){

        @Override
        public boolean isMonitored(UaNode uaNode) {
            return MonitoredEventItem.this.filter(new EventData(uaNode, null), true);
        }

        @Override
        public void onEvent(UaNode uaNode, EventData eventData) {
            MonitoredEventItem.this.notifyEvent(eventData);
        }
    };

    @Deprecated
    public static int getMaxQueueSize() {
        return maxQueueSize;
    }

    @Deprecated
    public static void setMaxQueueSize(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("maxQueueSize must be bigger than 0");
        }
        MonitoredItemBase.maxQueueSize = n2;
    }

    public MonitoredEventItem(ServiceContext serviceContext, Subscription subscription, UnsignedInteger unsignedInteger, NodeId nodeId, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        super(serviceContext, subscription, unsignedInteger, nodeId, Attributes.EventNotifier, MonitoringMode.Reporting);
        this.setEventFilterResult(eventFilterResult);
        try {
            this.setEventFilter(eventFilter);
        }
        catch (ServiceException serviceException) {
            throw new StatusException(serviceException.getServiceResult());
        }
        this.queueSize = 0L;
    }

    public boolean filter(EventData eventData) {
        return this.filter(eventData, false);
    }

    public Boolean filter(EventData eventData, Boolean bl) {
        Boolean bl2 = this.jA.evaluate(eventData, bl);
        return bl2 == null ? bl : bl2;
    }

    public int getCurrentQueueSize() {
        return this.jn == null ? 0 : this.jn.size();
    }

    public EventFilter getEventFilter() {
        return (EventFilter)this.getFilter();
    }

    public EventFilterResult getEventFilterResult() {
        return (EventFilterResult)this.getFilterResult();
    }

    public boolean isMonitored(UaNode uaNode) {
        return this.filter(new EventData(uaNode, null), true);
    }

    public void notifyEvent(EventData eventData) {
        this.notifyEvent(eventData, true);
    }

    public void notifyEvent(EventData eventData, boolean bl) {
        logger.debug("notifyEvent");
        if (this.getMonitoringMode().equals(MonitoringMode.Reporting) && eventData != null && (!bl || this.filter(eventData))) {
            this.a(eventData);
        }
    }

    @Deprecated
    public void onEvent(UaNode uaNode, EventData eventData) {
        this.notifyEvent(eventData);
    }

    private void a(EventData eventData) {
        logger.debug("addNewEvent: eventData={} ClientHandle={}", (Object)eventData, (Object)this.clientHandle);
        EventFieldList eventFieldList = new EventFieldList(this.clientHandle, Variant.asObjectArray(eventData.getFieldValues(this.jy)));
        this.a(eventFieldList);
    }

    private void a(EventFieldList eventFieldList) {
        logger.debug("addNewEvent: queue={}", (Object)this.jn);
        if (this.jn != null) {
            while (!this.jn.offer(eventFieldList)) {
                logger.warn("addNewEvent: queue overflow: SubscriptionId={} ItemId={} QueueSize={}", this.subscription.getSubscriptionId(), this.getMonitoredItemId(), this.getQueueSize());
                this.jz = true;
                if (!this.discardOldest) break;
                this.jn.pollFirst();
            }
        }
        this.subscription.newEventAvailable(this);
    }

    @Override
    protected long getDefaultQueueSize() {
        return maxQueueSize;
    }

    protected void getEvents(List<EventFieldList> list) {
        if (this.jn != null && this.jn.size() > 0) {
            logger.debug("getEvents: queue.size={}", (Object)this.jn.size());
            this.jn.drainTo(list);
            if (this.jz) {
                EventQueueOverflowEventTypeNode eventQueueOverflowEventTypeNode = this.getNodeManagerRoot().createEvent(EventQueueOverflowEventTypeNode.class);
                DateTime dateTime = DateTime.currentTime();
                eventQueueOverflowEventTypeNode.setTime(dateTime);
                eventQueueOverflowEventTypeNode.setReceiveTime(dateTime);
                eventQueueOverflowEventTypeNode.setEventId(EventManager.createFullEventId(null));
                EventData eventData = new EventData(eventQueueOverflowEventTypeNode, null);
                EventManagerRoot.a(eventQueueOverflowEventTypeNode);
                EventFieldList eventFieldList = new EventFieldList(this.clientHandle, Variant.asObjectArray(eventData.getFieldValues(this.jy)));
                if (this.discardOldest) {
                    list.add(0, eventFieldList);
                } else {
                    list.add(eventFieldList);
                }
                this.jz = false;
                if (this.subscription.getSubscriptionManager().getSessionManager().getServer().getDiagnosticsManager().isEnabled()) {
                    this.subscription.getDiagnostics().cmt().incrementAndGet();
                }
            }
        }
    }

    protected NodeManagerRoot getNodeManagerRoot() {
        return this.getSubscription().getSubscriptionManager().getNodeManagerTable().getNodeManagerRoot();
    }

    @Override
    protected void plugNodeListener() {
        logger.debug("plugNodeListener: {}", (Object)this.getNode());
        if (this.getNode() instanceof ServerNode) {
            logger.debug("ok");
            ((ServerNode)this.getNode()).addEventListener(this.eventListener);
        }
    }

    protected final void setEventFilter(EventFilter eventFilter) throws ServiceException {
        this.setFilter(eventFilter);
    }

    protected void setEventFilterResult(EventFilterResult eventFilterResult) {
        this.setFilterResult(eventFilterResult);
    }

    @Override
    protected void unPlugNodeListener() {
        logger.debug("unPlugNodeListener {} {}", (Object)this.subscription, (Object)this);
        UaNode uaNode = this.getNode();
        if (uaNode instanceof ServerNode) {
            ((ServerNode)uaNode).removeEventListener(this.eventListener);
        }
    }

    @Override
    protected void updateFilter() {
        ContentFilterDefinition.parseEventFilter(this.getNodeManagerRoot(), this.getEventFilter(), this.jy, this.jA, this.getEventFilterResult());
    }

    @Override
    protected void updateQueue() {
        logger.debug("updateQueue: MonitoredItem={}", (Object)this);
        BlockingDeque<EventFieldList> blockingDeque = this.jn;
        boolean bl = this.getMonitoringMode().equals(MonitoringMode.Disabled);
        BlockingDeque<Object> blockingDeque2 = this.jn = bl || this.queueSize <= 0L ? null : new LinkedBlockingDeque((int)this.queueSize);
        if (logger.isDebugEnabled()) {
            logger.debug("updateQueue: making queue of size: " + (this.jn == null ? "null" : Long.valueOf(this.queueSize)));
        }
        if (blockingDeque != null) {
            logger.debug("updateQueue: oldQueue={}", (Object)blockingDeque);
            if (this.jn != null) {
                while (!blockingDeque.isEmpty()) {
                    this.a(blockingDeque.poll());
                }
            } else {
                blockingDeque.clear();
            }
        }
        logger.debug("updateQueue done. Active size={}", (Object)(this.jn == null ? 0 : this.jn.size()));
    }
}

