/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.UaNodeUtils;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.Identifiers;

public final class ModellingRule {
    public static final ModellingRule ExposesItsArray = new ModellingRule(Identifiers.ModellingRule_ExposesItsArray, "ExposesItsArray");
    public static final ModellingRule Mandatory = new ModellingRule(Identifiers.ModellingRule_Mandatory, "Mandatory");
    public static final ModellingRule MandatoryPlaceholder = new ModellingRule(Identifiers.ModellingRule_MandatoryPlaceholder, "MandatoryPlaceholder");
    public static final ModellingRule Optional = new ModellingRule(Identifiers.ModellingRule_Optional, "Optional");
    public static final ModellingRule OptionalPlaceholder = new ModellingRule(Identifiers.ModellingRule_OptionalPlaceholder, "OptionalPlaceholder");
    public static final ModellingRule[] values = new ModellingRule[]{Mandatory, Optional, ExposesItsArray, OptionalPlaceholder, MandatoryPlaceholder};
    private final String jf;
    private final NodeId nodeId;

    public static ModellingRule byInstanceDeclaration(UaNode uaNode) {
        if (uaNode == null) {
            return null;
        }
        UaNode uaNode2 = UaNodeUtils.getModellingRule(uaNode);
        return uaNode2 == null ? null : ModellingRule.byModellingRuleNode(uaNode2);
    }

    public static ModellingRule byModellingRuleNode(UaNode uaNode) {
        if (!UaNodeUtils.isModellingRule(uaNode)) {
            throw new IllegalArgumentException("Node is not a modelling rule");
        }
        ModellingRule modellingRule = ModellingRule.h(uaNode.getNodeId());
        return modellingRule == null ? new ModellingRule(uaNode) : modellingRule;
    }

    private static ModellingRule h(NodeId nodeId) {
        for (ModellingRule modellingRule : values) {
            if (!modellingRule.nodeId.equals(nodeId)) continue;
            return modellingRule;
        }
        return null;
    }

    private ModellingRule(NodeId nodeId, String string) {
        this.nodeId = nodeId;
        this.jf = string;
    }

    private ModellingRule(UaNode uaNode) {
        this.nodeId = uaNode.getNodeId();
        this.jf = uaNode.getBrowseName().getName();
    }

    public String getDisplayName() {
        return this.jf;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public String toString() {
        return this.jf;
    }
}

