/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.EventData;
import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.EventManager;
import com.prosysopc.ua.server.EventManagerUaNode;
import com.prosysopc.ua.server.MethodManager;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.types.opcua.server.BaseEventTypeNode;
import com.prosysopc.ua.types.opcua.server.RefreshEndEventTypeNode;
import com.prosysopc.ua.types.opcua.server.RefreshStartEventTypeNode;
import java.util.UUID;

public class EventManagerRoot
extends EventManagerUaNode {
    static void a(BaseEventTypeNode baseEventTypeNode) {
        if (BaseEventTypeNode.isDeleteOneShotEvents()) {
            try {
                baseEventTypeNode.getNodeManager().deleteNode(baseEventTypeNode, true, true);
            }
            catch (StatusException statusException) {
                logger.warn("Could not delete one-shot event " + baseEventTypeNode.getClass(), statusException);
            }
        }
    }

    public EventManagerRoot(NodeManager nodeManager) {
        super(nodeManager);
    }

    @Override
    public boolean onCall(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, NodeId nodeId2, UaMethod uaMethod, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray, Variant[] variantArray2) throws StatusException {
        if (super.onCall(serviceContext, nodeId, uaNode, nodeId2, uaMethod, variantArray, statusCodeArray, diagnosticInfoArray, variantArray2)) {
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("onCall: ", (Object)("object=" + uaNode == null ? nodeId : (uaNode.getBrowseName() + "; method=" + uaMethod == null ? nodeId2 : uaMethod.getBrowseName())));
        }
        if (nodeId2.equals(Identifiers.ConditionType_ConditionRefresh) || uaMethod != null && uaMethod.getBrowseName().equals(new QualifiedName("ConditionRefresh"))) {
            try {
                MethodManager.checkInputArguments(new Class[]{UnsignedInteger.class}, variantArray, statusCodeArray, diagnosticInfoArray, false);
                UnsignedInteger unsignedInteger = (UnsignedInteger)variantArray[0].getValue();
                logger.debug("subscriptionId: {}", (Object)unsignedInteger);
                Subscription subscription = this.getSubscriptionManager().getSubscription(unsignedInteger);
                logger.debug("subscription: {}", (Object)subscription);
                return this.refresh(serviceContext, subscription);
            }
            catch (ClassCastException classCastException) {
                statusCodeArray[0] = StatusCode.valueOf(StatusCodes.Bad_SubscriptionIdInvalid);
            }
            catch (ServiceException serviceException) {
                statusCodeArray[0] = StatusCode.valueOf(StatusCodes.Bad_SubscriptionIdInvalid);
            }
            throw new StatusException(StatusCodes.Bad_InvalidArgument);
        }
        if (nodeId2.equals(Identifiers.ConditionType_ConditionRefresh2) || uaMethod != null && uaMethod.getBrowseName().equals(new QualifiedName("ConditionRefresh2"))) {
            try {
                MethodManager.checkInputArguments(new Class[]{UnsignedInteger.class, UnsignedInteger.class}, variantArray, statusCodeArray, diagnosticInfoArray, false);
            }
            catch (StatusException statusException) {
                statusCodeArray[0] = StatusCode.valueOf(StatusCodes.Bad_InvalidArgument);
                statusCodeArray[1] = StatusCode.valueOf(StatusCodes.Bad_InvalidArgument);
            }
            UnsignedInteger unsignedInteger = (UnsignedInteger)variantArray[0].getValue();
            logger.debug("subscriptionId: {}", (Object)unsignedInteger);
            try {
                Subscription subscription = this.getSubscriptionManager().getSubscription(unsignedInteger);
                if (!subscription.getSession().equals(serviceContext.getSession())) {
                    throw new StatusException(StatusCodes.Bad_UserAccessDenied);
                }
                UnsignedInteger unsignedInteger2 = (UnsignedInteger)variantArray[1].getValue();
                logger.debug("monitoredItemId: {}", (Object)unsignedInteger2);
                MonitoredEventItem monitoredEventItem = (MonitoredEventItem)subscription.getItem(unsignedInteger2);
                return this.refresh(serviceContext, subscription, monitoredEventItem);
            }
            catch (ServiceException serviceException) {
                throw new StatusException(StatusCodes.Bad_SubscriptionIdInvalid);
            }
        }
        return false;
    }

    private void b(BaseEventTypeNode baseEventTypeNode) {
        DateTime dateTime = DateTime.currentTime();
        if (baseEventTypeNode.getReceiveTime() == null) {
            baseEventTypeNode.setReceiveTime(dateTime);
        }
        if (baseEventTypeNode.getTime() == null) {
            baseEventTypeNode.setTime(dateTime);
        }
        if (baseEventTypeNode.getSeverity() == null) {
            baseEventTypeNode.setSeverity(UnsignedShort.ONE);
        }
        if (baseEventTypeNode.getMessage() == null) {
            if (baseEventTypeNode instanceof RefreshStartEventTypeNode) {
                baseEventTypeNode.setMessage(new LocalizedText("Refresh Start"));
            }
            if (baseEventTypeNode instanceof RefreshEndEventTypeNode) {
                baseEventTypeNode.setMessage(new LocalizedText("Refresh End"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refresh(ServiceContext serviceContext, Subscription subscription) throws StatusException {
        logger.debug("refresh: subscription={}", (Object)subscription);
        if (subscription != null) {
            this.refreshStartEvent(subscription);
            try {
                for (NodeManager nodeManager : this.getNodeManagerTable().ckm().values()) {
                    EventManager eventManager = nodeManager.getEventManager();
                    if (eventManager == null) continue;
                    eventManager.refreshItems(serviceContext, subscription);
                }
            }
            finally {
                this.refreshEndEvent(subscription);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refresh(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) throws StatusException {
        logger.debug("refresh: MonitoredItem={}", (Object)monitoredEventItem);
        if (monitoredEventItem != null) {
            this.refreshStartEvent(monitoredEventItem);
            try {
                for (NodeManager nodeManager : this.getNodeManagerTable().ckm().values()) {
                    EventManager eventManager = nodeManager.getEventManager();
                    if (eventManager == null) continue;
                    eventManager.fireConditionRefresh2(serviceContext, monitoredEventItem);
                    eventManager.refreshItem(monitoredEventItem);
                }
            }
            finally {
                this.refreshEndEvent(monitoredEventItem);
            }
        }
        return true;
    }

    protected void refreshEndEvent(MonitoredEventItem monitoredEventItem) {
        RefreshEndEventTypeNode refreshEndEventTypeNode = this.getNodeManagerTable().getNodeManagerRoot().createEvent(RefreshEndEventTypeNode.class);
        this.b(refreshEndEventTypeNode);
        EventData eventData = EventData.fromNodeHierarchy((UaNode)refreshEndEventTypeNode, ByteString.fromUUID(UUID.randomUUID()), new NodeClass[0]);
        EventManagerRoot.a(refreshEndEventTypeNode);
        if (monitoredEventItem instanceof MonitoredEventItem) {
            logger.debug("refreshEndEvent: eventItem={}", (Object)monitoredEventItem.getMonitoredItemId());
            monitoredEventItem.notifyEvent(eventData, false);
        }
    }

    protected void refreshEndEvent(Subscription subscription) {
        RefreshEndEventTypeNode refreshEndEventTypeNode = this.getNodeManagerTable().getNodeManagerRoot().createEvent(RefreshEndEventTypeNode.class);
        this.b(refreshEndEventTypeNode);
        EventData eventData = EventData.fromNodeHierarchy((UaNode)refreshEndEventTypeNode, ByteString.fromUUID(UUID.randomUUID()), new NodeClass[0]);
        EventManagerRoot.a(refreshEndEventTypeNode);
        for (MonitoredItemBase monitoredItemBase : subscription.getItems()) {
            if (!(monitoredItemBase instanceof MonitoredEventItem)) continue;
            MonitoredEventItem monitoredEventItem = (MonitoredEventItem)monitoredItemBase;
            logger.debug("refreshEndEvent: eventItem={}", (Object)monitoredEventItem.getMonitoredItemId());
            monitoredEventItem.notifyEvent(eventData, false);
        }
    }

    protected void refreshStartEvent(MonitoredEventItem monitoredEventItem) {
        RefreshStartEventTypeNode refreshStartEventTypeNode = this.getNodeManagerTable().getNodeManagerRoot().createEvent(RefreshStartEventTypeNode.class);
        this.b(refreshStartEventTypeNode);
        EventData eventData = EventData.fromNodeHierarchy((UaNode)refreshStartEventTypeNode, ByteString.fromUUID(UUID.randomUUID()), new NodeClass[0]);
        EventManagerRoot.a(refreshStartEventTypeNode);
        if (monitoredEventItem instanceof MonitoredEventItem) {
            logger.debug("refreshStartEvent: eventItem={}", (Object)monitoredEventItem.getMonitoredItemId());
            monitoredEventItem.notifyEvent(eventData, false);
        }
    }

    protected void refreshStartEvent(Subscription subscription) {
        RefreshStartEventTypeNode refreshStartEventTypeNode = this.getNodeManagerTable().getNodeManagerRoot().createEvent(RefreshStartEventTypeNode.class);
        this.b(refreshStartEventTypeNode);
        EventData eventData = EventData.fromNodeHierarchy((UaNode)refreshStartEventTypeNode, ByteString.fromUUID(UUID.randomUUID()), new NodeClass[0]);
        EventManagerRoot.a(refreshStartEventTypeNode);
        for (MonitoredItemBase monitoredItemBase : subscription.getItems()) {
            if (!(monitoredItemBase instanceof MonitoredEventItem)) continue;
            MonitoredEventItem monitoredEventItem = (MonitoredEventItem)monitoredItemBase;
            logger.debug("refreshStartEvent: eventItem={}", (Object)monitoredEventItem.getMonitoredItemId());
            monitoredEventItem.notifyEvent(eventData, false);
        }
    }
}

