/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.DataChangeListener;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.SubscriptionManager;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.b;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.SessionDiagnosticsDataType;
import com.prosysopc.ua.stack.core.SessionSecurityDiagnosticsDataType;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.SubscriptionDiagnosticsDataType;
import com.prosysopc.ua.types.opcua.server.ServerDiagnosticsTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsArrayTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionSecurityDiagnosticsArrayTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionsDiagnosticsSummaryTypeNode;
import com.prosysopc.ua.types.opcua.server.SubscriptionDiagnosticsArrayTypeNode;
import com.prosysopc.ua.types.opcua.server.SubscriptionDiagnosticsTypeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticsManager {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosticsManager.class);
    private final AtomicBoolean hT = new AtomicBoolean(false);
    private SubscriptionDiagnosticsArrayTypeNode hU;
    private boolean hV = true;
    private final UaServer hW;
    private ServerDiagnosticsTypeNode hX;
    private final b hY = new b();
    private final Map<Session, SessionDiagnosticsObjectTypeNode> hZ = new ConcurrentHashMap<Session, SessionDiagnosticsObjectTypeNode>();
    private SessionsDiagnosticsSummaryTypeNode ia;
    private final Map<Subscription, SubscriptionDiagnosticsTypeNode> ib = new ConcurrentHashMap<Subscription, SubscriptionDiagnosticsTypeNode>();
    private volatile boolean ic = this.hT.get();

    protected DiagnosticsManager(UaServer uaServer) {
        this.hW = uaServer;
    }

    public boolean isEnabled() {
        return this.hT.get();
    }

    public boolean isRemoveSamplingIntervalDiagnosticsArrayOnStart() {
        return this.hV;
    }

    public void setRemoveSamplingIntervalDiagnosticsArrayOnStart(boolean bl) {
        this.hV = bl;
    }

    private void a(Collection<Session> collection, SessionDiagnosticsArrayTypeNode sessionDiagnosticsArrayTypeNode) {
        try {
            ArrayList<SessionDiagnosticsDataType> arrayList = new ArrayList<SessionDiagnosticsDataType>();
            for (Session session : collection) {
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.hZ.get(session);
                arrayList.add(sessionDiagnosticsObjectTypeNode.getSessionDiagnostics());
            }
            sessionDiagnosticsArrayTypeNode.setValue(arrayList.toArray(new SessionDiagnosticsDataType[arrayList.size()]));
        }
        catch (Exception exception) {
            logger.error("Could not set diagnostics", exception);
        }
    }

    private void a(Collection<Session> collection, SessionSecurityDiagnosticsArrayTypeNode sessionSecurityDiagnosticsArrayTypeNode) {
        try {
            ArrayList<SessionSecurityDiagnosticsDataType> arrayList = new ArrayList<SessionSecurityDiagnosticsDataType>();
            for (Session session : collection) {
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.hZ.get(session);
                arrayList.add(sessionDiagnosticsObjectTypeNode.getSessionSecurityDiagnostics());
            }
            sessionSecurityDiagnosticsArrayTypeNode.setValue(arrayList.toArray(new SessionSecurityDiagnosticsDataType[arrayList.size()]));
        }
        catch (Exception exception) {
            logger.error("Could not set diagnostics", exception);
        }
    }

    private void a(Collection<Subscription> collection, SubscriptionDiagnosticsArrayTypeNode subscriptionDiagnosticsArrayTypeNode) {
        try {
            ArrayList<SubscriptionDiagnosticsDataType> arrayList = new ArrayList<SubscriptionDiagnosticsDataType>();
            for (Subscription subscription : collection) {
                SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode = this.ib.get(subscription);
                if (subscriptionDiagnosticsTypeNode == null) continue;
                arrayList.add((SubscriptionDiagnosticsDataType)subscriptionDiagnosticsTypeNode.getValue().getValue().getValue());
            }
            subscriptionDiagnosticsArrayTypeNode.setValue(arrayList.toArray(new SubscriptionDiagnosticsDataType[arrayList.size()]));
        }
        catch (Exception exception) {
            logger.error("Could not set diagnostics", exception);
        }
    }

    private SubscriptionManager getSubscriptionManager() {
        return this.hW.getSubscriptionManager();
    }

    private void cjH() throws StatusException {
        this.hX = this.hW.getNodeManagerRoot().getServerData().getServerDiagnosticsNode();
        this.ia = this.hX.getSessionsDiagnosticsSummaryNode();
        this.hU = this.hX.getSubscriptionDiagnosticsArrayNode();
        DataChangeListener dataChangeListener = new DataChangeListener(){

            @Override
            public void onDataChange(UaNode uaNode, DataValue dataValue, DataValue dataValue2) {
                if (dataValue2.isNull()) {
                    return;
                }
                boolean bl = dataValue2.getValue().booleanValue();
                DiagnosticsManager.this.hT.set(bl);
                if (bl) {
                    DiagnosticsManager.this.onDiagnosticsEnabled();
                } else {
                    DiagnosticsManager.this.onDiagnosticsDisabled();
                }
            }
        };
        this.hX.addEnabledChangeListener(dataChangeListener);
        DataValue dataValue = this.hX.getEnabledFlagNode().getValue();
        if (dataValue != null && !dataValue.isNull() && ((Boolean)dataValue.getValue().getValue()).booleanValue()) {
            dataChangeListener.onDataChange(this.hX, null, dataValue);
        }
    }

    private void cjI() {
        try {
            UaNode uaNode = this.hW.getNodeManagerRoot().getNode(Identifiers.ViewsFolder);
            this.hY.ckL().set(uaNode.getComponents().length);
            this.cjK();
        }
        catch (StatusException statusException) {
            logger.warn("ViewsFolder not available", statusException);
        }
    }

    private void cjJ() {
        DataValue dataValue = new DataValue(StatusCode.valueOf(StatusCodes.Bad_NotReadable));
        try {
            for (NodeId nodeId : this.hW.getNodeManagerRoot().ckk()) {
                UaVariable uaVariable = (UaVariable)this.hW.getAddressSpace().getNode(nodeId);
                uaVariable.setValue(dataValue);
            }
        }
        catch (Exception exception) {
            logger.error("Could not update diagnostics", exception);
        }
    }

    private void cjK() {
        if (this.isEnabled()) {
            try {
                this.hX.setServerDiagnosticsSummary(this.hY.ckB());
            }
            catch (Exception exception) {
                logger.error("Could not update diagnostics", exception);
            }
        }
    }

    protected void addSession(Session session) {
        logger.trace("addSession: session:{}", (Object)session);
        if (this.isEnabled()) {
            try {
                logger.trace("addSession, creating diagnostics node");
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.hW.getNodeManagerUaServer().createInstance(SessionDiagnosticsObjectTypeNode.class, session.getSessionName(), session.getSessionId());
                logger.trace("addSession, created diagnostics node");
                sessionDiagnosticsObjectTypeNode.setSessionDiagnostics(session.getSessionDiagnostics().snapshot());
                sessionDiagnosticsObjectTypeNode.setSessionSecurityDiagnostics(session.getSessionSecurityDiagnostics().snapshot());
                this.hZ.put(session, sessionDiagnosticsObjectTypeNode);
                this.ia.getSessionDiagnosticsArrayNode().addComponent(sessionDiagnosticsObjectTypeNode.getSessionDiagnosticsNode());
                this.ia.getSessionSecurityDiagnosticsArrayNode().addComponent(sessionDiagnosticsObjectTypeNode.getSessionSecurityDiagnosticsNode());
                this.ia.addComponent(sessionDiagnosticsObjectTypeNode);
                this.updateSession(session);
                this.hY.ckE().incrementAndGet();
                this.cjL();
                this.cjK();
            }
            catch (Exception exception) {
                logger.error("Could not set diagnostics", exception);
            }
        } else {
            this.cjL();
        }
    }

    protected void addSessionNoIncrement(Session session) {
        logger.trace("addSession: session:{}", (Object)session);
        if (this.isEnabled()) {
            try {
                logger.trace("addSession, creating diagnostics node");
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.hW.getNodeManagerUaServer().createInstance(SessionDiagnosticsObjectTypeNode.class, session.getSessionName(), session.getSessionId());
                logger.trace("addSession, created diagnostics node");
                sessionDiagnosticsObjectTypeNode.setSessionDiagnostics(session.getSessionDiagnostics().snapshot());
                sessionDiagnosticsObjectTypeNode.setSessionSecurityDiagnostics(session.getSessionSecurityDiagnostics().snapshot());
                this.hZ.put(session, sessionDiagnosticsObjectTypeNode);
                this.ia.getSessionDiagnosticsArrayNode().addComponent(sessionDiagnosticsObjectTypeNode.getSessionDiagnosticsNode());
                this.ia.getSessionSecurityDiagnosticsArrayNode().addComponent(sessionDiagnosticsObjectTypeNode.getSessionSecurityDiagnosticsNode());
                this.ia.addComponent(sessionDiagnosticsObjectTypeNode);
                this.updateSession(session);
                this.hY.ckE().incrementAndGet();
                this.cjK();
            }
            catch (Exception exception) {
                logger.error("Could not set diagnostics", exception);
            }
        }
    }

    protected void addSubscription(Session session, Subscription subscription) {
        if (this.isEnabled()) {
            try {
                SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode = this.hW.getNodeManagerUaServer().createInstance(SubscriptionDiagnosticsTypeNode.class, subscription.getSubscriptionId().toString(), NodeId.randomGUID(this.hW.getNodeManagerUaServer().getNamespaceIndex()));
                subscriptionDiagnosticsTypeNode.setValue(subscription.getDiagnostics().snapshot());
                this.ib.put(subscription, subscriptionDiagnosticsTypeNode);
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.hZ.get(session);
                logger.trace("addSubscription: session:{}, diag:{}", (Object)session, (Object)sessionDiagnosticsObjectTypeNode);
                sessionDiagnosticsObjectTypeNode.getSubscriptionDiagnosticsArrayNode().addComponent(subscriptionDiagnosticsTypeNode);
                this.hX.getSubscriptionDiagnosticsArrayNode().addComponent(subscriptionDiagnosticsTypeNode);
                this.updateSubscription(subscription);
                this.cjM();
                this.hY.ckF().incrementAndGet();
                this.cjK();
                session.getSessionDiagnostics().clh().incrementAndGet();
            }
            catch (Exception exception) {
                logger.error("Could not add diagnostics node", exception);
            }
        } else {
            this.cjM();
        }
    }

    protected void close() {
        logger.debug("close");
        if (this.hX != null) {
            this.hX.setEnabled(false);
        }
        this.hX = null;
    }

    protected void onDiagnosticsDisabled() {
        if (this.ic) {
            for (Subscription object : this.hW.getSubscriptionManager().getSubscriptions()) {
                this.removeSubscription(object.getSession(), object);
            }
            for (Session session : this.hW.getSessionManager().getSessions()) {
                this.removeSession(session);
            }
            this.cjJ();
        } else {
            logger.trace("Diagnostics is disabled, onDiagnosticsDisabled aborted");
        }
        this.ic = false;
    }

    protected void onDiagnosticsEnabled() {
        if (!this.ic) {
            for (Session iterator : this.hW.getSessionManager().getSessions()) {
                iterator.resetDiagnostics();
                this.hW.getDiagnosticsManager().addSessionNoIncrement(iterator);
            }
            this.hY.ckE().set(this.hW.getSessionManager().getSessionCount());
            SubscriptionManager subscriptionManager = this.getSubscriptionManager();
            this.hY.ckF().set(subscriptionManager.getSubscriptionCount());
            this.cjK();
            for (Subscription subscription : subscriptionManager.getSubscriptions()) {
                subscription.getSession().getSessionDiagnostics().clh().set(0L);
            }
            for (Subscription subscription : subscriptionManager.getSubscriptions()) {
                subscription.getDiagnostics().clK();
                this.addSubscription(subscription.getSession(), subscription);
                subscription.getSession().getSessionDiagnostics().clf().set(subscription.getItemCount());
            }
            this.cjI();
        } else {
            logger.trace("Diagnostics is enabled, onDiagnosticsEnabled aborted");
        }
        this.ic = true;
    }

    protected void removeSession(Session session) {
        SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.hZ.remove(session);
        logger.trace("removeSession, session: {}, diag: {}", (Object)session, (Object)sessionDiagnosticsObjectTypeNode);
        if (sessionDiagnosticsObjectTypeNode != null) {
            try {
                logger.trace("removeSession, deleting diagnostics nodes");
                this.ia.getSessionDiagnosticsArrayNode().removeComponent(sessionDiagnosticsObjectTypeNode.getSessionDiagnosticsNode());
                this.ia.getSessionSecurityDiagnosticsArrayNode().removeComponent(sessionDiagnosticsObjectTypeNode.getSessionSecurityDiagnosticsNode());
                this.ia.removeComponent(sessionDiagnosticsObjectTypeNode);
                sessionDiagnosticsObjectTypeNode.getNodeManager().deleteNode(sessionDiagnosticsObjectTypeNode, true, true);
                logger.trace("removeSession, deleted diagnostics nodes");
            }
            catch (Exception exception) {
                logger.error("Could not remove diagnostics", exception);
            }
        }
        if (this.hX.isEnabled()) {
            this.hY.ckE().set(this.hW.getSessionManager().getSessionCount());
            this.cjK();
        }
    }

    protected void removeSubscription(Session session, Subscription subscription) {
        logger.trace("removeSubscription, session: {}, subscription {}", (Object)session, (Object)subscription);
        SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode = this.ib.remove(subscription);
        if (subscriptionDiagnosticsTypeNode != null) {
            try {
                if (session != null) {
                    SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.hZ.get(session);
                    logger.trace("removeSubscription: session:{}, diag:{}", (Object)session, (Object)sessionDiagnosticsObjectTypeNode);
                    if (sessionDiagnosticsObjectTypeNode != null) {
                        sessionDiagnosticsObjectTypeNode.getSubscriptionDiagnosticsArrayNode().removeComponent(subscriptionDiagnosticsTypeNode);
                    }
                }
                this.hX.getSubscriptionDiagnosticsArrayNode().removeComponent(subscriptionDiagnosticsTypeNode);
                subscriptionDiagnosticsTypeNode.getNodeManager().deleteNode(subscriptionDiagnosticsTypeNode, true, true);
            }
            catch (Exception exception) {
                logger.error("Could not remove diagnostics", exception);
            }
        }
        if (this.isEnabled()) {
            try {
                this.hY.ckF().set(this.getSubscriptionManager().getSubscriptionCount());
                this.cjK();
                if (session.getSessionDiagnostics() != null) {
                    session.getSessionDiagnostics().clh().decrementAndGet();
                    session.updateDiagnostics();
                }
            }
            catch (Exception exception) {
                logger.error("Could not set diagnostics", exception);
            }
        }
    }

    protected void start() throws StatusException {
        logger.debug("start");
        if (this.hV) {
            try {
                this.hW.getNodeManagerRoot().deleteNode(Identifiers.Server_ServerDiagnostics_SamplingIntervalDiagnosticsArray, true, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cjH();
    }

    protected void updateSession(Session session) {
        logger.trace("updateSession, session: {}", (Object)session);
        SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.hZ.get(session);
        if (this.isEnabled() && sessionDiagnosticsObjectTypeNode != null) {
            try {
                sessionDiagnosticsObjectTypeNode.setSessionDiagnostics(session.getSessionDiagnostics().snapshot());
                sessionDiagnosticsObjectTypeNode.setSessionSecurityDiagnostics(session.getSessionSecurityDiagnostics().snapshot());
                this.a(this.hZ.keySet(), this.ia.getSessionDiagnosticsArrayNode());
                this.a(this.hZ.keySet(), this.ia.getSessionSecurityDiagnosticsArrayNode());
            }
            catch (Exception exception) {
                logger.error("Could not update diagnostics", exception);
            }
        }
    }

    protected void updateSubscription(Subscription subscription) {
        SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode = this.ib.get(subscription);
        if (this.isEnabled() && subscriptionDiagnosticsTypeNode != null) {
            try {
                subscriptionDiagnosticsTypeNode.setValue(subscription.getDiagnostics().snapshot());
                this.a(this.ib.keySet(), this.hU);
                Session session = subscription.getSession();
                if (session == null) {
                    return;
                }
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.hZ.get(session);
                logger.debug("diag object debug: {}, session: {}, subscription", sessionDiagnosticsObjectTypeNode, session, subscription);
                if (sessionDiagnosticsObjectTypeNode == null) {
                    return;
                }
                SubscriptionDiagnosticsArrayTypeNode subscriptionDiagnosticsArrayTypeNode = sessionDiagnosticsObjectTypeNode.getSubscriptionDiagnosticsArrayNode();
                if (subscriptionDiagnosticsArrayTypeNode != null) {
                    this.a(session.ckT(), subscriptionDiagnosticsArrayTypeNode);
                }
            }
            catch (Exception exception) {
                logger.error("Could not update diagnostics", exception);
            }
        }
    }

    void cjL() {
        this.hY.ckC().incrementAndGet();
        this.cjK();
    }

    void cjM() {
        this.hY.ckD().incrementAndGet();
        this.cjK();
    }

    void cjN() {
        this.hY.ckI().incrementAndGet();
        this.cjK();
    }

    void cjO() {
        this.hY.ckK().incrementAndGet();
        this.cjK();
    }

    void cjP() {
        this.hY.ckN().incrementAndGet();
        this.cjK();
    }
}

