/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.nodes;

import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.a;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.core.DataTypeDefinition;
import com.prosysopc.ua.stack.core.DataTypeIdentifiers;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.typedictionary.DynamicEnumeration;
import com.prosysopc.ua.typedictionary.DynamicOptionSetStructure;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.DynamicUIntOptionSet;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface UaDataType
extends UaType {
    public static final Logger logger = LoggerFactory.getLogger(UaDataType.class);

    public DataTypeDefinition getDataTypeDefinition();

    default public Class<?> getJavaClass() {
        UaNodeId uaNodeId = UaNodeId.fromLocal(this.getNodeId(), this.getAddressSpace().getNamespaceTable());
        UaDataTypeSpecification uaDataTypeSpecification = this.getAddressSpace().getEncoderContext().getDataTypeSpecifications().get(uaNodeId);
        if (uaDataTypeSpecification != null) {
            return uaDataTypeSpecification.getJavaClass();
        }
        if (Identifiers.Structure.equals(this.getNodeId())) {
            return ExtensionObject.class;
        }
        HashSet<UaNodeId> hashSet = new HashSet<UaNodeId>();
        hashSet.add(UaIds.Enumeration);
        hashSet.add(UaIds.Structure);
        hashSet.add(UaIds.OptionSet);
        HashSet<UaNodeId> hashSet2 = new HashSet<UaNodeId>();
        hashSet2.add(UaIds.Byte);
        hashSet2.add(UaIds.UInt16);
        hashSet2.add(UaIds.UInt32);
        hashSet2.add(UaIds.UInt64);
        hashSet.addAll(hashSet2);
        UaNodeId uaNodeId2 = this.inheritsFromAny(hashSet);
        if (uaNodeId2 == null) {
            UaDataType uaDataType = (UaDataType)this.getSuperType();
            if (uaDataType == null) {
                if (!DataTypeIdentifiers.BaseDataType.equals(this.getNodeId())) {
                    a.cjF().warn("A non-BaseDataType node {}, has no supertype", (Object)this.getNodeId());
                    return null;
                }
                return Object.class;
            }
            return uaDataType.getJavaClass();
        }
        if (UaIds.Enumeration.equals(uaNodeId2)) {
            return DynamicEnumeration.class;
        }
        if (UaIds.OptionSet.equals(uaNodeId2)) {
            return DynamicOptionSetStructure.class;
        }
        if (UaIds.Structure.equals(uaNodeId2)) {
            return DynamicStructure.class;
        }
        if (hashSet2.contains(uaNodeId2)) {
            return DynamicUIntOptionSet.class;
        }
        throw new IllegalStateException("getJavaClass reached an invalid internal state");
    }
}

