/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.UaException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.InternalAddressSpaceAccessHelper;
import com.prosysopc.ua.client.InternalGetNodesResults;
import com.prosysopc.ua.client.nodes.UaClientReference;
import com.prosysopc.ua.nodes.AbstractUaNode;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.AccessRestrictionType;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.RolePermissionType;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.utils.AttributesUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UaNodeImpl
extends AbstractUaNode {
    protected static final Logger logger = LoggerFactory.getLogger(UaNodeImpl.class);
    protected static final Map<Class<? extends UaNode>, List<UnsignedInteger>> supportedAttributesMap = new HashMap<Class<? extends UaNode>, List<UnsignedInteger>>();
    static final QualifiedName NODE_VERSION_PROPERTY_NAME = new QualifiedName("NodeVersion");
    private QualifiedName hl;
    private LocalizedText description = null;
    private LocalizedText hm = null;
    private NodeId nodeId;
    private RolePermissionType[] hn = null;
    private RolePermissionType[] ho = null;
    private AccessRestrictionType hp = null;
    private Map<QualifiedName, UaProperty> properties = null;
    private AttributeWriteMask hq = AttributeWriteMask.of();
    private AttributeWriteMask hr = AttributeWriteMask.of();
    protected final AddressSpace addressSpace;
    protected Set<UaReference> references = new HashSet<UaReference>();

    public UaNodeImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        this.nodeId = nodeId;
        this.hl = qualifiedName;
        this.setDisplayName(localizedText);
        this.addressSpace = addressSpace;
    }

    public UaNodeImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, AttributeWriteMask attributeWriteMask, AttributeWriteMask attributeWriteMask2, UaClientReference[] uaClientReferenceArray, UaProperty[] uaPropertyArray) {
        this(addressSpace, nodeId, qualifiedName, localizedText);
        this.setDescription(localizedText2);
        this.hr = attributeWriteMask;
        this.hq = attributeWriteMask2;
        this.references.addAll(Arrays.asList(uaClientReferenceArray));
        this.addProperties(uaPropertyArray);
    }

    public UaNodeImpl(AddressSpace addressSpace, NodeId nodeId, String string, Locale locale) {
        this(addressSpace, nodeId, new QualifiedName(nodeId.getNamespaceIndex(), string), new LocalizedText(string, locale));
    }

    protected UaNodeImpl(UaNode.Parameters parameters) {
        try {
            AddressSpace addressSpace = (AddressSpace)parameters.getAddressSpace();
            NodeId nodeId = parameters.getNodeId().asNodeId(addressSpace.getNamespaceTable());
            QualifiedName qualifiedName = QualifiedName.from(parameters.getBrowseName(), addressSpace.getNamespaceTable());
            this.nodeId = nodeId;
            this.hl = qualifiedName;
            this.setDisplayName(parameters.getDisplayName());
            this.addressSpace = addressSpace;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("ServerNode creation failed", exception);
        }
    }

    @Override
    public UaReference addComponent(UaNode uaNode) {
        return this.addReference(uaNode, Identifiers.HasComponent, false);
    }

    public void addProperties(UaProperty[] uaPropertyArray) {
        if (uaPropertyArray != null) {
            for (UaProperty uaProperty : uaPropertyArray) {
                this.addProperty(uaProperty);
            }
        }
    }

    @Override
    public UaReference addProperty(UaProperty uaProperty) {
        logger.debug("addProperty: property={}", (Object)uaProperty.getBrowseName());
        return this.addReference(uaProperty, Identifiers.HasProperty, false);
    }

    @Override
    public UaReference addReference(ExpandedNodeId expandedNodeId, NodeId nodeId, boolean bl) {
        ExpandedNodeId expandedNodeId2;
        try {
            expandedNodeId2 = this.getAddressSpace().getNamespaceTable().toExpandedNodeId(this.getNodeId());
        }
        catch (Exception exception) {
            expandedNodeId2 = new ExpandedNodeId(this.getNodeId());
        }
        ExpandedNodeId expandedNodeId3 = bl ? expandedNodeId : expandedNodeId2;
        ExpandedNodeId expandedNodeId4 = bl ? expandedNodeId2 : expandedNodeId;
        ExpandedNodeId expandedNodeId5 = expandedNodeId3;
        ExpandedNodeId expandedNodeId6 = expandedNodeId4;
        return this.addReference(new UaClientReference(nodeId, expandedNodeId5, expandedNodeId6, this.addressSpace));
    }

    @Override
    public UaReference addReference(NodeId nodeId, NodeId nodeId2, boolean bl) {
        ExpandedNodeId expandedNodeId;
        try {
            expandedNodeId = this.getAddressSpace().getNamespaceTable().toExpandedNodeId(nodeId);
        }
        catch (Exception exception) {
            expandedNodeId = new ExpandedNodeId(nodeId);
        }
        return this.addReference(expandedNodeId, nodeId2, bl);
    }

    @Override
    public UaReference addReference(UaNode uaNode, NodeId nodeId, boolean bl) {
        logger.debug("addReference: targetNode={}", (Object)uaNode);
        if (uaNode == null) {
            throw new NullPointerException("targetNode must not be null");
        }
        NodeId nodeId2 = bl ? uaNode.getNodeId() : this.getNodeId();
        NodeId nodeId3 = bl ? this.getNodeId() : uaNode.getNodeId();
        return this.addReference(new UaClientReference(nodeId, new ExpandedNodeId(nodeId2), new ExpandedNodeId(nodeId3), this.addressSpace));
    }

    @Override
    public UaReference deleteReference(ExpandedNodeId expandedNodeId, NodeId nodeId, boolean bl) {
        logger.debug("deleteReference targetNodeId : {}", (Object)expandedNodeId);
        ArrayList<UaReference> arrayList = new ArrayList<UaReference>();
        for (UaReference uaReference : this.references) {
            Comparable<ExpandedNodeId> comparable;
            Comparable<ExpandedNodeId> comparable2 = bl ? this.nodeId : expandedNodeId;
            Comparable<ExpandedNodeId> comparable3 = comparable = bl ? expandedNodeId : this.nodeId;
            if (!uaReference.getReferenceTypeId().equals(nodeId) || !uaReference.getTargetId().equals(comparable2) || !uaReference.getSourceId().equals(comparable)) continue;
            arrayList.add(uaReference);
        }
        this.references.removeAll(arrayList);
        return arrayList.isEmpty() ? null : (UaReference)arrayList.get(0);
    }

    @Override
    public UaReference deleteReference(NodeId nodeId, NodeId nodeId2, boolean bl) {
        return this.deleteReference(new ExpandedNodeId(nodeId), nodeId2, bl);
    }

    @Override
    public UaReference deleteReference(UaNode uaNode, NodeId nodeId, boolean bl) {
        return this.deleteReference(uaNode.getNodeId(), nodeId, bl);
    }

    @Override
    public UaReference deleteReference(UaReference uaReference) {
        if (this.references.remove(uaReference)) {
            this.afterDeleteReference(uaReference);
            return uaReference;
        }
        return null;
    }

    public void deleteReferences(NodeId nodeId) {
        logger.debug("deleteReferences targetNodeId : {}", (Object)nodeId);
        ArrayList<UaReference> arrayList = new ArrayList<UaReference>();
        for (UaReference uaReference : this.references) {
            if (!uaReference.getTargetId().equals(nodeId) && !uaReference.getSourceId().equals(nodeId)) continue;
            arrayList.add(uaReference);
        }
        this.references.removeAll(arrayList);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaNode uaNode = (UaNode)object;
        if (NodeId.isNull(this.nodeId)) {
            return NodeId.isNull(uaNode.getNodeId());
        }
        return this.nodeId.equals(uaNode.getNodeId());
    }

    @Override
    public AddressSpace getAddressSpace() {
        return this.addressSpace;
    }

    @Override
    public Map<UnsignedInteger, Object> getAttributesMap() {
        HashMap<UnsignedInteger, Object> hashMap = new HashMap<UnsignedInteger, Object>();
        this.getAttributesMap(hashMap);
        hashMap.replaceAll((unsignedInteger, object) -> StructureUtils.clone(object));
        return Collections.unmodifiableMap(hashMap);
    }

    @Override
    public QualifiedName getBrowseName() {
        return this.hl;
    }

    @Override
    public UaNode getComponent(QualifiedName qualifiedName) {
        for (UaReference uaReference : this.getReferences(Identifiers.HasComponent, false)) {
            UaNode uaNode = uaReference.getTargetNode();
            if (uaNode == null || !qualifiedName.equals(uaNode.getBrowseName())) continue;
            return uaNode;
        }
        return null;
    }

    @Override
    public UaNode[] getComponents() {
        UaReference[] uaReferenceArray = this.getReferences(Identifiers.HasComponent, false);
        if (uaReferenceArray == null || uaReferenceArray.length == 0) {
            return new UaNode[0];
        }
        try {
            ArrayList<NodeId> arrayList = new ArrayList<NodeId>(uaReferenceArray.length);
            for (UaReference uaReference : uaReferenceArray) {
                arrayList.add(this.getAddressSpace().getNamespaceTable().toNodeId(uaReference.getTargetId()));
            }
            InternalGetNodesResults internalGetNodesResults = InternalAddressSpaceAccessHelper.internalGetNodesWithNodeIds(false, this.getAddressSpace(), new HashSet<NodeId>(arrayList));
            ArrayList<UaNode> arrayList2 = new ArrayList<UaNode>(uaReferenceArray.length);
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                arrayList2.add(internalGetNodesResults.getNode((NodeId)arrayList.get(i2)));
            }
            return arrayList2.toArray(new UaNode[0]);
        }
        catch (Exception exception) {
            logger.warn("Cannot use AddressSpace.getNodes within getComponents, reverting to individual getNode operations", exception);
            ArrayList<UaNode> arrayList = new ArrayList<UaNode>(uaReferenceArray.length);
            for (UaReference uaReference : uaReferenceArray) {
                arrayList.add(uaReference.getTargetNode());
            }
            return arrayList.toArray(new UaNode[0]);
        }
    }

    @Override
    public LocalizedText getDescription() {
        return this.getDescription(null);
    }

    public LocalizedText getDescription(Locale locale) {
        return this.description;
    }

    @Override
    public LocalizedText getDisplayName() {
        return this.getDisplayName(null);
    }

    public LocalizedText getDisplayName(Locale locale) {
        return this.hm;
    }

    @Override
    public UaMethod getMethod(QualifiedName qualifiedName) {
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public NodeClass getNodeClass() {
        return null;
    }

    @Override
    public NodeId getNodeId() {
        return this.nodeId;
    }

    public String getNodeVersion() {
        UaProperty uaProperty = this.getNodeVersionNode();
        DataValue dataValue = uaProperty == null ? null : uaProperty.getValue();
        return dataValue == null || dataValue.isNull() ? null : dataValue.getValue().toString();
    }

    @Override
    public UaProperty getNodeVersionNode() {
        return this.getProperty(NODE_VERSION_PROPERTY_NAME);
    }

    @Override
    public UaProperty[] getProperties() {
        if (this.properties == null) {
            return null;
        }
        return this.properties.values().toArray(new UaProperty[0]);
    }

    @Override
    public UaProperty getProperty(QualifiedName qualifiedName) {
        if (this.properties == null) {
            return null;
        }
        logger.debug("getProperty: name={}", (Object)qualifiedName);
        return this.properties.get(qualifiedName);
    }

    public DataValue getPropertyValue(QualifiedName qualifiedName) throws StatusException {
        UaProperty uaProperty = this.getProperty(qualifiedName);
        if (uaProperty == null) {
            throw new IllegalArgumentException("Property " + qualifiedName + " does not exist.");
        }
        return uaProperty.getValue();
    }

    @Override
    public UaReference getReference(NodeId nodeId, boolean bl) {
        for (UaReference uaReference : this.references) {
            if (!NodeId.isNull(nodeId) && !uaReference.getReferenceTypeId().equals(nodeId) || uaReference.getIsInverse(this) != bl) continue;
            return uaReference;
        }
        return null;
    }

    @Override
    public UaReference[] getReferences(NodeId nodeId, boolean bl) {
        ArrayList<UaReference> arrayList = new ArrayList<UaReference>();
        for (UaReference uaReference : this.references) {
            UaReferenceType uaReferenceType;
            if (!NodeId.isNull(nodeId) && ((uaReferenceType = uaReference.getReferenceType()) == null ? !uaReference.getReferenceTypeId().equals(nodeId) : !uaReferenceType.inheritsFrom(nodeId)) || uaReference.getIsInverse(this) != bl) continue;
            arrayList.add(uaReference);
        }
        return arrayList.toArray(new UaReference[arrayList.size()]);
    }

    @Override
    public UnsignedInteger[] getSupportedAttributes() {
        List<UnsignedInteger> list = this.cjE();
        return list.toArray(new UnsignedInteger[list.size()]);
    }

    @Override
    public AttributeWriteMask getUserWriteMask() {
        return this.hq;
    }

    @Override
    public AttributeWriteMask getWriteMask() {
        return this.hr;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return n3;
    }

    public boolean hasProperty(QualifiedName qualifiedName) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(qualifiedName);
    }

    public boolean hasTypeDefinition() {
        return false;
    }

    @Override
    public boolean hasUserWriteAccess(UnsignedInteger unsignedInteger) {
        return AttributesUtil.hasAccessToAttribute(this.hq, unsignedInteger);
    }

    @Override
    public boolean hasWriteAccess(UnsignedInteger unsignedInteger) {
        return AttributesUtil.hasAccessToAttribute(this.hr, unsignedInteger);
    }

    @Override
    public DataValue readAttribute(UnsignedInteger unsignedInteger) {
        DataValue dataValue = new DataValue();
        this.readAttribute(unsignedInteger, dataValue, null);
        return dataValue;
    }

    @Override
    public final void readAttribute(UnsignedInteger unsignedInteger, DataValue dataValue, Locale locale) {
        try {
            this.a(unsignedInteger, dataValue, locale);
        }
        catch (StatusException statusException) {
            dataValue.setStatusCode(statusException.getStatusCode());
        }
    }

    @Override
    public UaNode removeComponent(UaNode uaNode) {
        UaReference uaReference = this.deleteReference(uaNode, Identifiers.HasComponent, false);
        return uaReference == null ? null : uaNode;
    }

    @Override
    public UaProperty removeProperty(QualifiedName qualifiedName) {
        UaProperty uaProperty = this.properties.get(qualifiedName);
        this.deleteReference(uaProperty, Identifiers.HasProperty, false);
        return uaProperty;
    }

    @Override
    public void setAttribute(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (dataValue == null) {
            logger.warn("dataValue=null");
            this.writeAttributeValue(unsignedInteger, null, StatusCode.BAD, null, null);
        } else {
            Object object = dataValue.getStatusCode().isBad() || dataValue.isNull() ? null : dataValue.getValue().getValue();
            this.writeAttributeValue(unsignedInteger, object, dataValue.getStatusCode(), dataValue.getSourceTimestamp(), dataValue.getSourcePicoseconds());
        }
    }

    @Override
    public void setAttributes(NodeAttributes nodeAttributes) {
        this.setDescription(nodeAttributes.getDescription());
    }

    @Override
    public void setBrowseName(QualifiedName qualifiedName) {
        this.hl = qualifiedName;
    }

    @Override
    public void setDescription(LocalizedText localizedText) {
        this.description = LocalizedText.merge(this.description, localizedText);
    }

    @Override
    public void setDisplayName(LocalizedText localizedText) {
        this.hm = LocalizedText.merge(this.hm, localizedText);
    }

    public void setPropertyValue(QualifiedName qualifiedName, Object object) throws StatusException, IllegalArgumentException {
        DataValue dataValue;
        UaProperty uaProperty = this.getProperty(qualifiedName);
        if (uaProperty == null) {
            throw new IllegalArgumentException("Property " + qualifiedName + " does not exist.");
        }
        if (object instanceof DataValue) {
            dataValue = (DataValue)object;
        } else {
            Variant variant = object instanceof Variant ? (Variant)object : new Variant(object);
            dataValue = new DataValue(variant);
        }
        uaProperty.setValue(dataValue);
    }

    @Override
    public void setReferences(UaReference[] uaReferenceArray) {
        this.references.clear();
        this.references.addAll(Arrays.asList(uaReferenceArray));
    }

    @Override
    public void setUserWriteMask(AttributeWriteMask attributeWriteMask) {
        this.hq = attributeWriteMask;
    }

    @Override
    public void setWriteMask(AttributeWriteMask attributeWriteMask) {
        this.hr = attributeWriteMask;
    }

    @Override
    public boolean supportsAttribute(UnsignedInteger unsignedInteger) {
        return this.cjE().contains(unsignedInteger);
    }

    public String toString() {
        return String.format(Locale.ROOT, "NodeId=%s, NodeClass=%s, BrowseName=%s", this.nodeId, this.getNodeClass(), this.hl);
    }

    @Override
    public final boolean writeAttribute(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (!this.supportsAttribute(unsignedInteger)) {
            throw new StatusException(String.format(Locale.ROOT, "Attribute '%s' not supported by node type '%s'", AttributesUtil.toString(unsignedInteger), this.getClass()), StatusCodes.Bad_AttributeIdInvalid);
        }
        if (!this.hasWriteAccess(unsignedInteger)) {
            throw new StatusException(String.format(Locale.ROOT, "Attribute '%s' not writable in node '%s(ID=%s)'", AttributesUtil.toString(unsignedInteger), this.getClass(), this.getNodeId()), StatusCodes.Bad_NotWritable);
        }
        try {
            this.setAttribute(unsignedInteger, dataValue);
        }
        catch (ClassCastException classCastException) {
            throw new StatusException("Write failed", StatusCodes.Bad_TypeMismatch);
        }
        return true;
    }

    private List<UnsignedInteger> cjE() {
        List<UnsignedInteger> list = supportedAttributesMap.get(this.getClass());
        if (list == null) {
            list = new ArrayList<UnsignedInteger>();
            this.initSupportedAttributes(list);
            supportedAttributesMap.put(this.getClass(), list);
        }
        return list;
    }

    private void a(UnsignedInteger unsignedInteger, DataValue dataValue, Locale locale) throws StatusException {
        if (unsignedInteger.equals(Attributes.DisplayName)) {
            dataValue.setValue(new Variant(this.getDisplayName(locale)));
        } else if (unsignedInteger.equals(Attributes.Description)) {
            dataValue.setValue(new Variant(this.getDescription(locale)));
        } else {
            this.readAttributeValue(unsignedInteger, dataValue);
        }
    }

    protected UaReference addReference(UaReference uaReference) {
        logger.debug("addReference: {}", (Object)uaReference);
        if (this.references.contains(uaReference)) {
            return this.getReference(uaReference.getReferenceTypeId(), uaReference.getIsInverse(this));
        }
        if (!(uaReference instanceof UaClientReference)) {
            throw new IllegalArgumentException("UaNodeImpl.addReference() requires an instance of UaClientReference");
        }
        if (!this.beforeAddReference(uaReference)) {
            return null;
        }
        boolean bl = this.references.add(uaReference);
        logger.debug("result: {}", (Object)bl);
        this.afterAddReference(uaReference);
        return uaReference;
    }

    protected void afterAddReference(UaReference uaReference) {
    }

    protected void afterDeleteReference(UaReference uaReference) {
        UaNode uaNode = uaReference.getTargetNode();
        if (uaNode != null && this.properties != null && uaReference.getReferenceTypeId().equals(Identifiers.HasProperty)) {
            this.properties.remove(uaNode.getBrowseName());
        }
    }

    protected void assertTypeSupport(ExpandedNodeId expandedNodeId) {
        if (expandedNodeId != null && this.getNodeClass() != NodeClass.Object && this.getNodeClass() != NodeClass.Variable) {
            throw new IllegalArgumentException("Type definitions are only available for the NodeClasses Object and Variable");
        }
    }

    protected void assertTypeSupport(NodeId nodeId) {
        if (nodeId != null && this.getNodeClass() != NodeClass.Object && this.getNodeClass() != NodeClass.Variable) {
            throw new IllegalArgumentException("Type definitions are only available for the NodeClasses Object and Variable");
        }
    }

    protected boolean beforeAddReference(UaReference uaReference) {
        if (uaReference.getReferenceTypeId().equals(Identifiers.HasProperty) && !uaReference.getIsInverse(this)) {
            UaNode uaNode = uaReference.getTargetNode();
            if (uaNode instanceof UaProperty) {
                return this.doAddProperty((UaProperty)uaNode);
            }
            logger.warn("Target of HasProperty (Source=" + this.getBrowseName() + "--Target=" + (uaNode == null ? "null" : uaNode.getBrowseName()) + ") reference is not UaProperty (i.e. TypeDefinition does not refer to PropertyType)");
        }
        return true;
    }

    protected boolean doAddProperty(UaProperty uaProperty) {
        logger.debug("doAddProperty: {}", (Object)uaProperty);
        if (uaProperty != null) {
            if (this.properties == null) {
                this.properties = new HashMap<QualifiedName, UaProperty>();
            }
            if (this.properties.containsKey(uaProperty.getBrowseName())) {
                return false;
            }
            this.properties.put(uaProperty.getBrowseName(), uaProperty);
            return true;
        }
        return false;
    }

    protected <T extends UaNode> List<T> findPlaceholders(Class<T> clazz, ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2) {
        try {
            NodeId nodeId;
            UaNode uaNode = this.getAddressSpace().getNode(expandedNodeId);
            NodeClass nodeClass = uaNode.getNodeClass();
            UaType uaType = null;
            if (uaNode instanceof UaInstance) {
                uaType = ((UaInstance)uaNode).getTypeDefinition();
            }
            try {
                nodeId = this.getAddressSpace().getNamespaceTable().toNodeId(expandedNodeId2);
            }
            catch (ServiceResultException serviceResultException) {
                throw new StatusException(serviceResultException);
            }
            UaReference[] uaReferenceArray = this.getForwardReferences(nodeId);
            ArrayList<T> arrayList = new ArrayList<T>();
            for (UaReference uaReference : uaReferenceArray) {
                UaType uaType2;
                UaNode uaNode2 = uaReference.getOppositeNode(this);
                if (uaNode2 == null) {
                    logger.debug("searchPlaceholders: Ignoring null UaNode reference target");
                    continue;
                }
                if (uaNode2.getNodeClass() != nodeClass || uaType != null && uaNode2 instanceof UaInstance && !(uaType2 = ((UaInstance)uaNode2).getTypeDefinition()).inheritsFrom(uaType) || !clazz.isAssignableFrom(uaNode2.getClass())) continue;
                arrayList.add(clazz.cast(uaNode2));
            }
            return Collections.unmodifiableList(arrayList);
        }
        catch (UaException uaException) {
            logger.warn("Unable to find nodes that are defined via a XXXHasPlaceHolder ModellingRule", uaException);
            return null;
        }
    }

    protected NodeAttributes getAttributes(NodeAttributes nodeAttributes) {
        nodeAttributes.setDescription(this.getDescription());
        nodeAttributes.setDisplayName(this.getDisplayName());
        nodeAttributes.setWriteMask((UnsignedInteger)this.getWriteMask().asBuiltInType());
        nodeAttributes.setUserWriteMask((UnsignedInteger)this.getUserWriteMask().asBuiltInType());
        return nodeAttributes;
    }

    protected void getAttributesMap(Map<UnsignedInteger, Object> map) {
        map.put(Attributes.NodeId, this.getNodeId());
        map.put(Attributes.NodeClass, this.getNodeClass());
        map.put(Attributes.Description, this.getDescription());
        map.put(Attributes.DisplayName, this.getDisplayName());
    }

    @Override
    protected Collection<UaReference> getReferenceList() {
        return this.references;
    }

    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        list.addAll(Arrays.asList(Attributes.NodeId, Attributes.NodeClass, Attributes.BrowseName, Attributes.DisplayName, Attributes.Description, Attributes.WriteMask, Attributes.UserWriteMask));
        if (this.getAddressSpace().isRead104Attributes()) {
            list.addAll(Arrays.asList(Attributes.RolePermissions, Attributes.UserRolePermissions, Attributes.AccessRestrictions));
        }
    }

    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals(Attributes.NodeId)) {
            dataValue.setValue(new Variant(this.getNodeId()));
        } else if (unsignedInteger.equals(Attributes.NodeClass)) {
            Integer n2 = this.getNodeClass().getValue();
            dataValue.setValue(new Variant(n2));
        } else if (unsignedInteger.equals(Attributes.BrowseName)) {
            dataValue.setValue(new Variant(this.getBrowseName()));
        } else if (unsignedInteger.equals(Attributes.DisplayName)) {
            dataValue.setValue(new Variant(this.getDisplayName()));
        } else if (unsignedInteger.equals(Attributes.Description)) {
            dataValue.setValue(new Variant(this.getDescription()));
        } else if (unsignedInteger.equals(Attributes.WriteMask)) {
            dataValue.setValue(new Variant(this.getWriteMask().asBuiltInType()));
        } else if (unsignedInteger.equals(Attributes.UserWriteMask)) {
            dataValue.setValue(new Variant(this.getUserWriteMask().asBuiltInType()));
        } else if (Attributes.RolePermissions.equals(unsignedInteger)) {
            dataValue.setValue(new Variant(this.hn));
        } else if (Attributes.UserRolePermissions.equals(unsignedInteger)) {
            dataValue.setValue(new Variant(this.ho));
        } else if (Attributes.AccessRestrictions.equals(unsignedInteger)) {
            dataValue.setValue(new Variant(this.hp));
        } else {
            throw new StatusException(StatusCodes.Bad_AttributeIdInvalid);
        }
    }

    @Override
    protected boolean referenceTypeInherits(NodeId nodeId, NodeId ... nodeIdArray) {
        if (nodeIdArray == null || nodeIdArray.length == 0) {
            return true;
        }
        try {
            UaReferenceType uaReferenceType = (UaReferenceType)this.addressSpace.getType(nodeId);
            return this.referenceTypeInherits(uaReferenceType, nodeIdArray);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (Exception exception) {
            logger.warn("referenceTypeInherits: Could not resolve type nodes from address space, falling back to checking raw typeids", exception);
            for (NodeId nodeId2 : nodeIdArray) {
                if (!nodeId.equals(nodeId2)) continue;
                return true;
            }
            return false;
        }
    }

    protected void setNodeVersion(String string) throws StatusException {
        this.setPropertyValue(NODE_VERSION_PROPERTY_NAME, string);
    }

    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        logger.debug("writeAttributeValue attributeId={} value={}", (Object)unsignedInteger, object);
        if (unsignedInteger.equals(Attributes.NodeId)) {
            this.nodeId = (NodeId)object;
        } else {
            if (unsignedInteger.equals(Attributes.NodeClass)) {
                throw new StatusException(StatusCodes.Bad_WriteNotSupported);
            }
            if (unsignedInteger.equals(Attributes.BrowseName)) {
                this.hl = (QualifiedName)object;
            } else if (unsignedInteger.equals(Attributes.DisplayName)) {
                this.setDisplayName((LocalizedText)object);
            } else if (unsignedInteger.equals(Attributes.Description)) {
                this.setDescription((LocalizedText)object);
            } else if (unsignedInteger.equals(Attributes.WriteMask)) {
                this.hr = object == null ? AttributeWriteMask.of() : (object.getClass().equals(AttributeWriteMask.class) ? (AttributeWriteMask)object : AttributeWriteMask.of((UnsignedInteger)object));
            } else if (unsignedInteger.equals(Attributes.UserWriteMask)) {
                this.hq = object == null ? AttributeWriteMask.of() : (object.getClass().equals(AttributeWriteMask.class) ? (AttributeWriteMask)object : AttributeWriteMask.of((UnsignedInteger)object));
            } else if (Attributes.RolePermissions.equals(unsignedInteger)) {
                this.hn = (RolePermissionType[])StructureUtils.fixEmptyStructureArrayType(RolePermissionType.class, (Variant)new Variant(object));
            } else if (Attributes.UserRolePermissions.equals(unsignedInteger)) {
                this.ho = (RolePermissionType[])StructureUtils.fixEmptyStructureArrayType(RolePermissionType.class, (Variant)new Variant(object));
            } else if (Attributes.AccessRestrictions.equals(unsignedInteger)) {
                if (object instanceof UnsignedInteger) {
                    logger.warn("Incorrect Attribute value for AccessRestriction Attribute, UInt32 when expecting UInt16, node:{}", (Object)this.getNodeId());
                    object = UnsignedShort.valueOf(((UnsignedInteger)object).longValue());
                }
                this.hp = object == null ? AccessRestrictionType.of() : (object.getClass().equals(AccessRestrictionType.class) ? (AccessRestrictionType)object : AccessRestrictionType.of((UnsignedShort)object));
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Invalid attribute {" + this.getClass() + "}: " + AttributesUtil.toString(unsignedInteger));
                }
                throw new StatusException(StatusCodes.Bad_AttributeIdInvalid);
            }
        }
    }
}

