/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client.nodes;

import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaClientReference
extends UaReference {
    private static Logger logger = LoggerFactory.getLogger(UaClientReference.class);
    private final AddressSpace addressSpace;
    private final NodeId eb;
    private final ExpandedNodeId hf;
    private final ExpandedNodeId hg;

    public UaClientReference(NodeId nodeId, ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2, AddressSpace addressSpace) {
        this.eb = nodeId;
        this.hg = expandedNodeId2;
        this.hf = expandedNodeId;
        this.addressSpace = addressSpace;
    }

    public UaClientReference(NodeId nodeId, UaNode uaNode, UaNode uaNode2, AddressSpace addressSpace) {
        this(nodeId, new ExpandedNodeId(uaNode.getNodeId()), new ExpandedNodeId(uaNode2.getNodeId()), addressSpace);
    }

    @Override
    public void delete() {
        UaNode uaNode = this.getSourceNode();
        UaNode uaNode2 = this.getTargetNode();
        if (uaNode != null) {
            uaNode.deleteReference(this);
        }
        if (uaNode2 != null) {
            uaNode2.deleteReference(this);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaClientReference uaClientReference = (UaClientReference)object;
        if (this.hg == null ? uaClientReference.hg != null : !this.addressSpace.getNamespaceTable().nodeIdEquals(this.hg, uaClientReference.hg)) {
            return false;
        }
        if (this.hf == null ? uaClientReference.hf != null : !this.addressSpace.getNamespaceTable().nodeIdEquals(this.hf, uaClientReference.hf)) {
            return false;
        }
        return !(this.eb == null ? uaClientReference.eb != null : !this.eb.equals(uaClientReference.eb));
    }

    @Override
    public boolean getIsInverse(NodeId nodeId) {
        logger.debug("getIsInverse: nodeId={} sourceId={} targetId={}", nodeId, this.hf, this.hg);
        if (this.addressSpace.getNamespaceTable().nodeIdEquals(nodeId, this.hf)) {
            return false;
        }
        if (this.addressSpace.getNamespaceTable().nodeIdEquals(nodeId, this.hg)) {
            return true;
        }
        throw new RuntimeException("getIsInverse() called from non-related node");
    }

    @Override
    public boolean getIsInverse(UaNode uaNode) {
        return this.getIsInverse(uaNode.getNodeId());
    }

    @Override
    public UaReferenceType getReferenceType() {
        UaNode uaNode = this.f(this.eb);
        if (uaNode instanceof UaReferenceType) {
            return (UaReferenceType)uaNode;
        }
        return null;
    }

    @Override
    public NodeId getReferenceTypeId() {
        return this.eb;
    }

    @Override
    public ExpandedNodeId getSourceId() {
        return this.hf;
    }

    @Override
    public UaNode getSourceNode() {
        UaNode uaNode = this.a(this.hf);
        return uaNode;
    }

    @Override
    public ExpandedNodeId getTargetId() {
        return this.hg;
    }

    @Override
    public UaNode getTargetNode() {
        UaNode uaNode = this.a(this.hg);
        return uaNode;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.eb == null ? 0 : this.eb.hashCode());
        n3 = 31 * n3 + (this.hg == null ? 0 : this.hg.hashCode());
        n3 = 31 * n3 + (this.hf == null ? 0 : this.hf.hashCode());
        return n3;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append(" ReferenceTypeId=");
        stringBuilder.append(this.getReferenceTypeId());
        stringBuilder.append(" SourceId=");
        stringBuilder.append(this.getSourceId());
        stringBuilder.append(" TargetId=");
        stringBuilder.append(this.getTargetId());
        return stringBuilder.toString();
    }

    private UaNode a(ExpandedNodeId expandedNodeId) {
        try {
            return this.f(this.addressSpace.getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (Exception exception) {
            logger.warn("Unable to retrieve node from AddressSpace: ", exception);
            return null;
        }
    }

    private UaNode f(NodeId nodeId) {
        try {
            return this.addressSpace.getNode(nodeId);
        }
        catch (Exception exception) {
            logger.warn("Unable to retrieve node from AddressSpace: ", exception);
            return null;
        }
    }
}

