/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.client.MonitoredItemErrorListener;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MonitoringFilterResult;
import com.prosysopc.ua.stack.core.MonitoringMode;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MonitoredItem
extends MonitoredItemBase {
    private static AtomicInteger fb = new AtomicInteger(0);
    protected static final Logger logger = LoggerFactory.getLogger(MonitoredItem.class);
    private StatusCode fc;
    private ExpandedNodeId fd;
    private boolean modified;
    private boolean fe;
    private Subscription ff;
    private StatusCode fg = null;
    private volatile MonitoredItemErrorListener fh = null;

    private static UnsignedInteger ciI() {
        return UnsignedInteger.valueOf(fb.incrementAndGet());
    }

    protected MonitoredItem(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode) {
        super(MonitoredItem.ciI(), null, null, unsignedInteger, monitoringMode);
        this.fd = expandedNodeId;
    }

    protected MonitoredItem(NodeId nodeId, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode) {
        super(MonitoredItem.ciI(), null, nodeId, unsignedInteger, monitoringMode);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            MonitoredItem monitoredItem = (MonitoredItem)object;
            return this.ff == monitoredItem.ff;
        }
        return false;
    }

    public StatusCode getErrorCode() {
        return this.fc;
    }

    public MonitoredItemErrorListener getErrorListener() {
        return this.fh;
    }

    public ExpandedNodeId getExpandedNodeId() {
        return this.fd;
    }

    public StatusCode getInitialStatus() {
        return this.fg;
    }

    @Override
    public NodeId getNodeId() {
        if (this.fd != null) {
            try {
                return this.getSubscription().getClient().getNamespaceTable().toNodeId(this.fd);
            }
            catch (ServiceResultException serviceResultException) {
                throw new RuntimeException(serviceResultException);
            }
        }
        return super.getNodeId();
    }

    public Subscription getSubscription() {
        return this.ff;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isMonitoringModeModified() {
        return this.fe;
    }

    public void setErrorListener(MonitoredItemErrorListener monitoredItemErrorListener) {
        this.fh = monitoredItemErrorListener;
    }

    protected void clearModified() {
        this.modified = false;
    }

    protected void clearMonitoringModeModified() {
        this.fe = false;
    }

    protected void fireError(StatusCode statusCode) {
        MonitoredItemErrorListener monitoredItemErrorListener = this.fh;
        if (monitoredItemErrorListener != null) {
            monitoredItemErrorListener.onError(this, statusCode);
        }
    }

    @Override
    protected String getNodeIdAsString() {
        if (this.fd != null) {
            return this.fd.toString();
        }
        return super.getNodeIdAsString();
    }

    protected void itemChanged() throws ServiceException {
        if (this.ff != null) {
            if (this.ff.isConnected()) {
                this.modified = true;
            }
            this.ff.itemChanged(this);
        }
    }

    @Override
    protected void monitoringModeChanged() throws ServiceException {
        super.monitoringModeChanged();
        if (this.ff != null) {
            if (this.ff.isConnected()) {
                this.fe = true;
            }
            this.ff.monitoringModeChanged(this);
        }
    }

    protected void setClientHandle(int n2) {
        this.clientHandle = UnsignedInteger.valueOf(n2);
    }

    protected void setErrorCode(StatusCode statusCode) {
        StatusCode statusCode2 = this.fc;
        this.fc = statusCode;
        if (this.fg == null) {
            this.fg = statusCode;
        }
        if (!Objects.equals(statusCode, statusCode2)) {
            this.fireError(statusCode);
        }
    }

    @Override
    protected void setFilterResult(MonitoringFilterResult monitoringFilterResult) {
        super.setFilterResult(monitoringFilterResult);
    }

    @Override
    protected void setMonitoredItemId(UnsignedInteger unsignedInteger) {
        super.setMonitoredItemId(unsignedInteger);
    }

    protected void setRevisedQueueSize(UnsignedInteger unsignedInteger) {
        this.queueSize = unsignedInteger.longValue();
    }

    @Override
    protected void updateFilter() throws ServiceException {
        super.updateFilter();
        this.itemChanged();
    }

    @Override
    protected void updateQueue() throws ServiceException {
        super.updateQueue();
        this.itemChanged();
    }

    void a(Subscription subscription) {
        this.ff = subscription;
    }
}

