/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.RelativePathElement;
import java.util.Objects;

public final class UaRelativePathElement {
    private final UaNodeId dM;
    private final Boolean dN;
    private final Boolean dO;
    private final UaQualifiedName dP;

    public static Builder builder() {
        return new Builder();
    }

    public static UaRelativePathElement from(RelativePathElement relativePathElement, NamespaceTable namespaceTable) {
        InternalArguments.checkNotNull(namespaceTable, "namespaceTable");
        if (relativePathElement == null) {
            return null;
        }
        Builder builder = UaRelativePathElement.builder();
        builder.setIncludeSubtypes(relativePathElement.getIncludeSubtypes());
        builder.setIsInverse(relativePathElement.getIsInverse());
        builder.setReferenceTypeId(UaNodeId.fromLocal(relativePathElement.getReferenceTypeId(), namespaceTable));
        builder.setTargetName(UaQualifiedName.from(relativePathElement.getTargetName(), namespaceTable));
        return builder.build();
    }

    private UaRelativePathElement(UaNodeId uaNodeId, Boolean bl, Boolean bl2, UaQualifiedName uaQualifiedName) {
        this.dM = uaNodeId;
        this.dN = bl;
        this.dO = bl2;
        this.dP = uaQualifiedName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UaRelativePathElement)) {
            return false;
        }
        UaRelativePathElement uaRelativePathElement = (UaRelativePathElement)object;
        return Objects.equals(this.dO, uaRelativePathElement.dO) && Objects.equals(this.dN, uaRelativePathElement.dN) && Objects.equals(this.dM, uaRelativePathElement.dM) && Objects.equals(this.dP, uaRelativePathElement.dP);
    }

    public Boolean getIncludeSubtypes() {
        return this.dO;
    }

    public Boolean getIsInverse() {
        return this.dN;
    }

    public UaNodeId getReferenceTypeId() {
        return this.dM;
    }

    public UaQualifiedName getTargetName() {
        return this.dP;
    }

    public int hashCode() {
        return Objects.hash(this.dO, this.dN, this.dM, this.dP);
    }

    public Builder toBuilder() {
        Builder builder = UaRelativePathElement.builder();
        builder.setIncludeSubtypes(this.dO);
        builder.setIsInverse(this.dN);
        builder.setReferenceTypeId(this.dM);
        builder.setTargetName(this.dP);
        return builder;
    }

    public RelativePathElement toRelativePathElement(NamespaceTable namespaceTable) {
        RelativePathElement.Builder builder = RelativePathElement.builder();
        builder.setIncludeSubtypes(this.dO);
        builder.setIsInverse(this.dN);
        builder.setReferenceTypeId(NodeId.from(this.dM, namespaceTable));
        builder.setTargetName(QualifiedName.from(this.dP, namespaceTable));
        return builder.build();
    }

    public String toString() {
        return "UaRelativePathElement [referenceTypeId=" + this.dM + ", isInverse=" + this.dN + ", includeSubtypes=" + this.dO + ", targetName=" + this.dP + "]";
    }

    public static final class Builder {
        private UaNodeId dM;
        private Boolean dN;
        private Boolean dO;
        private UaQualifiedName dP;

        private Builder() {
        }

        public UaRelativePathElement build() {
            return new UaRelativePathElement(this.dM, this.dN, this.dO, this.dP);
        }

        public Boolean getIncludeSubtypes() {
            return this.dO;
        }

        public Boolean getIsInverse() {
            return this.dN;
        }

        public UaNodeId getReferenceTypeId() {
            return this.dM;
        }

        public UaQualifiedName getTargetName() {
            return this.dP;
        }

        public Builder setIncludeSubtypes(Boolean bl) {
            this.dO = bl;
            return this;
        }

        public Builder setIsInverse(Boolean bl) {
            this.dN = bl;
            return this;
        }

        public Builder setReferenceTypeId(UaNodeId uaNodeId) {
            this.dM = uaNodeId;
            return this;
        }

        public Builder setTargetName(UaQualifiedName uaQualifiedName) {
            this.dP = uaQualifiedName;
            return this;
        }
    }
}

