/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.core.RelativePathElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class UaRelativeNamePath {
    private static final UaQualifiedName[] dL = new UaQualifiedName[0];
    public static UaRelativeNamePath EMPTY = new UaRelativeNamePath(new UaQualifiedName[0]);
    public final List<UaQualifiedName> elements;

    public static UaRelativeNamePath from(NamespaceTable namespaceTable, QualifiedName ... qualifiedNameArray) {
        if (namespaceTable == null) {
            throw new IllegalArgumentException("The given namespace table cannot be null");
        }
        if (qualifiedNameArray == null) {
            throw new IllegalArgumentException("The given elements cannot be null");
        }
        ArrayList<UaQualifiedName> arrayList = new ArrayList<UaQualifiedName>();
        for (QualifiedName qualifiedName : qualifiedNameArray) {
            arrayList.add(UaQualifiedName.from(qualifiedName, namespaceTable));
        }
        return UaRelativeNamePath.from(arrayList.toArray(dL));
    }

    public static UaRelativeNamePath from(UaNamespace uaNamespace, String ... stringArray) {
        if (uaNamespace == null) {
            throw new IllegalArgumentException("The given namespace cannot be null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("The given elementNames cannot be null");
        }
        ArrayList<UaQualifiedName> arrayList = new ArrayList<UaQualifiedName>();
        for (String string : stringArray) {
            arrayList.add(UaQualifiedName.from(uaNamespace.getURI(), string));
        }
        return UaRelativeNamePath.from(arrayList.toArray(dL));
    }

    public static UaRelativeNamePath from(UaQualifiedName ... uaQualifiedNameArray) {
        return new UaRelativeNamePath(uaQualifiedNameArray);
    }

    public static UaRelativeNamePath standard(String ... stringArray) {
        return UaRelativeNamePath.from(UaNamespace.STANDARD, stringArray);
    }

    private UaRelativeNamePath(List<UaQualifiedName> list) {
        if (list == null) {
            throw new IllegalArgumentException("The given elements cannot be null");
        }
        this.elements = Collections.unmodifiableList(list);
    }

    private UaRelativeNamePath(UaQualifiedName ... uaQualifiedNameArray) {
        if (uaQualifiedNameArray == null) {
            throw new IllegalArgumentException("The given elements cannot be null");
        }
        this.elements = Collections.unmodifiableList(Arrays.asList(uaQualifiedNameArray));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UaRelativeNamePath)) {
            return false;
        }
        UaRelativeNamePath uaRelativeNamePath = (UaRelativeNamePath)object;
        return Objects.equals(this.elements, uaRelativeNamePath.elements);
    }

    public List<UaQualifiedName> getElements() {
        return this.elements;
    }

    public int hashCode() {
        return Objects.hash(this.elements);
    }

    public RelativePath toRelativePath(NamespaceTable namespaceTable, ExpandedNodeId expandedNodeId, boolean bl, boolean bl2) {
        NodeId nodeId;
        if (namespaceTable == null) {
            throw new IllegalArgumentException("The given namespace table cannot be null");
        }
        try {
            nodeId = namespaceTable.toNodeId(expandedNodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new IllegalArgumentException("Cannot convert referenceType to nodeid ", serviceResultException);
        }
        ArrayList<RelativePathElement> arrayList = new ArrayList<RelativePathElement>();
        for (UaQualifiedName uaQualifiedName : this.elements) {
            arrayList.add(new RelativePathElement(nodeId, bl, bl2, uaQualifiedName.toQualifiedName(namespaceTable)));
        }
        return new RelativePath(arrayList.toArray(new RelativePathElement[arrayList.size()]));
    }

    public String toString() {
        return "UaRelativeNamePath [elements=" + this.elements + "]";
    }
}

