/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.BitField;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public interface UaOptionSet
extends BitField {
    default public boolean contains(OptionSpecification ... optionSpecificationArray) {
        if (optionSpecificationArray == null) {
            throw new IllegalArgumentException("Null array is not permitted");
        }
        if (optionSpecificationArray.length == 0) {
            return true;
        }
        for (OptionSpecification optionSpecification : Arrays.asList(optionSpecificationArray)) {
            if (optionSpecification == null) {
                throw new IllegalArgumentException("Null elements are not permitted");
            }
            if (this.specification().getOptions().contains(optionSpecification) && this.isBitSet(optionSpecification.getBitPosition())) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAll(Iterable<? extends OptionSpecification> iterable) {
        if (iterable == null) {
            return true;
        }
        for (OptionSpecification optionSpecification : iterable) {
            if (optionSpecification == null) {
                throw new IllegalArgumentException("Null elements not permitted");
            }
            if (this.contains(optionSpecification)) continue;
            return false;
        }
        return true;
    }

    public Object getValue();

    public OptionSetSpecification specification();

    default public BitSet toBitSet() {
        BitSet bitSet = new BitSet();
        for (OptionSpecification optionSpecification : this.specification().getOptions()) {
            if (!this.contains(optionSpecification)) continue;
            bitSet.set(optionSpecification.getBitPosition());
        }
        return bitSet;
    }

    public Builder toBuilder();

    default public Map<OptionSpecification, Boolean> toOptionsMap() {
        LinkedHashMap linkedHashMap = new LinkedHashMap(this.specification().getOptions().size());
        this.specification().getOptions().forEach(optionSpecification -> linkedHashMap.put(optionSpecification, this.contains((OptionSpecification)optionSpecification)));
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public static interface Builder {
        public Builder add(OptionSpecification ... var1);

        public Builder addAll(Iterable<? extends OptionSpecification> var1);

        public UaOptionSet build();

        public Builder clear();

        public boolean contains(OptionSpecification ... var1);

        public boolean containsAll(Iterable<? extends OptionSpecification> var1);

        public Builder remove(OptionSpecification ... var1);

        public Builder removeAll(Iterable<? extends OptionSpecification> var1);

        public OptionSetSpecification specification();
    }
}

