/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaNodeSetException;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.b;
import com.prosysopc.ua.internal.InternalDefinitionXMLDataContainer;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.AddNodesItem;
import com.prosysopc.ua.stack.core.AddReferencesItem;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.GenericAttributeValue;
import com.prosysopc.ua.stack.core.GenericAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.xml.XmlDecoder;
import com.prosysopc.ua.stack.utils.BijectionMap;
import com.prosysopc.ua.stack.utils.XMLFactoryCache;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class UaNodeSet {
    private static final Logger logger = LoggerFactory.getLogger(UaNodeSet.class);
    static final Set<NodeData.Attribute> cQ = Collections.unmodifiableSet(new HashSet<NodeData.Attribute>(Arrays.asList(NodeData.Attribute.dm, NodeData.Attribute.NODE_CLASS, NodeData.Attribute.NODE_ID, NodeData.Attribute.BROWSE_NAME, NodeData.Attribute.DISPLAY_NAME, NodeData.Attribute.DESCRIPTION, NodeData.Attribute.WRITE_MASK, NodeData.Attribute.USER_WRITE_MASK)));
    static final Set<NodeData.Attribute> cR = Collections.unmodifiableSet(new HashSet<NodeData.Attribute>(Arrays.asList(NodeData.Attribute.IS_ABSTRACT)));
    final Set<NodeData> cS;
    final Set<ReferenceData> references;
    final List<UaNamespace> cT;
    final List<ModelInfo> cU;
    final Map<String, String> ai;
    final Set<UaNamespace> cV;
    final Set<UaNamespace> cW;
    final Log cX;

    public static UaNodeSet parseXml(InputStream inputStream) throws UaNodeSetException {
        Document document;
        Object object;
        Object object2;
        if (inputStream == null) {
            throw new UaNodeSetException("Null modelSource not allowed");
        }
        try {
            object2 = XMLFactoryCache.getDocumentBuilderFactory();
            ((DocumentBuilderFactory)object2).setNamespaceAware(true);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(new InputSource(new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
        }
        catch (Exception exception) {
            throw new UaNodeSetException("Cannot low-level parse the NodeSet XML file (or it is not a NodeSet file)", exception);
        }
        object2 = new com.prosysopc.ua.a(document);
        object = ((com.prosysopc.ua.a)object2).parse();
        logger.debug("Parsed UaNodeSet with {} Infos, {} Warnings, {} Errors", ((UaNodeSet)object).cX.db, ((UaNodeSet)object).cX.dc, ((UaNodeSet)object).cX.dd);
        return object;
    }

    static a qv() {
        return new a();
    }

    UaNodeSet(Map<String, String> map, List<UaNamespace> list, Set<NodeData> set, Set<ReferenceData> set2, List<ModelInfo> list2, Log log) {
        this.cU = Collections.unmodifiableList(new ArrayList<ModelInfo>(list2));
        this.ai = Collections.unmodifiableMap(new HashMap<String, String>(map));
        this.cT = Collections.unmodifiableList(new ArrayList<UaNamespace>(list));
        this.cS = Collections.unmodifiableSet(new HashSet<NodeData>(set));
        this.references = Collections.unmodifiableSet(new HashSet<ReferenceData>(set2));
        this.cV = Collections.unmodifiableSet(this.cS.stream().map(nodeData -> nodeData.getNodeId().getNamespace()).collect(Collectors.toSet()));
        this.cW = Collections.unmodifiableSet(this.cT.stream().filter(uaNamespace -> !this.cV.contains(uaNamespace)).collect(Collectors.toSet()));
        this.cX = log;
    }

    public Map<String, String> getAliases() {
        return this.ai;
    }

    public Set<UaNamespace> getDependencyNamespaces() {
        return this.cW;
    }

    public Log getLog() {
        return this.cX;
    }

    public List<ModelInfo> getModelInfos() {
        return this.cU;
    }

    public List<UaNamespace> getNamespaces() {
        return this.cT;
    }

    public Set<NodeData> getNodes() {
        return this.cS;
    }

    public Map<NodeClass, List<NodeData>> getNodesByNodeClass() {
        return Collections.unmodifiableMap(this.cS.stream().collect(Collectors.groupingBy(nodeData -> nodeData.getNodeClass(), Collectors.collectingAndThen(Collectors.toList(), list -> Collections.unmodifiableList(list)))));
    }

    public Set<NodeData> getNodesWithLogLevels(Log.Event.Level ... levelArray) {
        HashSet hashSet = new HashSet();
        this.getNodes().stream().filter(nodeData -> nodeData.getLog().a(levelArray) > 0L).forEach(nodeData -> hashSet.add(nodeData));
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<UaNamespace> getProvidedNamespaces() {
        return this.cV;
    }

    public Set<ReferenceData> getReferences() {
        return this.references;
    }

    public Set<AddNodesItem> nodesToAddNodesItem(EncoderContext encoderContext) {
        logger.trace("Resolving all nodes to AddNodesItem(s), in the context of :{}", (Object)encoderContext.getNamespaceTable());
        HashMap hashMap = new HashMap();
        this.references.stream().filter(referenceData -> UaIds.HasTypeDefinition.equals(referenceData.dI)).forEach(referenceData -> {
            if (referenceData.dH) {
                hashMap.put(referenceData.dG, referenceData.dJ);
            } else {
                hashMap.put(referenceData.dJ, referenceData.dG);
            }
        });
        HashSet hashSet = new HashSet();
        this.cS.forEach(nodeData -> {
            try {
                Object object2;
                AddNodesItem.Builder builder = AddNodesItem.builder();
                builder.setRequestedNewNodeId(nodeData.getNodeId().asExpandedNodeId());
                builder.setNodeClass(nodeData.getNodeClass());
                builder.setBrowseName(nodeData.getBrowseName().toQualifiedName(encoderContext.getNamespaceTable()));
                if (NodeClass.Variable == nodeData.getNodeClass() || NodeClass.Object == nodeData.getNodeClass()) {
                    object2 = (UaNodeId)hashMap.get(nodeData.getNodeId());
                    if (object2 == null) {
                        logger.debug("Cannot find HasTypeDefinition Reference for {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
                    } else {
                        builder.setTypeDefinition(((UaNodeId)object2).asExpandedNodeId());
                    }
                }
                object2 = GenericAttributes.builder();
                ((GenericAttributes.Builder)object2).setDescription(nodeData.getDescription());
                ((GenericAttributes.Builder)object2).setDisplayName(nodeData.getDisplayName());
                ((GenericAttributes.Builder)object2).setUserWriteMask(nodeData.qC());
                ((GenericAttributes.Builder)object2).setWriteMask(nodeData.qD());
                ArrayList<GenericAttributeValue> arrayList = new ArrayList<GenericAttributeValue>();
                HashSet<NodeData.Attribute<Object>> hashSet = new HashSet<NodeData.Attribute<Object>>();
                hashSet.add(NodeData.Attribute.NODE_ID);
                hashSet.add(NodeData.Attribute.NODE_CLASS);
                hashSet.add(NodeData.Attribute.BROWSE_NAME);
                hashSet.add(NodeData.Attribute.DESCRIPTION);
                hashSet.add(NodeData.Attribute.DISPLAY_NAME);
                hashSet.add(NodeData.Attribute.USER_WRITE_MASK);
                hashSet.add(NodeData.Attribute.WRITE_MASK);
                hashSet.add(NodeData.Attribute.VALUE_XML);
                hashSet.add(NodeData.Attribute.dm);
                hashSet.add(NodeData.Attribute.DEFINITION_XML);
                hashSet.add(NodeData.Attribute.dl);
                ((NodeData)nodeData).attributes.forEach((attribute, object) -> {
                    if (!hashSet.contains(attribute)) {
                        if (NodeData.Attribute.ARRAY_DIMENSIONS == attribute) {
                            if (object != null) {
                                arrayList.add(new GenericAttributeValue(((NodeData.Attribute)attribute).dn, ((UaArrayDimensions)object).toArray()));
                            } else {
                                arrayList.add(new GenericAttributeValue(((NodeData.Attribute)attribute).dn, null));
                            }
                        } else {
                            if (object instanceof UaNodeId) {
                                object = ((UaNodeId)object).asNodeId(encoderContext.getNamespaceTable());
                            }
                            arrayList.add(new GenericAttributeValue(((NodeData.Attribute)attribute).dn, object));
                        }
                    }
                });
                if (((NodeData)nodeData).attributes.containsKey(NodeData.Attribute.VALUE_XML)) {
                    if (((NodeData)nodeData).attributes.get(NodeData.Attribute.VALUE_XML) != null) {
                        String string = (String)nodeData.getAttributes().get(NodeData.Attribute.VALUE_XML);
                        string = string.trim();
                        try {
                            XmlDecoder xmlDecoder = new XmlDecoder(new XmlElement(string), encoderContext);
                            NamespaceTable namespaceTable = new NamespaceTable();
                            if (this.cT.size() > 1) {
                                this.cT.subList(1, this.cT.size()).forEach(uaNamespace -> namespaceTable.add(uaNamespace.getURI()));
                            }
                            xmlDecoder.setNamespaceTable(namespaceTable);
                            Variant variant = xmlDecoder.getVariant("");
                            arrayList.add(new GenericAttributeValue(Attributes.Value, variant));
                            logger.trace("Parsed value: {}", (Object)variant);
                        }
                        catch (Exception exception) {
                            logger.warn("Cannot parse Value Attribute: '{}', for node: {} id: {}", string, nodeData.getBrowseName(), nodeData.getNodeId(), exception);
                        }
                    } else {
                        arrayList.add(new GenericAttributeValue(Attributes.Value, Variant.NULL));
                    }
                }
                ((GenericAttributes.Builder)object2).setAttributeValues(arrayList.toArray(new GenericAttributeValue[0]));
                builder.setNodeAttributes(new ExtensionObject(((GenericAttributes.Builder)object2).build()));
                hashSet.add(builder.build());
            }
            catch (Exception exception) {
                logger.warn("Could not convert: {} to AddNodesItem", (Object)nodeData.getNodeId(), (Object)exception);
            }
        });
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<AddReferencesItem> referencesToAddReferencesItem(EncoderContext encoderContext) {
        return Collections.unmodifiableSet(this.references.stream().map(referenceData -> referenceData.toAddReferencesItem(encoderContext.getNamespaceTable())).collect(Collectors.toSet()));
    }

    String qw() {
        b b2;
        try {
            b2 = new b(this);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Internal error, cannot generate XML", exception);
        }
        Document document = b2.c();
        return b.c(document);
    }

    static class a
    implements Log.b<a> {
        private static final Logger logger = LoggerFactory.getLogger(a.class);
        private final Set<NodeData> cS = new HashSet<NodeData>();
        private final Set<ReferenceData> references = new HashSet<ReferenceData>();
        private final List<UaNamespace> cY = new ArrayList<UaNamespace>();
        private final List<ModelInfo> cU = new ArrayList<ModelInfo>();
        private final Map<String, String> ai = new HashMap<String, String>();
        private final Log.a cZ = new Log.a();

        private a() {
            this.cY.add(UaNamespace.STANDARD);
        }

        public a a(String string, String string2) {
            this.ai.put(string, string2);
            return this;
        }

        public a a(ModelInfo modelInfo) {
            this.cU.add(modelInfo);
            this.cZ.de.addAll(modelInfo.cX.da);
            return this;
        }

        public a c(UaNamespace uaNamespace) {
            if (UaNamespace.STANDARD.equals(uaNamespace)) {
                throw new IllegalArgumentException("The core namespace must not be added manually. It is automatically in the index 0");
            }
            if (this.cY.contains(uaNamespace)) {
                logger.warn("The namespace {} was already part of the namespaces", (Object)uaNamespace);
            } else {
                this.cY.add(uaNamespace);
            }
            return this;
        }

        public a d(UaNamespace uaNamespace) {
            if (!this.cY.contains(uaNamespace)) {
                this.cY.add(uaNamespace);
            }
            return this;
        }

        public a c(NodeData nodeData) {
            this.cS.add(nodeData);
            this.cZ.de.addAll(nodeData.cX.da);
            return this;
        }

        public a c(ReferenceData referenceData) {
            this.references.add(referenceData);
            return this;
        }

        public a a(Iterable<ReferenceData> iterable) {
            iterable.forEach(referenceData -> this.c((ReferenceData)referenceData));
            return this;
        }

        public a a(Log.Event.Level level, String string, String string2, Exception exception) {
            this.cZ.c(level, string, string2, exception);
            return this;
        }

        UaNodeSet qx() {
            return new UaNodeSet(this.ai, this.cY, this.cS, this.references, this.cU, this.cZ.qy());
        }

        List<UaNamespace> getNamespaces() {
            return this.cY;
        }

        @Override
        public /* synthetic */ Object b(Log.Event.Level level, String string, String string2, Exception exception) {
            return this.a(level, string, string2, exception);
        }
    }

    public static class ReferenceData {
        final UaNodeId dG;
        final boolean dH;
        final UaNodeId dI;
        final UaNodeId dJ;

        static ReferenceData a(UaNodeId uaNodeId, boolean bl, UaNodeId uaNodeId2, UaNodeId uaNodeId3) {
            return new ReferenceData(uaNodeId, bl, uaNodeId2, uaNodeId3);
        }

        ReferenceData(UaNodeId uaNodeId, boolean bl, UaNodeId uaNodeId2, UaNodeId uaNodeId3) {
            this.dG = uaNodeId;
            this.dH = bl;
            this.dI = uaNodeId2;
            this.dJ = uaNodeId3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ReferenceData)) {
                return false;
            }
            ReferenceData referenceData = (ReferenceData)object;
            return this.dH == referenceData.dH && Objects.equals(this.dG, referenceData.dG) && Objects.equals(this.dJ, referenceData.dJ) && Objects.equals(this.dI, referenceData.dI);
        }

        public UaNodeId getReferenceSource() {
            return this.dG;
        }

        public UaNodeId getReferenceTarget() {
            return this.dJ;
        }

        public UaNodeId getReferenceType() {
            return this.dI;
        }

        public int hashCode() {
            return Objects.hash(this.dH, this.dG, this.dJ, this.dI);
        }

        public boolean isForward() {
            return this.dH;
        }

        public AddReferencesItem toAddReferencesItem(NamespaceTable namespaceTable) {
            AddReferencesItem.Builder builder = AddReferencesItem.builder();
            builder.setIsForward(this.dH);
            builder.setReferenceTypeId(NodeId.from(this.dI, namespaceTable));
            builder.setSourceNodeId(NodeId.from(this.dG, namespaceTable));
            builder.setTargetNodeId(new ExpandedNodeId(NodeId.from(this.dJ, namespaceTable)));
            builder.setTargetNodeClass(null);
            builder.setTargetServerUri(null);
            return builder.build();
        }

        public String toString() {
            return "ReferenceData [referenceSource=" + this.dG + ", referenceTarget=" + this.dJ + ", isForward=" + this.dH + ", referenceType=" + this.dI + "]";
        }
    }

    public static class NodeData {
        private final Map<Attribute, Object> attributes;
        private final Log cX;
        private final String dj;

        static a o(String string) {
            return new a(string);
        }

        private NodeData(Map<Attribute, Object> map, String string, Log log) {
            this.attributes = Collections.unmodifiableMap(new HashMap<Attribute, Object>(map));
            this.cX = log;
            this.dj = string;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof NodeData)) {
                return false;
            }
            NodeData nodeData = (NodeData)object;
            return Objects.equals(this.attributes, nodeData.attributes);
        }

        public <T> T get(Attribute<T> attribute) {
            Object object = this.attributes.get(attribute);
            return (T)object;
        }

        public UaQualifiedName getBrowseName() {
            return (UaQualifiedName)this.attributes.get(Attribute.BROWSE_NAME);
        }

        public LocalizedText getDescription() {
            return (LocalizedText)this.attributes.get(Attribute.DESCRIPTION);
        }

        public LocalizedText getDisplayName() {
            return (LocalizedText)this.attributes.get(Attribute.DISPLAY_NAME);
        }

        public NodeClass getNodeClass() {
            return (NodeClass)this.attributes.get(Attribute.NODE_CLASS);
        }

        public UaNodeId getNodeId() {
            return (UaNodeId)this.attributes.get(Attribute.NODE_ID);
        }

        public String getRawXml() {
            return this.dj;
        }

        public int hashCode() {
            return Objects.hash(this.attributes);
        }

        public AddNodesItem toAddNodesItem(EncoderContext encoderContext) {
            AddNodesItem.Builder builder = AddNodesItem.builder();
            return builder.build();
        }

        Map<Attribute, Object> getAttributes() {
            return this.attributes;
        }

        Log getLog() {
            return this.cX;
        }

        b qB() {
            return b.dD.getRight(this.getNodeClass());
        }

        UnsignedInteger qC() {
            return (UnsignedInteger)this.attributes.get(Attribute.USER_WRITE_MASK);
        }

        UnsignedInteger qD() {
            return (UnsignedInteger)this.attributes.get(Attribute.WRITE_MASK);
        }

        a qE() {
            a a2 = NodeData.o(this.dj);
            a2.attributes.putAll(this.attributes);
            a2.cZ.de.addAll(this.cX.getEvents());
            return a2;
        }

        static enum b {
            du(false, "UAObject", NodeClass.Object, Attribute.EVENT_NOTIFIER),
            dv(false, "UAVariable", NodeClass.Variable, Attribute.DATA_TYPE, Attribute.HISTORIZING, Attribute.VALUE_XML, Attribute.ACCESS_LEVEL, Attribute.USER_ACCESS_LEVEL, Attribute.MINIMUM_SAMPLING_INTERVAL, Attribute.VALUE_RANK, Attribute.ARRAY_DIMENSIONS),
            dw(false, "UAMethod", NodeClass.Method, Attribute.EXECUTABLE, Attribute.USER_EXECUTABLE),
            dx(true, "UAObjectType", NodeClass.ObjectType, new Attribute[0]),
            dy(true, "UAVariableType", NodeClass.VariableType, Attribute.VALUE_XML, Attribute.DATA_TYPE, Attribute.VALUE_RANK, Attribute.ARRAY_DIMENSIONS),
            dz(true, "UAReferenceType", NodeClass.ReferenceType, Attribute.SYMMETRIC, Attribute.INVERSE_NAME),
            dA(true, "UADataType", NodeClass.DataType, Attribute.dl),
            dB(false, "UAView", NodeClass.View, Attribute.CONTAINS_NO_LOOPS, Attribute.EVENT_NOTIFIER);

            static final Map<String, b> dC;
            static final BijectionMap<NodeClass, b> dD;
            private final NodeClass dE;
            private final Set<Attribute> attributes;
            private final String tagName;

            public static b a(NodeClass nodeClass) {
                if (nodeClass == null) {
                    return null;
                }
                return dD.getRight(nodeClass);
            }

            private b(boolean bl, String string2, NodeClass nodeClass, Attribute ... attributeArray) {
                this.tagName = string2;
                this.dE = nodeClass;
                HashSet<Attribute> hashSet = new HashSet<Attribute>();
                hashSet.addAll(cQ);
                if (bl) {
                    hashSet.addAll(cR);
                }
                hashSet.addAll(Arrays.asList(attributeArray));
                this.attributes = Collections.unmodifiableSet(hashSet);
            }

            public NodeClass getNodeClass() {
                return this.dE;
            }

            Set<Attribute> getAttributes() {
                return this.attributes;
            }

            String getTagName() {
                return this.tagName;
            }

            static {
                dD = new BijectionMap();
                HashMap<String, b> hashMap = new HashMap<String, b>();
                for (b b2 : b.values()) {
                    hashMap.put(b2.tagName, b2);
                    dD.map(b2.getNodeClass(), b2);
                }
                dC = Collections.unmodifiableMap(hashMap);
            }
        }

        static class a
        implements Log.b<a> {
            private final Map<Attribute, Object> attributes = new HashMap<Attribute, Object>();
            private final Log.a cZ = new Log.a();
            private String dj;

            private a(String string) {
                this.dj = string;
            }

            public a a(Attribute attribute, Object object) {
                this.attributes.put(attribute, object);
                return this;
            }

            public NodeData qF() {
                return new NodeData(this.attributes, this.dj, this.cZ.qy());
            }

            public a e(Log.Event.Level level, String string, String string2, Exception exception) {
                if (string2 == null) {
                    string2 = this.dj;
                }
                this.cZ.c(level, string, string2, exception);
                return this;
            }

            @Override
            public /* synthetic */ Object b(Log.Event.Level level, String string, String string2, Exception exception) {
                return this.e(level, string, string2, exception);
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public static class Attribute<T> {
            static final Map<UnsignedInteger, Attribute<?>> dk = new HashMap();
            public static final Attribute<UaNodeId> NODE_ID = new Attribute<UaNodeId>("NodeId", Attributes.NodeId, UaNodeId.class, true, a.dr, null);
            public static final Attribute<NodeClass> NODE_CLASS = new Attribute<NodeClass>("NodeClass", Attributes.NodeClass, NodeClass.class, true, a.dr, null);
            public static final Attribute<UaQualifiedName> BROWSE_NAME = new Attribute<UaQualifiedName>("BrowseName", Attributes.BrowseName, UaQualifiedName.class, true, a.dr, null);
            public static final Attribute<LocalizedText> DISPLAY_NAME = new Attribute<LocalizedText>("DisplayName", Attributes.DisplayName, LocalizedText.class, true, a.ds, null);
            public static final Attribute<LocalizedText> DESCRIPTION = new Attribute<LocalizedText>("Description", Attributes.Description, LocalizedText.class, true, a.ds, null);
            public static final Attribute<LocalizedText> INVERSE_NAME = new Attribute<LocalizedText>("InverseName", Attributes.InverseName, LocalizedText.class, true, a.ds, null);
            public static final Attribute<UnsignedByte> ACCESS_LEVEL = new Attribute<UnsignedByte>("AccessLevel", Attributes.AccessLevel, UnsignedByte.class, true, a.dr, "1");
            public static final Attribute<UnsignedByte> USER_ACCESS_LEVEL = new Attribute<UnsignedByte>("UserAccessLevel", Attributes.UserAccessLevel, UnsignedByte.class, true, a.dr, "1");
            public static final Attribute<UaArrayDimensions> ARRAY_DIMENSIONS = new Attribute<UaArrayDimensions>("ArrayDimensions", Attributes.ArrayDimensions, UaArrayDimensions.class, true, a.dr, "");
            public static final Attribute<UnsignedByte> EVENT_NOTIFIER = new Attribute<UnsignedByte>("EventNotifier", Attributes.EventNotifier, UnsignedByte.class, true, a.dr, "0");
            public static final Attribute<Integer> VALUE_RANK = new Attribute<Integer>("ValueRank", Attributes.ValueRank, Integer.class, true, a.dr, "-1");
            public static final Attribute<UnsignedInteger> WRITE_MASK = new Attribute<UnsignedInteger>("WriteMask", Attributes.WriteMask, UnsignedInteger.class, true, a.dr, "0");
            public static final Attribute<UnsignedInteger> USER_WRITE_MASK = new Attribute<UnsignedInteger>("UserWriteMask", Attributes.UserWriteMask, UnsignedInteger.class, true, a.dr, "0");
            public static final Attribute<Boolean> IS_ABSTRACT = new Attribute<Boolean>("IsAbstract", Attributes.IsAbstract, Boolean.class, true, a.dr, "false");
            public static final Attribute<Boolean> SYMMETRIC = new Attribute<Boolean>("Symmetric", Attributes.Symmetric, Boolean.class, true, a.dr, "false");
            public static final Attribute<Boolean> CONTAINS_NO_LOOPS = new Attribute<Boolean>("ContainsNoLoops", Attributes.ContainsNoLoops, Boolean.class, true, a.dr, "false");
            public static final Attribute<Boolean> EXECUTABLE = new Attribute<Boolean>("Executable", Attributes.Executable, Boolean.class, true, a.dr, "true");
            public static final Attribute<Boolean> USER_EXECUTABLE = new Attribute<Boolean>("UserExecutable", Attributes.UserExecutable, Boolean.class, true, a.dr, "true");
            public static final Attribute<Double> MINIMUM_SAMPLING_INTERVAL = new Attribute<Double>("MinimumSamplingInterval", Attributes.MinimumSamplingInterval, Double.class, true, a.dr, "0");
            public static final Attribute<Boolean> HISTORIZING = new Attribute<Boolean>("Historizing", Attributes.Historizing, Boolean.class, true, a.dr, "false");
            static final Attribute<InternalDefinitionXMLDataContainer> dl = new Attribute<InternalDefinitionXMLDataContainer>("Definition", Attributes.DataTypeDefinition, InternalDefinitionXMLDataContainer.class, true, a.ds, null);
            public static final Attribute<String> DEFINITION_XML = new Attribute<String>("Definition", Attributes.DataTypeDefinition, String.class, true, a.ds, null);
            static final Attribute<String> dm = new Attribute<String>("Debug XML", null, String.class, true, a.ds, null);
            public static final Attribute<String> VALUE_XML = new Attribute<String>("Value", Attributes.Value, String.class, true, a.ds, null);
            public static final Attribute<UaNodeId> DATA_TYPE = new Attribute<UaNodeId>("DataType", Attributes.DataType, UaNodeId.class, true, a.dr, "i=24");
            private final UnsignedInteger dn;
            private final Class<? extends T> javaClass;
            private final boolean do;
            private final a dp;
            private final String dq;
            private final String defaultValue;

            private Attribute(String string, UnsignedInteger unsignedInteger, Class<? extends T> clazz, boolean bl, a a2, String string2) {
                this.dn = unsignedInteger;
                this.do = bl;
                this.javaClass = clazz;
                this.dp = a2;
                this.dq = string;
                this.defaultValue = string2;
                if (unsignedInteger != null) {
                    dk.put(unsignedInteger, this);
                }
            }

            public UnsignedInteger getId() {
                return this.dn;
            }

            public Class<? extends T> getJavaClass() {
                return this.javaClass;
            }

            public a getKind() {
                return this.dp;
            }

            public String getXmlName() {
                return this.dq;
            }

            public boolean isMandatory() {
                return this.do;
            }

            public String toString() {
                return "ModelNodeAttribute [xmlName=" + this.dq + ", id=" + this.dn + ", javaClass=" + this.javaClass + ", kind=" + (Object)((Object)this.dp) + ", mandatory=" + this.do + ", defaultValue=" + this.defaultValue + "]";
            }

            String getDefaultValue() {
                return this.defaultValue;
            }

            static enum a {
                dr,
                ds;

            }
        }
    }

    public static class ModelInfo {
        final UaNamespace cI;
        final String version;
        final DateTime dh;
        final List<ModelInfo> di;
        private final Log cX;

        static a qz() {
            return new a();
        }

        ModelInfo(UaNamespace uaNamespace, String string, DateTime dateTime, List<ModelInfo> list, Log log) {
            this.cI = uaNamespace;
            this.version = string;
            this.dh = dateTime;
            this.di = Collections.unmodifiableList(new ArrayList<ModelInfo>(list));
            this.cX = log;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ModelInfo)) {
                return false;
            }
            ModelInfo modelInfo = (ModelInfo)object;
            return Objects.equals(this.di, modelInfo.di) && Objects.equals(this.cI, modelInfo.cI) && Objects.equals(this.dh, modelInfo.dh) && Objects.equals(this.version, modelInfo.version);
        }

        public List<ModelInfo> getDependencies() {
            return this.di;
        }

        public Log getLog() {
            return this.cX;
        }

        public UaNamespace getNamespace() {
            return this.cI;
        }

        public DateTime getPublicationDate() {
            return this.dh;
        }

        public String getVersion() {
            return this.version;
        }

        public int hashCode() {
            return Objects.hash(this.di, this.cI, this.dh, this.version);
        }

        public String toString() {
            return "ModelInfo [namespace=" + this.cI + ", version=" + this.version + ", publicationDate=" + this.dh + ", dependencies=" + this.di + "]";
        }

        static class a
        implements Log.b<a> {
            UaNamespace cI;
            String version;
            DateTime dh;
            final List<ModelInfo> di = new ArrayList<ModelInfo>();
            final Log.a cZ = new Log.a();

            private a() {
            }

            public a c(ModelInfo modelInfo) {
                this.di.add(modelInfo);
                return this;
            }

            public ModelInfo qA() {
                return new ModelInfo(this.cI, this.version, this.dh, this.di, this.cZ.qy());
            }

            public a d(Log.Event.Level level, String string, String string2, Exception exception) {
                this.cZ.c(level, string, string2, exception);
                return this;
            }

            public a e(UaNamespace uaNamespace) {
                this.cI = uaNamespace;
                return this;
            }

            public a a(DateTime dateTime) {
                this.dh = dateTime;
                return this;
            }

            public a n(String string) {
                this.version = string;
                return this;
            }

            @Override
            public /* synthetic */ Object b(Log.Event.Level level, String string, String string2, Exception exception) {
                return this.d(level, string, string2, exception);
            }
        }
    }

    public static class Log {
        private final List<Event> da;
        private final long db;
        private final long dc;
        private final long dd;

        Log(List<Event> list) {
            this.da = Collections.unmodifiableList(new ArrayList<Event>(list));
            this.db = list.stream().filter(event -> Event.Level.INFO == event.getLevel()).count();
            this.dc = list.stream().filter(event -> Event.Level.WARNING == event.getLevel()).count();
            this.dd = list.stream().filter(event -> Event.Level.ERROR == event.getLevel()).count();
        }

        public long getErrorCount() {
            return this.dd;
        }

        public List<Event> getErrors() {
            return Collections.unmodifiableList(new ArrayList(this.da.stream().filter(event -> Event.Level.ERROR == event.getLevel()).collect(Collectors.toList())));
        }

        public List<Event> getEvents() {
            return this.da;
        }

        public long getInfoCount() {
            return this.db;
        }

        public List<Event> getInfos() {
            return Collections.unmodifiableList(new ArrayList(this.da.stream().filter(event -> Event.Level.INFO == event.getLevel()).collect(Collectors.toList())));
        }

        public long getWarningCount() {
            return this.dc;
        }

        public List<Event> getWarnings() {
            return Collections.unmodifiableList(new ArrayList(this.da.stream().filter(event -> Event.Level.WARNING == event.getLevel()).collect(Collectors.toList())));
        }

        long a(Event.Level ... levelArray) {
            if (levelArray == null || levelArray.length == 0) {
                levelArray = Event.Level.values();
            }
            long l2 = 0L;
            HashSet<Event.Level> hashSet = new HashSet<Event.Level>(Arrays.asList(levelArray));
            if (hashSet.contains((Object)Event.Level.INFO)) {
                l2 += this.getInfoCount();
            }
            if (hashSet.contains((Object)Event.Level.WARNING)) {
                l2 += this.getWarningCount();
            }
            if (hashSet.contains((Object)Event.Level.ERROR)) {
                l2 += this.getErrorCount();
            }
            return l2;
        }

        static interface b<T> {
            default public T b(Event.Level level, String string, Exception exception) {
                return this.b(level, string, null, exception);
            }

            public T b(Event.Level var1, String var2, String var3, Exception var4);

            default public T k(String string) {
                return this.d(string, null);
            }

            default public T d(String string, Exception exception) {
                return this.b(Event.Level.ERROR, string, exception);
            }

            default public T l(String string) {
                return this.e(string, null);
            }

            default public T e(String string, Exception exception) {
                return this.b(Event.Level.INFO, string, exception);
            }

            default public T m(String string) {
                return this.f(string, null);
            }

            default public T f(String string, Exception exception) {
                return this.b(Event.Level.WARNING, string, exception);
            }
        }

        static class a {
            private final List<Event> de = new ArrayList<Event>();

            a() {
            }

            public a a(Event.Level level, String string, Exception exception) {
                return this.c(level, string, null, exception);
            }

            public a c(Event.Level level, String string, String string2, Exception exception) {
                this.de.add(new Event(level, string, string2, exception));
                return this;
            }

            public a h(String string) {
                return this.a(string, null);
            }

            public a a(String string, Exception exception) {
                return this.a(Event.Level.ERROR, string, exception);
            }

            public a i(String string) {
                return this.b(string, null);
            }

            public a b(String string, Exception exception) {
                return this.a(Event.Level.INFO, string, exception);
            }

            public a j(String string) {
                return this.c(string, null);
            }

            public a c(String string, Exception exception) {
                return this.a(Event.Level.WARNING, string, exception);
            }

            Log qy() {
                return new Log(this.de);
            }
        }

        public static class Event {
            private final Level df;
            private final String message;
            private final String additionalInfo;
            private final Exception exception;

            Event(Level level, String string, String string2, Exception exception) {
                this.df = level;
                this.message = string;
                this.additionalInfo = string2;
                this.exception = exception;
            }

            public String getAdditionalInfo() {
                return this.additionalInfo;
            }

            public Exception getException() {
                return this.exception;
            }

            public Level getLevel() {
                return this.df;
            }

            public String getMessage() {
                return this.message;
            }

            public static enum Level {
                INFO,
                WARNING,
                ERROR;

            }
        }
    }
}

