/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.InternalNamespaceUtils;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.IdType;
import java.util.UUID;

public class UaNodeId
implements Comparable<UaNodeId> {
    private static final UaNodeId[] cP = new UaNodeId[0];
    private final UaNamespace cI;
    private final NodeId cJ;
    private final int hash;

    public static UaNodeId[] arrayFromLocal(ExpandedNodeId[] expandedNodeIdArray) {
        if (expandedNodeIdArray == null) {
            return null;
        }
        if (expandedNodeIdArray.length == 0) {
            return cP;
        }
        UaNodeId[] uaNodeIdArray = new UaNodeId[expandedNodeIdArray.length];
        for (int i2 = 0; i2 < expandedNodeIdArray.length; ++i2) {
            uaNodeIdArray[i2] = UaNodeId.fromLocal(expandedNodeIdArray[i2]);
        }
        return uaNodeIdArray;
    }

    public static UaNodeId[] arrayFromLocal(ExpandedNodeId[] expandedNodeIdArray, NamespaceTable namespaceTable) {
        if (expandedNodeIdArray == null) {
            return null;
        }
        if (expandedNodeIdArray.length == 0) {
            return cP;
        }
        UaNodeId[] uaNodeIdArray = new UaNodeId[expandedNodeIdArray.length];
        for (int i2 = 0; i2 < expandedNodeIdArray.length; ++i2) {
            uaNodeIdArray[i2] = UaNodeId.fromLocal(expandedNodeIdArray[i2], namespaceTable);
        }
        return uaNodeIdArray;
    }

    public static UaNodeId[] arrayFromLocal(NodeId[] nodeIdArray, NamespaceTable namespaceTable) {
        if (nodeIdArray == null) {
            return null;
        }
        if (nodeIdArray.length == 0) {
            return cP;
        }
        UaNodeId[] uaNodeIdArray = new UaNodeId[nodeIdArray.length];
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            uaNodeIdArray[i2] = UaNodeId.fromLocal(nodeIdArray[i2], namespaceTable);
        }
        return uaNodeIdArray;
    }

    public static UaNodeId from(String string, Object object) {
        return new UaNodeId(UaNamespace.from(string), object);
    }

    public static UaNodeId from(UaNamespace uaNamespace, Object object) {
        return new UaNodeId(uaNamespace, object);
    }

    public static UaNodeId fromLocal(ExpandedNodeId expandedNodeId) {
        if (expandedNodeId == null) {
            return null;
        }
        if (!expandedNodeId.isLocal()) {
            throw new IllegalArgumentException("The given ExpandedNodeId.isLocal is not true");
        }
        if (expandedNodeId.getNamespaceUri() == null) {
            throw new IllegalArgumentException("The given ExpandedNode does not have namespace uri");
        }
        return UaNodeId.from(expandedNodeId.getNamespaceUri(), expandedNodeId.getValue());
    }

    public static UaNodeId fromLocal(ExpandedNodeId expandedNodeId, NamespaceTable namespaceTable) {
        if (expandedNodeId == null) {
            return null;
        }
        if (!expandedNodeId.isLocal()) {
            throw new IllegalArgumentException("The given ExpandedNodeId.isLocal is not true");
        }
        UaNamespace uaNamespace = expandedNodeId.getNamespaceUri() == null ? InternalNamespaceUtils.getNamespaceOrUseInvalidPattern(expandedNodeId.getNamespaceIndex(), namespaceTable) : InternalNamespaceUtils.getNamespace(expandedNodeId.getNamespaceUri(), namespaceTable);
        return UaNodeId.from(uaNamespace, expandedNodeId.getValue());
    }

    public static UaNodeId fromLocal(NodeId nodeId, NamespaceTable namespaceTable) {
        if (nodeId == null) {
            return null;
        }
        UaNamespace uaNamespace = InternalNamespaceUtils.getNamespaceOrUseInvalidPattern(nodeId.getNamespaceIndex(), namespaceTable);
        return UaNodeId.from(uaNamespace, nodeId.getValue());
    }

    public static UaNodeId fromStandard(NodeId nodeId) {
        if (nodeId.getNamespaceIndex() != 0) {
            throw new IllegalArgumentException("Given NodeId contains NamespaceIndex other than 0, was: " + nodeId.getNamespaceIndex());
        }
        return UaNodeId.from("http://opcfoundation.org/UA/", nodeId.getValue());
    }

    public static UaNodeId guid(UaNamespace uaNamespace, UUID uUID) {
        return UaNodeId.from(uaNamespace, (Object)uUID);
    }

    public static UaNodeId numeric(UaNamespace uaNamespace, long l2) {
        return UaNodeId.numeric(uaNamespace, UnsignedInteger.valueOf(l2));
    }

    public static UaNodeId numeric(UaNamespace uaNamespace, UnsignedInteger unsignedInteger) {
        return UaNodeId.from(uaNamespace, (Object)unsignedInteger);
    }

    public static UaNodeId opaque(UaNamespace uaNamespace, ByteString byteString) {
        return UaNodeId.from(uaNamespace, (Object)byteString);
    }

    public static UaNodeId parse(String string) {
        return UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId(string));
    }

    public static UaNodeId parse(String string, String string2) {
        NodeId nodeId = NodeId.parseNodeId(string2);
        return UaNodeId.from(string, nodeId.getValue());
    }

    public static UaNodeId parse(UaNamespace uaNamespace, String string) {
        NodeId nodeId = NodeId.parseNodeId(string);
        return UaNodeId.from(uaNamespace, nodeId.getValue());
    }

    public static UaNodeId string(UaNamespace uaNamespace, String string) {
        return UaNodeId.from(uaNamespace, (Object)string);
    }

    private UaNodeId(UaNamespace uaNamespace, Object object) {
        this.cI = uaNamespace;
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(uaNamespace.getURI(), object);
        this.cJ = NodeId.get(expandedNodeId.getIdType(), 0, expandedNodeId.getValue());
        this.hash = this.hM();
    }

    public ExpandedNodeId asExpandedNodeId() {
        return new ExpandedNodeId(this.cI.getURI(), this.cJ.getValue());
    }

    public ExpandedNodeId asLocalExpandedNodeId() {
        return new ExpandedNodeId(this.cI.getURI(), this.getValue());
    }

    public NodeId asNodeId(NamespaceTable namespaceTable) {
        try {
            return namespaceTable.toNodeId(this.asLocalExpandedNodeId());
        }
        catch (ServiceResultException serviceResultException) {
            throw new IllegalArgumentException("No mapping found for namespace uri:" + this.cI.getURI());
        }
    }

    @Override
    public int compareTo(UaNodeId uaNodeId) {
        int n2 = this.cI.compareTo(uaNodeId.cI);
        if (n2 != 0) {
            return n2;
        }
        return this.cJ.compareTo(uaNodeId.cJ);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaNodeId uaNodeId = (UaNodeId)object;
        if (this.hash != uaNodeId.hash) {
            return false;
        }
        if (this.cI == null ? uaNodeId.cI != null : !this.cI.equals(uaNodeId.cI)) {
            return false;
        }
        return !(this.cJ == null ? uaNodeId.cJ != null : !this.cJ.equals(uaNodeId.cJ));
    }

    public IdType getIdType() {
        return this.cJ.getIdType();
    }

    public UaNamespace getNamespace() {
        return this.cI;
    }

    public String getNamespaceUri() {
        return this.cI.getURI();
    }

    public Object getValue() {
        return this.cJ.getValue();
    }

    public String getValueAsParseForm() {
        return this.cJ.toString();
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.asExpandedNodeId().toString();
    }

    private int hM() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.cI == null ? 0 : this.cI.hashCode());
        n3 = 31 * n3 + (this.cJ == null ? 0 : this.cJ.hashCode());
        return n3;
    }
}

