/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaRelativePath;
import com.prosysopc.ua.UaRelativePathElement;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.BrowsePath;

public class UaBrowsePath {
    private final UaNodeId cD;
    private final UaRelativePath cF;

    public static UaBrowsePath from(BrowsePath browsePath, NamespaceTable namespaceTable) {
        InternalArguments.checkNotNull(namespaceTable, "namespaceTable");
        if (browsePath == null) {
            return null;
        }
        return new UaBrowsePath(UaNodeId.fromLocal(browsePath.getStartingNode(), namespaceTable), UaRelativePath.from(browsePath.getRelativePath(), namespaceTable));
    }

    public static UaBrowsePath from(UaNodeId uaNodeId, UaRelativePath uaRelativePath) {
        return new UaBrowsePath(uaNodeId, uaRelativePath);
    }

    private UaBrowsePath(UaNodeId uaNodeId, UaRelativePath uaRelativePath) {
        this.cD = InternalArguments.checkNotNull(uaNodeId, "startingNode");
        this.cF = InternalArguments.checkNotNull(uaRelativePath, "relativePath");
    }

    public UaBrowsePath append(UaRelativePath uaRelativePath) {
        return UaBrowsePath.from(this.cD, this.cF.append(uaRelativePath));
    }

    public UaBrowsePath append(UaRelativePathElement uaRelativePathElement) {
        return UaBrowsePath.from(this.cD, this.cF.append(uaRelativePathElement));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaBrowsePath uaBrowsePath = (UaBrowsePath)object;
        if (this.cF == null ? uaBrowsePath.cF != null : !this.cF.equals(uaBrowsePath.cF)) {
            return false;
        }
        return !(this.cD == null ? uaBrowsePath.cD != null : !this.cD.equals(uaBrowsePath.cD));
    }

    public UaRelativePath getRelativePath() {
        return this.cF;
    }

    public UaNodeId getStartingNode() {
        return this.cD;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.cF == null ? 0 : this.cF.hashCode());
        n3 = 31 * n3 + (this.cD == null ? 0 : this.cD.hashCode());
        return n3;
    }

    public BrowsePath toBrowsePath(NamespaceTable namespaceTable) {
        if (namespaceTable == null) {
            throw new IllegalArgumentException("The given namespace table cannot be null");
        }
        return new BrowsePath(this.cD.asNodeId(namespaceTable), this.cF.toRelativePath(namespaceTable));
    }

    public String toString() {
        return "UaBrowsePath [startingNode=" + this.cD + ", relativePath=" + this.cF + "]";
    }
}

