/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.core.EnumDefinition;
import com.prosysopc.ua.stack.core.EnumDescription;
import com.prosysopc.ua.stack.core.EnumField;
import com.prosysopc.ua.stack.core.SimpleTypeDescription;
import com.prosysopc.ua.stack.core.StructureDefinition;
import com.prosysopc.ua.stack.core.StructureDescription;
import com.prosysopc.ua.stack.core.StructureField;
import com.prosysopc.ua.stack.core.UABinaryFileDataType;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.io.InputStream;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaBinaryFile {
    private static final Logger logger = LoggerFactory.getLogger(UaBinaryFile.class);
    private final UABinaryFileDataType cA;
    private final EncoderContext cB;

    public static UaBinaryFile parse(InputStream inputStream) throws DecodingException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The given InputStream cannot be null");
        }
        NamespaceTable namespaceTable = new NamespaceTable();
        EncoderContext encoderContext = new EncoderContext(namespaceTable, new ServerTable());
        BinaryDecoder binaryDecoder = new BinaryDecoder(inputStream, Integer.MAX_VALUE);
        binaryDecoder.setEncoderContext(encoderContext);
        UABinaryFileDataType.Builder builder = UABinaryFileDataType.builder();
        binaryDecoder.setStructureFieldDecodeListener((fieldSpecification, object) -> {
            logger.error("TMP, field: {}, value: {}", fieldSpecification, object);
            if (UABinaryFileDataType.SPECIFICATION.getFields().contains(fieldSpecification)) {
                builder.set((FieldSpecification)fieldSpecification, object);
            }
            if (UABinaryFileDataType.Fields.SimpleDataTypes == fieldSpecification) {
                UABinaryFileDataType uABinaryFileDataType = builder.build();
                for (String object2 : uABinaryFileDataType.getNamespaces()) {
                    namespaceTable.add(object2);
                }
                for (SimpleTypeDescription simpleTypeDescription : uABinaryFileDataType.getSimpleDataTypes()) {
                    UaBinaryFile.a(simpleTypeDescription, encoderContext, namespaceTable);
                }
                for (EnumDescription enumDescription : uABinaryFileDataType.getEnumDataTypes()) {
                    if (UnsignedByte.valueOf(6).equals(enumDescription.getBuiltInType())) {
                        UaBinaryFile.a(enumDescription, encoderContext, namespaceTable);
                        continue;
                    }
                    if (UnsignedByte.valueOf(22).equals(enumDescription.getBuiltInType())) {
                        throw new IllegalStateException("Custom OptionSet-Structure types are not supported");
                    }
                    UaBinaryFile.a(namespaceTable, encoderContext, enumDescription);
                }
                for (StructureDescription structureDescription : uABinaryFileDataType.getStructureDataTypes()) {
                    UaBinaryFile.a(structureDescription, encoderContext, namespaceTable);
                }
            }
        });
        ExtensionObject extensionObject = binaryDecoder.getExtensionObject(null);
        UABinaryFileDataType uABinaryFileDataType = (UABinaryFileDataType)extensionObject.getObject();
        return new UaBinaryFile(uABinaryFileDataType, encoderContext);
    }

    private static void a(EnumDescription enumDescription, EncoderContext encoderContext, NamespaceTable namespaceTable) {
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setName(enumDescription.getName().getName());
        builder.setTypeId(UaNodeId.fromLocal(enumDescription.getDataTypeId(), namespaceTable));
        EnumDefinition enumDefinition = enumDescription.getEnumDefinition();
        for (EnumField enumField : enumDefinition.getFields()) {
            String string = enumField.getName();
            Long l2 = enumField.getValue();
            if (l2 > Long.valueOf(Integer.MAX_VALUE) && l2 < Long.valueOf(Integer.MIN_VALUE)) {
                logger.error("Encountered invalid enum value (outside of Int32 range) in type: {}, name:{}, value:{}, skipping", enumDescription.getName(), string, l2);
                continue;
            }
            builder.addMapping(l2.intValue(), string);
        }
        encoderContext.addDataTypeSpecification(builder.build());
    }

    private static void a(SimpleTypeDescription simpleTypeDescription, EncoderContext encoderContext, NamespaceTable namespaceTable) {
        SimpleTypeSpecification.Builder builder = SimpleTypeSpecification.builder();
        UaNodeId uaNodeId = UaNodeId.fromStandard(simpleTypeDescription.getBaseDataType());
        SimpleTypeSpecification simpleTypeSpecification = encoderContext.getSimpleTypeSpecification(uaNodeId);
        builder.setBaseTypeId(uaNodeId);
        builder.setJavaClass(simpleTypeSpecification.getJavaClass());
        builder.setName(simpleTypeDescription.getName().getName());
        builder.setTypeId(UaNodeId.fromLocal(simpleTypeDescription.getDataTypeId(), namespaceTable));
        encoderContext.addDataTypeSpecification(builder.build());
    }

    private static void a(StructureDescription structureDescription, EncoderContext encoderContext, NamespaceTable namespaceTable) {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.setName(structureDescription.getName().getName());
        builder.setTypeId(UaNodeId.fromLocal(structureDescription.getDataTypeId(), namespaceTable));
        StructureDefinition structureDefinition = structureDescription.getStructureDefinition();
        builder.setBinaryEncodeId(UaNodeId.fromLocal(structureDefinition.getDefaultEncodingId(), namespaceTable));
        boolean bl = false;
        boolean bl2 = false;
        switch (structureDefinition.getStructureType()) {
            case Structure: {
                builder.setStructureType(StructureSpecification.StructureType.NORMAL);
                break;
            }
            case StructureWithOptionalFields: {
                builder.setStructureType(StructureSpecification.StructureType.OPTIONAL);
                bl = true;
                break;
            }
            case StructureWithSubtypedValues: {
                builder.setStructureType(StructureSpecification.StructureType.SUBTYPES);
                bl2 = true;
                break;
            }
            case Union: {
                builder.setStructureType(StructureSpecification.StructureType.UNION);
                break;
            }
            case UnionWithSubtypedValues: {
                builder.setStructureType(StructureSpecification.StructureType.UNION_SUBTYPES);
                bl2 = true;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown StructureType constant: " + structureDefinition.getStructureType());
            }
        }
        for (StructureField structureField : structureDefinition.getFields()) {
            FieldSpecification.Builder builder2 = FieldSpecification.builder();
            if (bl) {
                builder2.setIsOptional(structureField.getIsOptional());
            } else if (bl2) {
                builder2.setAllowSubTypes(structureField.getIsOptional());
            }
            builder2.setName(structureField.getName());
            builder2.setArrayDimensions(UaArrayDimensions.valueOf(structureField.getArrayDimensions()));
            UaNodeId uaNodeId = UaNodeId.fromLocal(structureField.getDataType(), namespaceTable);
            builder2.setDataTypeId(uaNodeId);
            builder2.setDescription(null);
            Optional<UaDataTypeSpecification> optional = Optional.ofNullable(encoderContext.getDataTypeSpecification(uaNodeId));
            Optional<Class> optional2 = optional.map(uaDataTypeSpecification -> uaDataTypeSpecification.getJavaClass());
            builder2.setJavaClass(optional2.orElse(DynamicStructure.class));
            builder2.setMaxStringLength(structureField.getMaxStringLength().intValue());
            builder2.setValueRank(structureField.getValueRank());
            builder.addField(builder2.build());
        }
        encoderContext.addDataTypeSpecification(builder.build());
    }

    private static void a(NamespaceTable namespaceTable, EncoderContext encoderContext, EnumDescription enumDescription) {
        OptionSetSpecification.Builder<UaOptionSet.Builder> builder = OptionSetSpecification.builder();
        builder.setName(enumDescription.getName().getName());
        builder.setTypeId(UaNodeId.fromLocal(enumDescription.getDataTypeId(), namespaceTable));
        switch (enumDescription.getBuiltInType().intValue()) {
            case 3: {
                builder.setBaseTypeId(UaIds.Byte);
                break;
            }
            case 5: {
                builder.setBaseTypeId(UaIds.UInt16);
                break;
            }
            case 7: {
                builder.setBaseTypeId(UaIds.UInt32);
                break;
            }
            case 9: {
                builder.setBaseTypeId(UaIds.UInt64);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected BuiltInType for OptionSet: " + enumDescription.getBuiltInType());
            }
        }
        EnumDefinition enumDefinition = enumDescription.getEnumDefinition();
        for (EnumField enumField : enumDefinition.getFields()) {
            Long l2 = enumField.getValue();
            OptionSpecification.Builder builder2 = OptionSpecification.builder();
            builder2.setBitPosition(l2.intValue());
            builder2.setDescription(enumField.getDescription());
            builder2.setName(enumField.getName());
            builder.addOptions(builder2.build());
        }
        encoderContext.addDataTypeSpecification(builder.build());
    }

    private UaBinaryFile(UABinaryFileDataType uABinaryFileDataType, EncoderContext encoderContext) {
        this.cA = uABinaryFileDataType;
        this.cB = encoderContext;
    }

    public Object getBody() {
        return this.cA.getBody();
    }

    public EncoderContext getContext() {
        return this.cB;
    }

    public UABinaryFileDataType getData() {
        return this.cA;
    }
}

