/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class UaArrayDimensions {
    public static final UaArrayDimensions EMPTY;
    private static final UnsignedInteger[] cy;
    private final List<UnsignedInteger> cz;

    public static UaArrayDimensions parse(String string) {
        if (string == null || string.trim().isEmpty()) {
            return EMPTY;
        }
        if (string.startsWith("[")) {
            string = string.substring(1);
        }
        if (string.endsWith("]")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((string = string.trim()).isEmpty()) {
            return EMPTY;
        }
        ArrayList<UnsignedInteger> arrayList = new ArrayList<UnsignedInteger>();
        String[] stringArray = string.split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                arrayList.add(UnsignedInteger.parseUnsignedInteger(stringArray[i2].trim()));
                continue;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("The given input contained an element that could not be parsed to UnsignedInteger", exception);
            }
        }
        return UaArrayDimensions.valueOf(arrayList.toArray(UnsignedInteger.EMPTY_ARRAY));
    }

    public static UaArrayDimensions valueOf(long ... lArray) {
        if (lArray == null) {
            return null;
        }
        if (lArray.length == 0) {
            return EMPTY;
        }
        UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            unsignedIntegerArray[i2] = UnsignedInteger.valueOf(lArray[i2]);
        }
        return new UaArrayDimensions(new ArrayList<UnsignedInteger>(Arrays.asList(unsignedIntegerArray)));
    }

    public static UaArrayDimensions valueOf(UnsignedInteger ... unsignedIntegerArray) {
        if (unsignedIntegerArray == null) {
            return null;
        }
        if (unsignedIntegerArray.length == 0) {
            return EMPTY;
        }
        ArrayList<UnsignedInteger> arrayList = new ArrayList<UnsignedInteger>();
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            if (unsignedIntegerArray[i2] != null) {
                arrayList.add(unsignedIntegerArray[i2]);
                continue;
            }
            arrayList.add(UnsignedInteger.ZERO);
        }
        return new UaArrayDimensions(arrayList);
    }

    public static UaArrayDimensions zeros(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The given dimensions must be >=0");
        }
        UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[n2];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            unsignedIntegerArray[i2] = UnsignedInteger.ZERO;
        }
        return UaArrayDimensions.valueOf(unsignedIntegerArray);
    }

    private UaArrayDimensions(List<UnsignedInteger> list) {
        this.cz = Collections.unmodifiableList(list);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UaArrayDimensions)) {
            return false;
        }
        UaArrayDimensions uaArrayDimensions = (UaArrayDimensions)object;
        return this.cz.equals(uaArrayDimensions.cz);
    }

    public List<UnsignedInteger> getValue() {
        return this.cz;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.cz.hashCode();
        return n3;
    }

    public UnsignedInteger[] toArray() {
        return this.cz.toArray(cy);
    }

    public int[] toIntArray() {
        return this.cz.stream().mapToInt(unsignedInteger -> {
            if (unsignedInteger.longValue() > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return unsignedInteger.intValue();
        }).toArray();
    }

    public String toString() {
        return this.cz.toString();
    }

    static {
        cy = new UnsignedInteger[0];
        List<UnsignedInteger> list = Collections.emptyList();
        EMPTY = new UaArrayDimensions(list);
    }
}

