/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.AggregateCalculator;
import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.CodegenModel;
import com.prosysopc.ua.CodegenModelProvider;
import com.prosysopc.ua.OperationLimits;
import com.prosysopc.ua.RegisteredClasses;
import com.prosysopc.ua.RegisteredClassesImpl;
import com.prosysopc.ua.UaAddressSpace;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.typedictionary.DataTypeDictionary;
import com.prosysopc.ua.typedictionary.DataTypeDictionaryComposition;
import com.prosysopc.ua.typedictionary.GeneratedDataTypeDictionary;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UaApplication {
    private static Logger logger = LoggerFactory.getLogger(UaApplication.class);
    static final String cp = "5.1.0-116";
    private final AggregateCalculator cq = new AggregateCalculator();
    private CertificateValidator cr;
    private final RegisteredClasses cs = new RegisteredClassesImpl();
    private final DataTypeDictionaryComposition ct = new DataTypeDictionaryComposition();
    private OperationLimits cu = OperationLimits.defaults();
    private boolean cv = true;

    @Deprecated
    public static String formatUri(Protocol protocol, String string, int n2, String string2) {
        if (string2 == null) {
            string2 = "";
        } else if (!string2.isEmpty() && string2.charAt(0) != '/') {
            string2 = "/" + string2;
        }
        return String.format("%s://%s:%d%s", new Object[]{protocol, string, n2, string2});
    }

    public static String getSdkVersion() {
        return cp;
    }

    @Deprecated
    public static String getVersion() {
        return "v" + UaApplication.getSdkVersion();
    }

    public abstract UaAddressSpace getAddressSpace();

    public AggregateCalculator getAggregateCalculator() {
        return this.cq;
    }

    public abstract ApplicationIdentity getApplicationIdentity();

    public CertificateValidator getCertificateValidator() {
        return this.cr;
    }

    public abstract EncoderContext getEncoderContext();

    public DataTypeDictionary getKnownDataTypeDictionary() {
        return this.ct;
    }

    public NamespaceTable getNamespaceTable() {
        return this.getEncoderContext().getNamespaceTable();
    }

    public OperationLimits getOperationLimits() {
        return this.cu;
    }

    public RegisteredClasses getRegisteredClasses() {
        return this.cs;
    }

    public abstract ServerTable getServerTable();

    public boolean isAutoDiscoverCodegenModels() {
        return this.cv;
    }

    public void setAutoDiscoverCodegenModels(boolean bl) {
        this.cv = bl;
    }

    public void setCertificateValidator(CertificateValidator certificateValidator) {
        this.cr = certificateValidator;
    }

    public void setOperationLimits(OperationLimits operationLimits) {
        this.cu = operationLimits;
    }

    protected <T extends CodegenModelProvider> void registerAutoDiscoveredModels(Class<T> clazz) {
        logger.debug("Discovering CodegenModels from the classpath");
        ServiceLoader<CodegenModelProvider> serviceLoader = ServiceLoader.load(clazz);
        for (CodegenModelProvider codegenModelProvider : serviceLoader) {
            CodegenModel codegenModel = codegenModelProvider.get();
            logger.debug("Found {}", (Object)codegenModelProvider.getClass().getName());
            this.registerModelInternal(codegenModel);
        }
    }

    protected void registerModelInternal(CodegenModel codegenModel) {
        codegenModel.a(this::getRegisteredClasses, this::getEncoderContext);
        GeneratedDataTypeDictionary generatedDataTypeDictionary = codegenModel.getDataTypeDictionary();
        if (generatedDataTypeDictionary != null) {
            this.ct.addGeneratedDataTypeDictionary(generatedDataTypeDictionary);
        }
    }

    protected StatusCode validateApplicationCertificate(ApplicationIdentity applicationIdentity) {
        if (this.cr != null) {
            return this.cr.validateCertificate(applicationIdentity.getApplicationDescription(), applicationIdentity.getCertificate());
        }
        return StatusCode.GOOD;
    }

    static {
        logger.info("Prosys OPC UA SDK for Java version {}", (Object)cp);
        logger.info("(c) Prosys OPC Ltd. <http://www.prosysopc.com>");
        if (logger.isDebugEnabled()) {
            try {
                Properties properties = (Properties)System.getProperties().clone();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    logger.debug("{}={}", entry.getKey(), entry.getValue());
                }
            }
            catch (Exception exception) {
                logger.warn("Could not debug-print system properties", exception);
            }
        }
    }

    public static enum Protocol {
        Http,
        OpcHttps,
        OpcTcp;


        public static Protocol parseProtocol(String string) {
            String string2 = string.toLowerCase(Locale.ROOT);
            if (string2.equals("http")) {
                return Http;
            }
            if (string2.equals("opc.tcp")) {
                return OpcTcp;
            }
            if (string2.equals("opc.https")) {
                return OpcHttps;
            }
            return Protocol.valueOf(string);
        }

        public String getTransportProfileUri() {
            if (this.equals((Object)Http)) {
                return "http://opcfoundation.org/UA-Profile/Transport/https-uabinary";
            }
            if (this.equals((Object)OpcHttps)) {
                return "http://opcfoundation.org/UA-Profile/Transport/https-uabinary";
            }
            return "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary";
        }

        public String toString() {
            if (this.equals((Object)Http)) {
                return "http";
            }
            if (this.equals((Object)OpcHttps)) {
                return "opc.https";
            }
            return "opc.tcp";
        }
    }

    public static enum DiagnosticMask {
        AdditionalInfo(4),
        InnerDiagnostics(16),
        InnerStatusCode(8),
        LocalizedText(2),
        SymbolicId(1);

        int value;

        private DiagnosticMask(int n3) {
            this.value = n3;
        }

        public int getValue() {
            return this.value;
        }
    }
}

