/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureUtils {
    private static final Logger logger = LoggerFactory.getLogger(StructureUtils.class);

    public static <T> T clone(T t) {
        if (t == null) {
            return null;
        }
        if (t.getClass().isArray()) {
            try {
                Object object = MultiDimensionArrayUtils.deepClone(t);
                return (T)object;
            }
            catch (Exception exception) {
                logger.error("Could not MultiDimensionArrayUtils.deepClone array object: {}, fallback: returning the given object", (Object)t, (Object)exception);
            }
        }
        if (t instanceof Cloneable) {
            try {
                if (t instanceof Structure) {
                    Structure structure = ((Structure)t).clone();
                    return (T)structure;
                }
                Method method = t.getClass().getMethod("clone", new Class[0]);
                Object object = method.invoke(t, new Object[0]);
                return (T)object;
            }
            catch (Exception exception) {
                logger.error("Could not call clone on a Cloneable object: {}, fallback: returning the given object", (Object)t, (Object)exception);
            }
        }
        return t;
    }

    public static <T extends Structure> T[] fixEmptyStructureArrayType(Class<T> clazz, Variant variant) {
        Object[] objectArray;
        if (clazz == null) {
            throw new IllegalArgumentException("The given clazz cannot be null");
        }
        if (variant == null || variant.getValue() == null) {
            return null;
        }
        Object object = variant.getValue();
        if (Structure[].class.equals(object.getClass()) && (objectArray = (Structure[])object).length == 0) {
            Structure[] structureArray = (Structure[])Array.newInstance(clazz, 0);
            return structureArray;
        }
        if (BigDecimal[].class.equals(object.getClass()) && (objectArray = (BigDecimal[])object).length == 0) {
            Structure[] structureArray = (Structure[])Array.newInstance(clazz, 0);
            return structureArray;
        }
        objectArray = (Structure[])object;
        return objectArray;
    }

    public static int hashCode(Object ... objectArray) {
        int n2 = 31;
        int n3 = 1;
        if (objectArray != null && objectArray.length != 0) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object = objectArray[i2];
                int n4 = 0;
                if (object != null) {
                    n4 = object.getClass().isArray() ? (object.getClass().getComponentType().isArray() ? Arrays.deepHashCode((Object[])object) : Arrays.hashCode((Object[])object)) : object.hashCode();
                }
                n3 = 31 * n3 + n4;
            }
        }
        return n3;
    }

    public static boolean scalarOrArrayEquals(Object object, Object object2) {
        boolean bl;
        boolean bl2;
        if (object == object2) {
            return true;
        }
        if (object == null && object2 != null) {
            return false;
        }
        if (object != null && object2 == null) {
            return false;
        }
        boolean bl3 = object.getClass().isArray();
        if (bl3 != (bl2 = object2.getClass().isArray())) {
            return false;
        }
        boolean bl4 = bl3 ? object.getClass().getComponentType().isArray() : false;
        boolean bl5 = bl = bl2 ? object2.getClass().getComponentType().isArray() : false;
        if (bl4 != bl) {
            return false;
        }
        if (bl4) {
            return Arrays.deepEquals((Object[])object, (Object[])object2);
        }
        if (bl3) {
            return Arrays.equals((Object[])object, (Object[])object2);
        }
        return object.equals(object2);
    }

    private StructureUtils() {
    }
}

