/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.BitField;
import com.prosysopc.ua.BitPosition;
import com.prosysopc.ua.OptionSetDataType;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractOptionSetDataType<T extends Enum<T>, S extends Number, U extends AbstractOptionSetDataType<T, S, U, V>, V extends AbstractBuilder<T>>
implements OptionSetDataType<T, S> {
    protected final BitField delegate;
    protected final Class<T> optionClass;
    protected final Class<S> builtInTypeClass;
    protected final UaNodeId baseDataTypeId;
    protected int sizeInBits;

    @SafeVarargs
    protected static <T extends Enum<T>> BitField computeBitField(AbstractOptionSetDataType<T, ?, ?, ?> ... abstractOptionSetDataTypeArray) {
        if (abstractOptionSetDataTypeArray == null || abstractOptionSetDataTypeArray.length == 0) {
            return UnsignedByte.ZERO;
        }
        HashSet<T> hashSet = new HashSet<T>();
        for (AbstractOptionSetDataType<T, ?, ?, ?> abstractOptionSetDataType : abstractOptionSetDataTypeArray) {
            hashSet.addAll(abstractOptionSetDataType.toSet());
        }
        return AbstractOptionSetDataType.computeBitField(hashSet);
    }

    protected static BitField computeBitField(BitSet bitSet) {
        if (bitSet == null || bitSet.isEmpty()) {
            return UnsignedByte.ZERO;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0 && n2 <= 63) {
            arrayList.add(n2);
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        int[] nArray = new int[arrayList.size()];
        int n3 = 0;
        for (Integer n4 : arrayList) {
            nArray[n3] = n4;
            ++n3;
        }
        return AbstractOptionSetDataType.computeBitField(nArray);
    }

    protected static BitField computeBitField(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return UnsignedByte.ZERO;
        }
        int n2 = -1;
        long l2 = 0L;
        for (int n3 : nArray) {
            if (n3 > n2) {
                n2 = n3;
            }
            l2 |= (long)(1 << n3);
        }
        if (n2 < 8) {
            byte by = (byte)l2;
            return UnsignedByte.getFromBits(by);
        }
        if (n2 < 16) {
            short s2 = (short)l2;
            return UnsignedShort.getFromBits(s2);
        }
        if (n2 < 32) {
            int n4 = (int)l2;
            return UnsignedInteger.getFromBits(n4);
        }
        if (n2 < 64) {
            return UnsignedLong.getFromBits(l2);
        }
        throw new IllegalArgumentException("Too large bit position: " + n2);
    }

    protected static <T extends Enum<T>> BitField computeBitField(Iterable<T> iterable) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Enum enum_ : iterable) {
            hashSet.add(((BitPosition)((Object)enum_)).getBitPosition());
        }
        Object object = new int[hashSet.size()];
        int n2 = 0;
        for (Integer n3 : hashSet) {
            object[n2] = n3;
            ++n2;
        }
        return AbstractOptionSetDataType.computeBitField((int[])object);
    }

    protected static <T extends Enum<T>> BitField computeBitField(T ... TArray) {
        if (TArray == null || TArray.length == 0) {
            return UnsignedByte.ZERO;
        }
        int[] nArray = new int[TArray.length];
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            nArray[i2] = ((BitPosition)TArray[i2]).getBitPosition();
        }
        return AbstractOptionSetDataType.computeBitField(nArray);
    }

    protected static BitField computeBitFieldFixedSize(int n2, int ... nArray) {
        long l2 = 0L;
        for (int n3 : nArray) {
            l2 |= (long)(1 << n3);
        }
        if (n2 == 8) {
            byte by = (byte)l2;
            return UnsignedByte.getFromBits(by);
        }
        if (n2 == 16) {
            short s2 = (short)l2;
            return UnsignedShort.getFromBits(s2);
        }
        if (n2 == 32) {
            int n4 = (int)l2;
            return UnsignedInteger.getFromBits(n4);
        }
        if (n2 == 64) {
            return UnsignedLong.getFromBits(l2);
        }
        throw new IllegalArgumentException("Unsupported size for constructing BitField: " + n2);
    }

    protected AbstractOptionSetDataType(BitField bitField, Class<T> clazz, Class<S> clazz2, UaNodeId uaNodeId, int n2) {
        this.delegate = bitField;
        this.optionClass = clazz;
        this.builtInTypeClass = clazz2;
        this.baseDataTypeId = uaNodeId;
        this.sizeInBits = n2;
    }

    @Override
    public final S asBuiltInType() {
        return this.computeBuiltInTypeValue(this.builtInTypeClass, this.getSizeInBits());
    }

    public final boolean containsAll(U u) {
        if (u == null) {
            throw new IllegalArgumentException("Null value not permitted");
        }
        return this.containsAll((U)((AbstractOptionSetDataType)u).toSet());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractOptionSetDataType abstractOptionSetDataType = (AbstractOptionSetDataType)object;
        if (this.delegate == null && abstractOptionSetDataType.delegate != null) {
            return false;
        }
        if (this.delegate instanceof Number && abstractOptionSetDataType.delegate instanceof Number) {
            return ((Number)((Object)this.delegate)).longValue() == ((Number)((Object)abstractOptionSetDataType.delegate)).longValue();
        }
        return false;
    }

    @Override
    public final UaNodeId getBaseTypeId() {
        return this.baseDataTypeId;
    }

    @Override
    public final Class<S> getBuiltInTypeClass() {
        return this.builtInTypeClass;
    }

    @Override
    public final int getSizeInBits() {
        return this.sizeInBits;
    }

    public final S getValue() {
        return this.asBuiltInType();
    }

    public final int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = this.delegate instanceof Number ? 31 * n3 + Long.valueOf(((Number)((Object)this.delegate)).longValue()).hashCode() : 31 * n3 + (this.delegate == null ? 0 : this.delegate.hashCode());
        return n3;
    }

    @Override
    public final boolean isBitSet(int n2) {
        return this.delegate.isBitSet(n2);
    }

    public V toBuilder() {
        AbstractBuilder abstractBuilder = (AbstractBuilder)this.specification().toInstanceBuilder();
        for (Enum enum_ : this.toSet()) {
            abstractBuilder.add((OptionSpecification)((Object)enum_));
        }
        return (V)abstractBuilder;
    }

    public final Set<T> toSet() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        this.specification().getOptions().stream().map(optionSpecification -> (Enum)this.optionClass.cast(optionSpecification)).filter(enum_ -> this.contains((OptionSpecification)((Object)enum_))).forEach(enum_ -> linkedHashSet.add(enum_));
        return linkedHashSet;
    }

    public final String toString() {
        return this.delegate.toString();
    }

    private final int[] onBitsPositions(int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.isBitSet(i2)) continue;
            arrayList.add(i2);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            nArray[i3] = (Integer)arrayList.get(i3);
        }
        return nArray;
    }

    protected final S computeBuiltInTypeValue(Class<S> clazz, int n2) {
        if (clazz.equals(this.delegate.getClass())) {
            return (S)((Number)clazz.cast(this.delegate));
        }
        return (S)((Number)clazz.cast(AbstractOptionSetDataType.computeBitFieldFixedSize(n2, this.onBitsPositions(n2))));
    }

    public static abstract class AbstractBuilder<T extends Enum<T>>
    implements UaOptionSet.Builder {
        protected final BitSet data = new BitSet();
        private final OptionSetSpecification specification;

        protected AbstractBuilder(OptionSetSpecification optionSetSpecification) {
            this.specification = optionSetSpecification;
        }

        @Override
        public final UaOptionSet.Builder add(OptionSpecification ... optionSpecificationArray) {
            if (optionSpecificationArray == null || optionSpecificationArray.length == 0) {
                return this;
            }
            for (OptionSpecification optionSpecification : Arrays.asList(optionSpecificationArray)) {
                if (!this.specification.getOptions().contains(optionSpecification)) continue;
                this.data.set(optionSpecification.getBitPosition());
            }
            return this;
        }

        @Override
        public UaOptionSet.Builder addAll(Iterable<? extends OptionSpecification> iterable) {
            if (iterable == null) {
                throw new IllegalArgumentException("Null collection not permitted");
            }
            for (OptionSpecification optionSpecification : iterable) {
                this.add(optionSpecification);
            }
            return this;
        }

        @Override
        public final UaOptionSet.Builder clear() {
            this.data.clear();
            return this;
        }

        @Override
        public final boolean contains(OptionSpecification ... optionSpecificationArray) {
            if (optionSpecificationArray == null) {
                throw new IllegalArgumentException("Null array value not permitted");
            }
            return this.containsAll(Arrays.asList(optionSpecificationArray));
        }

        @Override
        public boolean containsAll(Iterable<? extends OptionSpecification> iterable) {
            if (iterable == null) {
                throw new IllegalArgumentException("Null array value not permitted");
            }
            for (OptionSpecification optionSpecification : iterable) {
                if (this.specification.getOptions().contains(optionSpecification)) {
                    if (this.data.get(optionSpecification.getBitPosition())) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public final UaOptionSet.Builder remove(OptionSpecification ... optionSpecificationArray) {
            if (optionSpecificationArray == null || optionSpecificationArray.length == 0) {
                return this;
            }
            for (OptionSpecification optionSpecification : Arrays.asList(optionSpecificationArray)) {
                if (!this.specification.getOptions().contains(optionSpecification)) continue;
                this.data.clear(optionSpecification.getBitPosition());
            }
            return this;
        }

        @Override
        public UaOptionSet.Builder removeAll(Iterable<? extends OptionSpecification> iterable) {
            if (iterable == null) {
                throw new IllegalArgumentException("Null collection not permitted");
            }
            for (OptionSpecification optionSpecification : iterable) {
                this.remove(optionSpecification);
            }
            return this;
        }

        @Override
        public OptionSetSpecification specification() {
            return this.specification;
        }
    }
}

