/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.point;

import com.tridium.json.JSONArray;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.BNiagaraCloudNetwork;
import com.tridium.nc.CloudMessageCallback;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.devices.CloudDecodeMsg;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.devices.CloudMessage;
import com.tridium.nc.devices.CloudReadHandler;
import com.tridium.nc.devices.CloudWriteHandler;
import com.tridium.nc.devices.sentience.SentienceRegisterCmdRequestV1;
import com.tridium.nc.devices.sentience.points.CloudMultiPointData;
import com.tridium.nc.point.BCloudLearnConfig;
import com.tridium.nc.point.BCloudPointDiscoveryJob;
import com.tridium.nc.point.BCloudPointDiscoveryLeaf;
import com.tridium.nc.point.BCloudPointDiscoveryPreferences;
import com.tridium.nc.point.BCloudPointFolder;
import com.tridium.nc.point.BCloudPointLearnJob;
import com.tridium.nc.point.BCloudProxyExt;
import com.tridium.nc.point.BSetCovParameter;
import com.tridium.nc.point.BSubscribePointParameter;
import com.tridium.nc.point.BatchPointUpdater;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.ndriver.point.BNPointDeviceExt;
import com.tridium.nre.util.NamedThreadFactory;
import com.tridium.util.CompUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="discoveryPreferences", type="BCloudPointDiscoveryPreferences", defaultValue="new BCloudPointDiscoveryPreferences()", flags=4, override=true), @NiagaraProperty(name="batchUpdateEnabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="batchSize", type="int", defaultValue="500", facets={@Facet(name="BFacets.MIN", value="BInteger.make(100)"), @Facet(name="BFacets.MAX", value="BInteger.make(10000)")}), @NiagaraProperty(name="priorityUpdateInterval", type="BRelTime", defaultValue="BRelTime.makeSeconds(30)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(5)")}), @NiagaraProperty(name="standardUpdateInterval", type="BRelTime", defaultValue="BRelTime.makeMinutes(5)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(60)")}), @NiagaraProperty(name="backgroundUpdateInterval", type="BRelTime", defaultValue="BRelTime.makeMinutes(15)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeMinutes(5)")}), @NiagaraProperty(name="maxCovPoints", type="int", defaultValue="MAX_COV_POINTS"), @NiagaraProperty(name="useHandleForPointId", type="boolean", defaultValue="true"), @NiagaraProperty(name="forceRelinquishEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="forceWriteDelay", type="BRelTime", defaultValue="BRelTime.make(100)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(0)"), @Facet(name="BFacets.MAX", value="BRelTime.make(10000)"), @Facet(name="BFacets.SHOW_MILLISECONDS", value="BBoolean.TRUE")})})
@NiagaraActions(value={@NiagaraAction(name="learnPoints", parameterType="BCloudLearnConfig", defaultValue="new BCloudLearnConfig()", returnType="BOrd", flags=4), @NiagaraAction(name="setCovActive", parameterType="BSetCovParameter", defaultValue="BSetCovParameter.make(\"\")", returnType="BBoolean", flags=4), @NiagaraAction(name="setCovInactive", parameterType="BSetCovParameter", defaultValue="BSetCovParameter.make(\"\")", returnType="BBoolean", flags=4), @NiagaraAction(name="subscribePoint", parameterType="BSubscribePointParameter", defaultValue="BSubscribePointParameter.make(\"\")", returnType="BBoolean", flags=4), @NiagaraAction(name="unsubscribePoint", parameterType="BSubscribePointParameter", defaultValue="BSubscribePointParameter.make(\"\")", returnType="BBoolean", flags=4)})
public class BCloudPointDeviceExt
extends BNPointDeviceExt {
    private static final int MAX_COV_POINTS = 20;
    private static final Lexicon LEX = Lexicon.make((String)"nCloudDriver");
    public static final Property discoveryPreferences = BCloudPointDeviceExt.newProperty((int)4, (BValue)new BCloudPointDiscoveryPreferences(), null);
    public static final Property batchUpdateEnabled = BCloudPointDeviceExt.newProperty((int)0, (boolean)true, null);
    public static final Property batchSize = BCloudPointDeviceExt.newProperty((int)0, (int)500, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)100)), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)10000))));
    public static final Property priorityUpdateInterval = BCloudPointDeviceExt.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)5)));
    public static final Property standardUpdateInterval = BCloudPointDeviceExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)5), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)60)));
    public static final Property backgroundUpdateInterval = BCloudPointDeviceExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)5)));
    public static final Property maxCovPoints = BCloudPointDeviceExt.newProperty((int)0, (int)20, null);
    public static final Property useHandleForPointId = BCloudPointDeviceExt.newProperty((int)0, (boolean)true, null);
    public static final Property forceRelinquishEnabled = BCloudPointDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Property forceWriteDelay = BCloudPointDeviceExt.newProperty((int)0, (BValue)BRelTime.make((long)100L), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.make((long)10000L))), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE)));
    public static final Action learnPoints = BCloudPointDeviceExt.newAction((int)4, (BValue)new BCloudLearnConfig(), null);
    public static final Action setCovActive = BCloudPointDeviceExt.newAction((int)4, (BValue)BSetCovParameter.make(""), null);
    public static final Action setCovInactive = BCloudPointDeviceExt.newAction((int)4, (BValue)BSetCovParameter.make(""), null);
    public static final Action subscribePoint = BCloudPointDeviceExt.newAction((int)4, (BValue)BSubscribePointParameter.make(""), null);
    public static final Action unsubscribePoint = BCloudPointDeviceExt.newAction((int)4, (BValue)BSubscribePointParameter.make(""), null);
    public static final Type TYPE = Sys.loadType(BCloudPointDeviceExt.class);
    public static final BCloudPointDiscoveryLeaf[] EMPTY_DISCOVERY_POINTS = new BCloudPointDiscoveryLeaf[0];
    private static final int EXECUTOR_POOL_SIZE = 3;
    private ScheduledExecutorService updater;
    private ScheduledFuture updateFuturePriority;
    private ScheduledFuture updateFutureStandard;
    private ScheduledFuture updateFutureBackground;
    private final Map<BControlPoint, BCloudProxyExt> proxyExtBySourcePointMap = new HashMap<BControlPoint, BCloudProxyExt>();
    private final CloudPointRead readCallback = new CloudPointRead();
    private final CloudMultiPointRead multiReadCallback = new CloudMultiPointRead();
    private final CloudPointWrite writeCallback = new CloudPointWrite();
    private final CloudMultiPointWrite multiWriteCallback = new CloudMultiPointWrite();
    private Set<BCloudProxyExt> covPoints = new HashSet<BCloudProxyExt>();
    private final Map<String, Clock.Ticket> covCancelTickets = new HashMap<String, Clock.Ticket>();
    private static final ReentrantLock covLock = new ReentrantLock();
    private final Map<String, Clock.Ticket> subCancelTickets = new HashMap<String, Clock.Ticket>();
    private static final ReentrantLock subLock = new ReentrantLock();
    private static final Logger log = Logger.getLogger("ncloud.point");

    public boolean getBatchUpdateEnabled() {
        return this.getBoolean(batchUpdateEnabled);
    }

    public void setBatchUpdateEnabled(boolean v) {
        this.setBoolean(batchUpdateEnabled, v, null);
    }

    public int getBatchSize() {
        return this.getInt(batchSize);
    }

    public void setBatchSize(int v) {
        this.setInt(batchSize, v, null);
    }

    public BRelTime getPriorityUpdateInterval() {
        return (BRelTime)this.get(priorityUpdateInterval);
    }

    public void setPriorityUpdateInterval(BRelTime v) {
        this.set(priorityUpdateInterval, (BValue)v, null);
    }

    public BRelTime getStandardUpdateInterval() {
        return (BRelTime)this.get(standardUpdateInterval);
    }

    public void setStandardUpdateInterval(BRelTime v) {
        this.set(standardUpdateInterval, (BValue)v, null);
    }

    public BRelTime getBackgroundUpdateInterval() {
        return (BRelTime)this.get(backgroundUpdateInterval);
    }

    public void setBackgroundUpdateInterval(BRelTime v) {
        this.set(backgroundUpdateInterval, (BValue)v, null);
    }

    public int getMaxCovPoints() {
        return this.getInt(maxCovPoints);
    }

    public void setMaxCovPoints(int v) {
        this.setInt(maxCovPoints, v, null);
    }

    public boolean getUseHandleForPointId() {
        return this.getBoolean(useHandleForPointId);
    }

    public void setUseHandleForPointId(boolean v) {
        this.setBoolean(useHandleForPointId, v, null);
    }

    public boolean getForceRelinquishEnabled() {
        return this.getBoolean(forceRelinquishEnabled);
    }

    public void setForceRelinquishEnabled(boolean v) {
        this.setBoolean(forceRelinquishEnabled, v, null);
    }

    public BRelTime getForceWriteDelay() {
        return (BRelTime)this.get(forceWriteDelay);
    }

    public void setForceWriteDelay(BRelTime v) {
        this.set(forceWriteDelay, (BValue)v, null);
    }

    public BOrd learnPoints(BCloudLearnConfig parameter) {
        return (BOrd)this.invoke(learnPoints, (BValue)parameter, null);
    }

    public BBoolean setCovActive(BSetCovParameter parameter) {
        return (BBoolean)this.invoke(setCovActive, (BValue)parameter, null);
    }

    public BBoolean setCovInactive(BSetCovParameter parameter) {
        return (BBoolean)this.invoke(setCovInactive, (BValue)parameter, null);
    }

    public BBoolean subscribePoint(BSubscribePointParameter parameter) {
        return (BBoolean)this.invoke(subscribePoint, (BValue)parameter, null);
    }

    public BBoolean unsubscribePoint(BSubscribePointParameter parameter) {
        return (BBoolean)this.invoke(unsubscribePoint, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.covPoints = new HashSet<BCloudProxyExt>(this.getMaxCovPoints());
        this.updater = new PointExecutor("nCD[" + this.getDevice().getName() + "].batchPtUpdate", 2L, TimeUnit.MINUTES);
        if (Sys.atSteadyState()) {
            this.startUpdateThreads();
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.updateFuturePriority != null) {
            this.updateFuturePriority.cancel(true);
            this.updateFuturePriority = null;
        }
        if (this.updateFutureStandard != null) {
            this.updateFutureStandard.cancel(true);
            this.updateFutureStandard = null;
        }
        if (this.updateFutureBackground != null) {
            this.updateFutureBackground.cancel(true);
            this.updateFutureBackground = null;
        }
        this.updater.shutdownNow();
    }

    public void descendantsStopped() throws Exception {
        super.descendantsStopped();
        this.covPoints = null;
    }

    public void descendantsStarted() throws Exception {
        BControlPoint[] points;
        super.descendantsStarted();
        for (BControlPoint point : points = this.getPoints()) {
            BCloudProxyExt proxyExt = (BCloudProxyExt)point.getProxyExt();
            if (!proxyExt.isFatalFault()) continue;
            log.warning(proxyExt.getFaultCause());
            break;
        }
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.startUpdateThreads();
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.remove("ndriver:NPointManager");
        return agents;
    }

    private void startUpdateThreads() {
        if (this.getBatchUpdateEnabled()) {
            this.updateFuturePriority = this.updater.scheduleAtFixedRate(new BatchPointUpdater(this, BPollFrequency.fast), 0L, this.getPriorityUpdateInterval().getSeconds(), TimeUnit.SECONDS);
            this.updateFutureStandard = this.updater.scheduleAtFixedRate(new BatchPointUpdater(this, BPollFrequency.normal), 5L, this.getStandardUpdateInterval().getSeconds(), TimeUnit.SECONDS);
            this.updateFutureBackground = this.updater.scheduleAtFixedRate(new BatchPointUpdater(this, BPollFrequency.slow), 15L, this.getBackgroundUpdateInterval().getSeconds(), TimeUnit.SECONDS);
        }
    }

    public void changed(Property p, Context cx) {
        block19: {
            block17: {
                block18: {
                    super.changed(p, cx);
                    if (!this.isRunning()) {
                        return;
                    }
                    if (!p.equals(batchUpdateEnabled)) break block17;
                    if (!this.getBatchUpdateEnabled()) break block18;
                    this.startUpdateThreads();
                    break block19;
                }
                if (this.updateFuturePriority != null) {
                    this.updateFuturePriority.cancel(false);
                }
                if (this.updateFutureStandard != null) {
                    this.updateFutureStandard.cancel(false);
                }
                if (this.updateFutureBackground == null) break block19;
                this.updateFutureBackground.cancel(false);
                break block19;
            }
            if (p.equals(batchSize)) {
                if (this.getBatchSize() <= 0) {
                    this.setBatchSize(1);
                }
            } else if (p.equals(priorityUpdateInterval)) {
                if (this.getBatchUpdateEnabled()) {
                    this.updateFuturePriority.cancel(false);
                    this.updateFuturePriority = this.updater.scheduleAtFixedRate(new BatchPointUpdater(this, BPollFrequency.fast), 0L, this.getPriorityUpdateInterval().getSeconds(), TimeUnit.SECONDS);
                }
            } else if (p.equals(standardUpdateInterval)) {
                if (this.getBatchUpdateEnabled()) {
                    this.updateFutureStandard.cancel(false);
                    this.updateFutureStandard = this.updater.scheduleAtFixedRate(new BatchPointUpdater(this, BPollFrequency.normal), 5L, this.getStandardUpdateInterval().getSeconds(), TimeUnit.SECONDS);
                }
            } else if (p.equals(backgroundUpdateInterval)) {
                if (this.getBatchUpdateEnabled()) {
                    this.updateFutureBackground.cancel(false);
                    this.updateFutureBackground = this.updater.scheduleAtFixedRate(new BatchPointUpdater(this, BPollFrequency.slow), 15L, this.getBackgroundUpdateInterval().getSeconds(), TimeUnit.SECONDS);
                }
            } else if (p.equals(useHandleForPointId)) {
                BControlPoint[] points;
                for (BControlPoint point : points = this.getPoints()) {
                    CloudUtilities.cloudProxy(point).setPointId(CloudUtilities.makePointId(CloudUtilities.cloudProxy(point)));
                }
            }
        }
    }

    public void renamed(Property p, String oldName, Context cx) {
        BAbstractProxyExt px;
        BValue pt = this.get(p);
        if (pt.getType().is(BControlPoint.TYPE) && (px = ((BControlPoint)pt).getProxyExt()) instanceof BCloudProxyExt) {
            ((BCloudProxyExt)px).setPointId(CloudUtilities.makePointId((BCloudProxyExt)px));
        }
    }

    public BOrd doLearnPoints(BCloudLearnConfig parameter, Context cx) {
        BCloudPointLearnJob job = new BCloudPointLearnJob(this, parameter);
        return job.submit(null);
    }

    public Type getDeviceType() {
        return BCloudDevice.TYPE;
    }

    public Type getPointFolderType() {
        return BCloudPointFolder.TYPE;
    }

    public Type getProxyExtType() {
        return BCloudProxyExt.TYPE;
    }

    public BOrd doSubmitDiscoveryJob(BNDiscoveryPreferences prefs) {
        this.setDiscoveryPreferences((BNDiscoveryPreferences)prefs.newCopy());
        BCloudPointDiscoveryJob job = new BCloudPointDiscoveryJob(this);
        job.setDiscoveryPreferences((BNDiscoveryPreferences)prefs.newCopy());
        return job.submit(null);
    }

    public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences prefs) throws Exception {
        BCloudPointDiscoveryPreferences cprefs = (BCloudPointDiscoveryPreferences)prefs.newCopy();
        this.setDiscoveryPreferences(cprefs);
        BITable result = (BITable)cprefs.getPointQuery().resolve((BObject)this).get();
        TableCursor c = result.cursor();
        String thisSlotPath = this.getSlotPath().toString();
        ArrayList<BCloudPointDiscoveryLeaf> points = new ArrayList<BCloudPointDiscoveryLeaf>();
        while (c.next()) {
            BControlPoint point = (BControlPoint)c.get();
            String slotPath = point.getSlotPath().toString();
            if (slotPath.startsWith(thisSlotPath)) continue;
            points.add(BCloudPointDiscoveryLeaf.make(point));
        }
        return (BINDiscoveryObject[])points.toArray(EMPTY_DISCOVERY_POINTS);
    }

    public CloudMessageCallback getReadCallback() {
        return this.readCallback;
    }

    public CloudMessageCallback getMultiReadCallback() {
        return this.multiReadCallback;
    }

    public CloudMessageCallback getWriteCallback() {
        return this.writeCallback;
    }

    public CloudMessageCallback getMultiWriteCallback() {
        return this.multiWriteCallback;
    }

    public void registerForCommands() {
        ArrayList<SentienceRegisterCmdRequestV1.RegisterCommandTypes> list = new ArrayList<SentienceRegisterCmdRequestV1.RegisterCommandTypes>();
        list.add(SentienceRegisterCmdRequestV1.RegisterCommandTypes.POINT_READ_REQUEST);
        list.add(SentienceRegisterCmdRequestV1.RegisterCommandTypes.POINT_WRITE_REQUEST);
        list.add(SentienceRegisterCmdRequestV1.RegisterCommandTypes.MULTI_POINT_READ_REQUEST);
        list.add(SentienceRegisterCmdRequestV1.RegisterCommandTypes.MULTI_POINT_WRITE_REQUEST);
        CloudEncodeMsg registerCmdReq = this.getCloudDevice().getFactory().createRegisterCmdRequestMsg(list);
        this.getCloudDevice().resolveConnector().sendMessage(registerCmdReq.encode(null), registerCmdReq.getProperties(null)).whenComplete((resp, err) -> {
            if (err != null) {
                log.warning("Failed to register point read/write commands");
            } else {
                log.fine("Point read/write commands registered successfully");
            }
        });
    }

    public final BNiagaraCloudNetwork getNiagaraCloudNetwork() {
        return (BNiagaraCloudNetwork)this.getNetwork();
    }

    public final BCloudDevice getCloudDevice() {
        return (BCloudDevice)this.getDevice();
    }

    public final BCloudProxyExt getProxyExtBySource(BControlPoint sourcePoint) {
        return this.proxyExtBySourcePointMap.get(sourcePoint);
    }

    void registerPoint(BControlPoint sourcePoint, BCloudProxyExt proxyExt) {
        this.proxyExtBySourcePointMap.put(sourcePoint, proxyExt);
    }

    void unregisterPoint(BControlPoint sourcePoint, BCloudProxyExt proxyExt) {
        if (this.proxyExtBySourcePointMap.get(sourcePoint) == proxyExt) {
            this.proxyExtBySourcePointMap.remove(sourcePoint);
        }
    }

    public static boolean writePoint(BControlPoint pxPoint, Object objValue, int priority, BRelTime duration, String source, String messageId, Context cx) {
        return CloudUtilities.cloudWriteController(pxPoint).writePoint(objValue, priority, duration, source, messageId, cx);
    }

    public static void clearPoint(BControlPoint pxPoint, int priority) {
        CloudUtilities.cloudWriteController(pxPoint).clearPoint(priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BBoolean doSetCovActive(BSetCovParameter covInfo, Context cx) {
        if (!cx.getUser().getPermissionsFor((BIProtected)this).hasAdminWrite()) {
            log.warning(() -> String.format("Attempt to set COV point %s active: access not allowed %s", covInfo.getPointId(), covInfo.getMessageId()));
            return BBoolean.FALSE;
        }
        String pointId = covInfo.getPointId();
        BControlPoint export = CloudUtilities.getPoint(pointId);
        if (export == null) {
            return BBoolean.FALSE;
        }
        BCloudProxyExt proxyExt = CloudUtilities.cloudProxy(export);
        covLock.lock();
        try {
            if (this.covPoints.contains((Object)proxyExt)) {
                BBoolean bBoolean = BBoolean.TRUE;
                return bBoolean;
            }
            int maxCov = this.getMaxCovPoints();
            if (this.covPoints.size() >= maxCov) {
                log.fine(() -> String.format("Attempt to add COV point %s beyond max allowed size of %s cov points %s", pointId, maxCov, covInfo.getMessageId()));
                BBoolean bBoolean = BBoolean.FALSE;
                return bBoolean;
            }
            CompUtil.setOrAdd((BComponent)proxyExt, (String)"covToCloudValue", (BValue)proxyExt.getPointValue().newCopy(), (int)7, null, null);
            BControlPoint srcPoint = proxyExt.getPoint();
            if (srcPoint != null && !proxyExt.isFault()) {
                BLink covLink = new BLink(srcPoint.getHandleOrd(), "out", "covToCloudValue", true);
                proxyExt.add("covLink", (BValue)covLink, 2, Context.decoding);
                proxyExt.setIsCovActive(true);
                this.covPoints.add(proxyExt);
                Clock.Ticket cancelTicket = Clock.schedule((BComponent)this, (BRelTime)proxyExt.getCloudTuningPolicy().getCovModeDuration(), (Action)setCovInactive, (BValue)covInfo);
                this.covCancelTickets.put(pointId, cancelTicket);
                BBoolean bBoolean = BBoolean.TRUE;
                return bBoolean;
            }
            log.fine(() -> String.format("Cannot add COV point %s; station %s %s", pointId, srcPoint == null ? "source point not found" : "proxy point in fault", covInfo.getMessageId()));
            BBoolean bBoolean = BBoolean.FALSE;
            return bBoolean;
        }
        finally {
            covLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BBoolean doSetCovInactive(BSetCovParameter covInfo, Context cx) {
        if (cx != null && !cx.getUser().getPermissionsFor((BIProtected)this).hasAdminWrite()) {
            log.warning(() -> String.format("Attempt to set COV point %s inactive: access not allowed %s", covInfo.getPointId(), covInfo.getMessageId()));
            return BBoolean.FALSE;
        }
        String pointId = covInfo.getPointId();
        BControlPoint export = CloudUtilities.getPoint(pointId);
        if (export == null) {
            return BBoolean.FALSE;
        }
        BCloudProxyExt proxyExt = CloudUtilities.cloudProxy(export);
        covLock.lock();
        try {
            if (!this.covPoints.contains((Object)proxyExt)) {
                BBoolean bBoolean = BBoolean.TRUE;
                return bBoolean;
            }
            if (proxyExt.get("covToCloudValue") != null) {
                proxyExt.remove("covToCloudValue");
            }
            if (proxyExt.get("covLink") != null) {
                proxyExt.remove("covLink");
            }
            proxyExt.setIsCovActive(false);
            this.covPoints.remove((Object)proxyExt);
            BBoolean bBoolean = BBoolean.TRUE;
            return bBoolean;
        }
        finally {
            Clock.Ticket ticket = this.covCancelTickets.remove(pointId);
            if (ticket != null) {
                ticket.cancel();
            }
            covLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BBoolean doSubscribePoint(BSubscribePointParameter ptParam, Context cx) {
        if (!cx.getUser().getPermissionsFor((BIProtected)this).hasAdminWrite()) {
            log.warning(() -> String.format("Attempt to subscribe point %s: access not allowed %s", ptParam.getPointId(), ptParam.getMessageId()));
            return BBoolean.FALSE;
        }
        String pointId = ptParam.getPointId();
        BControlPoint export = CloudUtilities.getPoint(pointId);
        if (export == null) {
            return BBoolean.FALSE;
        }
        BCloudProxyExt proxyExt = CloudUtilities.cloudProxy(export);
        subLock.lock();
        try {
            proxyExt.subscribeSourcePoint();
            Clock.Ticket cancelTicket = Clock.schedule((BComponent)this, (BRelTime)ptParam.getDuration(), (Action)unsubscribePoint, (BValue)BSubscribePointParameter.make(pointId));
            this.subCancelTickets.put(pointId, cancelTicket);
            BBoolean bBoolean = BBoolean.TRUE;
            return bBoolean;
        }
        finally {
            subLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BBoolean doUnsubscribePoint(BSubscribePointParameter ptParam, Context cx) {
        if (cx != null && !cx.getUser().getPermissionsFor((BIProtected)this).hasAdminWrite()) {
            log.warning(() -> String.format("Attempt to unsubscribe point %s: access not allowed %s", ptParam.getPointId(), ptParam.getMessageId()));
            return BBoolean.FALSE;
        }
        String pointId = ptParam.getPointId();
        BControlPoint export = CloudUtilities.getPoint(pointId);
        if (export == null) {
            return BBoolean.FALSE;
        }
        BCloudProxyExt proxyExt = CloudUtilities.cloudProxy(export);
        subLock.lock();
        try {
            proxyExt.updatePointSubscription();
            BBoolean bBoolean = BBoolean.TRUE;
            return bBoolean;
        }
        finally {
            Clock.Ticket ticket = this.subCancelTickets.remove(pointId);
            if (ticket != null) {
                ticket.cancel();
            }
            subLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle((Object)"CloudPointDeviceExt", 2);
        out.prop((Object)"updater", (Object)this.updater);
        out.prop((Object)"updateFuturePriority", (Object)this.updateFuturePriority);
        out.prop((Object)"updateFutureStandard", (Object)this.updateFutureStandard);
        out.prop((Object)"updateFutureBackground", (Object)this.updateFutureBackground);
        out.startTable(true);
        out.trTitle((Object)"COV Points", 3);
        out.w((Object)"<tr>").th((Object)"SlotPath").th((Object)"PointId").th((Object)"OrdPath").w((Object)"</tr>\n");
        covLock.lock();
        try {
            for (BCloudProxyExt bCloudProxyExt : this.covPoints) {
                out.tr((Object)bCloudProxyExt.getSlotPath(), (Object)bCloudProxyExt.getPointId(), (Object)bCloudProxyExt.getOrdPath());
            }
            out.endTable();
            out.startTable(true);
            out.trTitle((Object)"COV Cancellation Tickets", 2);
            out.w((Object)"<tr>").th((Object)"PointId").th((Object)"Ticket").w((Object)"</tr>\n");
            for (Map.Entry entry : this.covCancelTickets.entrySet()) {
                out.tr(entry.getKey(), entry.getValue());
            }
        }
        finally {
            covLock.unlock();
        }
        out.endTable();
        out.startTable(true);
        out.trTitle((Object)"Subscription Cancellation Tickets", 2);
        out.w((Object)"<tr>").th((Object)"PointId").th((Object)"Ticket").w((Object)"</tr>\n");
        subLock.lock();
        try {
            for (Map.Entry entry : this.subCancelTickets.entrySet()) {
                out.tr(entry.getKey(), entry.getValue());
            }
        }
        finally {
            subLock.unlock();
        }
        out.endTable();
        out.prop((Object)"Proxy Ext Map size", this.proxyExtBySourcePointMap.size());
        out.startTable(true);
        out.trTitle((Object)"Proxy Ext Map By Source Point", 3);
        out.w((Object)"<tr>").th((Object)"Source Point").th((Object)"Cloud Proxy Ext").th((Object)"Point Id").w((Object)"</tr>\n");
        this.proxyExtBySourcePointMap.forEach((key, value) -> out.tr((Object)key.getSlotPath(), (Object)value.getSlotPath(), (Object)value.getPointId()));
        out.endTable();
        out.endProps();
        super.spy(out);
    }

    public static class PointExecutor
    extends ScheduledThreadPoolExecutor {
        public PointExecutor(String threadPrefix, long keepAliveTime, TimeUnit keepAliveUnits) {
            super(3, (ThreadFactory)new NamedThreadFactory(threadPrefix));
            this.setMaximumPoolSize(3);
            this.setKeepAliveTime(keepAliveTime, keepAliveUnits);
        }
    }

    private class CloudMultiPointWrite
    implements CloudMessageCallback {
        private CloudMultiPointWrite() {
        }

        @Override
        public void onMessage(String messageId, CloudMessage decodedMessage, Context cx) {
            CloudWriteHandler writeHandler = BCloudPointDeviceExt.this.getCloudDevice().getFactory().createWriteHandler();
            writeHandler.handleMultiWriteAndReponse((CloudDecodeMsg)decodedMessage, messageId, cx);
        }

        @Override
        public boolean enabled() {
            return BCloudPointDeviceExt.this.getNiagaraCloudNetwork().getPointWriteAllowed();
        }

        @Override
        public CloudEncodeMsg getResponse() {
            BCloudDevice device = (BCloudDevice)BCloudPointDeviceExt.this.getDevice();
            return device.getFactory().createMultiPointWriteResponseMsg();
        }

        @Override
        public Map<String, Object> getResponseParams(String messageId, CloudDecodeMsg decodedMessage, int code, String message) {
            BCloudDevice device = (BCloudDevice)BCloudPointDeviceExt.this.getDevice();
            HashMap<String, Object> rv = new HashMap<String, Object>();
            ArrayList<CloudMultiPointData> cloudPointDataList = new ArrayList<CloudMultiPointData>();
            rv.put(device.getConstant("POINTVALUES"), cloudPointDataList);
            JSONArray points = (JSONArray)decodedMessage.getData(device.getConstant("POINTWRITES"));
            for (int lcv = 0; lcv < points.length(); ++lcv) {
                cloudPointDataList.add(new CloudMultiPointData(points.getJSONObject(lcv).getString(device.getConstant("POINTID")), message, null));
            }
            return rv;
        }
    }

    private class CloudPointWrite
    implements CloudMessageCallback {
        private CloudPointWrite() {
        }

        @Override
        public void onMessage(String messageId, CloudMessage decodedMessage, Context cx) {
            CloudWriteHandler writeHandler = BCloudPointDeviceExt.this.getCloudDevice().getFactory().createWriteHandler();
            writeHandler.handleWriteAndReponse((CloudDecodeMsg)decodedMessage, messageId, cx);
        }

        @Override
        public boolean enabled() {
            return BCloudPointDeviceExt.this.getNiagaraCloudNetwork().getPointWriteAllowed();
        }

        @Override
        public CloudEncodeMsg getResponse() {
            BCloudDevice device = (BCloudDevice)BCloudPointDeviceExt.this.getDevice();
            return device.getFactory().createPointWriteResponseMsg();
        }

        @Override
        public Map<String, Object> getResponseParams(String messageId, CloudDecodeMsg decodedMessage, int code, String message) {
            BCloudDevice device = (BCloudDevice)BCloudPointDeviceExt.this.getDevice();
            HashMap<String, Object> rv = new HashMap<String, Object>();
            rv.put(device.getConstant("RESULT"), message);
            return rv;
        }
    }

    private class CloudMultiPointRead
    implements CloudMessageCallback {
        private CloudMultiPointRead() {
        }

        @Override
        public void onMessage(String messageId, CloudMessage decodedMessage, Context cx) {
            CloudReadHandler readHandler = BCloudPointDeviceExt.this.getCloudDevice().getFactory().createReadHandler();
            readHandler.handleMultiResponse((CloudDecodeMsg)decodedMessage, messageId, cx);
        }

        @Override
        public boolean enabled() {
            return BCloudPointDeviceExt.this.getNiagaraCloudNetwork().getPointReadAllowed();
        }

        @Override
        public CloudEncodeMsg getResponse() {
            BCloudDevice device = (BCloudDevice)BCloudPointDeviceExt.this.getDevice();
            return device.getFactory().createMultiPointReadResponseMsg();
        }

        @Override
        public Map<String, Object> getResponseParams(String messageId, CloudDecodeMsg decodedMessage, int code, String message) {
            BCloudDevice device = (BCloudDevice)BCloudPointDeviceExt.this.getDevice();
            HashMap<String, Object> rv = new HashMap<String, Object>();
            ArrayList<CloudMultiPointData> cloudPointDataList = new ArrayList<CloudMultiPointData>();
            rv.put(device.getConstant("POINTVALUES"), cloudPointDataList);
            JSONArray points = (JSONArray)decodedMessage.getData(device.getConstant("POINTIDS"));
            for (int lcv = 0; lcv < points.length(); ++lcv) {
                cloudPointDataList.add(new CloudMultiPointData(points.getString(lcv), message, null));
            }
            return rv;
        }
    }

    private class CloudPointRead
    implements CloudMessageCallback {
        private CloudPointRead() {
        }

        @Override
        public void onMessage(String messageId, CloudMessage decodedMessage, Context cx) {
            CloudReadHandler readHandler = BCloudPointDeviceExt.this.getCloudDevice().getFactory().createReadHandler();
            readHandler.handleResponse((CloudDecodeMsg)decodedMessage, messageId, cx);
        }

        @Override
        public boolean enabled() {
            return BCloudPointDeviceExt.this.getNiagaraCloudNetwork().getPointReadAllowed();
        }

        @Override
        public CloudEncodeMsg getResponse() {
            BCloudDevice device = (BCloudDevice)BCloudPointDeviceExt.this.getDevice();
            return device.getFactory().createPointReadResponseMsg();
        }

        @Override
        public Map<String, Object> getResponseParams(String messageId, CloudDecodeMsg decodedMessage, int code, String message) {
            BCloudDevice device = (BCloudDevice)BCloudPointDeviceExt.this.getDevice();
            HashMap<String, Object> rv = new HashMap<String, Object>();
            rv.put(device.getConstant("STATUS"), message);
            return rv;
        }
    }
}

