/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.history;

import com.tridium.cloud.client.BICloudConnector;
import com.tridium.cloud.client.NiagaraMessageType;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudMessageCallback;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.devices.CloudDecodeMsg;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.devices.CloudMessage;
import com.tridium.nc.devices.CloudPointData;
import com.tridium.nc.devices.sentience.history.HistorySample;
import com.tridium.nc.devices.sentience.history.SentienceLastHistoryResponseV1;
import com.tridium.nc.history.BCloudHistoryExport;
import com.tridium.nc.history.BCloudHistoryExportLearnConfig;
import com.tridium.nc.history.BCloudHistoryFolder;
import com.tridium.nc.history.BCloudHistoryLearnJob;
import com.tridium.nc.history.HistoryUtil;
import com.tridium.util.CompUtil;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.driver.history.BHistoryDeviceExt;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BHistorySummary;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ExecutorUtil;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="retryTrigger", type="BTimeTrigger", defaultValue="new BTimeTrigger(BManualTriggerMode.make())", flags=5, override=true), @NiagaraProperty(name="lastHistoryTimestamp", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="batchTriggerTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeMinutes(15)))"), @NiagaraProperty(name="historyBatchSize", type="int", defaultValue="500", facets={@Facet(name="BFacets.MIN", value="100"), @Facet(name="BFacets.MAX", value="10000")}), @NiagaraProperty(name="maxBackfillDuration", type="BRelTime", defaultValue="BRelTime.makeHours(1)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(0)")})})
@NiagaraActions(value={@NiagaraAction(name="pingLastHistory"), @NiagaraAction(name="execute", flags=16), @NiagaraAction(name="learnHistories", parameterType="BCloudHistoryExportLearnConfig", defaultValue="new BCloudHistoryExportLearnConfig()", returnType="BOrd", flags=4)})
public class BCloudHistoryDeviceExt
extends BHistoryDeviceExt {
    public static final Property retryTrigger = BCloudHistoryDeviceExt.newProperty((int)5, (BValue)new BTimeTrigger((BTriggerMode)BManualTriggerMode.make()), null);
    public static final Property lastHistoryTimestamp = BCloudHistoryDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property batchTriggerTime = BCloudHistoryDeviceExt.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)15))), null);
    public static final Property historyBatchSize = BCloudHistoryDeviceExt.newProperty((int)0, (int)500, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)100), (BFacets)BFacets.make((String)"max", (int)10000)));
    public static final Property maxBackfillDuration = BCloudHistoryDeviceExt.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)));
    public static final Action pingLastHistory = BCloudHistoryDeviceExt.newAction((int)0, null);
    public static final Action execute = BCloudHistoryDeviceExt.newAction((int)16, null);
    public static final Action learnHistories = BCloudHistoryDeviceExt.newAction((int)4, (BValue)new BCloudHistoryExportLearnConfig(), null);
    public static final Type TYPE = Sys.loadType(BCloudHistoryDeviceExt.class);
    private final CloudLastHistoryCallback lastHistoryCallback = new CloudLastHistoryCallback();
    private final Lexicon lexicon = Lexicon.make((String)"nCloudDriver");
    private static final Logger log = Logger.getLogger("ncloud.history");
    private ScheduledExecutorService executor;
    public static final String STATUS = "status";
    public static final int HISTORY_BATCH_RECORD_SIZE = 500;
    public static final int HISTORY_BACKFILL_RECORD_COUNT_LIMIT = 100;
    private static final int REGISTER_DELAY_SEC = 10;
    private static final int HDBCONN_LINGER_SEC = 10;
    private static final long updateIntervalErrorMS = 60000L;
    private static final long updateIntervalWarnMS = 300000L;
    private static final long updateIntervalInfoMS = 900000L;
    private long historyMessageSuccessCount;
    private long historyMessageFailureCount;
    private volatile HistoryDatabaseConnection hdbConnection;
    private final Map<BComponent, BCloudHistoryExport> historyExportbySourceMap = new HashMap<BComponent, BCloudHistoryExport>();
    private static final Logger logDbg = Logger.getLogger("ncloud.history.dbg");

    public BAbsTime getLastHistoryTimestamp() {
        return (BAbsTime)this.get(lastHistoryTimestamp);
    }

    public void setLastHistoryTimestamp(BAbsTime v) {
        this.set(lastHistoryTimestamp, (BValue)v, null);
    }

    public BTimeTrigger getBatchTriggerTime() {
        return (BTimeTrigger)this.get(batchTriggerTime);
    }

    public void setBatchTriggerTime(BTimeTrigger v) {
        this.set(batchTriggerTime, (BValue)v, null);
    }

    public int getHistoryBatchSize() {
        return this.getInt(historyBatchSize);
    }

    public void setHistoryBatchSize(int v) {
        this.setInt(historyBatchSize, v, null);
    }

    public BRelTime getMaxBackfillDuration() {
        return (BRelTime)this.get(maxBackfillDuration);
    }

    public void setMaxBackfillDuration(BRelTime v) {
        this.set(maxBackfillDuration, (BValue)v, null);
    }

    public void pingLastHistory() {
        this.invoke(pingLastHistory, null, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public BOrd learnHistories(BCloudHistoryExportLearnConfig parameter) {
        return (BOrd)this.invoke(learnHistories, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.checkBatchInterval();
        this.executor = ExecutorUtil.newSingleThreadBackgroundScheduledExecutor((String)"nCloudDriver.history", (long)2L, (TimeUnit)TimeUnit.MINUTES);
        this.add(null, (BValue)new BLink(this.getBatchTriggerTime().getOrdInSession(), "fireTrigger", "execute", true), 6);
    }

    public void stopped() throws Exception {
        super.stopped();
        this.executor.shutdownNow();
    }

    public void doExecute() {
        if (CloudUtilities.canSendMessage(this.getCloudConnectorDevice())) {
            this.executor.submit(this::executeHistories);
        }
    }

    public void doPingLastHistory() {
        BCloudDevice device = (BCloudDevice)this.getDevice();
        BICloudConnector connector = device.resolveConnector();
        if (CloudUtilities.canSendMessage(this.getCloudConnectorDevice())) {
            CloudEncodeMsg request = ((BCloudDevice)this.getDevice()).getFactory().createLastHistoryRequestMsg();
            connector.sendMessage(request.encode(null), request.getProperties(null)).whenComplete((resp, err) -> {
                if (err != null) {
                    log.warning("request to receive last history timestamp failed");
                }
            });
        }
    }

    public BOrd doLearnHistories(BCloudHistoryExportLearnConfig learnConfig, Context cx) {
        BCloudHistoryLearnJob job = new BCloudHistoryLearnJob(this, learnConfig);
        return job.submit(null);
    }

    public Type getExportDescriptorType() {
        return BCloudHistoryExport.TYPE;
    }

    public Type getArchiveFolderType() {
        return BCloudHistoryFolder.TYPE;
    }

    public boolean supportsGenericArchiveFolder() {
        return false;
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.remove("history:DeviceHistoriesView");
        return agents;
    }

    public void setBackfillStartTime() {
        BAbsTime oldestBackfillStart = BAbsTime.now().subtract(this.getMaxBackfillDuration());
        log.fine(() -> String.format("Checking lastSentToCloud on history exports using backfill start %s", oldestBackfillStart));
        int backfillStartSetCount = 0;
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase database = service.getDatabase();
        if (database == null) {
            return;
        }
        try (HistoryDatabaseConnection conn = database.getDbConnection(null);){
            for (BCloudHistoryExport cloudHistoryExport : (BCloudHistoryExport[])CompUtil.getDescendants((BComponent)this, BCloudHistoryExport.class)) {
                BHistoryConfig hCfg;
                BHistorySummary hSumm;
                BIHistory h = conn.getHistory(cloudHistoryExport.getHistoryId().fromShorthand(Sys.getStation().getStationName()));
                if (h == null || (hSumm = conn.getSummary(h)) == null || !this.shouldLimitBackfill(cloudHistoryExport, oldestBackfillStart, hSumm, hCfg = h.getConfig())) continue;
                ++backfillStartSetCount;
                cloudHistoryExport.setLastSentToCloud(oldestBackfillStart);
            }
        }
        if (backfillStartSetCount > 0) {
            log.info(String.format("The backfill start time of %s was used to set lastSentToCloud on %s history exports; history records earlier than this will not be sent to the cloud.", oldestBackfillStart, backfillStartSetCount));
        }
    }

    public boolean shouldLimitBackfill(BCloudHistoryExport export, BAbsTime oldestBackfillStart, BHistorySummary summary, BHistoryConfig config) {
        BCollectionInterval interval = config.getInterval();
        if (summary.getLastTimestamp().isBefore(oldestBackfillStart)) {
            return false;
        }
        if (export.getLastSentToCloud().isAfter(oldestBackfillStart)) {
            return false;
        }
        return !(interval.isIrregular() ? summary.getRecordCount() < 100 : interval.getInterval().getMillis() > this.getMaxBackfillDuration().getMillis());
    }

    private void checkBatchInterval() {
        BTriggerMode trigger = this.getBatchTriggerTime().getTriggerMode();
        if (trigger instanceof BIntervalTriggerMode) {
            BRelTime interval = ((BIntervalTriggerMode)trigger).getInterval();
            long intervalMillis = interval.getMillis();
            if (intervalMillis < 60000L) {
                log.severe("Specified History Batch Trigger Time Interval is too short.");
            } else if (intervalMillis < 300000L) {
                log.warning("Specified History Batch Trigger Time Interval is too short.");
            } else if (intervalMillis < 900000L) {
                log.info("Specified History Batch Trigger Time Interval is too short.");
            }
        }
    }

    public void executeHistories() {
        BICloudConnector connector = this.getCloudConnectorDevice().resolveConnector();
        if (connector == null || !connector.isConnected()) {
            log.warning("Cloud Connector not connected while attempting to send histories");
            return;
        }
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase database = service.getDatabase();
        if (database == null) {
            return;
        }
        ArrayList<CloudPointData> multiHistoryRecordList = new ArrayList<CloudPointData>();
        ArrayList<HistoryMessageMetadata> contributingHistoryExportList = new ArrayList<HistoryMessageMetadata>();
        BRelTime ms = BRelTime.make((long)1L);
        String stationName = Sys.getStation().getStationName();
        try (HistoryDatabaseConnection conn = database.getDbConnection(null);){
            for (BCloudHistoryExport cloudHistoryExport : (BCloudHistoryExport[])CompUtil.getDescendants((BComponent)this, BCloudHistoryExport.class)) {
                if (cloudHistoryExport.isFatalFault() || cloudHistoryExport.getStatus().isDisabled() || cloudHistoryExport.getHistoryId() == null) continue;
                try {
                    cloudHistoryExport.setLastAttempt(Clock.time());
                    BHistoryId id = cloudHistoryExport.getHistoryId().fromShorthand(stationName);
                    BIHistory historyFromDB = conn.getHistory(id);
                    if (historyFromDB == null) {
                        throw new HistoryNotFoundException();
                    }
                    BAbsTime startTime = cloudHistoryExport.getLastSentToCloud();
                    if (startTime != null) {
                        startTime = startTime.add(ms);
                    }
                    TableCursor cursor = conn.timeQuery(historyFromDB, startTime, null).cursor();
                    String pointId = CloudUtilities.makePointId(historyFromDB);
                    cloudHistoryExport.setPointId(pointId);
                    if (this.exportHistory(connector, pointId, (TableCursor<BHistoryRecord>)cursor, multiHistoryRecordList, contributingHistoryExportList, cloudHistoryExport)) continue;
                    log.warning("Unable to enqueue history message for delivery; aborting export for " + cloudHistoryExport.getName() + " [" + cloudHistoryExport.getHistoryId() + ']');
                    return;
                }
                catch (Exception e) {
                    log.warning("Could not send history records to the cloud for history export " + cloudHistoryExport.getName() + " [" + cloudHistoryExport.getHistoryId() + "]: " + e);
                    cloudHistoryExport.executeFail(this.lexicon.getText("historyDevExtFail.unknown", new Object[]{e}));
                }
            }
        }
        if (!multiHistoryRecordList.isEmpty()) {
            this.sendHistoryMessages(connector, multiHistoryRecordList, contributingHistoryExportList);
        }
    }

    boolean exportHistory(BICloudConnector connector, String pointId, TableCursor<BHistoryRecord> cursor, ArrayList<CloudPointData> multiHistoryRecordList, ArrayList<HistoryMessageMetadata> contributingHistoryExportList, BCloudHistoryExport cloudHistoryExport) {
        BAbsTime lastTimestamp = cloudHistoryExport.getLastSentToCloud();
        int batchSize = this.getHistoryBatchSize();
        while (cursor.next()) {
            OffsetDateTime timeStamp;
            BHistoryRecord historyRecord = (BHistoryRecord)cursor.get();
            HistorySample pointData = HistoryUtil.buildpointData(historyRecord, pointId, timeStamp = OffsetDateTime.parse((lastTimestamp = historyRecord.getTimestamp()).encodeToString()));
            if (pointData == null) continue;
            multiHistoryRecordList.add(pointData);
            if (multiHistoryRecordList.size() < batchSize) continue;
            contributingHistoryExportList.add(new HistoryMessageMetadata(cloudHistoryExport, lastTimestamp));
            if (this.sendHistoryMessages(connector, multiHistoryRecordList, contributingHistoryExportList) || this.sendHistoryMessages(connector, multiHistoryRecordList, contributingHistoryExportList)) continue;
            return false;
        }
        if (!multiHistoryRecordList.isEmpty()) {
            contributingHistoryExportList.add(new HistoryMessageMetadata(cloudHistoryExport, lastTimestamp));
        }
        return true;
    }

    public boolean sendHistoryMessages(BICloudConnector connector, ArrayList<CloudPointData> multiHistoryRecordList, ArrayList<HistoryMessageMetadata> contributingHistoryExportList) {
        log.fine(String.format("Sending %s history records in one message", multiHistoryRecordList.size()));
        CloudEncodeMsg historyUpdateMsg = this.getCloudConnectorDevice().getFactory().createHistoryUpdateMsg(NiagaraMessageType.history);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("PointValues", multiHistoryRecordList);
        HistoryMessageMetadata[] messageContributingHistoryExports = new HistoryMessageMetadata[contributingHistoryExportList.size()];
        contributingHistoryExportList.toArray(messageContributingHistoryExports);
        CompletionStage future = connector.sendMessage(historyUpdateMsg.encode(properties), historyUpdateMsg.getProperties(properties)).whenComplete((resp, err) -> {
            if (err != null) {
                log.warning("failed to send history message");
                ++this.historyMessageFailureCount;
                for (HistoryMessageMetadata contributingHistoryExport : messageContributingHistoryExports) {
                    contributingHistoryExport.cloudHistoryExport.executeFail(this.lexicon.getText("historyDevExtFail.sendFailed", new Object[]{err.getMessage()}));
                }
            } else {
                BAbsTime lastTimestamp = BAbsTime.make((long)0L);
                for (HistoryMessageMetadata contributingHistoryExport : messageContributingHistoryExports) {
                    BAbsTime lastHistSend = contributingHistoryExport.setLastSendTime();
                    if (lastHistSend.isAfter(lastTimestamp)) {
                        lastTimestamp = lastHistSend;
                    }
                    contributingHistoryExport.cloudHistoryExport.executeOk();
                }
                if (lastTimestamp != null && lastTimestamp.isAfter(this.getLastHistoryTimestamp())) {
                    this.setLastHistoryTimestamp(lastTimestamp);
                }
                ++this.historyMessageSuccessCount;
                log.fine("History message sent successfully");
            }
        });
        if (((CompletableFuture)future).isCompletedExceptionally()) {
            try {
                ((CompletableFuture)future).get();
            }
            catch (ExecutionException e) {
                if ("Queue full, try again later.".equals(e.getCause().getMessage())) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            return false;
        }
        multiHistoryRecordList.clear();
        contributingHistoryExportList.clear();
        return true;
    }

    public CloudMessageCallback getLastHistoryCallback() {
        return this.lastHistoryCallback;
    }

    void registerHistoryExport(BComponent source, BCloudHistoryExport export) {
        this.historyExportbySourceMap.put(source, export);
    }

    void unregisterHistoryExport(BComponent source, BCloudHistoryExport export) {
        if (this.historyExportbySourceMap.get(source) == export) {
            this.historyExportbySourceMap.remove(source);
        }
    }

    public BCloudHistoryExport getHistoryExportBySource(BComponent source) {
        return this.historyExportbySourceMap.get(source);
    }

    private HistoryDatabaseConnection getHdbConnection() {
        if (this.hdbConnection != null) {
            return this.hdbConnection;
        }
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase database = service.getDatabase();
        if (database == null) {
            throw new IllegalStateException("Cannot get HistoryDbConnection: history database is null");
        }
        this.hdbConnection = database.getDbConnection(null);
        this.executor.schedule(this::clearDbConnection, 10L, TimeUnit.SECONDS);
        return this.hdbConnection;
    }

    private void clearDbConnection() {
        this.hdbConnection.close();
    }

    BOrd getSourceOrdForHistoryId(BHistoryId id) {
        logDbg.fine("getSourceOrdForHistoryId() hId=" + id);
        HistoryDatabaseConnection conn = this.getHdbConnection();
        BIHistory historyFromDB = conn.getHistory(id.fromShorthand(Sys.getStation().getStationName()));
        if (historyFromDB != null) {
            logDbg.finest("Calling HDE.getSourceOrd() from HDE getSourceOrdForHistoryId()...");
            return this.getSourceOrd(historyFromDB);
        }
        log.info("Cannot find ord for cloud history export: No history for historyId " + id);
        return BOrd.DEFAULT;
    }

    BOrd getSourceOrd(BIHistory h) {
        BHistoryConfig config = h.getConfig();
        BOrdList srcList = config.getSource();
        logDbg.fine("getSourceOrd(" + h + " [" + h.getId() + "]): config.source:" + srcList);
        int srcListSize = srcList.size();
        if (srcListSize > 0) {
            BOrd srcOrd = srcList.get(srcListSize - 1);
            try {
                BObject src = srcOrd.get((BObject)this);
                if (src != null) {
                    logDbg.fine("Resolved srcOrd " + srcOrd + " to type " + src.getType());
                    BControlPoint srcPoint = (BControlPoint)CloudUtilities.getParent(src.asComponent(), BControlPoint.TYPE);
                    logDbg.finest("srcPoint for ord: " + (srcPoint != null ? srcPoint.getSlotPath() : "null"));
                    if (srcPoint != null) {
                        return srcPoint.getOrdInSpace();
                    }
                } else {
                    log.fine("srcOrd resolved to null BObject??");
                }
            }
            catch (Exception e) {
                logDbg.fine("Exception resolving ord " + srcOrd);
                log.config("Error attempting to get a source ord for cloud history export with historyId: " + h.getId() + " : " + e);
            }
            log.config("Cannot find any ord in the history config source ord list resolving to a local point for cloud history export with historyId: " + h.getId());
            return BOrd.DEFAULT;
        }
        log.config("Cannot find ord. The history config source ord list is empty for cloud history export with historyId: " + h.getId());
        return BOrd.DEFAULT;
    }

    public final BCloudDevice getCloudConnectorDevice() {
        return (BCloudDevice)this.getDevice();
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Cloud Device History Extension");
        out.prop((Object)"History Messages Success Count", (double)this.historyMessageSuccessCount);
        out.prop((Object)"History Messages Failure Count", (double)this.historyMessageFailureCount);
        out.prop((Object)"History Export Map size", this.historyExportbySourceMap.size());
        out.startTable(true);
        out.trTitle((Object)"History Export Map By Source Point", 3);
        out.w((Object)"<tr>").th((Object)"Source Point").th((Object)"Cloud History Export").th((Object)"History Id").w((Object)"</tr>\n");
        this.historyExportbySourceMap.forEach((key, value) -> out.tr((Object)key.getSlotPath(), (Object)value.getSlotPath(), (Object)value.getHistoryId()));
        out.endTable();
        out.endProps();
        super.spy(out);
    }

    static class HistoryMessageMetadata {
        private final BCloudHistoryExport cloudHistoryExport;
        private final BAbsTime lastSendTime;

        public HistoryMessageMetadata(BCloudHistoryExport export, BAbsTime lastTime) {
            this.cloudHistoryExport = export;
            this.lastSendTime = lastTime;
        }

        public BAbsTime setLastSendTime() {
            if (this.lastSendTime.isAfter(this.cloudHistoryExport.getLastSentToCloud())) {
                this.cloudHistoryExport.setLastSentToCloud(this.lastSendTime);
            }
            return this.cloudHistoryExport.getLastSentToCloud();
        }
    }

    private class CloudLastHistoryCallback
    implements CloudMessageCallback {
        private CloudLastHistoryCallback() {
        }

        @Override
        public void onMessage(String messageId, CloudMessage decodedMessage, Context cx) {
            SentienceLastHistoryResponseV1 lastHistoryRequest = (SentienceLastHistoryResponseV1)decodedMessage;
            log.fine(() -> String.format("CloudLastHistory executing %s", messageId));
            try {
                BAbsTime timestamp = BAbsTime.make((String)((String)lastHistoryRequest.getData("TimeStamp")));
                BCloudHistoryDeviceExt.this.setLastHistoryTimestamp(timestamp);
            }
            catch (IOException e) {
                log.severe(BCloudHistoryDeviceExt.this.lexicon.getText("niagaraCloudService.listHistoryError") + ' ' + messageId);
            }
            log.info(() -> String.format("CloudLastHistory complete %s", messageId));
        }

        @Override
        public boolean enabled() {
            return true;
        }

        @Override
        public CloudEncodeMsg getResponse() {
            return null;
        }

        @Override
        public Map<String, Object> getResponseParams(String messageId, CloudDecodeMsg decodedMessage, int code, String message) {
            return null;
        }
    }
}

