/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.devices.sentience.points;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.nc.devices.CloudPointData;
import javax.baja.history.BTrendRecord;

public class CloudMultiPointData
extends CloudPointData {
    private static final String POINTID = "PointId";
    private static final String STATUS = "Status";
    private static final String VALUE = "Value";
    protected String pointId;
    protected String status;
    protected Object value;

    public CloudMultiPointData(String pointId, String status, Object value) {
        this.pointId = pointId;
        this.status = status;
        this.value = value;
    }

    @Override
    public void encode(JSONWriter writer) {
        writer.object();
        writer.key(POINTID).value((Object)this.pointId);
        writer.key(STATUS).value((Object)this.status);
        if (this.value != null) {
            writer.key(VALUE).value(this.value);
        }
        writer.endObject();
    }

    @Override
    public void decode(Object record) {
        BTrendRecord trendRecord = (BTrendRecord)record;
        this.pointId = trendRecord.getName();
        this.status = trendRecord.getStatus().toString();
        this.value = trendRecord.asValue();
    }

    public JSONObject toJsonObject() {
        JSONObject rv = new JSONObject();
        rv.put(POINTID, (Object)this.pointId);
        rv.put(STATUS, (Object)this.status);
        if (this.value != null) {
            rv.put(VALUE, this.value);
        }
        return rv;
    }

    public String getPointId() {
        return this.pointId;
    }

    public String getStatus() {
        return this.status;
    }

    public Object getValue() {
        return this.value;
    }
}

