/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.devices.sentience.cmds;

import com.tridium.json.JSONObject;
import com.tridium.nc.cmds.BCloudCommandQueue;
import com.tridium.nc.devices.sentience.SentienceDecodeMsg;

public class SentienceSystemCommandRequestV1
extends SentienceDecodeMsg {
    public static final String command = "SystemCommand";
    public static final String version = "1";

    @Override
    public String getCommand() {
        return command;
    }

    @Override
    public int getPriority() {
        try {
            JSONObject platformHeaders = new JSONObject(this.decodedObj.getJSONObject("CommandParameters").getString("CloudPlatformHeaders"));
            int rv = platformHeaders.getInt("Priority");
            if (rv > BCloudCommandQueue.getLowestPriority()) {
                return BCloudCommandQueue.getLowestPriority();
            }
            if (rv < BCloudCommandQueue.getHighestPriority()) {
                return BCloudCommandQueue.getHighestPriority();
            }
            return rv;
        }
        catch (Exception ignore) {
            return BCloudCommandQueue.getLowestPriority();
        }
    }

    @Override
    public Object getAuth() {
        try {
            JSONObject platformHeaders = this.getCloudPlatformHeaders();
            if (platformHeaders != null) {
                return platformHeaders.get("Auth");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean getSuppressStatusResponse() {
        return false;
    }

    public JSONObject getCloudPlatformHeaders() {
        try {
            return new JSONObject(this.decodedObj.getJSONObject("CommandParameters").getString("CloudPlatformHeaders"));
        }
        catch (Exception ignore) {
            return null;
        }
    }
}

