/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.devices.sentience;

import com.tridium.cloud.client.NiagaraMessageType;
import com.tridium.json.JSONStringer;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.devices.sentience.SentienceCloudUtilities;
import java.util.Map;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;

public class SentienceSystemInfoMessageV1
implements CloudEncodeMsg {
    public static final String command = "SystemInfoMessage";
    public static final String version = "1";
    private final BCloudDevice cloudConnectorDevice;

    public SentienceSystemInfoMessageV1(BCloudDevice cloudConnectorDevice) {
        this.cloudConnectorDevice = cloudConnectorDevice;
    }

    @Override
    public String getCommand() {
        return command;
    }

    @Override
    public String encode(Map<String, Object> properties) {
        JSONStringer writer = new JSONStringer();
        BModule bajaModule = Sys.getBajaModule();
        String systemVersion = bajaModule.getModuleName() + ' ' + bajaModule.getVendorVersion(RuntimeProfile.rt);
        BModule cloudConnectorModule = this.cloudConnectorDevice.resolveConnector().getType().getModule();
        String ccVersion = cloudConnectorModule.getModuleName() + ' ' + cloudConnectorModule.getVendorVersion(RuntimeProfile.rt);
        writer.object();
        writer.key("CloudConnectorVersion").value((Object)ccVersion);
        writer.key("SystemTime").value((Object)BAbsTime.now().encodeToString());
        writer.key("SystemType").value((Object)this.cloudConnectorDevice.resolveConnector().getConnectorImpl().get("systemType"));
        writer.key("SystemVersion").value((Object)systemVersion);
        writer.endObject();
        return writer.toString();
    }

    @Override
    public Map<String, String> getProperties(Map<String, Object> properties) {
        Map<String, String> props = SentienceCloudUtilities.buildProperties(command, version, this.cloudConnectorDevice.resolveConnector().getId());
        props.put("NiagaraMessageType", NiagaraMessageType.cmdResp.name());
        return props;
    }
}

