/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.cmds.ICloudSystemCommand;
import com.tridium.nc.point.BCloudPointDeviceExt;
import com.tridium.nc.point.BSetCovParameter;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.sys.Context;
import javax.baja.util.Lexicon;

public final class CovInactiveCommand
implements ICloudSystemCommand {
    private String commandName;
    private final BCloudDevice device;
    private static final Logger log = Logger.getLogger("ncloud.point");
    private static final Lexicon LEX = Lexicon.make((String)"nCloudDriver");

    public CovInactiveCommand(BCloudCommandsDeviceExt bCloudCommandsDeviceExt) {
        this.setCommandName("CovInactiveCommand");
        this.register(bCloudCommandsDeviceExt);
        this.device = (BCloudDevice)bCloudCommandsDeviceExt.getDevice();
    }

    @Override
    public void setCommandName(String cmdName) {
        this.commandName = cmdName;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void runCommand(JSONObject commandProperties, Map<String, Object> responseProperties, Context cx) {
        String messageId = (String)responseProperties.get(this.device.getConstant("CORRELATIONID"));
        log.fine(() -> String.format("%s executing %s", this.commandName, messageId));
        BCloudPointDeviceExt pointDeviceExt = this.device.getPoints();
        String commandID = JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMANDID"));
        responseProperties.put(this.device.getConstant("COMMANDID"), commandID);
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMAND_PAYLOAD")));
        JSONArray points = payload.getJSONArray(this.device.getConstant("POINTIDS"));
        JSONObject covResults = new JSONObject();
        for (int i = 0; i < points.length(); ++i) {
            String pointId = points.getString(i);
            boolean result = pointDeviceExt.doSetCovInactive(BSetCovParameter.make(pointId, messageId), cx).getBoolean();
            covResults.put(pointId, result);
        }
        responseProperties.put("PointCOVStatuses", covResults);
        responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_RESP_CODE_OK"));
        responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
        log.fine(() -> String.format("%s complete %s", this.commandName, messageId));
    }
}

