/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.cmds.ICloudSystemCommand;
import com.tridium.nc.point.BCloudPointDeviceExt;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.security.PermissionException;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;

public final class CloudMultiPointWriteCommand
implements ICloudSystemCommand {
    private String commandName;
    private final BCloudDevice device;
    private static final Logger log = Logger.getLogger("ncloud.command");
    private static final int BATCH_SIZE = 1024;

    public CloudMultiPointWriteCommand(BCloudCommandsDeviceExt bCloudCommandsDeviceExt) {
        this.setCommandName("CloudMultiPointWriteCommand");
        this.register(bCloudCommandsDeviceExt);
        this.device = (BCloudDevice)bCloudCommandsDeviceExt.getDevice();
    }

    @Override
    public void setCommandName(String cmdName) {
        this.commandName = cmdName;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void runCommand(JSONObject commandProperties, Map<String, Object> responseProperties, Context cx) {
        int msgTotal;
        Map<String, Object> respProperties;
        String messageId = (String)responseProperties.get(this.device.getConstant("CORRELATIONID"));
        log.fine(() -> String.format("%s executing %s", this.commandName, messageId));
        String commandID = JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMANDID"));
        if (!this.device.getNiagaraCloudNetwork().getPointWriteAllowed()) {
            log.warning(() -> String.format("Attempted to write to Point: access not allowed %s", messageId));
            responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_ERR_CODE_FORBIDDEN"));
            responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("ERR_ACCESS_NOT_ALLOWED"));
            responseProperties.put(this.device.getConstant("COMMANDID"), commandID);
            return;
        }
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMAND_PAYLOAD")));
        JSONArray points = payload.getJSONArray(this.device.getConstant("POINTWRITES"));
        if (points.length() <= 1024) {
            respProperties = responseProperties;
            msgTotal = 1;
        } else {
            msgTotal = points.length() / 1024 + (points.length() % 1024 == 0 ? 0 : 1);
            respProperties = new HashMap<String, Object>();
            respProperties.put(this.device.getConstant("CORRELATIONID"), messageId);
        }
        respProperties.put(this.device.getConstant("COMMANDID"), commandID);
        JSONObject pointResults = new JSONObject();
        for (int lcv = 0; lcv < points.length(); ++lcv) {
            String status;
            String pointId;
            block11: {
                JSONObject pointObj = (JSONObject)points.get(lcv);
                pointId = (String)pointObj.get(this.device.getConstant("POINTID"));
                int priority = pointObj.optInt(this.device.getConstant("PRIORITY"), 0);
                BRelTime duration = BRelTime.makeMinutes((int)pointObj.optInt(this.device.getConstant("DURATION"), 0));
                String source = pointObj.optString(this.device.getConstant("SOURCE"), commandProperties.optString(this.device.getConstant("CALLINGID"), null));
                BControlPoint point = CloudUtilities.getPoint(pointId);
                if (point != null && CloudUtilities.isPointWriteAllowed(this.device.getNiagaraCloudNetwork(), point, cx)) {
                    try {
                        if (BCloudPointDeviceExt.writePoint(point, pointObj.get("Value"), priority, duration, source, messageId, cx)) {
                            status = "Success";
                            break block11;
                        }
                        status = "Error: Invalid point value";
                    }
                    catch (PermissionException ignored) {
                        status = this.device.getConstant("ERR_ACCESS_NOT_ALLOWED");
                        log.warning(() -> String.format("Attempted to write to Point: access not allowed: %s %s", pointId, messageId));
                    }
                } else {
                    status = this.device.getConstant("ERR_ACCESS_NOT_ALLOWED");
                    log.warning(() -> String.format("Attempted to write to Point: access not allowed: %s %s", pointId, messageId));
                }
            }
            pointResults.put(pointId, (Object)status);
            if (lcv % 1024 != 1023 || lcv == points.length() - 1) continue;
            respProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_RESP_CODE_OK"));
            respProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
            respProperties.put("sequenceNum", lcv / 1024);
            respProperties.put("segmentTotal", msgTotal);
            respProperties.put("PointWriteDetails", pointResults);
            this.device.getCommands().sendResponse(respProperties, commandID, this.commandName);
            pointResults = new JSONObject();
            if (points.length() - lcv <= 1024) {
                respProperties = responseProperties;
            } else {
                respProperties = new HashMap<String, Object>();
                respProperties.put(this.device.getConstant("CORRELATIONID"), messageId);
            }
            respProperties.put(this.device.getConstant("COMMANDID"), commandID);
        }
        responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_RESP_CODE_OK"));
        responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
        responseProperties.put("SequenceNum", points.length() / 1024);
        responseProperties.put("segmentTotal", msgTotal);
        responseProperties.put("PointWriteDetails", pointResults);
        log.fine(() -> String.format("%s complete %s", this.commandName, messageId));
    }
}

