/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.nc.point.BCloudWriteController;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="source", type="BString", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="expiration", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.TRUE")}), @NiagaraProperty(name="value", type="BStatusValue", defaultValue="new BStatusString()", flags=1)})
public class BCloudWriteInfo
extends BComponent {
    public static final Property source = BCloudWriteInfo.newProperty((int)1, (BValue)BString.DEFAULT, null);
    public static final Property expiration = BCloudWriteInfo.newProperty((int)1, (BValue)BAbsTime.DEFAULT, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    public static final Property value = BCloudWriteInfo.newProperty((int)1, (BValue)new BStatusString(), null);
    public static final Type TYPE = Sys.loadType(BCloudWriteInfo.class);
    private Clock.Ticket resetTicket;
    private final Object ticketSync = new Object();

    public String getSource() {
        return this.getString(source);
    }

    public void setSource(String v) {
        this.setString(source, v, null);
    }

    public BAbsTime getExpiration() {
        return (BAbsTime)this.get(expiration);
    }

    public void setExpiration(BAbsTime v) {
        this.set(expiration, (BValue)v, null);
    }

    public BStatusValue getValue() {
        return (BStatusValue)this.get(value);
    }

    public void setValue(BStatusValue v) {
        this.set(value, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BControlPoint;
    }

    public final BControlPoint getParentPoint() {
        return (BControlPoint)this.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeTicket() {
        BRelTime resetTime = BAbsTime.now().delta(this.getExpiration());
        Object object = this.ticketSync;
        synchronized (object) {
            this.clearTicket();
            this.resetTicket = Clock.schedule((BComponent)this.controller(), (BRelTime)resetTime, (Action)BCloudWriteController.clearCloudWrite, (BValue)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTicket() {
        Object object = this.ticketSync;
        synchronized (object) {
            if (this.resetTicket != null) {
                this.resetTicket.cancel();
                this.resetTicket = null;
            }
        }
    }

    public BCloudWriteController controller() {
        return (BCloudWriteController)this.getParent().get("cloudWriteController").as(BCloudWriteController.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        out.startProps("Cloud Write Info");
        Object object = this.ticketSync;
        synchronized (object) {
            out.prop((Object)"resetTicket", (Object)this.resetTicket);
        }
        out.endProps();
        super.spy(out);
    }

    public String toString(Context cx) {
        return String.format("%s until %s {%s}", this.getValue(), this.getExpiration(), this.getSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toDebugString() {
        Object object = this.ticketSync;
        synchronized (object) {
            return String.format("CloudWriteInfo: %s -> %s until %s; %s", this.getSource(), this.getValue(), this.getExpiration(), this.resetTicket);
        }
    }
}

