/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.enums.BCcnTableGroupTypeEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.util.CcnErrorCodes;

public abstract class CcnRspTableUtil
implements CcnErrorCodes,
CcnMessageConst {
    protected static final int BLOCK_NO_LOCATION = 2;
    protected static final int TBL_NBR_HI = 0;
    protected static final int TBL_NBR_LO = 1;
    protected static final int REJECT_STATUS_LOCATION = 0;

    public static int parseTableNo(CcnResponseMessage rsp) throws CcnException {
        if (rsp.getResponseBuffer().getResponseCommand() == 6) {
            byte[] rData = rsp.getResponseBuffer().getResponseData();
            int tableNbr = ((rData[0] & 0xFF) << 8 | rData[1] & 0xFF) & 0xFFFF;
            return tableNbr;
        }
        throw new CcnException(0x630066, "Cannot parse table number because the read block reply was not an ACK (command 6)");
    }

    public static int parseBlockNo(CcnResponseMessage rsp) {
        return rsp.getResponseBuffer().getResponseData()[2];
    }

    public static int parseRejectStatus(CcnResponseMessage rsp) throws CcnException {
        if (rsp.getResponseBuffer().getResponseCommand() == 21) {
            return rsp.getResponseBuffer().getResponseData()[0];
        }
        throw new CcnException(0x630066, "Cannot parse rejection status because the read block reply was not a rejection notice (command 15)");
    }

    public static int getTableType(CcnResponseMessage rsp) throws CcnException {
        int reqTableType = rsp.getTableType();
        int blockNo = CcnRspTableUtil.parseBlockNo(rsp);
        if (blockNo == 1) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            int rspTableType = ((buf[3] & 0xFF) << 8 | buf[4] & 0xFF) & 0xFFFF;
            if (rspTableType == reqTableType) {
                return rspTableType;
            }
            throw new CcnException(6488169, "Response tableType does not match request tableType");
        }
        throw new CcnException(6488167, "Need block 1 to getTableType");
    }

    public static String getTableName(CcnResponseMessage rsp) throws CcnException {
        int blockNo = CcnRspTableUtil.parseBlockNo(rsp);
        if (blockNo == 1) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return new String(CcnRspTableUtil.getSubByteArray(buf, 5, 8));
        }
        throw new CcnException(6488167, "Need block 1 to getTableName");
    }

    public static String getFIDTableName(CcnResponseMessage rsp) throws CcnException {
        int blockNo = CcnRspTableUtil.parseBlockNo(rsp);
        if (blockNo == 1) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return new String(CcnRspTableUtil.getSubByteArray(buf, 3, 8));
        }
        throw new CcnException(6488167, "Need block 1 to getTableName");
    }

    public static byte getBlockCount(CcnResponseMessage rsp) throws CcnException {
        int blockNo = CcnRspTableUtil.parseBlockNo(rsp);
        if (blockNo == 1) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return buf[15];
        }
        throw new CcnException(6488167, "Need block 1 to getBlockCount");
    }

    public static byte getBlockAccessRights(CcnResponseMessage rsp, int blockNum) throws CcnException {
        int blockNo = CcnRspTableUtil.parseBlockNo(rsp);
        if (blockNo == 1) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return buf[16 + 2 * (blockNum - 1) + 1];
        }
        throw new CcnException(6488167, "Need block 1 to getBlockAccessRights");
    }

    public static int getPointCount(CcnResponseMessage rsp) throws CcnException {
        int blockNo = CcnRspTableUtil.parseBlockNo(rsp);
        if (blockNo == 1) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            int block2Size = buf[18] & 0xFF;
            int block3Size = buf[20] & 0xFF;
            int block4Size = buf[22] & 0xFF;
            return (block2Size + block3Size + block4Size) / 12;
        }
        throw new CcnException(6488167, "Need block 1 to getPointCount");
    }

    protected static byte[] getSubByteArray(byte[] buf, int start, int num) {
        byte[] ba = new byte[num];
        for (int i = 0; i < num; ++i) {
            ba[i] = buf[i + start];
        }
        return ba;
    }

    public static boolean compareFloatValues(float _float1, float _float2) {
        float difference = Math.abs(_float1 - _float2);
        if (difference < 1.0f) {
            return true;
        }
        float tolerance = (_float1 + _float2) / 200.0f;
        return difference <= tolerance;
    }

    public static String getTableTypeString(int tableType) {
        if (tableType == 1281) {
            return BCcnTableGroupTypeEnum.StatusDisplay.getTag();
        }
        if (tableType == 1284) {
            return BCcnTableGroupTypeEnum.SetPoints.getTag();
        }
        if (tableType == 1283) {
            return BCcnTableGroupTypeEnum.TimeSchedules.getTag();
        }
        if (tableType == 1285) {
            return BCcnTableGroupTypeEnum.Holiday.getTag();
        }
        return BCcnTableGroupTypeEnum.Generic.getTag();
    }

    protected static boolean isTableType(int tableType, int[] expectedTableTypes) {
        for (int i = 0; i < expectedTableTypes.length; ++i) {
            if (tableType != expectedTableTypes[i]) continue;
            return true;
        }
        return false;
    }

    protected static void checkTableType(int tableType, int[] expectedTableTypes) throws CcnException {
        for (int i = 0; i < expectedTableTypes.length; ++i) {
            if (tableType != expectedTableTypes[i]) continue;
            return;
        }
        new CcnException(6488168, "Unexpected tableType is " + tableType + " expectedTableTypes are " + expectedTableTypes);
    }
}

