/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.tables;

import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnPointList;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BCcnTimeScheduleEntry;
import com.tridium.ccn.components.BCcnTimeScheduleList;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnInputProxy;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnFidTable;
import com.tridium.ccn.util.CcnRspDataUtil;
import com.tridium.ccn.util.CcnRspFidUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BCcnFidTableWithTimeSchedule
extends BCcnFidTable {
    public static final Property timeScheduleList = BCcnFidTableWithTimeSchedule.newProperty((int)4, (BValue)new BCcnTimeScheduleList(), null);
    public static final Action saveTimeSchedule = BCcnFidTableWithTimeSchedule.newAction((int)20, (BValue)new BCcnTimeScheduleList(), null);
    public static final Type TYPE = Sys.loadType(BCcnFidTableWithTimeSchedule.class);
    BCcnTableEntry entry;

    public BCcnTimeScheduleList getTimeScheduleList() {
        return (BCcnTimeScheduleList)this.get(timeScheduleList);
    }

    public void setTimeScheduleList(BCcnTimeScheduleList v) {
        this.set(timeScheduleList, (BValue)v, null);
    }

    public void saveTimeSchedule(BCcnTimeScheduleList agr) {
        this.invoke(saveTimeSchedule, (BValue)agr, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BCcnFidTableWithTimeSchedule() {
    }

    public BCcnFidTableWithTimeSchedule(BCcnTableEntry entry) {
        this.entry = entry;
    }

    public void doSaveTimeSchedule(BCcnTimeScheduleList newList) {
        String errorMessage = null;
        BCcnPointEntry[] pointList = (BCcnPointEntry[])this.getPointList().getChildren(BCcnPointEntry.class);
        BCcnTimeScheduleEntry[] entries = newList.getTimeScheduleList();
        CcnResponseMessage rsp = this.getReadTableResponse(this.getTableType(), this.getTableInstance(), 2);
        if (rsp == null) {
            BCcnTimeScheduleEntry[] tsList = CcnRspDataUtil.buildTimeSchedules(pointList);
            this.getTimeScheduleList().setTimeScheduleList(tsList);
            errorMessage = "Reading table block 0x02 is failed";
            this.ccnTablesLog.error("Write value is unsuccessful.\n" + errorMessage);
            return;
        }
        byte[] data = rsp.getData();
        for (int i = 0; i < 7; ++i) {
            int j = i * 3;
            String newStrFromTime = entries[i].getFrom();
            pointList[j + 0].setPointValue(newStrFromTime);
            String newStrToTime = entries[i].getTo();
            pointList[j + 1].setPointValue(newStrToTime);
            int newValue = entries[i].getMon() ? 128 : 0;
            if (entries[i].getTues()) {
                newValue |= 0x40;
            }
            if (entries[i].getWed()) {
                newValue |= 0x20;
            }
            if (entries[i].getThur()) {
                newValue |= 0x10;
            }
            if (entries[i].getFri()) {
                newValue |= 8;
            }
            if (entries[i].getSat()) {
                newValue |= 4;
            }
            if (entries[i].getSun()) {
                newValue |= 2;
            }
            if (entries[i].getHoliday()) {
                newValue |= 1;
            }
            String newStrDayOfWeek = Integer.toBinaryString(newValue);
            pointList[j + 2].setPointValue(newStrDayOfWeek);
            data = CcnRspFidUtil.mergeNewValue(data, newStrFromTime, pointList[j + 0], this.getTableType());
            data = CcnRspFidUtil.mergeNewValue(data, newStrToTime, pointList[j + 1], this.getTableType());
            data = CcnRspFidUtil.mergeNewValue(data, newStrDayOfWeek, pointList[j + 2], this.getTableType());
        }
        byte[] newData = new byte[data.length - 3];
        for (int z = 3; z < data.length - 3; ++z) {
            newData[z - 3] = data[z];
        }
        CcnResponseMessage writeRsp = this.writeTable(newData, (byte)2);
        this.ccnTablesLog.trace(this.getSummaryString() + "writeTimeSchedule data=");
        if (writeRsp != null) {
            this.ccnTablesLog.trace("write command response: getResponseCommand()=" + writeRsp.getResponseCommand() + "; getData=");
            BCcnPointList pList = new BCcnPointList(pointList);
            BCcnPointEntry[] pUpdatedEntry = pList.getPointList();
            if (writeRsp.getResponseCommand() == 6) {
                this.getPointList().setPointList(pUpdatedEntry);
                this.getTimeScheduleList().setTimeScheduleList(entries);
                BCcnProxyExt[] createdPoints = this.getCreatedPoints();
                for (int z = 0; z < 21; ++z) {
                    if (createdPoints[z] == null) continue;
                    ((BCcnInputProxy)createdPoints[z]).setValue(pointList[z].getPointValue());
                }
                return;
            }
            if (writeRsp.getResponseCommand() == 21) {
                switch (writeRsp.getResponseCode()) {
                    case 1: {
                        errorMessage = "Command not implemented.";
                        break;
                    }
                    case 4: {
                        errorMessage = "Table not defined.";
                        break;
                    }
                    case 9: {
                        errorMessage = "POC function does not exist.";
                        break;
                    }
                    case 10: {
                        errorMessage = "Block not defined.";
                        break;
                    }
                    case 16: {
                        errorMessage = "Access denied.";
                        break;
                    }
                    case 18: {
                        errorMessage = "Invalid configuration parameter.";
                        break;
                    }
                    default: {
                        errorMessage = "Unknown error.";
                        break;
                    }
                }
            } else {
                errorMessage = "Unknown error. Response command is neither 0x15 nor 0x06.";
            }
        } else {
            errorMessage = "Unknown error. Response is null.";
        }
        BCcnTimeScheduleEntry[] tsList = CcnRspDataUtil.buildTimeSchedules(pointList);
        this.getTimeScheduleList().setTimeScheduleList(tsList);
        this.ccnTablesLog.trace("Write time schedule is unsuccessful.\n" + errorMessage);
    }
}

