/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.tables;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.components.BCcnPointList;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.job.BCcnAddDataPointsJob;
import com.tridium.ccn.job.BCcnLearnDataPointsJob;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.util.CcnRspDataUtil;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

public class BCcnDataTable
extends BCcnTable {
    public static final Property pocTableType = BCcnDataTable.newProperty((int)1, (int)0, null);
    public static final Property dataBlock = BCcnDataTable.newProperty((int)0, (int)0, null);
    public static final Property pointList = BCcnDataTable.newProperty((int)4, (BValue)new BCcnPointList(), null);
    public static final Property pointLearnCount = BCcnDataTable.newProperty((int)1, (int)0, null);
    public static final Property pointCreateCount = BCcnDataTable.newProperty((int)1, (int)0, null);
    public static final Property learnedTimeSchedules = BCcnDataTable.newProperty((int)4, (BValue)new BFolder(), null);
    public static final Action submitDataPointDiscoveryJob = BCcnDataTable.newAction((int)4, null);
    public static final Action submitAddDataPointsJob = BCcnDataTable.newAction((int)4, (BValue)new BCcnPointList(), null);
    public static final Type TYPE = Sys.loadType(BCcnDataTable.class);
    BIcon icon = BIcon.std((String)"editPolygon.png");
    private BCcnPocTable tParent;
    BCcnTableEntry entry;

    public int getPocTableType() {
        return this.getInt(pocTableType);
    }

    public void setPocTableType(int v) {
        this.setInt(pocTableType, v, null);
    }

    public int getDataBlock() {
        return this.getInt(dataBlock);
    }

    public void setDataBlock(int v) {
        this.setInt(dataBlock, v, null);
    }

    @Override
    public BCcnPointList getPointList() {
        return (BCcnPointList)this.get(pointList);
    }

    @Override
    public void setPointList(BCcnPointList v) {
        this.set(pointList, (BValue)v, null);
    }

    public int getPointLearnCount() {
        return this.getInt(pointLearnCount);
    }

    @Override
    public void setPointLearnCount(int v) {
        this.setInt(pointLearnCount, v, null);
    }

    public int getPointCreateCount() {
        return this.getInt(pointCreateCount);
    }

    public void setPointCreateCount(int v) {
        this.setInt(pointCreateCount, v, null);
    }

    public BFolder getLearnedTimeSchedules() {
        return (BFolder)this.get(learnedTimeSchedules);
    }

    public void setLearnedTimeSchedules(BFolder v) {
        this.set(learnedTimeSchedules, (BValue)v, null);
    }

    public BOrd submitDataPointDiscoveryJob() {
        return (BOrd)this.invoke(submitDataPointDiscoveryJob, null, null);
    }

    public BOrd submitAddDataPointsJob(BCcnPointList parameters) {
        return (BOrd)this.invoke(submitAddDataPointsJob, (BValue)parameters, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BCcnDataTable() {
    }

    public BCcnDataTable(BCcnTableEntry entry) {
        this.entry = entry;
        this.setTableBlockCount(entry.getBlockCount());
        this.setTableType(entry.getTableType());
        this.setTableTypeString(entry.getTableTypeString());
        this.setTableInstance(entry.getTableInstance());
        this.setTableNum(entry.getTableNum());
        this.setTableName(entry.getTableName());
    }

    @Override
    public void started() throws Exception {
        this.recordPocTableType();
        super.started();
    }

    @Override
    public void stopped() throws Exception {
        BCcnPocTable pocTable = this.getParentPoc();
        pocTable.setDataTableCreateCount(pocTable.getDataTableCreateCount() - 1);
        super.stopped();
    }

    public BOrd doSubmitDataPointDiscoveryJob() {
        BCcnLearnDataPointsJob job = new BCcnLearnDataPointsJob(this);
        return job.submit(null);
    }

    public BOrd doSubmitAddDataPointsJob(BCcnPointList pointList) {
        BCcnAddDataPointsJob job = new BCcnAddDataPointsJob(this, pointList);
        return job.submit(null);
    }

    private void recordPocTableType() {
        int pocTableType = this.getParentPoc().getTableType();
        this.setPocTableType(pocTableType);
    }

    @Override
    public boolean isParentLegal(BComponent parent) throws LocalizableRuntimeException {
        if (parent instanceof BCcnPocTable) {
            return true;
        }
        throw new LocalizableRuntimeException("ccn", "CcnDataTable.Drop");
    }

    @Override
    public boolean isChildLegal(BComponent child) throws LocalizableRuntimeException {
        if (child instanceof BCcnPicTable || child instanceof BCcnPocTable) {
            throw new LocalizableRuntimeException("ccn", "CcnPicTable and CcnPocTable nodes may not be under a CcnDataTable node");
        }
        return true;
    }

    public BCcnPocTable getParentPoc() {
        if (this.tParent == null) {
            for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BCcnPocTable)) continue;
                this.tParent = (BCcnPocTable)parent;
                break;
            }
        }
        return this.tParent;
    }

    @Override
    protected boolean isTableTypeRestricted() {
        int pocTableType = this.getPocTableType();
        int dataTableType = this.getTableType();
        return pocTableType == 21 || pocTableType == 22 || pocTableType == 20 && dataTableType != 1556;
    }

    @Override
    public boolean isConfigurationType() {
        int pocTableType = this.getPocTableType();
        return pocTableType == 16 || pocTableType == 19 || pocTableType == 20 || pocTableType == 22;
    }

    @Override
    public boolean isSetpointType() {
        int pocTableType = this.getPocTableType();
        return pocTableType == 23 || pocTableType == 24;
    }

    @Override
    public void pollForData() {
        BCcnDevice device = this.getCcnDevice();
        if (this.getCCNNetwork().isDiscoveryInProgress() || !device.isRunning() || this.getCCNNetwork().isChangingDisplay() || this.getPointCreateCount() == 0) {
            return;
        }
        long startTime = BAbsTime.now().getTimeOfDayMillis();
        if (this.vPollAttributeProxyExts.size() == 0) {
            return;
        }
        this.ccnSubscribedPointLog.trace("Number of subscribed points-->::Device::" + device.getDeviceName() + "::Table-->" + this.getTableName() + " are::" + this.vPollAttributeProxyExts.size());
        CcnResponseMessage rsp = this.getReadTableResponse(this.getDataBlock());
        this.ccnTablesLog.trace(this.getTableName() + " Poll Resposne for tabletype::" + tableType + "is" + (Object)((Object)rsp));
        if (rsp == null) {
            return;
        }
        this.commSuccess(true);
        for (int i = 0; i < this.vPollAttributeProxyExts.size(); ++i) {
            BCcnProxyExt proxy = (BCcnProxyExt)this.vPollAttributeProxyExts.get(i);
            if (proxy == null) continue;
            try {
                CcnRspDataUtil.setProxyReadValue(rsp, proxy.getValueBlockOffset(), proxy);
                continue;
            }
            catch (Exception ex) {
                this.ccnTablesLog.error("CcnDataTable poll for data exception::" + ex.getMessage());
            }
        }
        long endTime = BAbsTime.now().getTimeOfDayMillis();
        this.ccnTimeLog.trace("Data Table PollForData Device->" + device.getName() + ", table->" + this.getTableName() + ", polltime::" + (endTime - startTime) + "milli seconds");
    }

    @Override
    public BIcon getIcon() {
        return this.icon;
    }
}

