/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.point;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BasicWriteAsyncRequest;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.exceptions.CcnRuntimeException;
import com.tridium.ccn.messages.CcnAutoVariableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.messages.CcnWriteVariableRequest;
import com.tridium.ccn.point.BCcnInputProxy;
import com.tridium.ccn.util.CcnEnumsUtil;
import com.tridium.ccn.util.CcnRspPicPocUtil;
import com.tridium.platCcn.CcnVariableDef;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringWritable;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BLink;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BCcnOutputProxy
extends BCcnInputProxy {
    public static final Property ismanualOverride = BCcnOutputProxy.newProperty((int)4, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BCcnOutputProxy.class);
    BCcnPointEntry entry;

    public boolean getIsmanualOverride() {
        return this.getBoolean(ismanualOverride);
    }

    public void setIsmanualOverride(boolean v) {
        this.setBoolean(ismanualOverride, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BCcnOutputProxy() {
    }

    public BCcnOutputProxy(BCcnPointEntry entry) {
        super(entry);
        this.setDiscreteTextOffset(entry.getDiscreteTextOffset());
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.isRunning()) {
            return;
        }
        try {
            if (this.getParent() instanceof BBooleanWritable || this.getParentPoint() instanceof BBooleanPoint) {
                this.updateControlPointFacets();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void stopped() throws Exception {
        super.stopped();
    }

    public boolean write(Context cx) throws Exception {
        if (this.getMode() != BReadWriteMode.readonly) {
            BStatusValue out = this.getWriteValue();
            BBasicNetwork network = (BBasicNetwork)this.getNetwork();
            if (network.getLog().isTraceOn()) {
                network.getLog().trace("Write <" + this + "> " + out);
            }
            try {
                network.postWrite((Runnable)new BasicWriteAsyncRequest((BBasicProxyExt)this, out));
            }
            catch (Exception e) {
                this.writeFail(Lexicon.make(BBasicProxyExt.class).getText("postWriteFail") + ": " + e);
                network.getLog().error("Could not post write for " + this.getParent().getName(), (Throwable)e);
            }
        }
        return false;
    }

    public void doWrite(BStatusValue out) {
        BStatus status = out.getStatus();
        BPriorityLevel priorityLevel = BPriorityLevel.make((int)status.geti("activeLevel", 17));
        if (priorityLevel.equals((Object)BPriorityLevel.fallback) && status.isNull()) {
            this.autoValue(this, true);
            return;
        }
        if (this.getIsmanualOverride()) {
            this.setIsmanualOverride(false);
            return;
        }
        this.ccnPointsLog.trace("=================doWrite START=============");
        String strLevel = out.getStatusValue().toString();
        String subStr = strLevel.substring(strLevel.indexOf("@") + 1).trim();
        int fwForceLevel = 0;
        boolean isFromLink = false;
        try {
            fwForceLevel = Integer.parseInt(subStr);
        }
        catch (NumberFormatException e) {
            fwForceLevel = 0;
        }
        this.ccnPointsLog.trace("doWrite::fwForceLevel" + fwForceLevel);
        boolean bValue = false;
        double fValue = 0.0;
        if (this.getParentPoint() instanceof BNumericWritable) {
            fValue = ((BStatusNumeric)out).getNumeric();
        } else if (this.getParentPoint() instanceof BBooleanWritable) {
            int dataType = this.getPointDataType();
            if (this.isDiscrete() && (dataType == 1 || dataType == 9)) {
                bValue = ((BStatusBoolean)out).getBoolean();
                fValue = bValue ? 1.0 : 0.0;
            }
        } else if (this.getParentPoint() instanceof BStringWritable) {
            fValue = Float.parseFloat(((BStatusString)out).getValue());
        }
        int devForcelevel = CcnEnumsUtil.setProperForceLevelForEntry(this.getForceLevel());
        this.ccnPointsLog.trace("doWrite::devForcelevel" + devForcelevel);
        BLink[] links = this.getParentPoint().getLinks();
        int linkCount = links == null ? 0 : links.length;
        this.ccnPointsLog.trace("doWrite::LinkCount" + linkCount);
        if (linkCount > 0) {
            if (fwForceLevel != 8) {
                if (links != null && links.length > 0) {
                    isFromLink = this.isFromLink(links, fwForceLevel);
                }
                if (isFromLink && (devForcelevel == 7 || devForcelevel == 0)) {
                    this.writeForceValue((float)fValue, true, out);
                    this.setForceLevel("Controlling POC commands");
                } else {
                    this.ccnPointsLog.trace("Higher device level force is in effect");
                }
            } else if (fwForceLevel == 8 && devForcelevel <= 7) {
                this.writeForceValue((float)fValue, false, out);
            }
        } else if (fwForceLevel != 8) {
            if (devForcelevel == 4 || devForcelevel == 0) {
                this.writeForceValue((float)fValue, false, out);
                this.autoValue(this, false);
                this.ccnPointsLog.trace("if(fwForceLevel != 8) WRITE TO DEVICE, AUTO IT ");
            } else if (devForcelevel == 7 || devForcelevel == 0) {
                this.writeForceValue((float)fValue, true, out);
                this.autoValue(this, true);
                this.ccnPointsLog.trace("if(fwForceLevel != 8) WRITE TO DEVICE, AUTO IT ");
            }
        } else if (fwForceLevel == 8 && devForcelevel <= 7) {
            this.writeForceValue((float)fValue, false, out);
        }
        this.ccnPointsLog.trace("============== DO WRITE STOP ========");
        super.doWrite(out);
    }

    public void autoValue(BCcnOutputProxy proxyExt, boolean isFromCommand) {
        this.getTable().checkFullAccessPermitted("auto");
        if (this.writeAutoValue(isFromCommand, proxyExt)) {
            this.ccnPointsLog.trace("doCcnCommand CMD_ID_Auto for object" + this.getDebugSummaryString() + " success");
        } else {
            System.out.println("auto value command failed");
        }
    }

    @Override
    public void writeForceValue(float value, boolean isFromCommand, BStatusValue out) {
        try {
            this.ccnPointsLog.trace("writeForceValue::Value" + value);
            if (this.getTable().getCcnDevice().areYouOutOfService()) {
                return;
            }
            if (!CcnRspPicPocUtil.checkRange(Float.toString(value), this)) {
                throw new CcnRuntimeException(6488176, this.getDebugSummaryString() + "User value " + value + " out of limits, force aborted.\nThe limits are " + this.getLoLimit() + " to " + this.getHiLimit());
            }
            this.ccnPointsLog.trace("CcnOutput: writeForceValue for object " + this.getDebugSummaryString() + "; the new value is " + value);
            int busNum = this.getCcnDevice().getBusNo();
            int localAddr = this.getCcnDevice().getElemNo();
            int dataType = this.getPointDataType();
            CcnVariableDef vDef = isFromCommand ? new CcnVariableDef((byte)localAddr, (byte)busNum, null, (short)this.getVariableNo(), 7, 7) : new CcnVariableDef((byte)localAddr, (byte)busNum, null, (short)this.getVariableNo(), 4, 4);
            String errorMessage = null;
            String sNewValue = new String();
            sNewValue = CcnRspPicPocUtil.convertToImperial(this.getConfigFlags(), this.getCcnDevice().getCcnNetwork().getDisplayMetric(), this.getDisplayDigits(), this.getUnits(), Float.toString(value));
            if (dataType == 0) {
                value = new Float(Integer.parseInt(sNewValue, 2)).floatValue();
            }
            if (dataType == 1 || dataType == 2 || dataType == 6 || dataType == 7 || dataType == 9 || dataType == 10 || dataType == 17 || dataType == 48) {
                value = new Float(sNewValue).floatValue();
                this.ccnPointsLog.trace(this.getDebugSummaryString() + "new value=" + value);
            }
            if (dataType == 12) {
                String hh = sNewValue.substring(0, sNewValue.indexOf(":"));
                String mm = sNewValue.substring(sNewValue.indexOf(":") + 1);
                value = new Float(hh + mm).floatValue();
            }
            if (dataType == 51) {
                int p1 = sNewValue.indexOf(":");
                int p2 = sNewValue.indexOf(" ");
                int p3 = sNewValue.lastIndexOf(":");
                String hh1 = sNewValue.substring(0, p1);
                String mm1 = sNewValue.substring(p1 + 1, p2).trim();
                String hh2 = sNewValue.substring(p2 + 1, p3).trim();
                String mm2 = sNewValue.substring(p3 + 1);
                value = new Float(hh1 + mm1 + hh2 + mm2).floatValue();
            }
            CcnWriteVariableRequest req = new CcnWriteVariableRequest(vDef, value);
            CcnResponseMessage forceRsp = this.getCcnDevice().getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
            if (forceRsp != null) {
                this.ccnPointsLog.trace(this.getDebugSummaryString() + "write variable request: " + req.toString());
                this.ccnPointsLog.trace(this.getDebugSummaryString() + "write variable response: ");
            }
            if (forceRsp != null) {
                this.ccnPointsLog.trace(this.getDebugSummaryString() + "force command response: getResponseCommand()=" + forceRsp.getResponseCommand());
                if (forceRsp.getResponseCommand() == 21) {
                    switch (forceRsp.getResponseCode()) {
                        case 1: {
                            errorMessage = "Command not implemented.";
                            break;
                        }
                        case 5: {
                            errorMessage = "Variable not found.";
                            break;
                        }
                        case 7: {
                            errorMessage = "Insufficient priority.";
                            break;
                        }
                        case 8: {
                            errorMessage = "Point write protected.";
                            break;
                        }
                        case 9: {
                            errorMessage = "POC function does not exist.";
                            break;
                        }
                        case 16: {
                            errorMessage = "Access denied.";
                            break;
                        }
                        case 17: {
                            errorMessage = "Value was above/below protective limits.";
                            break;
                        }
                        default: {
                            errorMessage = "Unknown error. 0x" + Integer.toHexString(forceRsp.getResponseCode());
                            break;
                        }
                    }
                } else if (forceRsp.getResponseCommand() != 6) {
                    errorMessage = "Unknown error. 0x" + Integer.toHexString(forceRsp.getResponseCode());
                } else if (forceRsp.getResponseCommand() == 6) {
                    this.writeOk(out);
                    if (isFromCommand) {
                        this.setForceLevel("Controlling POC commands");
                    } else {
                        this.setForceLevel("Supervisor Override");
                    }
                }
            } else {
                this.getTable().updateObject(null, 2, 1, this);
                errorMessage = "Unknown error.";
                this.ccnPointsLog.trace(this.getDebugSummaryString() + "force command response is null");
            }
            if (errorMessage != null) {
                this.ccnPointsLog.error("Force value is unsuccessful.\n" + errorMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean writeAutoValue(boolean isCommand, BCcnOutputProxy proxyExt) {
        String errorMessage;
        block15: {
            block13: {
                CcnResponseMessage autoRsp;
                block14: {
                    CcnVariableDef vDef;
                    errorMessage = null;
                    int busNum = this.getCcnDevice().getBusNo();
                    int localAddr = this.getCcnDevice().getElemNo();
                    int forceLevel = this.convertForceLevel();
                    if (isCommand) {
                        forceLevel = 7;
                        vDef = new CcnVariableDef((byte)localAddr, (byte)busNum, null, (short)this.getVariableNo(), (byte)forceLevel, (byte)forceLevel);
                    } else {
                        vDef = new CcnVariableDef((byte)localAddr, (byte)busNum, null, (short)this.getVariableNo(), (byte)forceLevel, (byte)forceLevel);
                    }
                    CcnAutoVariableRequest req = new CcnAutoVariableRequest(vDef);
                    autoRsp = this.getCcnDevice().getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
                    if (autoRsp == null) break block13;
                    if (autoRsp.getResponseCommand() != 21) break block14;
                    switch (autoRsp.getResponseCode()) {
                        case 1: {
                            errorMessage = "Command not implemented.";
                            break;
                        }
                        case 5: {
                            errorMessage = "Variable not found.";
                            break;
                        }
                        case 7: {
                            if (this.convertForceLevel() != 0) {
                                errorMessage = "Higher output precedence in effect.";
                                break;
                            }
                            break block15;
                        }
                        case 9: {
                            errorMessage = "POC function does not exist.";
                            break;
                        }
                        default: {
                            errorMessage = "Unknown error.";
                            break;
                        }
                    }
                    break block15;
                }
                if (autoRsp.getResponseCommand() != 6) {
                    errorMessage = "Unknown error.";
                } else if (autoRsp.getResponseCommand() == 6) {
                    this.ccnPointsLog.trace("updateObject is gng to invoke in autoValue");
                    this.setForceLevel("");
                }
                break block15;
            }
            errorMessage = "Unknown error.";
        }
        if (errorMessage != null) {
            this.ccnPointsLog.error("Auto variable " + this.getFieldName() + "(" + this.getVariableNo() + ") is unsuccessful.\n" + errorMessage);
            return false;
        }
        return true;
    }

    public int convertForceLevel() {
        int forceLevel = 0;
        String forceDes = this.getForceLevel();
        this.ccnPointsLog.trace("ForceDescriprion is>>>>" + forceDes);
        if (forceDes.equals("")) {
            forceLevel = 0;
        } else if (forceDes.equalsIgnoreCase("Service tool override")) {
            forceLevel = 1;
        } else if (forceDes.equalsIgnoreCase("Internal safety override")) {
            forceLevel = 2;
        } else if (forceDes.equalsIgnoreCase("Service tool command ON")) {
            forceLevel = 3;
        } else if (forceDes.equalsIgnoreCase("Supervisor override")) {
            forceLevel = 4;
        } else if (forceDes.equalsIgnoreCase("Offsite monitoring override")) {
            forceLevel = 5;
        } else if (forceDes.equalsIgnoreCase("Minimum OFF or ON time command rejection")) {
            forceLevel = 6;
        } else if (forceDes.equalsIgnoreCase("Controlling POC commands")) {
            forceLevel = 7;
        } else if (forceDes.equalsIgnoreCase("BEST command")) {
            forceLevel = 8;
        } else if (forceDes.equalsIgnoreCase("Temperature override")) {
            forceLevel = 9;
        } else if (forceDes.equalsIgnoreCase("Loadshed")) {
            forceLevel = 10;
        } else if (forceDes.equalsIgnoreCase("spare")) {
            forceLevel = 11;
        }
        return forceLevel;
    }
}

