/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BCcnTableList;
import com.tridium.ccn.messages.CcnCreateDataTablesRequest;
import com.tridium.ccn.messages.CcnCreatePointsRequest;
import com.tridium.ccn.messages.CcnCreateTablesRequest;
import com.tridium.ccn.messages.CcnLearnDataPointsRequest;
import com.tridium.ccn.messages.CcnLearnDeviceRequest;
import com.tridium.ccn.messages.CcnLearnPICPointsRequest;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.point.BCcnInputProxy;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnFidTable;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.util.AsynchronousRequest;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.sys.BComponent;
import javax.baja.sys.LocalizableRuntimeException;

public class CcnPointConfigUploadRequest
implements AsynchronousRequest,
CcnMessageConst {
    BCcnDevice ccnDevice;
    Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");

    public CcnPointConfigUploadRequest(BCcnDevice device) {
        this.ccnDevice = device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (!this.ccnDevice.isDeviceStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnUpload.error");
        }
        try {
            int i;
            CcnLearnDeviceRequest reqDev = new CcnLearnDeviceRequest(this.ccnDevice);
            reqDev.execute();
            Vector<BCcnTable> vTable = new Vector<BCcnTable>();
            this.ccnDevice.getExistingTableArray((BComponent)this.ccnDevice, vTable);
            BCcnTable[] tableArray = new BCcnTable[vTable.size()];
            vTable.copyInto((Object[])tableArray);
            this.ccnMessageLog.trace("The existed tables are::" + tableArray.length);
            BCcnTableEntry[] tableList = (BCcnTableEntry[])this.ccnDevice.getLearnedTables().getChildren(BCcnTableEntry.class);
            this.ccnMessageLog.trace("the table list length is::" + tableList.length);
            this.ccnDevice.setLearnStatus("Upload-> Start process for CcnDevice " + this.ccnDevice.getDeviceName() + " ... number of tables = " + tableArray.length);
            for (i = 0; i < tableArray.length; ++i) {
                BCcnTableEntry[] tableEntry;
                if (!(tableArray[i] instanceof BCcnPicTable || tableArray[i] instanceof BCcnPocTable || tableArray[i] instanceof BCcnDataTable || tableArray[i] instanceof BCcnFidTable)) {
                    this.ccnDevice.setLearnStatus("Upload-> Table " + tableArray[i].getTableName() + " Skipped ... not Pic/Poc/Data/Fid table");
                    continue;
                }
                if (!tableArray[i].isFullAccessPermittedByLicense()) {
                    this.ccnDevice.setLearnStatus("Upload-> Table " + tableArray[i].getTableName() + " Skipped ... table access denied");
                    continue;
                }
                if (tableArray[i] instanceof BCcnPicTable) {
                    tableEntry = new BCcnTableEntry[]{this.findTableListEntry(tableArray[i], tableList)};
                    if (tableEntry[0] != null) {
                        this.ccnMessageLog.trace("Table entry is>>>>" + tableEntry[0].getTableName());
                    }
                    if (tableEntry[0] == null) {
                        this.ccnDevice.setLearnStatus("Upload-> CcnPicTable " + tableArray[i].getTableName() + "  mismatch... did not upload");
                        continue;
                    }
                    CcnCreateTablesRequest picUpload = new CcnCreateTablesRequest(this.ccnDevice, new BCcnTableList(tableEntry), tableArray[i], false, true);
                    picUpload.execute();
                    this.ccnDevice.setLearnStatus("Upload-> CcnPicTable " + tableArray[i].getTableName() + "  update PointList");
                } else if (tableArray[i] instanceof BCcnPocTable) {
                    String curName = tableArray[i].getTableName();
                    if (curName.equals("SPSCHPOC")) {
                        this.ccnDevice.setLearnStatus("Upload-> CcnPocTable " + curName + "  table access denied for CcnPocTable");
                        continue;
                    }
                    BCcnTableEntry[] tableEntry2 = new BCcnTableEntry[]{this.findTableListEntry(tableArray[i], tableList)};
                    if (tableEntry2[0] != null) {
                        this.ccnMessageLog.trace("Table entry is>>>>" + tableEntry2[0].getTableName());
                    }
                    if (tableEntry2[0] == null) {
                        this.ccnDevice.setLearnStatus("Upload-> CcnPocTable " + tableArray[i].getTableName() + "  mismatch... did not upload");
                        continue;
                    }
                    CcnCreateTablesRequest pocUpload = new CcnCreateTablesRequest(this.ccnDevice, new BCcnTableList(tableEntry2), tableArray[i], false, true);
                    pocUpload.execute();
                    this.ccnDevice.setLearnStatus("Upload-> CcnPocTable " + tableArray[i].getTableName() + "  update MasterPointList");
                } else if (tableArray[i] instanceof BCcnDataTable) {
                    BCcnPocTable parentPocTable = ((BCcnDataTable)tableArray[i]).getParentPoc();
                    BCcnTableEntry[] dataTableList = (BCcnTableEntry[])parentPocTable.getLearnedDataTables().getChildren(BCcnTableEntry.class);
                    BCcnTableEntry[] tableEntry3 = new BCcnTableEntry[]{this.findTableListEntry(tableArray[i], dataTableList)};
                    if (tableEntry3[0] != null) {
                        this.ccnMessageLog.trace("Table entry is>>>>" + tableEntry3[0].getTableName());
                    }
                    if (tableEntry3[0] == null) {
                        this.ccnDevice.setLearnStatus("Upload-> CcnDataTable " + tableArray[i].getTableName() + "  mismatch... did not upload");
                        continue;
                    }
                    CcnCreateDataTablesRequest dataUpload = new CcnCreateDataTablesRequest(((BCcnDataTable)tableArray[i]).getParentPoc(), tableEntry3, (BCcnDataTable)tableArray[i], false, false, true);
                    dataUpload.execute();
                    this.ccnDevice.setLearnStatus("Upload-> CcnDataTable " + tableArray[i].getTableName() + "  update PointList");
                }
                if (!(tableArray[i] instanceof BCcnFidTable)) continue;
                tableEntry = new BCcnTableEntry[1];
                this.ccnMessageLog.trace("1 Getting ready to call CcnCreateTablesRequest for table: " + tableArray[i].getTableName());
                tableEntry[0] = this.findTableListEntry(tableArray[i], tableList);
                if (tableEntry[0] == null) {
                    this.ccnDevice.setLearnStatus("Upload-> CcnFidTable " + tableArray[i].getTableName() + "  mismatch... did not upload");
                    continue;
                }
                CcnCreateTablesRequest fidUpload = new CcnCreateTablesRequest(this.ccnDevice, new BCcnTableList(tableEntry), tableArray[i], false, true);
                fidUpload.execute();
                this.ccnDevice.setLearnStatus("Upload-> CcnFidTable " + tableArray[i].getTableName() + "  update PointList");
            }
            for (i = 0; i < tableArray.length; ++i) {
                BCcnPointEntry[] pointList;
                if (!(tableArray[i] instanceof BCcnPicTable) && !(tableArray[i] instanceof BCcnDataTable) && !(tableArray[i] instanceof BCcnFidTable) || !tableArray[i].isFullAccessPermittedByLicense()) continue;
                Vector<BCcnProxyExt> vObject = new Vector<BCcnProxyExt>();
                tableArray[i].getExistingObjectArray(tableArray[i], vObject);
                if (vObject.size() <= 0) continue;
                Object[] objectArray = new BCcnProxyExt[vObject.size()];
                vObject.copyInto(objectArray);
                for (int j = 0; j < objectArray.length; ++j) {
                    this.ccnMessageLog.trace("tableArray[" + i + "]" + (Object)((Object)tableArray[i]) + ":  objectArray[" + j + "]=" + objectArray[j]);
                }
                if (tableArray[i] instanceof BCcnPicTable) {
                    CcnLearnPICPointsRequest picPointsReq = new CcnLearnPICPointsRequest((BCcnPicTable)tableArray[i], this.ccnDevice);
                    picPointsReq.execute();
                    pointList = (BCcnPointEntry[])tableArray[i].getPointList().getChildren(BCcnPointEntry.class);
                } else if (tableArray[i] instanceof BCcnDataTable) {
                    CcnLearnDataPointsRequest dataPointsReq = new CcnLearnDataPointsRequest(this.ccnDevice, (BCcnDataTable)tableArray[i], null);
                    dataPointsReq.execute();
                    pointList = (BCcnPointEntry[])tableArray[i].getPointList().getChildren(BCcnPointEntry.class);
                } else {
                    if (!(tableArray[i] instanceof BCcnFidTable)) continue;
                    pointList = (BCcnPointEntry[])tableArray[i].getPointList().getChildren(BCcnPointEntry.class);
                }
                Vector<BCcnPointEntry> vPointList = new Vector<BCcnPointEntry>();
                this.ccnMessageLog.trace("Start CcnObject update: objectArray.length=" + objectArray.length + " :  pointList.length=" + pointList.length);
                for (int j = 0; j < objectArray.length; ++j) {
                    boolean matchFound = false;
                    for (int k = 0; k < pointList.length; ++k) {
                        if (!pointList[k].getFieldName().equals(((BCcnProxyExt)objectArray[j]).getFieldName())) continue;
                        vPointList.addElement(pointList[k]);
                        matchFound = true;
                        break;
                    }
                    if (matchFound) continue;
                    BCcnInputProxy child = (BCcnInputProxy)objectArray[j];
                    child.setFault(true);
                    this.ccnDevice.setLearnStatus("Upload Problem-> Table " + tableArray[i].getTableName() + " has a CcnObject " + ((BCcnProxyExt)objectArray[j]).getFieldName() + " with no matching pointEntry from the upload... set the CcnObject's Fault flags");
                }
                BCcnPointEntry[] aPointList = new BCcnPointEntry[vPointList.size()];
                vPointList.copyInto((Object[])aPointList);
                this.ccnMessageLog.trace("PointList is::" + aPointList.length);
                CcnCreatePointsRequest reqCreatePoints = new CcnCreatePointsRequest(tableArray[i], aPointList, true, true);
                reqCreatePoints.execute();
                this.ccnDevice.setLearnStatus("Upload-> Update Table " + tableArray[i].getTableName() + "'s CcnObjects from upload");
            }
        }
        finally {
            this.ccnDevice.setLearnStatus("Upload-> CcnDevice " + this.ccnDevice.getDeviceName() + " ... Complete");
            this.ccnMessageLog.trace("<CcnPointConfigUploadRequest: complete");
            this.ccnDevice.setLearnStatus("Idle");
        }
    }

    private BCcnTableEntry findTableListEntry(BCcnTable table, BCcnTableEntry[] teList) {
        int tableType = table.getTableType();
        int tableInstance = table.getTableInstance();
        for (int i = 0; i < teList.length; ++i) {
            if (tableType != teList[i].getTableType() || tableInstance != teList[i].getTableInstance()) continue;
            return teList[i];
        }
        return null;
    }
}

