/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.components.BCcnByteEntry;
import com.tridium.ccn.components.BCcnByteList;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnFidTable;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.BByteArray;
import com.tridium.ccn.util.CcnBlkPicPocUtil;
import com.tridium.ccn.util.CcnRspFidUtil;
import com.tridium.ccn.util.CcnRspPicPocUtil;
import com.tridium.platCcn.CcnTableDef;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.LocalizableRuntimeException;

public class CcnPointConfigDownloadRequest
implements AsynchronousRequest,
CcnMessageConst {
    private BCcnDevice dev;
    private BCcnTable[] tableArray;
    private BCcnTable curTable;
    private BCcnPointEntry[] pointEntries;
    Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");

    public CcnPointConfigDownloadRequest(BCcnTable[] tableArray, BCcnDevice device) {
        this.tableArray = tableArray;
        this.dev = device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() {
        if (!this.dev.isDeviceStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnDownload.error");
        }
        try {
            this.dev.setLearnStatus("Download-> Start process for CcnDevice " + this.dev.getDeviceName() + " ... number of tables = " + this.tableArray.length);
            this.ccnMessageLog.trace("<CcnPointConfigDownloadRequest: tableArray.length: " + this.tableArray.length);
            int i = 0;
            while (i < this.tableArray.length) {
                block114: {
                    int datalength;
                    boolean displayType;
                    int[] blockConstructedLength;
                    boolean[] blockConstructed;
                    BByteArray[] blockData;
                    BCcnByteEntry[] blockAccessRights;
                    int maxBlockNum;
                    block127: {
                        int j;
                        int dataTableEndBlock;
                        block124: {
                            block119: {
                                block125: {
                                    block126: {
                                        block122: {
                                            int dataTableStrBlock;
                                            block123: {
                                                block116: {
                                                    block121: {
                                                        String curName;
                                                        block120: {
                                                            block117: {
                                                                block118: {
                                                                    block115: {
                                                                        if (!(this.tableArray[i] instanceof BCcnTable)) break block114;
                                                                        boolean staticTable = true;
                                                                        if (this.tableArray[i].getTableType() == 17 || this.tableArray[i].getTableType() == 18 || this.tableArray[i].getTableType() == 21) {
                                                                            staticTable = false;
                                                                        }
                                                                        maxBlockNum = this.tableArray[i].getTableBlockCount();
                                                                        if (this.tableArray[i].getTableType() == 1281) {
                                                                            maxBlockNum = 64;
                                                                        }
                                                                        BCcnByteList exactBytelist = !this.dev.isDeviceFID() ? (BCcnByteList)this.dev.getTableAccessRights().get(SlotPath.escape((String)this.tableArray[i].getTableName()) + this.tableArray[i].getTableNum()) : (BCcnByteList)this.dev.getTableAccessRights().get(SlotPath.escape((String)this.tableArray[i].getTableName()) + this.tableArray[i].getTableType());
                                                                        blockAccessRights = null;
                                                                        if (exactBytelist != null) {
                                                                            blockAccessRights = (BCcnByteEntry[])exactBytelist.getChildren(BCcnByteEntry.class);
                                                                        }
                                                                        if (blockAccessRights != null) break block115;
                                                                        this.dev.setLearnStatus("Download-> Table " + this.tableArray[i].getTableName() + " Skipped ... table access denied");
                                                                        break block114;
                                                                    }
                                                                    this.ccnMessageLog.trace("MaxBlockNumber>>>>" + maxBlockNum);
                                                                    blockData = new BByteArray[maxBlockNum];
                                                                    blockConstructed = new boolean[maxBlockNum];
                                                                    blockConstructedLength = new int[maxBlockNum];
                                                                    displayType = this.tableArray[i].getCurMetricDisplay();
                                                                    this.ccnMessageLog.trace("<CcnPointConfigDownloadRequest: tableArray entry " + i + ":" + this.tableArray[i].getTableName() + " is instanceof Pic/Poc/Data/Fid: " + (this.tableArray[i] instanceof BCcnPicTable) + "/" + (this.tableArray[i] instanceof BCcnPocTable) + "/" + (this.tableArray[i] instanceof BCcnDataTable) + "/" + (this.tableArray[i] instanceof BCcnFidTable));
                                                                    this.curTable = this.tableArray[i];
                                                                    if (!(this.curTable instanceof BCcnPicTable) && !(this.curTable instanceof BCcnPocTable)) break block116;
                                                                    if (!(this.curTable instanceof BCcnPicTable)) break block117;
                                                                    this.ccnMessageLog.trace("Instance of PIC table....");
                                                                    if (((BCcnPicTable)this.curTable).isFullAccessPermittedByLicense()) break block118;
                                                                    this.dev.setLearnStatus("Download-> Table " + this.curTable.getTableName() + " Skipped ... table access denied");
                                                                    this.ccnMessageLog.trace("<CcnPointConfigDownloadRequest: table access denied for CcnPicTable = " + this.curTable.getTableName());
                                                                    break block114;
                                                                }
                                                                this.pointEntries = (BCcnPointEntry[])this.curTable.getPointList().getChildren(BCcnPointEntry.class);
                                                                break block119;
                                                            }
                                                            if (!(this.curTable instanceof BCcnPocTable)) break block119;
                                                            curName = this.curTable.getTableName();
                                                            if (!curName.equals("SPSCHPOC")) break block120;
                                                            this.dev.setLearnStatus("Download-> CcnPocTable " + curName + " Skipped ... table access denied");
                                                            break block114;
                                                        }
                                                        if (this.curTable.isFullAccessPermittedByLicense()) break block121;
                                                        this.dev.setLearnStatus("Download-> BCcnPocTable " + curName + " Skipped ... table access denied");
                                                        this.ccnMessageLog.trace("<CcnPointConfigDownloadRequest: table access denied for BCcnPocTable = " + curName);
                                                        break block114;
                                                    }
                                                    this.pointEntries = (BCcnPointEntry[])((BCcnPocTable)this.curTable).getMasterPointList().getChildren(BCcnPointEntry.class);
                                                    break block119;
                                                }
                                                if (!(this.curTable instanceof BCcnDataTable)) break block122;
                                                if (((BCcnDataTable)this.curTable).isFullAccessPermittedByLicense()) break block123;
                                                this.dev.setLearnStatus("Download-> Table " + this.curTable.getTableName() + " Skipped ... table access denied");
                                                this.ccnMessageLog.trace("<CcnPointConfigDownloadRequest: table access denied for BCcnDataTable = " + this.curTable.getTableName());
                                                break block114;
                                            }
                                            this.dev.setLearnStatus("Download-> Table " + this.curTable.getTableName() + " ... build blocks");
                                            this.pointEntries = (BCcnPointEntry[])this.curTable.getPointList().getChildren(BCcnPointEntry.class);
                                            this.ccnMessageLog.trace("<CcnPointConfigDownloadRequest dataTable: pointEntries.length/maxBlockNum: " + this.pointEntries.length + "/" + maxBlockNum);
                                            BCcnPocTable parentTable = ((BCcnDataTable)this.curTable).getParentPoc();
                                            dataTableEndBlock = dataTableStrBlock = parentTable.getDataTableBlock();
                                            if (dataTableStrBlock == 255) {
                                                dataTableStrBlock = parentTable.getDataTableStartBlock();
                                                dataTableEndBlock = parentTable.getDataTableEndBlock();
                                            }
                                            j = 0;
                                            break block124;
                                        }
                                        if (!(this.curTable instanceof BCcnFidTable)) break block125;
                                        this.dev.setLearnStatus("Download-> Table " + this.curTable.getTableName() + " ... build blocks");
                                        this.pointEntries = (BCcnPointEntry[])this.curTable.getPointList().getChildren(BCcnPointEntry.class);
                                        this.ccnMessageLog.trace("<CcnPointConfigDownloadRequest fidTable: pointEntries.length/maxBlockNum: " + this.pointEntries.length + "/" + maxBlockNum);
                                        if (this.curTable.getTableType() >= 1283 && this.curTable.getTableType() <= 1285) break block126;
                                        this.ccnMessageLog.trace("<CcnPointConfigDownloadRequest fidTable: " + this.curTable.getTableType() + " skipped... tableType not in valid range");
                                        break block114;
                                    }
                                    datalength = 0;
                                    break block127;
                                }
                                this.dev.setLearnStatus("Download-> Table " + this.curTable.getTableName() + " Skipped ... not Pic/Poc/Data table");
                                break block114;
                            }
                            this.dev.setLearnStatus("Download-> Table " + this.curTable.getTableName() + " ... build blocks");
                            this.ccnMessageLog.trace("<CcnPointConfigDownloadRequest PicTable/PocTable: pointEntries.length/maxBlockNum: " + this.pointEntries.length + "/" + maxBlockNum);
                            this.ccnMessageLog.trace("The number of pointEntries are::" + this.pointEntries.length);
                            int j2 = 0;
                            while (true) {
                                String imperialVal;
                                String currentVal;
                                int dataType;
                                byte discreteTextOffset;
                                byte configFlags;
                                byte byteCount;
                                int units;
                                byte displayDigits;
                                int fieldIndex;
                                if (j2 < this.pointEntries.length) {
                                    fieldIndex = this.pointEntries[j2].getFieldIndex();
                                    this.pointEntries[j2].setDisplayType(displayType);
                                    displayDigits = (byte)this.pointEntries[j2].getDisplayDigits();
                                    units = this.pointEntries[j2].getUnits();
                                    byteCount = (byte)this.pointEntries[j2].getFieldByteCount();
                                    configFlags = (byte)this.pointEntries[j2].getConfigFlags();
                                    discreteTextOffset = (byte)this.pointEntries[j2].getDiscreteTextOffset();
                                    dataType = this.pointEntries[j2].getPointDataType();
                                    currentVal = new String();
                                    imperialVal = new String();
                                } else {
                                    this.dev.setLearnStatus("Download-> Table " + this.curTable.getTableName() + " ... send blocks");
                                    this.ccnMessageLog.trace("\n>>>>>>>>>>>>>>> Start Pic/Poc downLoadData >>>>>>>>>>>>>>> " + this.curTable.getTableName());
                                    break;
                                }
                                for (int k = 0; k < maxBlockNum; ++k) {
                                    int blockOffset;
                                    if (2 <= k && k <= 4) {
                                        k = 2 + fieldIndex / 20;
                                        if (!this.isBlockWritePermitted(k, blockAccessRights)) continue;
                                        byte[] block2_3_4_entry = this.getBlock(blockData, k);
                                        this.ccnMessageLog.trace("block2_3_4 entry==" + block2_3_4_entry);
                                        try {
                                            CcnBlkPicPocUtil.setFieldName(block2_3_4_entry, fieldIndex, this.pointEntries[j2].getName());
                                            CcnBlkPicPocUtil.setDisplayType(block2_3_4_entry, fieldIndex, displayType);
                                            CcnBlkPicPocUtil.setDataType(block2_3_4_entry, fieldIndex, (byte)dataType);
                                            if ((configFlags & 0x80) == 0) {
                                                CcnBlkPicPocUtil.setDisplayDigits(block2_3_4_entry, fieldIndex, displayDigits, this.pointEntries[j2]);
                                            }
                                            CcnBlkPicPocUtil.setFieldByteCount(block2_3_4_entry, fieldIndex, byteCount, this.pointEntries[j2]);
                                            CcnBlkPicPocUtil.setDiscreteTextOffset(block2_3_4_entry, fieldIndex, discreteTextOffset, this.pointEntries[j2]);
                                            CcnBlkPicPocUtil.setConfigFlags(block2_3_4_entry, fieldIndex, configFlags);
                                            CcnBlkPicPocUtil.setUnits(block2_3_4_entry, fieldIndex, units);
                                        }
                                        catch (CcnException e) {
                                            e.printStackTrace();
                                        }
                                        blockConstructed[k - 1] = true;
                                        blockConstructedLength[k - 1] = blockConstructedLength[k - 1] + 12;
                                        this.setBlock(blockData, k, block2_3_4_entry);
                                        k = 4;
                                    }
                                    if (k == 5) {
                                        if (this.curTable instanceof BCcnPocTable || !this.isBlockWritePermitted(k, blockAccessRights)) continue;
                                        byte[] block5_entry = this.getBlock(blockData, k);
                                        try {
                                            imperialVal = CcnRspPicPocUtil.convertToImperial(this.pointEntries[j2]);
                                            blockOffset = this.pointEntries[j2].getValueBlockOffset();
                                            block5_entry = CcnRspPicPocUtil.mergeNewValue(block5_entry, blockOffset - 3, dataType, (int)byteCount, imperialVal, null, this.pointEntries[j2]);
                                        }
                                        catch (Exception e) {
                                            this.ccnMessageLog.error("<CcnPointConfigDownloadRequest: Pic or Poc table setBlock_5 Value ERROR: " + e);
                                        }
                                        blockConstructed[k - 1] = true;
                                        blockConstructedLength[k - 1] = blockConstructedLength[k - 1] + this.pointEntries[j2].getFieldByteCount();
                                        this.setBlock(blockData, k, block5_entry);
                                        continue;
                                    }
                                    if (k == 6) {
                                        if (this.curTable instanceof BCcnPicTable || fieldIndex != 0 || !this.isBlockWritePermitted(k, blockAccessRights)) continue;
                                        CcnResponseMessage rsp = ((BCcnPocTable)this.curTable).getReadTableResponse(6);
                                        if (rsp == null || rsp.getResponseCommand() != 6) {
                                            this.dev.setLearnStatus("Download-> Table " + this.curTable.getTableName() + " ... Block 6 download failed for BCcnPocTable");
                                            this.ccnMessageLog.error("<CcnPointConfigDownloadRequest: Poc table setBlock_6 Data Table Values ERROR: Cannot Read Block 6");
                                            continue;
                                        }
                                        byte[] data = rsp.getData();
                                        byte[] block6_entry = new byte[data.length - 3];
                                        for (int m = 0; m < block6_entry.length; ++m) {
                                            block6_entry[m] = data[m + 3];
                                        }
                                        try {
                                            CcnBlkPicPocUtil.setDataTableType(block6_entry, ((BCcnPocTable)this.curTable).getDataTableType());
                                            int dataBlockNo = ((BCcnPocTable)this.curTable).getDataTableBlock();
                                            CcnBlkPicPocUtil.setDataBlock(block6_entry, dataBlockNo);
                                            if (dataBlockNo == 255) {
                                                CcnBlkPicPocUtil.setStrDataBlock(block6_entry, ((BCcnPocTable)this.curTable).getDataTableStartBlock());
                                                CcnBlkPicPocUtil.setEndDataBlock(block6_entry, ((BCcnPocTable)this.curTable).getDataTableEndBlock());
                                            }
                                        }
                                        catch (CcnException e) {
                                            this.ccnMessageLog.error("<CcnPointConfigDownloadRequest: Pic or Poc table setBlock_9 Variable Number ERROR: " + (Object)((Object)e));
                                        }
                                        blockConstructed[k - 1] = true;
                                        this.setBlock(blockData, k, block6_entry);
                                        continue;
                                    }
                                    if (7 <= k && k <= 8) {
                                        int hiLimBlock;
                                        byte[] block7_8_entry;
                                        int loLimBlock = this.pointEntries[j2].getLoLimitBlock();
                                        if ((loLimBlock == 7 || loLimBlock == 8) && this.isBlockWritePermitted(k = loLimBlock, blockAccessRights)) {
                                            block7_8_entry = this.getBlock(blockData, k);
                                            try {
                                                if ((configFlags & 1) != 0) {
                                                    blockOffset = this.pointEntries[j2].getLoLimitBlockOffset();
                                                    currentVal = this.pointEntries[j2].getLoLimit();
                                                    imperialVal = CcnRspPicPocUtil.convertToImperial(configFlags, displayType, displayDigits, units, currentVal);
                                                    block7_8_entry = CcnRspPicPocUtil.mergeNewValue(block7_8_entry, blockOffset - 3, dataType, (int)byteCount, imperialVal, null, this.pointEntries[j2]);
                                                }
                                            }
                                            catch (Exception e) {
                                                this.ccnMessageLog.error("<CcnPointConfigDownloadRequest: Pic or Poc table setBlock_7_8 Lo Limit ERROR: " + e);
                                            }
                                            blockConstructed[k - 1] = true;
                                            blockConstructedLength[k - 1] = blockConstructedLength[k - 1] + this.pointEntries[j2].getFieldByteCount();
                                            this.setBlock(blockData, k, block7_8_entry);
                                        }
                                        if (((hiLimBlock = this.pointEntries[j2].getHiLimitBlock()) == 7 || hiLimBlock == 8) && this.isBlockWritePermitted(k = hiLimBlock, blockAccessRights)) {
                                            block7_8_entry = this.getBlock(blockData, k);
                                            try {
                                                if ((configFlags & 2) != 0) {
                                                    k = this.pointEntries[j2].getHiLimitBlock();
                                                    blockOffset = this.pointEntries[j2].getHiLimitBlockOffset();
                                                    currentVal = this.pointEntries[j2].getHiLimit();
                                                    imperialVal = CcnRspPicPocUtil.convertToImperial(configFlags, displayType, displayDigits, units, currentVal);
                                                    block7_8_entry = CcnRspPicPocUtil.mergeNewValue(block7_8_entry, blockOffset - 3, dataType, (int)byteCount, imperialVal, null, this.pointEntries[j2]);
                                                }
                                            }
                                            catch (Exception e) {
                                                this.ccnMessageLog.error("<CcnPointConfigDownloadRequest: Pic or Poc table setBlock_7_8 Hi Limit ERROR: " + e);
                                            }
                                            blockConstructed[k - 1] = true;
                                            blockConstructedLength[k - 1] = blockConstructedLength[k - 1] + this.pointEntries[j2].getFieldByteCount();
                                            this.setBlock(blockData, k, block7_8_entry);
                                        }
                                        k = 8;
                                        continue;
                                    }
                                    if (k == 9) {
                                        if (this.curTable instanceof BCcnPocTable || !this.isBlockWritePermitted(k, blockAccessRights)) continue;
                                        byte[] block9_entry = this.getBlock(blockData, k);
                                        try {
                                            CcnBlkPicPocUtil.setVariableNum(block9_entry, fieldIndex, this.pointEntries[j2].getVariableNo());
                                        }
                                        catch (CcnException e) {
                                            this.ccnMessageLog.error("<CcnPointConfigDownloadRequest: Pic or Poc table setBlock_9 Variable Number ERROR: " + (Object)((Object)e));
                                        }
                                        blockConstructed[k - 1] = true;
                                        blockConstructedLength[k - 1] = blockConstructedLength[k - 1] + 2;
                                        this.setBlock(blockData, k, block9_entry);
                                        continue;
                                    }
                                    if (10 > k || k > 15) continue;
                                    k = 10 + fieldIndex / 10;
                                    if (!this.isBlockWritePermitted(k, blockAccessRights)) {
                                        k = 15;
                                        continue;
                                    }
                                    byte[] block10_15_entry = this.getBlock(blockData, k);
                                    try {
                                        CcnBlkPicPocUtil.setDescription(block10_15_entry, fieldIndex, this.pointEntries[j2].getDescription());
                                    }
                                    catch (CcnException e) {
                                        this.ccnMessageLog.error("<CcnPointConfigDownloadRequest: Pic or Poc table setBlock10_15 Description ERROR: " + (Object)((Object)e));
                                    }
                                    blockConstructed[k - 1] = true;
                                    blockConstructedLength[k - 1] = blockConstructedLength[k - 1] + 24;
                                    this.setBlock(blockData, k, block10_15_entry);
                                    k = 15;
                                }
                                ++j2;
                            }
                            for (int l = 2; l <= maxBlockNum; ++l) {
                                String errorMessage;
                                block110: {
                                    block128: {
                                        this.dev.getCcnNetwork().setDiscoveryInProgress(true);
                                        errorMessage = null;
                                        if (!blockConstructed[l - 1]) break block110;
                                        byte[] downLoadData = this.getBlock(blockData, l, blockConstructedLength[l - 1]);
                                        this.ccnMessageLog.trace("downLoadData... " + this.curTable.getTableName() + " blockNo=" + l + " len=" + blockConstructedLength[l - 1]);
                                        CcnResponseMessage writeRsp = this.curTable.writeTable(downLoadData, (byte)l);
                                        if (writeRsp == null) break block128;
                                        if (writeRsp.getResponseCommand() == 6) {
                                            this.curTable.commSuccess(false);
                                            break block110;
                                        } else if (writeRsp.getResponseCommand() == 21) {
                                            switch (writeRsp.getResponseCode()) {
                                                case 1: {
                                                    errorMessage = "Command not implemented.";
                                                    break;
                                                }
                                                case 4: {
                                                    errorMessage = "Table not defined.";
                                                    break;
                                                }
                                                case 9: {
                                                    errorMessage = "POC function does not exist.";
                                                    break;
                                                }
                                                case 10: {
                                                    errorMessage = "Block not defined.";
                                                    break;
                                                }
                                                case 16: {
                                                    errorMessage = "Access denied.";
                                                    break;
                                                }
                                                case 18: {
                                                    errorMessage = "Invalid configuration parameter.";
                                                    break;
                                                }
                                                default: {
                                                    errorMessage = "Unknown error.";
                                                    break;
                                                }
                                            }
                                            break block110;
                                        } else {
                                            errorMessage = "Unknown error. Response from write table command is neither 0x15 nor 0x06.";
                                        }
                                        break block110;
                                    }
                                    errorMessage = "Unknown error. Response from write table command is null.";
                                }
                                if (errorMessage == null) continue;
                                this.ccnMessageLog.trace("Download " + this.curTable.getCcnDevice().getDeviceName() + "|" + this.curTable.getTableName() + "| is unsuccessful.\n" + errorMessage);
                            }
                            break block114;
                        }
                        while (true) {
                            String imperialVal;
                            int dataType;
                            byte byteCount;
                            if (j < this.pointEntries.length) {
                                this.pointEntries[j].setDisplayType(displayType);
                                byteCount = (byte)this.pointEntries[j].getFieldByteCount();
                                dataType = this.pointEntries[j].getPointDataType();
                                imperialVal = new String();
                            } else {
                                this.dev.setLearnStatus("Download-> Table " + this.curTable.getTableName() + " ... send blocks");
                                this.ccnMessageLog.trace("\n>>>>>>>>>>>>>>> Start Data downLoadData >>>>>>>>>>>>>>> " + this.curTable.getTableName());
                                break;
                            }
                            for (int k = dataTableStrBlock; k <= dataTableEndBlock; ++k) {
                                if (2 > k || !this.isBlockWritePermitted(k, blockAccessRights)) continue;
                                byte[] block_entry = this.getBlock(blockData, k);
                                try {
                                    imperialVal = CcnRspPicPocUtil.convertToImperial(this.pointEntries[j]);
                                    int blockOffset = this.pointEntries[j].getValueBlockOffset();
                                    block_entry = CcnRspPicPocUtil.mergeNewValue(block_entry, blockOffset - 3, dataType, (int)byteCount, imperialVal, null, this.pointEntries[j]);
                                }
                                catch (Exception e) {
                                    this.ccnMessageLog.error("<CcnPointConfigDownloadRequest: Data table setBlock Value ERROR: " + e);
                                }
                                blockConstructed[k - 1] = true;
                                blockConstructedLength[k - 1] = blockConstructedLength[k - 1] + this.pointEntries[j].getFieldByteCount();
                                this.setBlock(blockData, k, block_entry);
                            }
                            ++j;
                        }
                        for (int l = dataTableStrBlock; l <= dataTableEndBlock; ++l) {
                            String errorMessage;
                            block111: {
                                block129: {
                                    this.dev.getCcnNetwork().setDiscoveryInProgress(true);
                                    errorMessage = null;
                                    if (!blockConstructed[l - 1]) break block111;
                                    byte[] downLoadData = this.getBlock(blockData, l, blockConstructedLength[l - 1]);
                                    this.ccnMessageLog.trace("downLoadData... " + this.curTable.getTableName() + " blockNo=" + l);
                                    CcnResponseMessage writeRsp = this.curTable.writeTable(downLoadData, (byte)l);
                                    if (writeRsp == null) break block129;
                                    if (writeRsp.getResponseCommand() == 6) {
                                        this.curTable.commSuccess(false);
                                        break block111;
                                    } else if (writeRsp.getResponseCommand() == 21) {
                                        switch (writeRsp.getResponseCode()) {
                                            case 1: {
                                                errorMessage = "Command not implemented.";
                                                break;
                                            }
                                            case 4: {
                                                errorMessage = "Table not defined.";
                                                break;
                                            }
                                            case 9: {
                                                errorMessage = "POC function does not exist.";
                                                break;
                                            }
                                            case 10: {
                                                errorMessage = "Block not defined.";
                                                break;
                                            }
                                            case 16: {
                                                errorMessage = "Access denied.";
                                                break;
                                            }
                                            case 18: {
                                                errorMessage = "Invalid configuration parameter.";
                                                break;
                                            }
                                            default: {
                                                errorMessage = "Unknown error.";
                                                break;
                                            }
                                        }
                                        break block111;
                                    } else {
                                        errorMessage = "Unknown error. Response from write table command is neither 0x15 nor 0x06.";
                                    }
                                    break block111;
                                }
                                errorMessage = "Unknown error. Response from write table command is null.";
                            }
                            if (errorMessage == null) continue;
                            this.ccnMessageLog.trace("Download " + this.curTable.getCcnDevice().getDeviceName() + "|" + this.curTable.getTableName() + "| is unsuccessful.\n" + errorMessage);
                        }
                        break block114;
                    }
                    block68: for (int j = 0; j < this.pointEntries.length; ++j) {
                        this.ccnMessageLog.trace("<CcnPointConfigDownloadRequest: j/pointEntries.length: " + j + "/" + this.pointEntries.length);
                        this.ccnMessageLog.trace("<CcnPointConfigDownloadRequest: j/fieldIndex: " + j + "/" + this.pointEntries[j].getFieldIndex());
                        int fieldIndex = this.pointEntries[j].getFieldIndex();
                        this.pointEntries[j].setDisplayType(displayType);
                        String imperialVal = new String();
                        int k = 2;
                        if (!this.isBlockWritePermitted(k, blockAccessRights)) continue;
                        int tableType = this.curTable.getTableType();
                        byte[] block_entry = null;
                        CcnResponseMessage drsp = null;
                        switch (tableType) {
                            case 1283: {
                                if (fieldIndex == 0) {
                                    drsp = this.getBlockDataFromTable(tableType, this.curTable.getTableInstance(), k);
                                    if (drsp == null) continue block68;
                                    block_entry = drsp.getData();
                                    datalength = block_entry.length;
                                    break;
                                }
                                block_entry = this.getBlock(blockData, k);
                                break;
                            }
                            case 1284: {
                                datalength = 5;
                                block_entry = this.getBlock(blockData, k);
                                break;
                            }
                            case 1285: {
                                datalength = 60;
                                block_entry = this.getBlock(blockData, k);
                            }
                        }
                        try {
                            switch (tableType) {
                                case 1283: {
                                    imperialVal = CcnRspPicPocUtil.convertToImperial(this.pointEntries[j]);
                                    this.ccnMessageLog.trace("0x503... merge value into block " + imperialVal);
                                    if (fieldIndex % 3 == 0) {
                                        CcnRspFidUtil.setPeriodOccTime(imperialVal, block_entry, fieldIndex - 3);
                                    }
                                    if (fieldIndex % 3 == 1) {
                                        CcnRspFidUtil.setPeriodUnoccTime(imperialVal, block_entry, fieldIndex - 3);
                                    }
                                    if (fieldIndex % 3 == 2) {
                                        CcnRspFidUtil.setDaysFlags(imperialVal, block_entry, fieldIndex - 3);
                                    }
                                    break;
                                }
                                case 1284: {
                                    int setpointType = ((BCcnFidTable)this.curTable).getSetpointType();
                                    if (fieldIndex == 0) {
                                        CcnRspFidUtil.setSetpointType((byte)setpointType, block_entry);
                                    }
                                    imperialVal = CcnRspPicPocUtil.convertToImperial(this.pointEntries[j]);
                                    this.ccnMessageLog.trace("0x504... merge value into block " + imperialVal);
                                    CcnRspFidUtil.setSetpointValue(imperialVal, block_entry, setpointType, fieldIndex - 3);
                                    break;
                                }
                                case 1285: {
                                    imperialVal = CcnRspPicPocUtil.convertToImperial(this.pointEntries[j]);
                                    if (fieldIndex % 2 == 0) {
                                        CcnRspFidUtil.setHolidayMonth(imperialVal, block_entry, fieldIndex - 3);
                                        break;
                                    }
                                    CcnRspFidUtil.setHolidayDay(imperialVal, block_entry, fieldIndex - 3);
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            this.ccnMessageLog.error("<CcnPointConfigDownloadRequest: Data table setBlock Value ERROR: " + e);
                        }
                        switch (tableType) {
                            case 1283: 
                            case 1284: 
                            case 1285: {
                                blockConstructed[k - 1] = true;
                                blockConstructedLength[k - 1] = datalength;
                                this.setBlock(blockData, k, block_entry);
                                continue block68;
                            }
                        }
                    }
                    this.dev.setLearnStatus("Download-> Table " + this.curTable.getTableName() + " ... send blocks");
                    this.ccnMessageLog.trace("\n>>>>>>>>>>>>>>> Start Fid downLoadData >>>>>>>>>>>>>>> " + this.curTable.getTableName());
                    for (int l = 1; l <= maxBlockNum; ++l) {
                        String errorMessage;
                        block113: {
                            block130: {
                                this.dev.getCcnNetwork().setDiscoveryInProgress(true);
                                errorMessage = null;
                                if (!blockConstructed[l - 1]) break block113;
                                byte[] downLoadData = this.getBlock(blockData, l, blockConstructedLength[l - 1]);
                                this.ccnMessageLog.trace("downLoadData... " + this.curTable.getTableName() + " blockNo=" + l + " blockConstructedLength[l-1]=" + blockConstructedLength[l - 1] + " downLoadData.length=" + downLoadData.length);
                                CcnResponseMessage writeRsp = this.curTable.writeTable(downLoadData, (byte)l);
                                if (writeRsp == null) break block130;
                                if (writeRsp.getResponseCommand() == 6) {
                                    this.curTable.commSuccess(false);
                                    break block113;
                                } else if (writeRsp.getResponseCommand() == 21) {
                                    switch (writeRsp.getResponseCode()) {
                                        case 1: {
                                            errorMessage = "Command not implemented.";
                                            break;
                                        }
                                        case 4: {
                                            errorMessage = "Table not defined.";
                                            break;
                                        }
                                        case 9: {
                                            errorMessage = "POC function does not exist.";
                                            break;
                                        }
                                        case 10: {
                                            errorMessage = "Block not defined.";
                                            break;
                                        }
                                        case 16: {
                                            errorMessage = "Access denied.";
                                            break;
                                        }
                                        case 18: {
                                            errorMessage = "Invalid configuration parameter.";
                                            break;
                                        }
                                        default: {
                                            errorMessage = "Unknown error.";
                                            break;
                                        }
                                    }
                                    break block113;
                                } else {
                                    errorMessage = "Unknown error. Response from write table command is neither 0x15 nor 0x06.";
                                }
                                break block113;
                            }
                            errorMessage = "Unknown error. Response from write table command is null.";
                        }
                        if (errorMessage == null) continue;
                        this.ccnMessageLog.trace("Download " + this.curTable.getCcnDevice().getDeviceName() + "|" + this.curTable.getTableName() + "| is unsuccessful.\n" + errorMessage);
                    }
                }
                ++i;
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            this.dev.setLearnStatus("Download-> CcnDevice " + this.dev.getDeviceName() + " ... Complete");
            this.ccnMessageLog.trace("<CcnPointConfigDownloadRequest: complete");
            this.dev.setLearnStatus("Idle");
        }
    }

    private boolean isBlockWritePermitted(int blockNum, BCcnByteEntry[] blockAccessRights) {
        byte accessRight = 0;
        for (int r = 0; r < blockAccessRights.length / 2; ++r) {
            if (blockAccessRights[r].getIndex() != blockNum) continue;
            accessRight = (byte)blockAccessRights[r].getValue();
            break;
        }
        this.ccnMessageLog.trace("<CcnPointConfigDownloadRequest: blockNum/accessRight/test: " + blockNum + "/" + accessRight + "/" + ((accessRight & 2) == 2));
        return (accessRight & 2) == 2;
    }

    private byte[] getBlock(BByteArray[] blocks, int blockNum) {
        byte[] tBlock = blocks[blockNum - 1] == null ? new byte[240] : blocks[blockNum - 1].getByteArray();
        return tBlock;
    }

    private byte[] getBlock(BByteArray[] blocks, int blockNum, int blockSize) {
        byte[] tBlock = new byte[blockSize];
        if (blocks[blockNum - 1] == null) {
            tBlock = new byte[240];
        } else {
            byte[] xBlock = blocks[blockNum - 1].getByteArray();
            for (int i = 0; i < tBlock.length; ++i) {
                tBlock[i] = xBlock[i];
            }
        }
        this.ccnMessageLog.trace("<CcnPointConfigDownloadRequest: getBlock: blockNum|tBlock.length=" + blockNum + "|" + tBlock.length);
        return tBlock;
    }

    private void setBlock(BByteArray[] blocks, int blockNum, byte[] block) {
        if (blocks[blockNum - 1] == null) {
            blocks[blockNum - 1] = new BByteArray(block);
        } else {
            blocks[blockNum - 1].setByteArray(block);
        }
    }

    private CcnResponseMessage getBlockDataFromTable(int curTableType, int curTableInstance, int curBlock) {
        int curBusNo = this.dev.getBusNo();
        int curElemNo = this.dev.getElemNo();
        CcnResponseMessage rsp = new CcnResponseMessage();
        for (int i = 0; i < 3; ++i) {
            rsp = new CcnResponseMessage();
            CcnReadTableRequest req = new CcnReadTableRequest(new CcnTableDef((byte)curElemNo, (byte)curBusNo, null, (short)curTableType, (byte)curTableInstance, (byte)curBlock, 0, 0));
            rsp = this.dev.getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
            if (rsp != null && rsp.getResponseCommand() == 21) {
                return rsp;
            }
            if (rsp == null || rsp.getResponseCommand() != 6 || curBlock != rsp.getBlock() || curTableInstance != rsp.getTableInstance() || curTableType != rsp.getTableType()) continue;
            return rsp;
        }
        if (rsp != null) {
            this.ccnMessageLog.trace("\n****  pointConfigDownload... return from block read, device: " + curBusNo + "," + curElemNo + " for table= " + Integer.toHexString(curTableType) + "," + curTableInstance + " curBlock= " + curBlock + " blockLen= " + rsp.getBlockLen());
        }
        if (rsp == null) {
            this.ccnMessageLog.trace("\n****  pointConfigDownload... getBlockDataFromTable failed to get block from block read, device: " + curBusNo + "," + curElemNo + " for table= " + Integer.toHexString(curTableType) + "," + curTableInstance + " curBlock= " + curBlock);
        }
        return rsp;
    }
}

