/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnByteEntry;
import com.tridium.ccn.components.BCcnByteList;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.job.BCcnLearnDataTablesJob;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.platCcn.CcnTableDef;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;

public class CcnLearnPocTableRequest
implements AsynchronousRequest,
CcnMessageConst {
    private BCcnLearnDataTablesJob job;
    private int maxTableNum;
    private Vector<BCcnTableEntry> tableEntriesAdded;
    private BCcnPocTable pocTable = null;
    private final BCcnNetwork ccnNetwork;
    private final BCcnDevice ccnDevice;
    private static final Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");

    public CcnLearnPocTableRequest(BCcnPocTable table) {
        this.pocTable = table;
        this.ccnDevice = this.pocTable.getCcnDevice();
        this.ccnNetwork = this.ccnDevice.getCcnNetwork();
    }

    public CcnLearnPocTableRequest(BCcnDevice device, BCcnPocTable table, BCcnLearnDataTablesJob job) {
        this.job = job;
        this.pocTable = table;
        this.ccnDevice = device;
        this.ccnNetwork = device.getCcnNetwork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (!this.ccnDevice.isDeviceStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnLearnDataTable.add");
        }
        this.pocTable.setLearnStatus("Learn-> Start discovery process... disable deviceStatus and polling");
        if (this.job != null) {
            this.job.log().message("Learn-> Start discovery process... disable deviceStatus and polling");
        }
        if (ccnMessageLog.isTraceOn()) {
            ccnMessageLog.trace("CcnLearnPocTableRequest: Learn-> Start discovery process... disable deviceStatus and polling");
        }
        try {
            this.tableEntriesAdded = new Vector();
            this.pocTable.setDataTableLearnCount(0);
            int busNo = this.ccnDevice.getBusNo();
            int elemNo = this.ccnDevice.getElemNo();
            int pocTableType = this.pocTable.getTableType();
            int pocTableInstance = this.pocTable.getTableInstance();
            if (ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnLearnPocTableRequest: Interrogate device at busNo=" + busNo + ", elemNo=" + elemNo + ", pocTableType=" + pocTableType + ", pocTableInstance=" + pocTableInstance);
            }
            int dataTableType = this.pocTable.getDataTableType();
            this.maxTableNum = this.ccnDevice.getMaxTableNumber();
            for (int i = 1; i <= 255; ++i) {
                this.ccnNetwork.setDiscoveryInProgress(true);
                if (this.job != null) {
                    this.job.progress((100 * i + 1) / 256);
                }
                this.pocTable.setLearnStatus("Learn-> Process data table type " + dataTableType + " dataTableInstance " + i);
                if (this.job != null) {
                    this.job.log().message("Learn-> Process data table type " + dataTableType + " dataTableInstance " + i);
                }
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnPocTableRequest: Learn-> Process data table type " + dataTableType + " dataTableInstance " + i);
                }
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnPocTableRequest: Interrogate pocTable:" + busNo + "," + elemNo + " for table type=" + dataTableType + " for dataTableInstance=" + i);
                }
                if (!this.interrogateDataTableInstance(busNo, elemNo, dataTableType, i)) break;
            }
            if (ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnLearnPocTableRequest: Closing out learn, entries added = " + this.tableEntriesAdded.size());
            }
            if (this.tableEntriesAdded.size() == 0) {
                this.pocTable.setLearnStatus("Learn-> Assembling Table list-> No Tables found");
                if (this.job != null) {
                    this.job.log().message("Learn-> Assembling Table list-> No Tables found");
                }
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnPocTableRequest: Learn-> Assembling Table list-> No Tables found");
                }
                this.pocTable.setDataTableLearnCount(0);
            } else {
                this.pocTable.setLearnStatus("Learn-> Assembling Table list-> Tables found = " + this.tableEntriesAdded.size());
                if (this.job != null) {
                    this.job.log().message("Learn-> Assembling Table list-> Tables found = " + this.tableEntriesAdded.size());
                }
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnPocTableRequest: Learn-> Assembling Table list-> Tables found = " + this.tableEntriesAdded.size());
                }
                BCcnTableEntry[] tableList = new BCcnTableEntry[this.tableEntriesAdded.size()];
                this.tableEntriesAdded.copyInto((Object[])tableList);
                for (int itableCount = 0; itableCount < tableList.length; ++itableCount) {
                    this.addLearnedDataTable(tableList[itableCount]);
                }
                this.pocTable.setDataTableLearnCount(tableList.length);
            }
        }
        catch (Exception e) {
            ccnMessageLog.error("Exception occurred while running CcnLearnPocTableRequest", (Throwable)e);
        }
        finally {
            this.pocTable.setLearnStatus("Learn-> Complete");
            if (this.job != null) {
                this.job.log().message("Learn-> Complete");
            }
            this.pocTable.setLearnStatus("Idle");
            if (ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnCreateDataTablesRequest: Learn-> Complete");
            }
        }
    }

    private boolean interrogateDataTableInstance(int curBusNo, int curElemNo, int curDataTableType, int curDataTableInstance) {
        CcnResponseMessage rsp = this.getBlockDataFromDataTable(curBusNo, curElemNo, curDataTableType, curDataTableInstance, 1);
        if (rsp == null || rsp.getResponseCommand() != 6) {
            return false;
        }
        if (this.maxTableNum != 0 && rsp.getTableNumber() > this.maxTableNum) {
            return false;
        }
        BCcnTableEntry newEntry = this.convertBlockDataToDataTableData(rsp, curDataTableType, curDataTableInstance, 1);
        this.tableEntriesAdded.addElement(new BCcnTableEntry(newEntry));
        return true;
    }

    private BCcnTableEntry convertBlockDataToDataTableData(CcnResponseMessage curBlockResponse, int curTableType, int curTableInstance, int curBlock) {
        BCcnTableEntry curTableEntry = new BCcnTableEntry();
        try {
            curTableEntry.setTableType(CcnRspTableUtil.getTableType(curBlockResponse));
            curTableEntry.setTableTypeString(this.pocTable.getGroup().getTableGroupDescription());
            curTableEntry.setTableInstance(curTableInstance);
            int curTableNum = curBlockResponse.getTableNumber();
            curTableEntry.setTableNum(curTableNum);
            String tableName = CcnRspTableUtil.getTableName(curBlockResponse).trim();
            curTableEntry.setTableName(CcnRspTableUtil.getTableName(curBlockResponse).trim());
            int blockCount = CcnRspTableUtil.getBlockCount(curBlockResponse);
            curTableEntry.setBlockCount(blockCount);
            BCcnByteEntry[] blockAR = new BCcnByteEntry[blockCount];
            BCcnByteList byteList = new BCcnByteList();
            for (int i = 0; i < blockCount; ++i) {
                blockAR[i] = new BCcnByteEntry();
                blockAR[i].setIndex(i + 1);
                blockAR[i].setValue(CcnRspTableUtil.getBlockAccessRights(curBlockResponse, i + 1));
                if (byteList.get("index" + curTableNum + blockAR[i].getIndex()) != null) continue;
                byteList.add("index" + curTableNum + blockAR[i].getIndex(), (BValue)blockAR[i]);
            }
            if (this.ccnDevice.getTableAccessRights().get(SlotPath.escape((String)tableName) + curTableNum) == null) {
                this.ccnDevice.getTableAccessRights().add(SlotPath.escape((String)tableName) + curTableNum, (BValue)byteList);
            }
            curTableEntry.setPointCount(this.pocTable.getPointLearnCount());
        }
        catch (CcnException e) {
            ccnMessageLog.error("Exception occurred while updating BCcnTableEntry " + (Object)((Object)curTableEntry), (Throwable)((Object)e));
        }
        return curTableEntry;
    }

    private CcnResponseMessage getBlockDataFromDataTable(int curBusNo, int curElemNo, int curTableType, int curTableInstance, int curBlock) {
        CcnResponseMessage rsp = null;
        for (int i = 0; i < 3; ++i) {
            CcnReadTableRequest req = new CcnReadTableRequest(new CcnTableDef((byte)curElemNo, (byte)curBusNo, null, (short)curTableType, (byte)curTableInstance, (byte)curBlock, 0, 0));
            rsp = this.ccnNetwork.getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
            if (rsp != null) break;
        }
        if (ccnMessageLog.isTraceOn()) {
            ccnMessageLog.trace("CcnLearnPocTableRequest: Return from block read, device:" + curBusNo + "," + curElemNo + " for table=" + curTableType + "," + curTableInstance + " curBlock=" + curBlock);
        }
        return rsp;
    }

    void addLearnedDataTable(BCcnTableEntry panel) {
        boolean isDataTableLearntAlready = false;
        BCcnTableEntry[] learnedTables = (BCcnTableEntry[])this.pocTable.getLearnedDataTables().getChildren(BCcnTableEntry.class);
        for (int i = 0; i < learnedTables.length; ++i) {
            if (!learnedTables[i].getTableName().equalsIgnoreCase(panel.getTableName()) || learnedTables[i].getTableNum() != panel.getTableNum() || learnedTables[i].getTableInstance() != panel.getTableInstance() || learnedTables[i].getTableType() != panel.getTableType()) continue;
            isDataTableLearntAlready = true;
            break;
        }
        if (!isDataTableLearntAlready) {
            this.pocTable.getLearnedDataTables().add(SlotPath.escape((String)(panel.getTableName().trim() + "_" + panel.getTableType() + "_" + panel.getTableNum() + "_" + panel.getTableInstance() + "_" + panel.getTableTypeString())), (BValue)panel);
        }
    }
}

