/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.components.BCcnByteEntry;
import com.tridium.ccn.components.BCcnByteList;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BCcnTableList;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnCreateDataTablesRequest;
import com.tridium.ccn.messages.CcnCreateTablesRequest;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.tables.BCcnTableGroup;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.platCcn.CcnTableDef;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;

public class CcnFetchTableDataRequest
implements AsynchronousRequest,
CcnMessageConst {
    BCcnDevice dev;
    int controllerNum;
    int busNum;
    BCcnTable table;
    int tableType;
    int tableInstance;
    int tableNum;
    boolean upload;
    Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");

    public CcnFetchTableDataRequest(BCcnTable newTable, BCcnDevice device) {
        this.table = newTable;
        this.dev = device;
        this.controllerNum = device.getElemNo();
        this.busNum = device.getBusNo();
        this.tableType = newTable.getTableType();
        this.tableInstance = newTable.getTableInstance();
        this.tableNum = newTable.getTableNum();
        this.upload = false;
    }

    @Override
    public void execute() {
        block42: {
            if (!this.dev.isDeviceStatusOk()) {
                throw new LocalizableRuntimeException("ccn", "Device is Out Of Service.Cannot fetch table data at this time");
            }
            try {
                block40: {
                    String curName = this.table.getTableName();
                    if (curName.equalsIgnoreCase("SPSCHPOC")) {
                        this.ccnMessageLog.trace("<CcnFetchTableDataRequest... fetch table data not allowed for this table: " + curName);
                        return;
                    }
                    if (!this.upload) {
                        this.table.setLearnStatus("Learn-> process table type " + this.tableType + " tableInstance " + this.tableInstance);
                    }
                    CcnReadTableRequest req = new CcnReadTableRequest(new CcnTableDef((byte)this.controllerNum, (byte)this.busNum, null, (short)this.tableType, (byte)this.tableInstance, 1, 0, 0));
                    CcnResponseMessage rsp = this.dev.getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
                    if (rsp == null) {
                        this.ccnMessageLog.trace("CcnFetchTableDataRequest... rsp from CcnReadTableRequest is null");
                        if (!this.upload) {
                            this.table.setLearnStatus("Idle");
                        }
                        return;
                    }
                    this.ccnMessageLog.trace("CcnFetchTableDataRequest... rsp.getResponseCommand()=" + rsp.getResponseCommand());
                    if (rsp.getResponseCommand() == 6 || rsp.getResponseCommand() == 21 && (this.tableType == 1283 || this.tableType == 1284 || this.tableType == 1285) && rsp.getResponseCode() == 16) {
                        BCcnTableEntry curTableEntry = new BCcnTableEntry();
                        try {
                            block41: {
                                if (!this.dev.isDeviceFID()) {
                                    int pointCount;
                                    BCcnTableGroup tableGroup = this.table.getGroup();
                                    String tableGroupName = this.table.getGroup().getTableGroupDescription();
                                    curTableEntry.setTableType(this.tableType);
                                    curTableEntry.setTableTypeString(tableGroupName);
                                    curTableEntry.setTableInstance(this.tableInstance);
                                    this.table.setTableTypeString(tableGroupName);
                                    int curTableNum = rsp.getTableNumber();
                                    this.table.setTableNum(curTableNum);
                                    curTableEntry.setTableNum(curTableNum);
                                    this.tableNum = this.table.getTableNum();
                                    String tableName = CcnRspTableUtil.getTableName(rsp).trim();
                                    this.table.setTableName(tableName);
                                    curTableEntry.setTableName(tableName);
                                    try {
                                        String newName = CcnRspTableUtil.getTableName(rsp).trim();
                                        if (!(this.table instanceof BCcnDataTable)) {
                                            if (!this.table.getName().equalsIgnoreCase(newName)) {
                                                Property prop = tableGroup.getProperty(this.table.getName().trim());
                                                if (tableGroup.getSlot(this.table.getName()) != null) {
                                                    tableGroup.rename(tableGroup.getSlot(prop.getName().trim()).asProperty(), newName);
                                                }
                                                this.table.setDuplicateTableName(newName);
                                            }
                                        } else if (((BCcnDataTable)this.table).getDataBlock() != 0 && !this.table.getName().equalsIgnoreCase(newName)) {
                                            BCcnPocTable parentPoc = ((BCcnDataTable)this.table).getParentPoc();
                                            Property prop1 = null;
                                            if (tableGroup.getSlot(parentPoc.getName()) != null) {
                                                prop1 = parentPoc.getProperty(this.table.getName().trim());
                                            }
                                            if (parentPoc.getSlot(this.table.getName()) != null && prop1 != null) {
                                                parentPoc.rename(parentPoc.getSlot(prop1.getName().trim()).asProperty(), newName);
                                            }
                                            this.table.setDuplicateTableName(newName);
                                        }
                                    }
                                    catch (Exception e) {
                                        this.ccnMessageLog.error("CcnFetchTableDataRequest... can not rename the object" + e);
                                        if (!this.upload) {
                                            this.table.setLearnStatus("Idle");
                                        }
                                        e.printStackTrace();
                                        this.table.setTableName(this.table.getName());
                                        return;
                                    }
                                    int blockCount = CcnRspTableUtil.getBlockCount(rsp);
                                    curTableEntry.setBlockCount(blockCount);
                                    this.table.setTableBlockCount(blockCount);
                                    BCcnByteEntry[] blockAR = new BCcnByteEntry[blockCount];
                                    BCcnByteList byteList = new BCcnByteList();
                                    for (int i = 0; i < blockCount; ++i) {
                                        blockAR[i] = new BCcnByteEntry();
                                        blockAR[i].setIndex(i + 1);
                                        blockAR[i].setValue(CcnRspTableUtil.getBlockAccessRights(rsp, i + 1));
                                        if (byteList.get("index" + this.tableNum + blockAR[i].getIndex()) != null) continue;
                                        byteList.add("index" + this.tableNum + blockAR[i].getIndex(), (BValue)blockAR[i]);
                                    }
                                    if (this.dev.getTableAccessRights().get(SlotPath.escape((String)tableName) + this.tableNum) == null) {
                                        this.dev.getTableAccessRights().add(SlotPath.escape((String)tableName) + this.tableNum, (BValue)byteList);
                                    }
                                    this.table.setPreMetricDisplay(this.dev.getCcnNetwork().getDisplayMetric());
                                    this.table.setCurMetricDisplay(this.dev.getCcnNetwork().getDisplayMetric());
                                    if (this.table instanceof BCcnDataTable) {
                                        BCcnPocTable parentPoc = ((BCcnDataTable)this.table).getParentPoc();
                                        pointCount = parentPoc.getPointLearnCount();
                                        ((BCcnDataTable)this.table).setPointLearnCount(pointCount);
                                        curTableEntry.setPointCount(pointCount);
                                        BCcnTableEntry[] tableEntry = new BCcnTableEntry[]{curTableEntry};
                                        CcnCreateDataTablesRequest reqCreateData = new CcnCreateDataTablesRequest(parentPoc, tableEntry, (BCcnDataTable)this.table, true, true, this.upload);
                                        reqCreateData.execute();
                                    } else if (this.table instanceof BCcnPocTable) {
                                        pointCount = CcnRspTableUtil.getPointCount(rsp);
                                        curTableEntry.setPointCount(pointCount);
                                        BCcnTableEntry[] tableEntry = new BCcnTableEntry[]{curTableEntry};
                                        CcnCreateTablesRequest reqCreate = new CcnCreateTablesRequest(this.dev, new BCcnTableList(tableEntry), this.table, true, this.upload);
                                        reqCreate.execute();
                                    } else if (this.table instanceof BCcnPicTable) {
                                        pointCount = CcnRspTableUtil.getPointCount(rsp);
                                        this.table.setPointLearnCount(pointCount);
                                        curTableEntry.setPointCount(pointCount);
                                        BCcnTableEntry[] tableEntry = new BCcnTableEntry[]{curTableEntry};
                                        CcnCreateTablesRequest reqCreate = new CcnCreateTablesRequest(this.dev, new BCcnTableList(tableEntry), this.table, true, this.upload);
                                        reqCreate.execute();
                                    }
                                    break block40;
                                }
                                BCcnTableGroup tableGroup = this.table.getGroup();
                                String tableGroupName = this.table.getGroup().getTableGroupDescription();
                                curTableEntry.setTableType(this.tableType);
                                curTableEntry.setTableTypeString(tableGroupName);
                                curTableEntry.setTableInstance(this.tableInstance);
                                this.table.setTableTypeString(tableGroupName);
                                String xTableName = new String();
                                int xBlockCount = 0;
                                int xPointCount = 0;
                                switch (this.tableType) {
                                    case 1281: {
                                        xTableName = new String("IO_Points");
                                        xBlockCount = 6;
                                        byte[] ba501 = new byte[]{1, 1, 2, 3, 3, 1, 4, 1, 5, 1, 6, 3};
                                        this.setBlockAccessRightsForFIDTable(ba501, 6, this.tableType, xTableName);
                                        xPointCount = 64;
                                        break;
                                    }
                                    case 1283: {
                                        xTableName = new String("TST" + this.tableInstance);
                                        xBlockCount = 3;
                                        byte[] ba503 = new byte[]{1, 0, 2, 3, 3, 1};
                                        this.setBlockAccessRightsForFIDTable(ba503, 3, this.tableType, xTableName);
                                        xPointCount = 21;
                                        break;
                                    }
                                    case 1284: {
                                        xTableName = new String("SP" + this.tableInstance);
                                        xBlockCount = 2;
                                        byte[] ba504 = new byte[]{1, 0, 2, 3};
                                        this.setBlockAccessRightsForFIDTable(ba504, 2, this.tableType, xTableName);
                                        xPointCount = 4;
                                        break;
                                    }
                                    case 1285: {
                                        xTableName = new String("HO" + this.tableInstance);
                                        xBlockCount = 2;
                                        byte[] ba505 = new byte[]{1, 0, 2, 3};
                                        this.setBlockAccessRightsForFIDTable(ba505, 2, this.tableType, xTableName);
                                        xPointCount = 60;
                                        break;
                                    }
                                    default: {
                                        this.ccnMessageLog.trace("CcnFetchTableDataRequest... ERROR: table type = " + this.tableType + " or table instance = " + this.tableInstance + " not valid for a FID device");
                                        return;
                                    }
                                }
                                this.table.setTableName(xTableName);
                                curTableEntry.setTableName(new String(xTableName));
                                curTableEntry.setBlockCount(xBlockCount);
                                this.table.setTableBlockCount(xBlockCount);
                                this.table.setPreMetricDisplay(this.dev.getCcnNetwork().getDisplayMetric());
                                this.table.setCurMetricDisplay(this.dev.getCcnNetwork().getDisplayMetric());
                                curTableEntry.setPointCount(xPointCount);
                                this.table.setPointLearnCount(xPointCount);
                                try {
                                    if (!this.table.getName().equalsIgnoreCase(xTableName)) {
                                        Property prop = tableGroup.getProperty(this.table.getName().trim());
                                        if (tableGroup.getSlot(this.table.getName()) != null) {
                                            tableGroup.rename(tableGroup.getSlot(prop.getName().trim()).asProperty(), xTableName);
                                        }
                                        this.table.setDuplicateTableName(xTableName);
                                    }
                                }
                                catch (Exception e) {
                                    this.ccnMessageLog.error("CcnFetchTableDataRequest... can not rename the object" + e);
                                    if (this.upload) break block41;
                                    this.table.setLearnStatus("Idle");
                                }
                            }
                            BCcnTableEntry[] tableEntry = new BCcnTableEntry[]{curTableEntry};
                            CcnCreateTablesRequest reqCreate = new CcnCreateTablesRequest(this.dev, new BCcnTableList(tableEntry), this.table, true, this.upload);
                            reqCreate.execute();
                        }
                        catch (CcnException e) {
                            this.ccnMessageLog.error("CcnFetchTableDataRequest... ERROR: " + (Object)((Object)e));
                            if (this.upload) break block40;
                            this.table.setLearnStatus("Idle");
                        }
                    }
                }
                if (!this.upload) {
                    this.table.setLearnStatus("Idle");
                } else {
                    this.dev.setLearnStatus("Upload-> Table " + this.table.getTableName());
                }
            }
            catch (Exception e) {
                this.ccnMessageLog.error("CcnFetchTableDataRequest... ERROR: " + e);
                if (this.upload) break block42;
                this.table.setLearnStatus("Idle");
            }
        }
    }

    private void setBlockAccessRightsForFIDTable(byte[] byteArray, int blockCount, int currentTableType, String tableName) {
        BCcnByteEntry[] blockAR = new BCcnByteEntry[blockCount];
        BCcnByteList byteList = new BCcnByteList();
        for (int i = 0; i < blockCount; ++i) {
            blockAR[i] = new BCcnByteEntry();
            blockAR[i].setIndex(i + 1);
            blockAR[i].setValue(byteArray[(i + 1) * 2 - 1]);
            if (byteList.get("index" + currentTableType + blockAR[i].getIndex()) != null) continue;
            byteList.add("index" + currentTableType + blockAR[i].getIndex(), (BValue)blockAR[i]);
        }
        if (this.dev.getTableAccessRights().get(SlotPath.escape((String)tableName) + currentTableType) == null) {
            this.dev.getTableAccessRights().add(SlotPath.escape((String)tableName) + currentTableType, (BValue)byteList);
        }
    }
}

